import { ContactTypeOption } from '../../enums/common-enums';
import { EntityFqdn } from '../../enums/core-enums';
import { BaseDto } from '../common/baseDto';
export class SessionEntityDto extends BaseDto {
    constructor() {
        super(...arguments);
        this.ReferenceNumber = 0;
        this.Description = null;
        this.SessionStartDateTime = new Date(-62135596800000);
        this.SessionEndDateTime = new Date(-62135596800000);
        this.CustomerName = null;
        this.CurrentStatus = null;
        this.CurrentUserId = null;
        this.CurrentEmployee = null;
        this.SessionHistoryList = [];
        this.SessionObject = null;
        this.RelatedEntityFqdn = EntityFqdn.Decos_Kcs_Sessions_Entities_Session;
        this.LockedByUser = false;
        this.LoadingDetail = false;
        this.ContactType = ContactTypeOption.None;
        this.ContactTypeSource = null;
    }
}
//# sourceMappingURL=session-entityDto.js.map