import { GlobalFunctions } from "src/app/shared/global-functions";
import { ViewerSettingItem } from "./viewer-setting-item";
export class ViewerSetting {
    constructor() {
        this.viewerSettingList = [];
    }
    initialize(value) {
        try {
            if (!GlobalFunctions.isEmpty(value)) {
                this.viewerSettingList = [];
                const xmlDoc = $.parseXML(value);
                const settings = $(xmlDoc).find('Viewer');
                if (!GlobalFunctions.isEmpty(settings)) {
                    settings.each((i, setting) => {
                        const newSetting = new ViewerSettingItem();
                        newSetting.ContentType = setting.getAttribute('ContentType').toUpperCase();
                        newSetting.LoadFromRelatedItem = setting.getAttribute('LoadFromRelatedItem').toUpperCase() === "TRUE";
                        this.viewerSettingList.push(newSetting);
                    });
                }
            }
        }
        catch (e) {
            console.error(e);
        }
    }
    ;
    loadFromRelatedItem(domain) {
        let loadFromRelatedItem = false;
        if (!GlobalFunctions.isEmpty(domain) && this.viewerSettingList.length > 0) {
            const contentType = GlobalFunctions.toContentType(domain);
            const setting = jlinq.from(this.viewerSettingList).equals("ContentType", contentType.toUpperCase()).first();
            if (setting?.LoadFromRelatedItem)
                loadFromRelatedItem = setting.LoadFromRelatedItem;
        }
        return loadFromRelatedItem;
    }
    ;
}
//# sourceMappingURL=viewer-setting.js.map