import { GlobalFunctions } from "src/app/shared/global-functions";
import { SuggestionSectionType } from "../../enums/common-enums";
import { Suggestion } from "../suggestion/suggestion";
import { SuggestionEmailTemplate } from "../suggestion/suggestion-email-template";
import { SuggestionCbnTemplate } from "../suggestion/suggestion-cbn-template";
import { SuggestionEmployee } from "../suggestion/suggestion-employee";
import { SuggestionLink } from "../suggestion/suggestion-link";
import { SuggestionPopularNumber } from "../suggestion/suggestion-popular-name";
import { SuggestionSection } from "../suggestion/suggestion-section";
import { SuggestionRelation } from "../suggestion/suggetion-ralation";
export class SuggestionSetting {
    constructor() {
        this.suggestionList = [];
        this.autoShow = false;
        this.suggestions = [];
    }
    initialize(value) {
        try {
            if (!GlobalFunctions.isEmpty(value)) {
                const xmlDoc = $.parseXML(value);
                const autoShow = $($(xmlDoc).find('SUGGESTIONSETTING')[0]).attr('AUTOSHOW');
                if (!GlobalFunctions.isEmpty(autoShow))
                    this.autoShow = autoShow.toLowerCase() === 'true';
                this.suggestionList = [];
                const suggestions = $(xmlDoc).find('SUGGESTION');
                if (!GlobalFunctions.isEmpty(suggestions)) {
                    suggestions.each((i, suggestion) => {
                        const newSuggestion = new Suggestion();
                        newSuggestion.Id = suggestion.getAttribute('ID');
                        newSuggestion.Name = suggestion.getAttribute('NAME');
                        newSuggestion.Description = suggestion.getAttribute('DESCRIPTION');
                        newSuggestion.Relations = [];
                        const relations = $(suggestion).find('RELATION');
                        relations.each((i, relation) => {
                            const newRelation = new SuggestionRelation();
                            newRelation.Id = relation.getAttribute('ID');
                            newRelation.Entity = relation.getAttribute('ENTITY');
                            newRelation.Source = relation.getAttribute('SOURCE');
                            newSuggestion.Relations.push(newRelation);
                        });
                        newSuggestion.Sections = [];
                        const linkSection = new SuggestionSection();
                        linkSection.Type = SuggestionSectionType.Link;
                        if (!GlobalFunctions.isEmpty($(suggestion).find('LINKS')))
                            linkSection.Order = parseInt($(suggestion).find('LINKS')[0].getAttribute('ORDER'));
                        linkSection.Items = [];
                        const links = $(suggestion).find('LINK');
                        links.each((i, link) => {
                            if (!GlobalFunctions.isEmpty(link.getAttribute('ID'))) {
                                const newLink = new SuggestionLink();
                                newLink.Id = link.getAttribute('ID');
                                newLink.Title = link.getAttribute('TITLE');
                                newLink.Entity = link.getAttribute('ENTITY');
                                newLink.Source = link.getAttribute('SOURCE');
                                linkSection.Items.push(newLink);
                            }
                        });
                        newSuggestion.Sections.push(linkSection);
                        const popularNumberSection = new SuggestionSection();
                        popularNumberSection.Type = SuggestionSectionType.PopularNumber;
                        if (!GlobalFunctions.isEmpty($(suggestion).find('POPULARNUMBERS')))
                            popularNumberSection.Order = parseInt($(suggestion).find('POPULARNUMBERS')[0].getAttribute('ORDER'));
                        popularNumberSection.Items = [];
                        const popularNumbers = $(suggestion).find('POPULARNUMBER');
                        popularNumbers.each((i, popularNumber) => {
                            if (!GlobalFunctions.isEmpty(popularNumber.getAttribute('ID'))) {
                                const newPopularNumber = new SuggestionPopularNumber();
                                newPopularNumber.Id = popularNumber.getAttribute('ID');
                                newPopularNumber.Name = popularNumber.getAttribute('NAME');
                                newPopularNumber.Number = popularNumber.getAttribute('NUMBER');
                                newPopularNumber.Type = popularNumber.getAttribute('TYPE');
                                popularNumberSection.Items.push(newPopularNumber);
                            }
                        });
                        newSuggestion.Sections.push(popularNumberSection);
                        const emailTemplateSection = new SuggestionSection();
                        emailTemplateSection.Type = SuggestionSectionType.EmailTemplate;
                        if (!GlobalFunctions.isEmpty($(suggestion).find('EMAILTEMPLATES')))
                            emailTemplateSection.Order = parseInt($(suggestion).find('EMAILTEMPLATES')[0].getAttribute('ORDER'));
                        emailTemplateSection.Items = [];
                        const emailTemplates = $(suggestion).find('EMAILTEMPLATE');
                        emailTemplates.each((i, emailTemplate) => {
                            if (!GlobalFunctions.isEmpty(emailTemplate.getAttribute('ID'))) {
                                const newEmailTemplate = new SuggestionEmailTemplate();
                                newEmailTemplate.Id = emailTemplate.getAttribute('ID');
                                newEmailTemplate.TypeId = emailTemplate.getAttribute('TYPEID');
                                newEmailTemplate.Title = emailTemplate.getAttribute('TITLE');
                                emailTemplateSection.Items.push(newEmailTemplate);
                            }
                        });
                        newSuggestion.Sections.push(emailTemplateSection);
                        const cbnTemplateSection = new SuggestionSection();
                        cbnTemplateSection.Type = SuggestionSectionType.CbnTemplate;
                        if (!GlobalFunctions.isEmpty($(suggestion).find('CBNTEMPLATES')))
                            cbnTemplateSection.Order = parseInt($(suggestion).find('CBNTEMPLATES')[0].getAttribute('ORDER'));
                        cbnTemplateSection.Items = [];
                        const cbnTemplates = $(suggestion).find('CBNTEMPLATE');
                        cbnTemplates.each((i, cbnTemplate) => {
                            if (!GlobalFunctions.isEmpty(cbnTemplate.getAttribute('ID'))) {
                                const newCbnTemplate = new SuggestionCbnTemplate();
                                newCbnTemplate.Id = cbnTemplate.getAttribute('ID');
                                newCbnTemplate.TypeId = cbnTemplate.getAttribute('TYPEID');
                                newCbnTemplate.Title = cbnTemplate.getAttribute('TITLE');
                                cbnTemplateSection.Items.push(newCbnTemplate);
                            }
                        });
                        newSuggestion.Sections.push(cbnTemplateSection);
                        const employeeSection = new SuggestionSection();
                        employeeSection.Type = SuggestionSectionType.Employee;
                        if (!GlobalFunctions.isEmpty($(suggestion).find('EMPLOYEES')))
                            employeeSection.Order = parseInt($(suggestion).find('EMPLOYEES')[0].getAttribute('ORDER'));
                        employeeSection.Items = [];
                        const employees = $(suggestion).find('EMPLOYEE');
                        employees.each((i, employee) => {
                            if (!GlobalFunctions.isEmpty(employee.getAttribute('ID'))) {
                                const newEmployee = new SuggestionEmployee();
                                newEmployee.Id = employee.getAttribute('ID');
                                newEmployee.Name = employee.getAttribute('NAME');
                                employeeSection.Items.push(newEmployee);
                            }
                        });
                        newSuggestion.Sections.push(employeeSection);
                        const noteSection = new SuggestionSection();
                        noteSection.Type = SuggestionSectionType.Note;
                        if (!GlobalFunctions.isEmpty($(suggestion).find('NOTE')))
                            noteSection.Order = parseInt($(suggestion).find('NOTE')[0].getAttribute('ORDER'));
                        noteSection.Items = [];
                        const note = $(suggestion).find('NOTE')[0];
                        if (note) {
                            noteSection.Items.push(note.textContent);
                            newSuggestion.Sections.push(noteSection);
                        }
                        newSuggestion.Sections.sort((x, y) => (x.Order - y.Order));
                        this.suggestionList.push(newSuggestion);
                    });
                }
            }
        }
        catch (e) {
            console.error(e);
        }
    }
    ;
    searchByRelationId(relationId, entity) {
        let suggestion = null;
        if (!GlobalFunctions.isEmpty(relationId) && this.suggestionList?.length > 0)
            for (let index = 0; index < this.suggestionList.length; index++) {
                let relation = jlinq.from(this.suggestionList[index].Relations).starts("Id", relationId).first();
                if (relation) {
                    suggestion = this.suggestionList[index];
                    break;
                }
            }
        return suggestion;
    }
    ;
}
//# sourceMappingURL=suggestion-setting.js.map