export class SearchOption {
    constructor(query, type, clickable, item, translateService, style = '', isMatch = false, orderScore = 20, infoButton = '', defaultSelect = false, entityFqdn = '') {
        this.currentDateTime = null;
        this.searchQuery = query;
        this.searchType = type;
        this.selectable = clickable;
        if (item == null && clickable) {
            if (type == 'locations')
                this.formattedText = translateService.instant('LBL_SEARCHING') + ' in ' + translateService.instant('LBL_' + this.searchType.toUpperCase()) + infoButton;
            else if (type == 'fileentity' || type == 'caseentity')
                this.formattedText = translateService.instant('LBL_SEARCHING') + ' in ' + translateService.instant('LBL_' + this.searchType.toUpperCase() + 'S');
            else
                this.formattedText = translateService.instant('LBL_SEARCHING') + ' in ' + translateService.instant('LBL_' + this.searchType.toUpperCase());
        }
        else
            this.formattedText = query;
        this.item = item;
        this.style = style;
        this.isMatch = isMatch;
        this.orderScore = orderScore;
        this.isMultiple = false;
        this.sourceLocation = '';
        this.multipleSources = [];
        this.defaultSelect = defaultSelect;
        this.entityFqdn = entityFqdn;
    }
}
//# sourceMappingURL=serach-option.js.map