import { GlobalFunctions } from "../../../shared/global-functions";
import { ContentType } from "../jkc-object/jkc-object";
import { RefreshEntityCount } from "./refresh-entity-count";
export class RefreshCountSetting {
    constructor() {
        this.Ticket = new RefreshEntityCount();
        this.Task = new RefreshEntityCount();
        this.Document = new RefreshEntityCount();
        this.Email = new RefreshEntityCount();
        this.SocialMedia = new RefreshEntityCount();
    }
    initialize(value) {
        try {
            if (!GlobalFunctions.isEmpty(value)) {
                const xmlDoc = $.parseXML(value);
                const settings = $(xmlDoc).find('RefreshEntityCountSetting');
                if (!GlobalFunctions.isEmpty(settings)) {
                    settings.each((i, setting) => {
                        switch (setting.getAttribute('Entity')) {
                            case ContentType.Ticket:
                                {
                                    this.Ticket.OnDashboard = setting.getAttribute('OnDashboard').toUpperCase() === "TRUE";
                                    this.Ticket.OnMenu = setting.getAttribute('OnMenu').toUpperCase() === "TRUE";
                                    break;
                                }
                            case ContentType.Task:
                                {
                                    this.Task.OnDashboard = setting.getAttribute('OnDashboard').toUpperCase() === "TRUE";
                                    this.Task.OnMenu = setting.getAttribute('OnMenu').toUpperCase() === "TRUE";
                                    break;
                                }
                            case ContentType.Document:
                                {
                                    this.Document.OnDashboard = setting.getAttribute('OnDashboard').toUpperCase() === "TRUE";
                                    this.Document.OnMenu = setting.getAttribute('OnMenu').toUpperCase() === "TRUE";
                                    break;
                                }
                            case ContentType.Email:
                                {
                                    this.Email.OnDashboard = setting.getAttribute('OnDashboard').toUpperCase() === "TRUE";
                                    this.Email.OnMenu = setting.getAttribute('OnMenu').toUpperCase() === "TRUE";
                                    break;
                                }
                            case ContentType.SocialMedia:
                                {
                                    this.SocialMedia.OnDashboard = setting.getAttribute('OnDashboard').toUpperCase() === "TRUE";
                                    this.SocialMedia.OnMenu = setting.getAttribute('OnMenu').toUpperCase() === "TRUE";
                                    break;
                                }
                        }
                    });
                }
            }
        }
        catch (e) {
            console.error(e);
        }
    }
    ;
}
//# sourceMappingURL=refresh-count-setting.js.map