import { GlobalFunctions } from "src/app/shared/global-functions";
import { CallStatus, PhoneStatus } from "../../enums/phone-enum";
import { PhoneCallerDetailDto } from "../phone/phone-caller-detailDto";
import { PhoneSupportedFeature } from "../phone/phone-supported-feature";
export class PhoneState {
    constructor() {
        this.LeftMargin = "-175px";
        this.TopMargin = "18px";
        this.IsColdTransferEnabled = false;
        this.IsSessionTransferWithCallEnabled = false;
        this.IsPhoneFeatureEnabled = true;
        this.WarmTransferCallConnected = false;
        this.ShowPhoneStatus = false;
        this.IsPhoneKeepBusyFeatureEnabled = false;
        this.IsPhonePlayAndPauseFeatureEnabled = true;
        this.PhoneAvailableStatus = PhoneStatus.Available;
        this.IsPhoneBasicFeatureEnabled = false;
        this.EnableCallNumberCheckbox = false;
        this.UpdateCallNumberText = null;
        this.SaveCallNumber = false;
        this.IsCallerIdResolved = false;
        this.IsCiscoPhoneEnabled = false;
        this.IsMitelPhoneEnabled = false;
        this.IsAvayaPhoneEnabled = false;
        this.IsUnexusPhoneEnabled = false;
        this.CurrentCallDto = null;
        this.PreviousCallDto = null;
        this.CurrentState = CallStatus.None;
        this.CurrentCaller = new PhoneCallerDetailDto();
        this.PreviousCaller = new PhoneCallerDetailDto();
        this.CurrentDialer = new PhoneCallerDetailDto();
        this.RegisteredExtension = null;
        this.StateBeforeAttendedTransfer = CallStatus.Unregistered;
        this.CurrentCallerRecentActivity = null;
        this.IsCallFailed = false;
        this.TransferSessionManagerDto = null;
        this.PhoneStatusList = [];
        this.PhoneStatusActionList = [];
        this.SelectedPhoneStatus = null;
        this.EnabledPhoneFeatures = new PhoneSupportedFeature();
    }
    GetPhoneStatus(statusIndex, statusCode) {
        let phoneStatus = { key: statusIndex, value: "", color: "", code: statusCode };
        if (this.PhoneStatusList != null && this.PhoneStatusList.length > 0) {
            for (let index = 0; index < this.PhoneStatusList.length; index++) {
                if (GlobalFunctions.isEmpty(statusCode)) {
                    if (this.PhoneStatusList[index].key == statusIndex) {
                        phoneStatus = this.PhoneStatusList[index];
                        break;
                    }
                }
                else {
                    if (this.PhoneStatusList[index].code == statusCode) {
                        phoneStatus = this.PhoneStatusList[index];
                        break;
                    }
                }
            }
        }
        return phoneStatus;
    }
}
//# sourceMappingURL=phone-state.js.map