import { GlobalFunctions } from "../../../shared/global-functions";
import { UniversalDto } from "./universalDto";
export class Mapper {
    constructor() {
        this.DateJS = Date;
    }
    getMappedItems(existingItems, contentType, calledFor) {
        let newItems = new Array();
        switch (contentType.toLowerCase()) {
            case "contactmoment":
                for (let i = 0; i < existingItems.length; i++) {
                    if (calledFor === "activity_items")
                        newItems.push(this.contactmomentMapToActivity(existingItems[i], null));
                }
                break;
            case "task":
                for (let i = 0; i < existingItems.length; i++) {
                    if (calledFor === "activity_items")
                        newItems.push(this.taskMapToActivity(existingItems[i], null));
                }
                break;
            case "ticket":
                for (let i = 0; i < existingItems.length; i++) {
                    if (calledFor === "activity_items")
                        newItems.push(this.ticketMapToActivity(existingItems[i]));
                }
                break;
            case "person":
                for (let i = 0; i < existingItems.length; i++) {
                    if (calledFor === "universal_dto")
                        newItems.push(this.personMapToUniversalDto(existingItems[i], null));
                }
                break;
            case "organization":
                for (let i = 0; i < existingItems.length; i++) {
                    if (calledFor === "universal_dto")
                        newItems.push(this.organizationMapToUniversalDto(existingItems[i], null));
                }
                break;
            case "caseentity":
                for (let i = 0; i < existingItems.length; i++) {
                    if (calledFor === "universal_dto")
                        newItems.push(this.caseentityMapToUniversalDto(existingItems[i], null));
                }
                break;
            case "document":
                for (let i = 0; i < existingItems.length; i++) {
                    if (calledFor === "universal_dto")
                        newItems.push(this.documentMapToUniversalDto(existingItems[i], null));
                }
                break;
            case "product":
                for (let i = 0; i < existingItems.length; i++) {
                    if (calledFor === "universal_dto")
                        newItems.push(this.productMapToUniversalDto(existingItems[i], null));
                }
                break;
            case "questionanswer":
                for (let i = 0; i < existingItems.length; i++) {
                    if (calledFor === "universal_dto")
                        newItems.push(this.questionanswerMapToUniversalDto(existingItems[i], null));
                }
                break;
            case "noteentity":
                for (let i = 0; i < existingItems.length; i++) {
                    if (calledFor === "universal_dto")
                        newItems.push(this.noteentityMapToUniversalDto(existingItems[i], null));
                }
                break;
            case "employee":
                for (let i = 0; i < existingItems.length; i++) {
                    if (calledFor === "universal_dto")
                        newItems.push(this.employeeMapToUniversalDto(existingItems[i], null));
                }
                break;
            case "fileentity":
                for (let i = 0; i < existingItems.length; i++) {
                    if (calledFor === "universal_dto")
                        newItems.push(this.fileentityMapToUniversalDto(existingItems[i], null));
                }
                break;
            case "theme":
                for (let i = 0; i < existingItems.length; i++) {
                    if (calledFor === "universal_dto")
                        newItems.push(this.themeMapToUniversalDto(existingItems[i], null));
                }
                break;
            case "link":
                for (let i = 0; i < existingItems.length; i++) {
                    if (calledFor === "universal_dto")
                        newItems.push(this.linkMapToUniversalDto(existingItems[i], null));
                }
                break;
            case "item":
                for (let i = 0; i < existingItems.length; i++) {
                    if (calledFor === "universal_dto")
                        newItems.push(this.itemMapToUniversalDto(existingItems[i], null));
                }
                break;
            case "issue":
                for (let i = 0; i < existingItems.length; i++) {
                    if (calledFor === "universal_dto")
                        newItems.push(this.issueMapToUniversalDto(existingItems[i], null));
                }
                break;
        }
        return newItems;
    }
    contactmomentMapToActivity(sourceObject, index) {
        let entityDescriptionGrammar;
        let entityDateGrammar;
        let entityHandlerGrammar;
        let title;
        title = this.translateService.instant("LBL_CONTACT_HISTORY");
        let response = GlobalFunctions.setGrammarForBaseDto(sourceObject, '{Memo}');
        if (response != '')
            entityDescriptionGrammar = this.translateService.instant("LBL_QUESTION") + ': {Subject}\n' + this.translateService.instant("LBL_RESPONSE") + ': {Memo}' + '\n';
        else
            entityDescriptionGrammar = '{Subject}';
        entityDateGrammar = '{EndDate}';
        entityHandlerGrammar = '{HandlerDto.HandlerObject.StringRepresentation}';
        let retValue = this.getAcitivityItem(title, sourceObject, entityDescriptionGrammar, entityDateGrammar, "CONTACTHISTORY");
        retValue.DateTime = new this.DateJS(sourceObject.EndDate).toString('dd MMM yyyy') + ' ' + new this.DateJS(sourceObject.EndDate).toString('HH:mm');
        return retValue;
    }
    taskMapToActivity(sourceObject, index) {
        let entityDescriptionGrammar;
        let entityDateGrammar;
        let entityHandlerGrammar;
        let title;
        title = this.translateService.instant("LBL_TASK");
        if (sourceObject != null && sourceObject.TaskType.toLowerCase() === 'appointment' && sourceObject.ObjectSource != null && sourceObject.ObjectSource.toLowerCase().indexOf('qmatic') >= 0)
            entityDescriptionGrammar = this.translateService.instant("LBL_PRODUCT") + ': {StringRepresentation}, \n' + this.translateService.instant("LBL_DESCRIPTION") + ': {CustomerQuestion}';
        else if (sourceObject != null && sourceObject.TaskType.toLowerCase() === 'appointment')
            entityDescriptionGrammar = this.translateService.instant("LBL_QUESTION") + ': {CustomerQuestion}\n' + this.translateService.instant("LBL_APPOINTMENT_DATE") + ': ' + GlobalFunctions.getDateTimeFromTo(sourceObject.RequiredCallbackDate, sourceObject.CallBetweenStartDate, sourceObject.CallBetweenEndDate);
        else if (sourceObject != null && sourceObject.TaskType.toLowerCase() === 'callbacknote')
            entityDescriptionGrammar = this.translateService.instant("LBL_QUESTION") + ': {CustomerQuestion}\n' + this.translateService.instant("LBL_CALLBACK_DATE") + ': ' + GlobalFunctions.getDateTimeFromTo(sourceObject.RequiredCallbackDate, sourceObject.CallBetweenStartDate, sourceObject.CallBetweenEndDate);
        else
            entityDescriptionGrammar = '{CustomerQuestion}';
        entityDateGrammar = '{CreatedDate}';
        let retValue = this.getAcitivityItem(title, sourceObject, entityDescriptionGrammar, entityDateGrammar, "TASK");
        if (sourceObject != null && (sourceObject.TaskType.toLowerCase() === 'assignment' || sourceObject.TaskType.toLowerCase() === 'reportimprovement' || sourceObject.TaskType.toLowerCase() === 'informationrequest'))
            retValue.DateTime = new this.DateJS(sourceObject.CreatedDate).toString('dd MMM yyyy HH:mm');
        else
            retValue.DateTime = GlobalFunctions.getDateTimeFromTo(sourceObject.RequiredCallbackDate, sourceObject.CallBetweenStartDate, sourceObject.CallBetweenEndDate);
        return retValue;
    }
    ticketMapToActivity(sourceObject) {
        let title = this.translateService.instant("LBL_TICKET");
        let entityDescriptionGrammar = '{Description}';
        let entityDateGrammar = '{CreatedDate}';
        let retValue = this.getAcitivityItem(title, sourceObject, entityDescriptionGrammar, entityDateGrammar, "TICKET");
        retValue.DateTime = new this.DateJS(sourceObject.CreatedDate).toString('dd MMM yyyy HH:mm');
        return retValue;
    }
    getAcitivityItem(title, sourceObject, entityDescriptionGrammar, entityDateGrammar, contentType) {
        let activityItem = new Object();
        activityItem.title = title;
        activityItem.description = GlobalFunctions.setGrammarForBaseDto(sourceObject, entityDescriptionGrammar);
        activityItem.contentType = contentType;
        activityItem.date = GlobalFunctions.setGrammarForBaseDto(sourceObject, entityDateGrammar);
        let date2 = Date;
        if (!GlobalFunctions.isEmpty(activityItem.date)) {
            activityItem.fullDate = date2.parse(activityItem.date);
            activityItem.date = date2.parse(activityItem.date).setHours(0, 0, 0, 0);
        }
        activityItem.handler = GlobalFunctions.setGrammarForBaseDto(sourceObject);
        activityItem.entityObject = sourceObject;
        return activityItem;
    }
    getUniversalDto(sourceObject, regularGrammar, selectedGrammar, contentType, score) {
        let universalDto = new UniversalDto();
        universalDto.RegularDescription = GlobalFunctions.setGrammarForBaseDto(sourceObject, regularGrammar);
        universalDto.DetailDescription = GlobalFunctions.setGrammarForBaseDto(sourceObject, selectedGrammar);
        universalDto.UnderlyingObjectContentType = contentType;
        universalDto.UnderlyingObject = sourceObject;
        universalDto.Score = score;
        return universalDto;
    }
    personMapToUniversalDto(sourceObject, index) {
        let score = 100;
        let searchTerm = this.searchQuery.toUpperCase();
        let regularGrammar = this.applicationSettingManager.getObjectGrammerSetting("PersonDto_AllSearch_Regular");
        let selectedGrammar = this.applicationSettingManager.getObjectGrammerSetting("PersonDto_AllSearch_Selected");
        if (GlobalFunctions.isEmpty(regularGrammar))
            regularGrammar = '{Details.FormalName.Surname}, {Details.AddressName.Initials}';
        if (GlobalFunctions.isEmpty(selectedGrammar))
            selectedGrammar = '{Details.FormalName.Surname}, {Details.AddressName.Initials}';
        if (sourceObject.Details != null && sourceObject.Details.FormalName != null) {
            if ((sourceObject != null && sourceObject.Name != null && sourceObject.Name.toUpperCase().indexOf(searchTerm) > -1)
                || (sourceObject.Details.FormalName.Surname != null && sourceObject.Details.FormalName.Surname.toUpperCase().indexOf(searchTerm) > -1)
                || (sourceObject.Details.FormalName.FirstNames != null && sourceObject.Details.FormalName.FirstNames.length > 0 && sourceObject.Details.FormalName.FirstNames[0].toUpperCase().indexOf(searchTerm) > -1)) {
                score = 100;
            }
            else {
                score = 90;
            }
        }
        return this.getUniversalDto(sourceObject, regularGrammar, selectedGrammar, "PERSON", score);
    }
    organizationMapToUniversalDto(sourceObject, index) {
        let score = 100;
        let searchTerm = this.searchQuery.toUpperCase();
        let regularGrammar = this.applicationSettingManager.getObjectGrammerSetting("OrganizationDto_AllSearch_Regular");
        let selectedGrammar = this.applicationSettingManager.getObjectGrammerSetting("OrganizationDto_AllSearch_Selected");
        if (GlobalFunctions.isEmpty(regularGrammar))
            regularGrammar = '{Name}';
        if (GlobalFunctions.isEmpty(selectedGrammar))
            selectedGrammar = '{Name}';
        score = sourceObject.Name != null && sourceObject.Name.toUpperCase().indexOf(searchTerm) > -1 ? 100 : 90;
        return this.getUniversalDto(sourceObject, regularGrammar, selectedGrammar, "ORGANIZATION", score);
    }
    caseentityMapToUniversalDto(sourceObject, index) {
        let score = 100;
        let searchTerm = this.searchQuery.toUpperCase();
        let regularGrammar = this.applicationSettingManager.getObjectGrammerSetting("CaseEntityDto_AllSearch_Regular");
        let selectedGrammar = this.applicationSettingManager.getObjectGrammerSetting("CaseEntityDto_AllSearch_Selected");
        if (GlobalFunctions.isEmpty(regularGrammar))
            regularGrammar = '{Description}';
        if (GlobalFunctions.isEmpty(selectedGrammar))
            selectedGrammar = '{Description}';
        return this.getUniversalDto(sourceObject, regularGrammar, selectedGrammar, "CASEENTITY", score);
    }
    documentMapToUniversalDto(sourceObject, index) {
        let score = 100;
        let searchTerm = this.searchQuery.toUpperCase();
        let regularGrammar = this.applicationSettingManager.getObjectGrammerSetting("DocumentDto_AllSearch_Regular");
        let selectedGrammar = this.applicationSettingManager.getObjectGrammerSetting("DocumentDto_AllSearch_Selected");
        if (GlobalFunctions.isEmpty(regularGrammar))
            regularGrammar = '{Identification}';
        if (GlobalFunctions.isEmpty(selectedGrammar))
            selectedGrammar = '{Identification}';
        return this.getUniversalDto(sourceObject, regularGrammar, selectedGrammar, "DOCUMENT", score);
    }
    productMapToUniversalDto(sourceObject, index) {
        let score = 100;
        let searchTerm = this.searchQuery.toUpperCase();
        let regularGrammar = this.applicationSettingManager.getObjectGrammerSetting("ProductDto_AllSearch_Regular");
        let selectedGrammar = this.applicationSettingManager.getObjectGrammerSetting("ProductDto_AllSearch_Selected");
        if (GlobalFunctions.isEmpty(regularGrammar))
            regularGrammar = '{Name}';
        if (GlobalFunctions.isEmpty(selectedGrammar))
            selectedGrammar = '{Name}';
        score = sourceObject.Name != null && sourceObject.Name.toUpperCase().indexOf(searchTerm) > -1 ? 100 : 90;
        if (!GlobalFunctions.isEmpty(sourceObject.Name) && !GlobalFunctions.isEmpty(sourceObject.CategoryName) && sourceObject.Name.indexOf(sourceObject.CategoryName + ':') != 0)
            sourceObject.Name = sourceObject.CategoryName + ': ' + sourceObject.Name;
        return this.getUniversalDto(sourceObject, regularGrammar, selectedGrammar, "PRODUCT", score);
    }
    questionanswerMapToUniversalDto(sourceObject, index) {
        let score = 100;
        let searchTerm = this.searchQuery.toUpperCase();
        let regularGrammar = this.applicationSettingManager.getObjectGrammerSetting("QuestionAnswerDto_AllSearch_Regular");
        let selectedGrammar = this.applicationSettingManager.getObjectGrammerSetting("QuestionAnswerDto_AllSearch_Selected");
        if (GlobalFunctions.isEmpty(regularGrammar))
            regularGrammar = '{ChannelQuestionAnswers[0].Question}';
        if (GlobalFunctions.isEmpty(selectedGrammar))
            selectedGrammar = '{ChannelQuestionAnswers[0].Question}';
        score = sourceObject.Name != null && sourceObject.Name.toUpperCase().indexOf(searchTerm) > -1 ? 100 : 90;
        return this.getUniversalDto(sourceObject, regularGrammar, selectedGrammar, "QUESTIONANSWER", score);
    }
    noteentityMapToUniversalDto(sourceObject, index) {
        let score = 100;
        let searchTerm = this.searchQuery.toUpperCase();
        let regularGrammar = this.applicationSettingManager.getObjectGrammerSetting("NoteEntityDto_AllSearch_Regular");
        let selectedGrammar = this.applicationSettingManager.getObjectGrammerSetting("NoteEntityDto_AllSearch_Selected");
        if (!GlobalFunctions.isEmpty(sourceObject.Title)) {
            regularGrammar = '{Title}';
            selectedGrammar = '{Title}';
        }
        else {
            if (GlobalFunctions.isEmpty(regularGrammar))
                regularGrammar = '{DescriptionPlaintext}';
            if (GlobalFunctions.isEmpty(selectedGrammar))
                selectedGrammar = '{DescriptionPlaintext}';
            score = sourceObject.DescriptionPlaintext != null && sourceObject.DescriptionPlaintext.toUpperCase().indexOf(searchTerm) > -1 ? 100 : 90;
        }
        return this.getUniversalDto(sourceObject, regularGrammar, selectedGrammar, "NOTEENTITY", score);
    }
    employeeMapToUniversalDto(sourceObject, index) {
        let score = 100;
        let searchTerm = this.searchQuery.toUpperCase();
        let regularGrammar = this.applicationSettingManager.getObjectGrammerSetting("EmployeeDto_AllSearch_Regular");
        let selectedGrammar = this.applicationSettingManager.getObjectGrammerSetting("EmployeeDto_AllSearch_Selected");
        if (GlobalFunctions.isEmpty(regularGrammar))
            regularGrammar = '{FirstName}, {Surname}';
        if (GlobalFunctions.isEmpty(selectedGrammar))
            selectedGrammar = '{FirstName}, {Surname}';
        return this.getUniversalDto(sourceObject, regularGrammar, selectedGrammar, "EMPLOYEE", score);
    }
    fileentityMapToUniversalDto(sourceObject, index) {
        let score = 100;
        let searchTerm = this.searchQuery.toUpperCase();
        let regularGrammar = this.applicationSettingManager.getObjectGrammerSetting("FileEntityDto_AllSearch_Regular");
        let selectedGrammar = this.applicationSettingManager.getObjectGrammerSetting("FileEntityDto_AllSearch_Selected");
        if (GlobalFunctions.isEmpty(regularGrammar))
            regularGrammar = '{Title}';
        if (GlobalFunctions.isEmpty(selectedGrammar))
            selectedGrammar = '{Title}';
        return this.getUniversalDto(sourceObject, regularGrammar, selectedGrammar, "FILEENTITY", score);
    }
    themeMapToUniversalDto(sourceObject, index) {
        let score = 100;
        let searchTerm = this.searchQuery.toUpperCase();
        let regularGrammar = this.applicationSettingManager.getObjectGrammerSetting("ThemeDto_AllSearch_Regular");
        let selectedGrammar = this.applicationSettingManager.getObjectGrammerSetting("ThemeDto_AllSearch_Selected");
        if (GlobalFunctions.isEmpty(regularGrammar))
            regularGrammar = '{Title}';
        if (GlobalFunctions.isEmpty(selectedGrammar))
            selectedGrammar = '{Title}';
        return this.getUniversalDto(sourceObject, regularGrammar, selectedGrammar, "THEME", score);
    }
    linkMapToUniversalDto(sourceObject, index) {
        let score = 100;
        let searchTerm = this.searchQuery.toUpperCase();
        let regularGrammar = this.applicationSettingManager.getObjectGrammerSetting("LinkDto_AllSearch_Regular");
        let selectedGrammar = this.applicationSettingManager.getObjectGrammerSetting("LinkDto_AllSearch_Selected");
        if (GlobalFunctions.isEmpty(regularGrammar))
            regularGrammar = '{Title}';
        if (GlobalFunctions.isEmpty(selectedGrammar))
            selectedGrammar = '{Title}';
        return this.getUniversalDto(sourceObject, regularGrammar, selectedGrammar, "LINK", score);
    }
    itemMapToUniversalDto(sourceObject, index) {
        let score = 100;
        let searchTerm = this.searchQuery.toUpperCase();
        let regularGrammar = this.applicationSettingManager.getObjectGrammerSetting("ItemDto_AllSearch_Regular");
        let selectedGrammar = this.applicationSettingManager.getObjectGrammerSetting("ItemDto_AllSearch_Selected");
        if (GlobalFunctions.isEmpty(regularGrammar))
            regularGrammar = '{Title}';
        if (GlobalFunctions.isEmpty(selectedGrammar))
            selectedGrammar = '{Title}';
        score = sourceObject.Title != null && sourceObject.Title.toUpperCase().indexOf(searchTerm) > -1 ? 100 : 90;
        return this.getUniversalDto(sourceObject, regularGrammar, selectedGrammar, "ITEM", score);
    }
    issueMapToUniversalDto(sourceObject, index) {
        let score = 100;
        let searchTerm = this.searchQuery.toUpperCase();
        let regularGrammar = this.applicationSettingManager.getObjectGrammerSetting("IssueDto_AllSearch_Regular");
        let selectedGrammar = this.applicationSettingManager.getObjectGrammerSetting("IssueDto_AllSearch_Selected");
        if (GlobalFunctions.isEmpty(regularGrammar))
            regularGrammar = '{Description}';
        if (GlobalFunctions.isEmpty(selectedGrammar))
            selectedGrammar = '{Description}';
        score = sourceObject.Name != null && sourceObject.Name.toUpperCase().indexOf(searchTerm) > -1 ? 100 : 90;
        return this.getUniversalDto(sourceObject, regularGrammar, selectedGrammar, "ISSUE", score);
    }
}
//# sourceMappingURL=mapper.js.map