import { GlobalFunctions } from "../../../shared/global-functions";
import { OperationType } from "../../enums/common-enums";
import { ContentType } from "../jkc-object/jkc-object";
export class LetterTemplateSetting {
    constructor() {
        this.templateList = [];
        this.typeList = [];
    }
    setSettings(value) {
        try {
            if (!GlobalFunctions.isEmpty(value)) {
                this.typeList = [];
                this.templateList = [];
                const xmlDoc = $.parseXML(value);
                const templates = $(xmlDoc).find('LETTERTEMPLATE');
                if (!GlobalFunctions.isEmpty(templates)) {
                    templates.each((i, template) => {
                        if (!this.isTemplateExistInList(template.getAttribute('NAME'), this.templateList))
                            this.templateList.push({ Id: template.getAttribute('ID'), Name: template.getAttribute('NAME'), Type: template.getAttribute('TYPE'), EntityType: template.getAttribute('ENTITY') });
                    });
                }
                const templateTypes = $(xmlDoc).find('LETTERTEMPLATETYPE');
                if (!GlobalFunctions.isEmpty(templateTypes))
                    templateTypes.each((i, templateType) => this.typeList.push({ Id: templateType.getAttribute('ID'), Name: templateType.getAttribute('NAME') }));
            }
        }
        catch (e) {
            console.error(e);
        }
    }
    ;
    getTemplateByType(selectedTemplateType, selectedEntityType) {
        let emailTemplateList = [];
        if (GlobalFunctions.isEmpty(selectedTemplateType))
            return { ...this.templateList };
        if (this.templateList && this.templateList.length > 0) {
            for (let i = 0; i < this.templateList.length; i++) {
                if (this.templateList[i].Type.indexOf(selectedTemplateType) != -1 && (this.templateList[i].EntityType == selectedEntityType))
                    emailTemplateList.push(this.templateList[i]);
            }
            return emailTemplateList;
        }
    }
    ;
    isTemplateExistInList(templateName, templateList) {
        let isExist = false;
        if (templateList.length == 0 || GlobalFunctions.isEmpty(templateName))
            return isExist;
        for (let i = 0; i < templateList.length; i++) {
            if (templateName.toLowerCase() == templateList[i].Name.toLowerCase()) {
                isExist = true;
                break;
            }
        }
        return isExist;
    }
    ;
    getLetterTemplateTypeList(entityType) {
        if (this.typeList.length == 0)
            return;
        let filteredTypeList = [];
        let contentType = entityType == "0" ? ContentType.Person : ContentType.Organization;
        let operationType = entityType == "0" ? OperationType.MergeLetterTemplatePerson : OperationType.MergeLetterTemplateOrganization;
        for (let i = 0; i < this.typeList.length; i++) {
            if (GlobalFunctions.hasAllowDataRights(contentType, operationType, this.typeList[i].Id))
                filteredTypeList.push(this.typeList[i]);
        }
        return filteredTypeList;
    }
    ;
}
;
//# sourceMappingURL=letter-template-setting.js.map