import { GlobalFunctions } from '../../../shared/global-functions';
import { OperationType } from '../../enums/common-enums';
import { ContentType } from '../jkc-object/jkc-object';
export class EmailTemplateSetting {
    constructor() {
        this.TemplateList = [];
        this.TypeList = [];
    }
    getTemplateByType(selectedTemplateType) {
        let emailTemplateList = [];
        if (GlobalFunctions.isEmpty(selectedTemplateType))
            return this.TemplateList;
        if (this.TemplateList && this.TemplateList.length > 0) {
            for (let i = 0; i < this.TemplateList.length; i++) {
                if (!GlobalFunctions.isEmpty(this.TemplateList[i].Type)) {
                    let typeIds = this.TemplateList[i].Type.split('|');
                    typeIds.forEach((typeId) => {
                        if (typeId.toLowerCase() == selectedTemplateType.toLowerCase())
                            emailTemplateList.push(this.TemplateList[i]);
                    });
                }
            }
        }
        return emailTemplateList;
    }
    isTemplateExistInList(templateName, templateList) {
        let isExist = false;
        if (templateList.length == 0 || GlobalFunctions.isEmpty(templateName))
            return isExist;
        for (let i = 0; i < templateList.length; i++) {
            if (templateName.toLowerCase() == templateList[i].Name.toLowerCase()) {
                isExist = true;
                break;
            }
        }
        return isExist;
    }
    filterTypesAndTemplateAsPerRight() {
        if (this.TypeList.length == 0)
            return;
        let filteredTypeList = [];
        let filteredTemplateList = [];
        for (let i = 0; i < this.TypeList.length; i++) {
            if (GlobalFunctions.hasAllowDataRights(ContentType.Email, OperationType.TemplateTypes, this.TypeList[i].Id)) {
                filteredTypeList.push(this.TypeList[i]);
                let templateList = this.getTemplateByType(this.TypeList[i].Id);
                for (let j = 0; j < templateList.length; j++) {
                    if (!this.isTemplateExistInList(templateList[j].Name, filteredTemplateList))
                        filteredTemplateList.push(templateList[j]);
                }
            }
        }
        this.TypeList = filteredTypeList;
        this.TemplateList = filteredTemplateList;
    }
    setSettings(value) {
        if (!GlobalFunctions.isEmpty(value)) {
            let xmlDoc = $.parseXML(value);
            this.TemplateList = [];
            this.TypeList = [];
            let templates = $(xmlDoc).find('EMAILTEMPLATE');
            if (!GlobalFunctions.isEmpty(templates)) {
                templates.each((i, template) => {
                    if (!this.isTemplateExistInList(template.getAttribute('NAME'), this.TemplateList)) {
                        let attachments = $(template).find('ATTACHMENT');
                        let attachmentArray = [];
                        if (!GlobalFunctions.isEmpty(attachments)) {
                            attachments.each((i, attachment) => {
                                if (!GlobalFunctions.isEmpty(attachment.getAttribute('ID')))
                                    attachmentArray.push({ Id: attachment.getAttribute('ID'), Name: attachment.getAttribute('NAME'), Title: attachment.getAttribute('TITLE'), Path: attachment.getAttribute('CONTENT') });
                            });
                        }
                        this.TemplateList.push({ Id: template.getAttribute('ID'), Name: template.getAttribute('NAME'), Content: template.getAttribute('TEXT'), Type: template.getAttribute('TYPE'), Subject: template.getAttribute('SUBJECT'), ToEmailAddresses: template.getAttribute('TOEMAILADDRESSES'), CcEmailAddresses: template.getAttribute('CCEMAILADDRESSES'), BccEmailAddresses: template.getAttribute('BCCEMAILADDRESSES'), Attachments: attachmentArray });
                    }
                });
            }
            let templateTypes = $(xmlDoc).find('EMAILTEMPLATETYPE');
            if (!GlobalFunctions.isEmpty(templateTypes)) {
                templateTypes.each((i, templateType) => {
                    this.TypeList.push({
                        Id: templateType.getAttribute('ID'),
                        Name: templateType.getAttribute('NAME')
                    });
                });
            }
            this.filterTypesAndTemplateAsPerRight();
        }
    }
}
//# sourceMappingURL=email-template-setting.js.map