import { GlobalFunctions } from "src/app/shared/global-functions";
import { OperationType } from "../../enums/common-enums";
import { Dashboard } from "../dashboard/dashboard";
import { DashboardWebTile } from "../dashboard/dashboard-web-tile";
import { DashboardWebtileType } from "../dashboard/dashboard-web-tile-type";
import { DashboardWebpartLink } from "../dashboard/dashboard-webpart-link";
import { DashboardWebpart } from "../dashboard/dashboard-webparts";
import { DashboardRole } from "../dashboard/dashhboard-role";
export class DashboardSetting {
    constructor() {
        this.dashboardList = [];
        this.webtileDefaultType = new DashboardWebtileType();
        this.getWebtileType = (webtiles) => {
            let dashboardWebtileType = new DashboardWebtileType();
            if (webtiles != null && webtiles.length > 0) {
                for (let index = 0; index < webtiles.length; index++) {
                    if (this.webtileDefaultType.Task.indexOf(webtiles[index].Type) != -1)
                        dashboardWebtileType.Task = dashboardWebtileType.Task + webtiles[index].Type;
                    else if (this.webtileDefaultType.Contact.indexOf(webtiles[index].Type) != -1)
                        dashboardWebtileType.Contact = dashboardWebtileType.Contact + webtiles[index].Type;
                    else if (this.webtileDefaultType.Ticket.indexOf(webtiles[index].Type) != -1)
                        dashboardWebtileType.Ticket = dashboardWebtileType.Ticket + webtiles[index].Type;
                    else if (this.webtileDefaultType.Social.indexOf(webtiles[index].Type) != -1)
                        dashboardWebtileType.Social = dashboardWebtileType.Social + webtiles[index].Type;
                    else if (this.webtileDefaultType.Email.indexOf(webtiles[index].Type) != -1)
                        dashboardWebtileType.Email = dashboardWebtileType.Email + webtiles[index].Type;
                    else if (this.webtileDefaultType.Document.indexOf(webtiles[index].Type) != -1)
                        dashboardWebtileType.Document = dashboardWebtileType.Document + webtiles[index].Type;
                }
            }
            return dashboardWebtileType;
        };
        this.hasRights = (type) => {
            let rights = false;
            if (!GlobalFunctions.isEmpty(type)) {
                type = type.toUpperCase();
                if (type === 'MOSTSELECTEDBYEVERYONE' || type === 'MOSTSELECTEDBYME' || type === 'MOSTSELECTEDBYROLE' || type === 'IMPORTANT' || type === 'MYFAVOURITE')
                    rights = true;
                else {
                    if (type === 'NOTIFICATIONS')
                        type = 'NOTEENTITY';
                    else if (type === 'BIRTHDAYWEEK')
                        type = 'EMPLOYEE';
                    else if (type === 'RSSFEED')
                        type = 'NEWS';
                    else if (type === 'POST')
                        type = 'DOCUMENT';
                    else if (type === 'CONTACT')
                        type = 'CONTACTMOMENT';
                    rights = GlobalFunctions.checkRights(type, OperationType.View);
                }
            }
            return rights;
        };
        this.hasWebpartLinkRights = (type, entity, source) => {
            let rights = type.toUpperCase() !== 'IMPORTANT';
            if (!rights) {
                if (entity.toUpperCase() === "PERSON" || entity.toUpperCase() === "ORGANIZATION") {
                    rights = GlobalFunctions.hasRight(entity, OperationType.View, source);
                    if (rights === null)
                        rights = GlobalFunctions.checkRights(entity, OperationType.View);
                }
                else
                    rights = GlobalFunctions.checkRights(entity, OperationType.View);
            }
            return rights;
        };
        this.searchByRoleId = (roleId) => {
            let dashboard = null;
            if (!GlobalFunctions.isEmpty(roleId) && this.dashboardList != null && this.dashboardList.length > 0)
                for (let index = 0; index < this.dashboardList.length; index++) {
                    let role = jlinq.from(this.dashboardList[index].Roles).starts("Id", roleId).first();
                    if (role != null) {
                        dashboard = this.dashboardList[index];
                        break;
                    }
                }
            return dashboard;
        };
        this.updateWebtiledata = (dashboardId, webtile) => {
            if (!GlobalFunctions.isEmpty(dashboardId) && webtile != null && this.dashboardList != null && this.dashboardList.length > 0) {
                let dashboard = jlinq.from(this.dashboardList).starts("Id", dashboardId).first();
                if (dashboard != null && dashboard.Webtiles != null && dashboard.Webtiles.length > 0) {
                    let existWebtile = jlinq.from(dashboard.Webtiles).starts("Id", webtile.Id).first();
                    if (existWebtile != null) {
                        existWebtile.Count = !GlobalFunctions.isEmpty(webtile.Count) ? webtile.Count : '...';
                        existWebtile.TooltipText = !GlobalFunctions.isEmpty(webtile.TooltipText) ? webtile.TooltipText : '...';
                        ;
                    }
                }
            }
        };
        this.webtileDefaultType.Contact = "|HANDLEDTASKBYME|HANDLEDTASKBYROLE|HANDLEDTASKBYDEPARTMENT|HANDLEDSOCIALMEDIABYME|HANDLEDSOCIALMEDIABYDEPARTMENT|HANDLEDEMAILBYME|CONTACTBYME|CONTACTBYDEPARTMENT|CONTACTBYROLE|CONTACTBYALL|";
        this.webtileDefaultType.Task = "|OPENTASKFORME|OPENTASKFORROLE|OPENTASKFORDEPARTMENT|CREATEDTASKBYME|CREATEDTASKBYROLE|CREATEDTASKBYDEPARTMENT|";
        this.webtileDefaultType.Ticket = "|OPENTICKETFORME|OPENTICKETFORDEPARTMENT|CREATEDTICKETBYME|CREATEDTICKETBYDEPARTMENT|HANDLEDTICKETBYME|HANDLEDTICKETBYDEPARTMENT|";
        this.webtileDefaultType.Social = "|TOTALOPENSOCIALMEDIA|INPROGRESSSOCIALMEDIABYME|INPROGRESSSOCIALMEDIABYDEPARTMENT|";
        this.webtileDefaultType.Email = "|TOTALOPENEMAILPERMAILBOX|";
        this.webtileDefaultType.Document = "|TOTALOPENPOST|";
    }
    initialize(value, sessionManager) {
        try {
            if (!GlobalFunctions.isEmpty(value)) {
                const xmlDoc = $.parseXML(value);
                this.dashboardList = [];
                const dashboards = $(xmlDoc).find('DASHBOARD');
                if (!GlobalFunctions.isEmpty(dashboards)) {
                    dashboards.each((i, dashboard) => {
                        const newDashboard = new Dashboard();
                        newDashboard.Id = dashboard.getAttribute('ID');
                        newDashboard.Title = dashboard.getAttribute('NAME');
                        newDashboard.IsDefault = dashboard.getAttribute('ISDEFAULT') === 'true';
                        newDashboard.WebtileType = new DashboardWebtileType();
                        newDashboard.Webparts = [];
                        const webparts = $(dashboard).find('WEBPART');
                        webparts.each((i, webpart) => {
                            if (!GlobalFunctions.isEmpty(webpart.getAttribute('ID'))) {
                                const type = webpart.getAttribute('TYPE');
                                if (this.hasRights(type)) {
                                    const newWebpart = new DashboardWebpart();
                                    newWebpart.Id = webpart.getAttribute('ID');
                                    newWebpart.Title = webpart.getAttribute('TITLE');
                                    newWebpart.Type = type;
                                    newWebpart.IsSystem = webpart.getAttribute('ISSYSTEM') === 'true';
                                    newWebpart.IsSortable = webpart.getAttribute('ISSORTABLE') === 'true';
                                    newWebpart.Order = parseInt(webpart.getAttribute('ORDER'));
                                    newWebpart.Width = parseInt(webpart.getAttribute('WIDTH'));
                                    newWebpart.DisplayCount = parseInt(webpart.getAttribute('DISPLAYCOUNT'));
                                    newWebpart.Height = (newWebpart.DisplayCount * 33) + "px";
                                    newWebpart.Links = [];
                                    const links = $(webpart).find('LINKS');
                                    links.each((i, link) => {
                                        if (!GlobalFunctions.isEmpty(link.getAttribute('ID'))) {
                                            if (this.hasWebpartLinkRights(type, link.getAttribute('ENTITY'), link.getAttribute('SOURCE'))) {
                                                const newLink = new DashboardWebpartLink();
                                                newLink.Id = link.getAttribute('ID');
                                                newLink.StringRepresentation = link.getAttribute('TITLE');
                                                newLink.Number = link.getAttribute('NUMBER');
                                                if (!GlobalFunctions.isEmpty(link.getAttribute('DATE')))
                                                    newLink.Date = new Date(link.getAttribute('DATE'));
                                                newLink.Link = link.getAttribute('LINK');
                                                newLink.Entity = link.getAttribute('ENTITY');
                                                newLink.RelatedEntityFqdn = GlobalFunctions.toContentType(newLink.Entity);
                                                newLink.Icon = GlobalFunctions.getIconClass(newLink.RelatedEntityFqdn);
                                                newLink.RelatedEntityFqdn = newLink.RelatedEntityFqdn.replace(/\./g, '_');
                                                newLink.ObjectSource = link.getAttribute('SOURCE');
                                                newLink.Order = parseInt(link.getAttribute('ORDER'));
                                                newWebpart.Links.push(newLink);
                                            }
                                        }
                                    });
                                    if (newWebpart.Links.length > 0)
                                        sessionManager.setBgColorBasedOnObjectSource(newWebpart.Links);
                                    newDashboard.Webparts.push(newWebpart);
                                }
                            }
                        });
                        newDashboard.Webtiles = [];
                        newDashboard.PerRowTiles = parseInt($(dashboard).find('WEBTILES')[0].getAttribute('PERROWCOUNT'));
                        const webtiles = $(dashboard).find('WEBTILE');
                        webtiles.each((i, webtile) => {
                            if (!GlobalFunctions.isEmpty(webtile.getAttribute('ID'))) {
                                const entity = webtile.getAttribute('ENTITY');
                                if (this.hasRights(entity)) {
                                    const newWebtile = new DashboardWebTile();
                                    newWebtile.Id = webtile.getAttribute('ID');
                                    newWebtile.Entity = webtile.getAttribute('ENTITY');
                                    newWebtile.Type = webtile.getAttribute('TYPE').toUpperCase();
                                    newWebtile.Order = parseInt(webtile.getAttribute('ORDER'));
                                    newWebtile.Color = webtile.getAttribute('COLOR');
                                    newDashboard.Webtiles.push(newWebtile);
                                }
                            }
                        });
                        newDashboard.WebtileType = this.getWebtileType(newDashboard.Webtiles);
                        newDashboard.Roles = [];
                        const roles = $(dashboard).find('ROLE');
                        roles.each((i, role) => {
                            if (!GlobalFunctions.isEmpty(role.getAttribute('ID'))) {
                                const newRole = new DashboardRole();
                                newRole.Id = role.getAttribute('ID');
                                newRole.Title = role.getAttribute('TITLE');
                                newDashboard.Roles.push(newRole);
                            }
                        });
                        newDashboard.Webparts.sort((x, y) => (x.Order - y.Order));
                        this.dashboardList.push(newDashboard);
                    });
                }
            }
        }
        catch (e) {
            console.error(e);
        }
    }
    ;
    getDefaultDashboard() {
        let dashboard = null;
        if (this.dashboardList != null && this.dashboardList.length > 0)
            dashboard = jlinq.from(this.dashboardList).starts("IsDefault", true).first();
        return dashboard;
    }
    ;
    updateWebpartData(type, item) {
        if (this.dashboardList != null && this.dashboardList.length > 0) {
            for (let d = 0; d < this.dashboardList.length; d++) {
                const dashboard = this.dashboardList[d];
                if (dashboard != null && dashboard.Webparts != null && dashboard.Webparts.length > 0) {
                    const existWebpart = jlinq.from(dashboard.Webparts).equals("Type", type.toUpperCase()).first();
                    if (existWebpart != null && existWebpart.Links != null && existWebpart.Links.length > 0) {
                        const existWebpartLink = jlinq.from(existWebpart.Links).equals("Id", item.Id).first();
                        if (existWebpartLink != null)
                            existWebpartLink.StringRepresentation = item.StringRepresentation;
                    }
                }
            }
        }
    }
}
//# sourceMappingURL=dashboard-setting.js.map