import { GlobalFunctions } from "../../../shared/global-functions";
import { OperationType } from "../../enums/common-enums";
import { TaskDtoSource } from "../jkc-object/jkc-object";
export class ActionMenu {
    constructor(translateService) {
        this.translateService = translateService;
        this.actionMenuItems = [];
        this.defaultActionMenuItem = null;
        this.init();
    }
    addLicencedMenuItem(sessionManager) {
        if (sessionManager.isThemeFeatureEnabled)
            this.addMenuItem("LBL_THEME", "ADD_THEME", OperationType.Add, GlobalFunctions.toContentType("THEME"));
        if (sessionManager.isSocialMediaFeatureEnabled)
            this.addMenuItem("LBL_SOCIAL_MEDIA", "ADD_SOCIALMEDIA", OperationType.Add, GlobalFunctions.toContentType("SocialMedia"));
        if (sessionManager.isIssueFeatureEnabled)
            this.addMenuItem("LBL_ISSUE", "ADD_ISSUE", OperationType.Add, GlobalFunctions.toContentType("Issue"));
    }
    addMenuItem(title, key, operation, oldContentType, dontCheckRight = false, objectSource = null) {
        if (!this.isMenuItemExists(key)) {
            if (operation == OperationType.Add && !dontCheckRight && GlobalFunctions.hasRight(oldContentType, operation, objectSource) && GlobalFunctions.hasRight(oldContentType, OperationType.View, objectSource))
                this.actionMenuItems.push(new ActionMenuItem(title, key));
            else if (dontCheckRight || GlobalFunctions.hasRight(oldContentType, operation, objectSource))
                this.actionMenuItems.push(new ActionMenuItem(title, key));
        }
    }
    removeMenuItem(key) {
        if (!GlobalFunctions.isEmpty(key)) {
            for (let index = 0; index < this.actionMenuItems.length; index++) {
                if (this.actionMenuItems[index].key.toLocaleLowerCase() == key.toLocaleLowerCase()) {
                    this.actionMenuItems.splice(index, 1);
                    break;
                }
            }
        }
    }
    isMenuItemExists(key) {
        let exists = false;
        if (!GlobalFunctions.isEmpty(key)) {
            for (let index = 0; index < this.actionMenuItems.length; index++) {
                if (this.actionMenuItems[index].key.toLocaleLowerCase() == key.toLocaleLowerCase()) {
                    exists = true;
                    break;
                }
            }
        }
        return exists;
    }
    init() {
        this.addMenuItem("LBL_CALLBACK_NOTE", "ADD_CALLBACKNOTE", OperationType.Add, GlobalFunctions.toContentType("Task"), false, TaskDtoSource.CallbackNotes);
        this.addMenuItem("LBL_APPOINTMENT", "ADD_APPOINTMENT", OperationType.Add, GlobalFunctions.toContentType("Task"), false, TaskDtoSource.Appointments);
        this.addMenuItem("LBL_INFORMATION_REQUEST", "ADD_INFORMATIONREQUEST", OperationType.Add, GlobalFunctions.toContentType("Task"), false, TaskDtoSource.InformationRequest);
        this.addMenuItem("LBL_ASSIGNMENT", "ADD_ASSIGNMENT", OperationType.Add, GlobalFunctions.toContentType("Task"), false, TaskDtoSource.Assignments);
        this.addMenuItem("LBL_NOTE", "ADD_NOTE", OperationType.Add, GlobalFunctions.toContentType("NoteEntity"));
        this.addMenuItem("LBL_CASE", "ADD_CASE", OperationType.Add, GlobalFunctions.toContentType("CaseEntity"));
        this.addMenuItem("LBL_DOCUMENT", "ADD_DOCUMENT", OperationType.Add, GlobalFunctions.toContentType("Document"));
        this.addMenuItem("LBL_ORGANIZATION", "ADD_ORGANIZATION", OperationType.Add, GlobalFunctions.toContentType("Organization"));
        this.addMenuItem("LBL_PERSON", "ADD_PERSON", OperationType.Add, GlobalFunctions.toContentType("Person"));
        this.addMenuItem("LBL_EMAIL", "EMAIL_DIALOG", OperationType.Email, GlobalFunctions.toContentType("Email"));
        this.addMenuItem("LBL_FILE_ENTITY", "ADD_FILE", OperationType.Add, GlobalFunctions.toContentType("FileEntity"));
        this.addMenuItem("LBL_QUICK_LINK", "ADD_LINK", OperationType.Add, GlobalFunctions.toContentType("Link"));
        if (this.actionMenuItems.length > 0)
            this.defaultActionMenuItem = this.actionMenuItems[0];
        else
            this.defaultActionMenuItem = new ActionMenuItem(this.translateService.instant("LBL_SELECT_ANY_PLAIN"), "SELECT_ANY");
    }
}
class ActionMenuItem {
    constructor(title, key) {
        this.title = title;
        this.key = key;
    }
}
//# sourceMappingURL=action-menu.js.map