var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Injectable } from "@angular/core";
import { GlobalFunctions } from "src/app/shared/global-functions";
import { BaseService } from "../services/base-service";
let X2JS = require('x2js');
let SortManager = class SortManager extends BaseService {
    constructor(zone, router, httpClient, eventProvider, applicationSettingManager) {
        super(zone, router, httpClient, eventProvider);
        this.zone = zone;
        this.router = router;
        this.httpClient = httpClient;
        this.eventProvider = eventProvider;
        this.applicationSettingManager = applicationSettingManager;
        this.sortDictionary = {};
        this.sortItemsList = (sortItems, items) => {
            let fields = "";
            for (let i = 0; i < sortItems.length; i++) {
                let prefix = "";
                if (sortItems[i].Descending.toLowerCase() == "true")
                    prefix = "-";
                fields += "\"" + prefix + sortItems[i].PropertyName + "\",";
            }
            fields = fields.substring(0, fields.length - 1);
            return eval("jlinq.from(items).sort(" + fields + ").select();");
        };
    }
    initialize() {
        try {
            const settingValue = this.applicationSettingManager.getApplicationSettingValueByKey("ContentSortOrderList");
            if (!GlobalFunctions.isEmpty(settingValue)) {
                const x2js = new X2JS();
                const jsonObj = x2js.xml2js(settingValue);
                if (jsonObj?.ContentSortOrderList?.SortItem) {
                    jsonObj.ContentSortOrderList.SortItem = GlobalFunctions.ConvertToArrayIfOnlySingleObject(jsonObj.ContentSortOrderList.SortItem);
                    $.each(jsonObj.ContentSortOrderList.SortItem, (index, value) => {
                        const sortItemObject = new Object();
                        let newContentType = GlobalFunctions.getObjectTypeName(value._ContentType);
                        if (newContentType) {
                            newContentType = newContentType.toUpperCase();
                            sortItemObject.ContentType = value._ContentType;
                            const oldFieldName = value._PropertyName;
                            const tokens = oldFieldName.split(".").slice(5);
                            const fieldName = tokens.join(".");
                            if (newContentType == "TASK")
                                sortItemObject.PropertyName = "ObjectSourceDto." + fieldName;
                            else
                                sortItemObject.PropertyName = fieldName;
                            sortItemObject.Descending = value._Descending;
                            sortItemObject.Order = value._Order;
                            if (this.sortDictionary[newContentType] == null)
                                this.sortDictionary[newContentType] = [];
                            this.sortDictionary[newContentType].push(sortItemObject);
                            this.sortDictionary[newContentType] = jlinq.from(this.sortDictionary[newContentType]).sort("order").select();
                        }
                    });
                }
            }
        }
        catch (e) {
            console.error(e);
        }
        ;
    }
    sortEntityBasedOnApplicationSetting(entityType, items) {
        if (entityType === "CONTACTHISTORY")
            entityType = "CONTACTMOMENT";
        if (entityType === "NEWS")
            entityType = "ITEM";
        let sortItems = this.sortDictionary[entityType];
        if (sortItems == undefined)
            sortItems = this.sortDictionary[entityType];
        if (sortItems?.length > 0)
            items = this.sortItemsList(sortItems, items);
        return items;
    }
    ;
    sortItemsBasedOnProperty(items, propertyName) {
        if (items != null && items.length > 0) {
            let fields = "";
            for (let i = 0; i < items.length; i++)
                fields += "\"" + "-" + propertyName + "\",";
            fields = fields.substring(0, fields.length - 1);
            let evalToExecute = "jlinq.from(items).sort(" + fields + ").select();";
            items = eval(evalToExecute);
        }
        return items;
    }
    ;
    clear() {
        this.sortDictionary = {};
    }
};
SortManager = __decorate([
    Injectable({
        providedIn: 'root'
    })
], SortManager);
export { SortManager };
//# sourceMappingURL=sort-manager.js.map