var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Injectable } from '@angular/core';
import hotkeys from 'hotkeys-js';
import { GlobalFunctions } from '../../shared/global-functions';
import { OperationType } from '../enums/common-enums';
import { Shortcut } from '../models/common/shortcut';
let ShortcutManager = class ShortcutManager {
    constructor() {
        this.hotkeys = [];
        this.shortcuts = [];
        this.initialized = false;
    }
    init() {
        return new Promise((resolve, reject) => {
            if (this.initialized)
                return resolve();
            this.getShortcuts().forEach(x => {
                if (this.checkRights(x.label))
                    this.shortcuts.push(new Shortcut(x.key, x.label));
            });
            // Enables hotkeys on INPUT, SELECT and TEXTAREA elements
            hotkeys.filter = () => true;
            this.initialized = true;
            return resolve();
        });
    }
    ;
    bind(label, callback) {
        const shortcut = this.getShortcut(label);
        if (!this.hotkeys.includes(shortcut)) {
            hotkeys(shortcut?.key, (event) => {
                event.preventDefault();
                callback();
            });
            this.hotkeys.push(shortcut);
        }
    }
    ;
    unbind(label) {
        const shortcut = this.getShortcut(label);
        if (this.hotkeys.includes(shortcut)) {
            hotkeys.unbind(shortcut?.key);
            this.hotkeys.splice(this.hotkeys.indexOf(shortcut), 1);
        }
    }
    ;
    getShortcut(label) {
        return this.shortcuts.find(shortcut => label === shortcut.label);
    }
    getShortcutDetails(phoneManager, applicationFeatureManager) {
        if (!phoneManager.phoneState.IsPhoneFeatureEnabled) {
            for (let index = 0; index < this.shortcuts.length; index++) {
                if (this.shortcuts[index].label.indexOf('LBL_SHORTCUT_PHONE') > -1) {
                    this.shortcuts.splice(index, 1);
                    index--;
                }
            }
        }
        if (!applicationFeatureManager.isShowNextEmailFeatureEnabled) {
            for (let index = 0; index < this.shortcuts.length; index++) {
                if (this.shortcuts[index].label.indexOf('LBL_SHORTCUT_NEXT_EMAIL') > -1) {
                    this.shortcuts.splice(index, 1);
                    index--;
                }
            }
        }
        return this.shortcuts;
    }
    ;
    getShortcuts() {
        return [
            { key: 'alt+j', label: 'LBL_SHORTCUT_SEARCH_BOX' },
            { key: 'alt+r', label: 'LBL_SHORTCUT_SEARCH_WITHIN_RESULTS' },
            { key: 'alt+g', label: 'LBL_SHORTCUT_ADVANCE_SEARCH' },
            { key: 'alt+b', label: 'LBL_SHORTCUT_ADD_CALLBACK_NOTE' },
            { key: 'alt+n', label: 'LBL_SHORTCUT_NEXT_EMAIL' },
            { key: 'alt+m', label: 'LBL_SHORTCUT_EMPLOYEE_POPUP_PANEL' },
            { key: 'alt+y', label: 'LBL_SHORTCUT_SEND_EMAIL' },
            { key: 'alt+k', label: 'LBL_SHORTCUT_END_SESSION' },
            { key: 'alt+u', label: 'LBL_SHORTCUT_ACTIVATE_ACTION_MENU' },
            { key: 'alt+s', label: 'LBL_SHORTCUT_ACTIVATE_SETTING_MENU' },
            { key: 'alt+w', label: 'LBL_SHORTCUT_CONTEXT_MENU' },
            { key: 'alt+1', label: 'LBL_SHORTCUT_ACTION_BUTTON_1' },
            { key: 'alt+2', label: 'LBL_SHORTCUT_ACTION_BUTTON_2' },
            { key: 'alt+o', label: 'LBL_SHORTCUT_SAVE_BUTTON' },
            { key: 'alt+q', label: 'LBL_SHORTCUT_PHONE' },
            { key: 'alt+i', label: 'LBL_SHORTCUT_PHONE_PICK_UP_CALL' },
            { key: 'alt+z', label: 'LBL_SHORTCUT_PHONE_HANG_UP_CALL' },
            { key: 'alt+x', label: 'LBL_SHORTCUT_PHONE_TRANSFER_CALL' },
            { key: 'alt+l', label: 'LBL_SHORTCUT_PHONE_CANCEL_CALL' },
            { key: 'alt+h', label: 'LBL_SHORTCUT_PHONE_HOLD_UNHOLD_CALL' }
        ];
    }
    ;
    checkRights(label) {
        switch (label) {
            case 'LBL_SHORTCUT_ADD_CONTACT_HISTORY':
                return GlobalFunctions.hasRight(GlobalFunctions.toContentType('ContactMoment'), OperationType.Add);
            case 'LBL_SHORTCUT_ADD_CASE':
                return GlobalFunctions.hasRight(GlobalFunctions.toContentType('CaseEntity'), OperationType.Add);
            case 'LBL_SHORTCUT_ADD_DOCUMENT':
                return GlobalFunctions.hasRight(GlobalFunctions.toContentType('Document'), OperationType.Add);
            case 'LBL_SHORTCUT_ADD_CALLBACK_NOTE':
                return GlobalFunctions.hasRight(GlobalFunctions.toContentType('Task'), OperationType.Add);
            case 'LBL_SHORTCUT_ADD_ORGANIZATION':
                return GlobalFunctions.hasRight(GlobalFunctions.toContentType('Organization'), OperationType.Add);
            case 'LBL_SHORTCUT_ADD_APPOINTMENT':
                return GlobalFunctions.hasRight(GlobalFunctions.toContentType('Task'), OperationType.Add);
            case 'LBL_SHORTCUT_NEXT_EMAIL':
                return GlobalFunctions.hasRight(GlobalFunctions.toContentType('Email'), OperationType.Email);
            case 'LBL_SHORTCUT_SEND_EMAIL':
                return GlobalFunctions.hasRight(GlobalFunctions.toContentType('Email'), OperationType.Email);
            case 'LBL_SHORTCUT_EMPLOYEE_POPUP_PANEL':
                return GlobalFunctions.hasRight(GlobalFunctions.toContentType('Employee'), OperationType.View);
            default:
                return true;
        }
    }
    ;
};
ShortcutManager = __decorate([
    Injectable({
        providedIn: 'root'
    })
], ShortcutManager);
export { ShortcutManager };
//# sourceMappingURL=shortcut-manager.js.map