var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Injectable } from "@angular/core";
import { cloneDeep } from "lodash";
import { IncomingCallComponent } from "../../components/domain/phone/incoming-call/incoming-call.component";
import { IncomingSessionComponent } from "../../components/domain/phone/incoming-session/incoming-session.component";
import { PhoneStatusComponent } from "../../components/domain/phone/phone-status/phone-status.component";
import { RecallComponent } from "../../components/domain/phone/recall/recall.component";
import { EntityName, LanaguageCode, LocalStorageKey, RoutePath } from "../../shared/constants";
import { GlobalFunctions } from "../../shared/global-functions";
import { ExceptionHelper } from "../../shared/helper/exception-helper";
import { LicenseSpecificFeature, ScreenMode } from "../enums/common-enums";
import { EntityFqdn } from "../enums/core-enums";
import { CallStatus, PhoneStatus } from "../enums/phone-enum";
import { SessionStatus, UIState } from "../enums/session-enum";
import { BaseDto } from "../models/common/baseDto";
import { PhoneState } from "../models/common/phone-state";
import { UpdateEmployeeStatusRequest } from "../models/employee/update-employee-status-request";
import { SourceType } from "../models/jkc-object/jkc-object";
import { PhoneCallerDetailDto } from "../models/phone/phone-caller-detailDto";
import { PhoneExtensionDto } from "../models/phone/phone-extensionDto";
import { PhoneTransferSessionManagerDto } from "../models/phone/phone-transfer-session-managerDto";
import { BaseService } from "../services/base-service";
const JsPanel = require('../../../../node_modules/jspanel4/dist/jspanel.min.js');
let PhoneManager = class PhoneManager extends BaseService {
    constructor(zone, router, httpClient, eventProvider, sessionManager, phoneService, translateService, employeeService, applicationSettingManager, personService, organizationService, cacheManager, notificationMessageManager) {
        super(zone, router, httpClient, eventProvider);
        this.zone = zone;
        this.router = router;
        this.httpClient = httpClient;
        this.eventProvider = eventProvider;
        this.sessionManager = sessionManager;
        this.phoneService = phoneService;
        this.translateService = translateService;
        this.employeeService = employeeService;
        this.applicationSettingManager = applicationSettingManager;
        this.personService = personService;
        this.organizationService = organizationService;
        this.cacheManager = cacheManager;
        this.notificationMessageManager = notificationMessageManager;
        this.phoneState = new PhoneState();
        this.endSessionCallback = null;
        this.saveTaskCallback = null;
        this.isExtensionNumber = false;
        this.extensionNumberLength = 6;
        this.isCallerLoaded = false;
        this.failedCallMessageTitle = "";
        this.failedCallMessageDescription = "";
        this.IsCallerIdResolved = false;
        this.recallEvent = this.recallEvent.bind(this);
        this.newCallEvent = this.newCallEvent.bind(this);
        this.endCallEvent = this.endCallEvent.bind(this);
        this.transferSessionEvent = this.transferSessionEvent.bind(this);
        this.registerPeerResponse = this.registerPeerResponse.bind(this);
        this.callStatusChangedEvent = this.callStatusChangedEvent.bind(this);
        this.updatePhoneAvailabilityStatusResponse = this.updatePhoneAvailabilityStatusResponse.bind(this);
        this.personResponse = this.personResponse.bind(this);
        this.organizationResponse = this.organizationResponse.bind(this);
        this.phoneService.setUpdatePhoneStatusCallback(this.updatePhoneAvailabilityStatusResponse);
    }
    updateCallerDetail(phoneNumber, name, picture) {
        this.phoneState.CurrentCaller.PhoneNumber = phoneNumber;
        this.phoneState.CurrentCaller.Name = name;
        if (picture != null && picture.length > 0)
            this.phoneState.CurrentCaller.Picture = picture;
        else
            this.phoneState.CurrentCaller.Picture = 'assets/images/nophoto.png';
    }
    updateDialerDetail(phoneNumber, name, picture, id = null) {
        this.phoneState.CurrentDialer.PhoneNumber = phoneNumber;
        this.phoneState.CurrentDialer.Name = name;
        if (picture != null && picture.length > 0)
            this.phoneState.CurrentDialer.Picture = picture;
        else
            this.phoneState.CurrentDialer.Picture = 'assets/images/nophoto.png';
        this.phoneState.CurrentDialer.EmployeeId = id;
    }
    loadResolvedItem(callerDetail) {
        if (callerDetail.Item != null) {
            this.sessionManager.selectedEntity = callerDetail.Item;
            let phoneRelatedItems = new Array();
            phoneRelatedItems.push(callerDetail.Item);
            phoneRelatedItems.forEach(phoneRelatedItem => {
                if (callerDetail.ItemType == EntityFqdn.Decos_Kcs_Persons_Entities_Person)
                    phoneRelatedItem.locationUrl = `${RoutePath.DETAIL_PATH}/${EntityName.PERSON}/${phoneRelatedItem.Id}`;
                else
                    phoneRelatedItem.locationUrl = `${RoutePath.DETAIL_PATH}/${EntityName.ORGANIZATION}/${phoneRelatedItem.Id}`;
            });
            this.sessionManager.addBreadcrumbItems(phoneRelatedItems, null, this.router.url);
            if (callerDetail.ItemType == EntityFqdn.Decos_Kcs_Persons_Entities_Person)
                this.router.navigate([RoutePath.DETAIL_PATH, EntityName.PERSON, callerDetail.Item.Id]);
            else
                this.router.navigate([RoutePath.DETAIL_PATH, EntityName.ORGANIZATION, callerDetail.Item.Id]);
        }
    }
    autoRegisterInPhone(employeeExtensionNumber) {
        try {
            if (this.phoneState.IsCiscoPhoneEnabled || !this.sessionManager.showTopHeader)
                return;
            if (GlobalFunctions.isEmpty(this.phoneState.RegisteredExtension) && !GlobalFunctions.isEmpty(employeeExtensionNumber)) {
                this.phoneService.setRegisterPeerResponseCallback(this.registerPeerResponse);
                this.tempExtensionNumber = employeeExtensionNumber;
                let extension = new PhoneExtensionDto();
                extension.Id = employeeExtensionNumber;
                this.phoneService.registerPeerRequest(extension);
            }
        }
        catch (e) {
            ExceptionHelper.showException(null, null, false, e.message, "");
        }
    }
    registerPeerResponse(message) {
        try {
            this.phoneService.setRegisterPeerResponseCallback(null);
            console.log("Received register extension response: {0}", message);
            if (message != null && message.Success == true) {
                $("#mainPhoneContainer").hide();
                this.phoneState.RegisteredExtension = this.tempExtensionNumber;
                this.phoneState.CurrentState = CallStatus.Inactive;
                this.phoneState.PhoneAvailableStatus = PhoneStatus.Available;
                this.phoneState.EnabledPhoneFeatures.init(message.NotSupportedFeatures);
            }
        }
        catch (e) {
            ExceptionHelper.showException(null, null, false, e.message, "");
        }
    }
    unregisterExtension() {
        try {
            if (this.phoneState != null && !GlobalFunctions.isEmpty(this.phoneState.RegisteredExtension)) {
                let extension = new PhoneExtensionDto();
                extension.Id = this.phoneState.RegisteredExtension;
                this.phoneService.unregisterPeerRequest(extension);
            }
        }
        catch (e) {
            ExceptionHelper.showException(null, null, false, e.message, "");
        }
    }
    transferCall(target, name, picture, isAttended, employeeId, transferSession = false) {
        try {
            this.resetScreenPosition();
            if (this.phoneState.RegisteredExtension != undefined && this.phoneState.RegisteredExtension != '') {
                if (this.phoneState.CurrentCallDto != null) {
                    target = target.split("-").join("").trim().replace(/ /g, "");
                    this.updateDialerDetail(target, name, picture, employeeId);
                    let transferSessionManagerDto = null;
                    if (transferSession) {
                        let targetEmployeeId = !GlobalFunctions.isEmpty(employeeId) ? employeeId : cloneDeep(this.phoneState.CurrentDialer.EmployeeId);
                        transferSessionManagerDto = new PhoneTransferSessionManagerDto();
                        transferSessionManagerDto.SourceNumber = this.phoneState.RegisteredExtension;
                        transferSessionManagerDto.SourceEmployeeId = GlobalFunctions.getLoggedInUserId();
                        transferSessionManagerDto.TargetNumber = target;
                        transferSessionManagerDto.TargetEmployeeId = targetEmployeeId;
                        transferSessionManagerDto.Session = this.createSession(targetEmployeeId, target);
                        transferSessionManagerDto.LastChangedDate = new Date();
                    }
                    this.phoneService.transferCallRequest(this.phoneState.CurrentCallDto, target, isAttended, transferSessionManagerDto);
                    if (isAttended && this.phoneState.CurrentCallDto != null && this.phoneState.PreviousCallDto == null) {
                        this.phoneState.PreviousCallDto = Object.assign(true, {}, this.phoneState.CurrentCallDto);
                        this.phoneState.PreviousCaller = Object.assign(true, {}, this.phoneState.CurrentCaller);
                        this.phoneState.CurrentCaller = Object.assign(true, {}, this.phoneState.CurrentDialer);
                        this.showHidePhoneStatus(false);
                        $("#mainPhoneContainer").show();
                        this.phoneState.StateBeforeAttendedTransfer = this.phoneState.CurrentState;
                        this.phoneState.CurrentState = CallStatus.AttendedTransfer;
                        this.sessionManager.phoneTransferStatus = CallStatus.AttendedTransfer;
                    }
                    else {
                        this.phoneState.CurrentState = CallStatus.Transfer;
                        this.sessionManager.phoneTransferStatus = CallStatus.Transfer;
                        this.showHidePhoneStatus(false);
                        this.endTransfer();
                    }
                }
            }
            else
                $("#mainPhoneContainer").show();
        }
        catch (e) {
            ExceptionHelper.showException(null, null, false, e.message, "");
        }
    }
    resetScreenPosition() {
        if (this.phoneState.CurrentState != CallStatus.Ringing) {
            this.phoneState.LeftMargin = "-175px";
            ;
            this.phoneState.TopMargin = "0px";
        }
    }
    createSession(targetEmployeeId, targetNumber) {
        console.log("phone manager: create session");
        let sessionUIDetail = { uiState: UIState.ContactHistory, uiObject: null };
        if (this.sessionManager.jkcParentPanel && this.sessionManager.jkcParentPanel.parameters && this.sessionManager.jkcParentPanel.parameters.IsUsed) {
            let scope = this.sessionManager.jkcParentPanel.parameters.Scope;
            if (!GlobalFunctions.isEmpty(scope))
                this.sessionManager.getSessionUIDetails(scope, sessionUIDetail);
        }
        else {
            let modalStack = null; // $modalStack.getTop(); [TODO] - Uzer Check for modal stack
            if (!GlobalFunctions.isEmpty(modalStack) && !GlobalFunctions.isEmpty(modalStack.value) && !GlobalFunctions.isEmpty(modalStack.value.modalScope))
                this.sessionManager.getSessionUIDetails(modalStack.value.modalScope, sessionUIDetail);
        }
        let sessionDescription = this.translateService.instant("LBL_SAVED_SESSION");
        if (!GlobalFunctions.isEmpty(this.sessionManager.currentSession) && !GlobalFunctions.isEmpty(this.sessionManager.currentSession.Description))
            sessionDescription = this.sessionManager.currentSession.Description;
        let forwardedTo = !GlobalFunctions.isEmpty(targetEmployeeId) ? targetEmployeeId : targetNumber;
        console.log("phone manager: create session: forwarded to: " + forwardedTo);
        let session = this.sessionManager.createCurrentSession(SessionStatus.Park, sessionDescription, forwardedTo, sessionUIDetail.uiObject, sessionUIDetail.uiState, this.sessionManager.sessionStartDateTime);
        return session;
    }
    showHidePhoneStatus(show) {
        try {
            if (this.phoneState.ShowPhoneStatus == show)
                return;
            this.phoneState.ShowPhoneStatus = show;
            if (show) {
                this.checkLoadedEntity();
                $("#phoneStatusContainer").empty();
                const componentRef = this.sessionManager.headerViewContainerRef.createComponent(PhoneStatusComponent);
                JsPanel.ziBase = 10000;
                this.phonePanel = JsPanel.create({
                    container: '#phoneStatusContainer',
                    id: "phonePanel",
                    borderRadius: '5px',
                    contentOverflow: 'hidden',
                    content: componentRef.location.nativeElement,
                    header: false,
                    dragit: {
                        opacity: 0.6,
                        containment: [-47, 0, 0, 0],
                        handles: '.jspanel-header',
                    },
                    resizeit: false
                });
            }
            else {
                if (!GlobalFunctions.isEmpty(this.phonePanel))
                    setTimeout(() => this.phonePanel.close(), 1);
            }
            if (this.phoneState.ShowPhoneStatus)
                this.resizePhoneStatusPanel();
            setTimeout(() => this.phoneState.ShowPhoneStatus = show, 1);
        }
        catch (e) {
            ExceptionHelper.showException(null, null, false, e.message, "");
        }
    }
    resizePhoneStatusPanel() {
        if ($("#phonePanel"))
            $("#phonePanel").css({ top: $(window).outerHeight() - 150, left: 10, width: "auto", height: 40 });
    }
    endTransfer() {
        try {
            this.isExtensionNumber = this.isValidExtensionNumber(this.phoneState.PreviousCallDto);
            this.phoneState.PreviousCallDto = null;
            this.phoneState.PreviousCaller = null;
            this.phoneState.CurrentCallDto = null;
            this.phoneState.WarmTransferCallConnected = false;
            $("#mainPhoneContainer").hide();
            if (!this.phoneState.IsCiscoPhoneEnabled)
                this.phoneState.PhoneAvailableStatus = PhoneStatus.Available;
            if (this.phoneState.CurrentState != CallStatus.Inactive) {
                this.phoneState.CurrentState = CallStatus.Inactive;
                // Instead of setEndSessionCallback use below function.
                if (!this.isExtensionNumber)
                    this.sessionManager.contactSessionNotesState.isContactSessionNotesHighlighted = true;
                if (!this.isExtensionNumber && !this.phoneState.IsCiscoPhoneEnabled) {
                    if (this.phoneState.IsMitelPhoneEnabled || this.phoneState.IsAvayaPhoneEnabled)
                        this.phoneState.PhoneAvailableStatus = PhoneStatus.NotAvailable;
                    else
                        this.updatePhoneAvailabilityStatus(PhoneStatus.NotAvailable);
                }
            }
            this.isExtensionNumber = false;
            this.phoneState.CurrentCallerRecentActivity = null;
            this.phoneState.TransferSessionManagerDto = null;
            this.sessionManager.ActivityItemsRelatedBreadCrumbs = [];
        }
        catch (e) {
            ExceptionHelper.showException(null, null, false, e.message, "");
        }
    }
    isValidExtensionNumber(callDto) {
        let isExtension = false;
        if (!GlobalFunctions.isEmpty(callDto) && !GlobalFunctions.isEmpty(callDto.CallerId) && !GlobalFunctions.isEmpty(callDto.CallerId.Id))
            isExtension = callDto.CallerId.Id.length !== 0 && !GlobalFunctions.isEmpty(this.extensionNumberLength) && callDto.CallerId.Id.length <= this.extensionNumberLength;
        return isExtension;
    }
    updatePhoneAvailabilityStatus(phoneStatusToUpdate, phoneStatusCode = "") {
        if (this.phoneState.CurrentState != CallStatus.Unregistered) {
            this.phoneService.updatePhoneStatusRequest(phoneStatusToUpdate, phoneStatusCode);
            this.updateEmployeeStatus();
        }
    }
    updatePhoneAvailabilityStatusResponse(message) {
        if (message != null) {
            if (message.CurrentStatus != null)
                this.phoneState.PhoneAvailableStatus = message.CurrentStatus;
            else if (message.Result === true) {
                if (this.phoneState.PhoneAvailableStatus === PhoneStatus.NotAvailable)
                    this.phoneState.PhoneAvailableStatus = PhoneStatus.Available;
                else
                    this.phoneState.PhoneAvailableStatus = PhoneStatus.NotAvailable;
            }
        }
        this.phoneState.SelectedPhoneStatus = this.phoneState.GetPhoneStatus(this.phoneState.PhoneAvailableStatus, message.PhoneStatusCode);
        this.changeAvailabilityStatus();
        this.phoneState.PhoneAvailableStatus;
        this.phoneState.SelectedPhoneStatus;
    }
    changeAvailabilityStatus() {
        if (this.employeeService.loggedInEmployee != null && this.phoneState.SelectedPhoneStatus && !GlobalFunctions.isEmpty(this.phoneState.SelectedPhoneStatus.employeeStatus)) {
            this.sessionManager.employeeStatus.statusIndex = this.phoneState.SelectedPhoneStatus.employeeStatus;
            this.sessionManager.employeeStatus.changeStatusIndex(this.sessionManager.employeeStatus.statusIndex);
            let updateEmployeeStatusRequest = new UpdateEmployeeStatusRequest();
            updateEmployeeStatusRequest.EmployeeStatus = this.sessionManager.employeeStatus.getEmployeeStatus();
            this.setEmployeePhoneStatus(updateEmployeeStatusRequest.EmployeeStatus);
            this.employeeService.updateEmployeeAvailabilityStatus(updateEmployeeStatusRequest);
        }
    }
    setFeatureControlsVisibility() {
        let enablePhoneColdTransfer = this.applicationSettingManager.getApplicationSettingValueByKey("EnablePhoneColdTransfer");
        this.phoneState.IsColdTransferEnabled = !GlobalFunctions.isEmpty(enablePhoneColdTransfer) && (enablePhoneColdTransfer.toLowerCase() === 'true');
        let enableSessionTransferWithCall = this.applicationSettingManager.getApplicationSettingValueByKey("EnableSessionTransferWithCall");
        this.phoneState.IsSessionTransferWithCallEnabled = GlobalFunctions.isLicenseSpecificFeatureEnabled(LicenseSpecificFeature.ForwardSession) && !GlobalFunctions.isEmpty(enableSessionTransferWithCall) && (enableSessionTransferWithCall.toLowerCase() === 'true');
        this.phoneState.IsCiscoPhoneEnabled = this.applicationSettingManager.isPhoneHandlerEnabled(SourceType.Phone_Cisco);
        this.phoneState.IsMitelPhoneEnabled = this.applicationSettingManager.isPhoneHandlerEnabled(SourceType.Phone_Mitel);
        this.phoneState.IsAvayaPhoneEnabled = this.applicationSettingManager.isPhoneHandlerEnabled(SourceType.Phone_Avaya);
        this.phoneState.IsUnexusPhoneEnabled = this.applicationSettingManager.isPhoneHandlerEnabled(SourceType.Phone_Unexus);
        this.phoneState.IsPhoneBasicFeatureEnabled = this.applicationSettingManager.isPhoneBasicEnabled();
        let enablePhoneKeepBusyFeature = this.applicationSettingManager.getApplicationSettingValueByKey("EnablePhoneAvailability");
        this.phoneState.IsPhoneKeepBusyFeatureEnabled = !GlobalFunctions.isEmpty(enablePhoneKeepBusyFeature) && (enablePhoneKeepBusyFeature.toLowerCase() === 'true');
        let enablePhonePlayAndPauseFeature = this.applicationSettingManager.getApplicationSettingValueByKey("EnablePhonePlayAndPauseFeature");
        this.phoneState.IsPhonePlayAndPauseFeatureEnabled = !GlobalFunctions.isEmpty(enablePhonePlayAndPauseFeature) && (enablePhonePlayAndPauseFeature.toLowerCase() === 'true');
        this.extensionNumberLength = Number.parseInt(this.applicationSettingManager.getApplicationSettingValueByKey("ExtensionNumberDigits"));
    }
    placeCall(phoneNumber, name, picture, employeeId = null) {
        try {
            if (this.phoneState.IsPhoneFeatureEnabled && !this.phoneState.IsPhoneBasicFeatureEnabled) {
                this.resetScreenPosition();
                if (!GlobalFunctions.isEmpty(this.phoneState.RegisteredExtension)) {
                    if (this.phoneState.CurrentCallDto != null && this.phoneState.PreviousCallDto == null) {
                        this.transferCall(phoneNumber, name, picture, true, employeeId, false);
                        return;
                    }
                    else {
                        phoneNumber = phoneNumber.split("-").join("").trim().replace(/ /g, "");
                        this.updateCallerDetail(phoneNumber, name, picture);
                    }
                    this.updateDialerDetail(phoneNumber, name, picture);
                    this.phoneState.CurrentState = CallStatus.Dialing;
                    this.phoneService.placeCallRequest(this.phoneState.RegisteredExtension, phoneNumber);
                    $("#mainPhoneContainer").show();
                    this.phoneState.PhoneAvailableStatus = PhoneStatus.NotAvailable;
                }
                else
                    setTimeout(() => { $("#mainPhoneContainer").show(); }, 1000);
            }
        }
        catch (e) {
            console.error(e.message);
        }
    }
    checkLoadedEntity() {
        if (!GlobalFunctions.isEmpty(this.sessionManager.selectedEntity)) {
            if (!GlobalFunctions.isEmpty(this.sessionManager.selectedEntity.ObjectSource) && (this.sessionManager.selectedEntity.ObjectSource.toLowerCase().indexOf("person") > -1) || (this.sessionManager.selectedEntity.ObjectSource.toLowerCase().indexOf("organization") > -1)) {
                if (this.phoneState.IsCallerIdResolved) {
                    this.phoneState.UpdateCallNumberText = this.translateService.instant("LBL_REMOVE_PHONE_NUMBER");
                    this.phoneState.SaveCallNumber = true;
                }
                else
                    this.phoneState.SaveCallNumber = false;
                this.phoneState.EnableCallNumberCheckbox = true;
            }
        }
        else {
            this.phoneState.UpdateCallNumberText = this.translateService.instant("LBL_ADD_PHONE_NUMBER");
            this.phoneState.EnableCallNumberCheckbox = false;
            this.phoneState.SaveCallNumber = false;
        }
    }
    cancelCall(sendRequest, hideMakeCallDialog) {
        try {
            this.resetScreenPosition();
            this.phoneState.CurrentCallDto = jQuery.extend(true, {}, this.phoneState.PreviousCallDto);
            this.phoneState.CurrentCaller = jQuery.extend(true, {}, this.phoneState.PreviousCaller);
            if (this.phoneState.StateBeforeAttendedTransfer == CallStatus.Hold || this.phoneState.StateBeforeAttendedTransfer == CallStatus.Active)
                this.phoneState.CurrentState = this.phoneState.StateBeforeAttendedTransfer;
            this.phoneState.PreviousCaller = null;
            this.phoneState.PreviousCallDto = null;
            this.phoneState.WarmTransferCallConnected = false;
            this.sessionManager.phoneTransferStatus = 0;
            if (!GlobalFunctions.isEmpty(sendRequest) && sendRequest)
                this.phoneService.cancelCallRequest();
            if (!GlobalFunctions.isEmpty(hideMakeCallDialog) && hideMakeCallDialog)
                $("#mainPhoneContainer").hide();
            this.showHidePhoneStatus(true);
        }
        catch (e) {
            ExceptionHelper.showException(null, null, false, e.message, "");
        }
    }
    hangupCall() {
        try {
            this.resetScreenPosition();
            if (this.phoneState.CurrentState != CallStatus.Inactive) {
                if (this.phoneState.PreviousCallDto != null)
                    this.cancelCall(true, true);
                else {
                    this.isExtensionNumber = this.isValidExtensionNumber(this.phoneState.CurrentCallDto);
                    this.phoneState.PreviousCallDto = null;
                    this.phoneState.PreviousCaller = null;
                    let currentCallDto = this.phoneState.CurrentCallDto;
                    this.phoneState.CurrentCallDto = null;
                    this.phoneState.StateBeforeAttendedTransfer = CallStatus.Inactive;
                    this.phoneState.WarmTransferCallConnected = false;
                    if (!this.phoneState.IsCiscoPhoneEnabled || this.phoneState.CurrentState === CallStatus.Dialing || this.isExtensionNumber)
                        this.phoneState.PhoneAvailableStatus = PhoneStatus.Available;
                    this.phoneService.hangupCallRequest(currentCallDto);
                    if (this.phoneState.CurrentState != CallStatus.Dialing) {
                        if (this.sessionManager.isSessionStart) {
                            if (!this.isExtensionNumber)
                                this.sessionManager.contactSessionNotesState.isContactSessionNotesHighlighted = true;
                            if (!this.isExtensionNumber && !this.phoneState.IsCiscoPhoneEnabled) {
                                if (this.phoneState.IsMitelPhoneEnabled || this.phoneState.IsAvayaPhoneEnabled)
                                    this.phoneState.PhoneAvailableStatus = PhoneStatus.NotAvailable;
                                else
                                    this.updatePhoneAvailabilityStatus(PhoneStatus.NotAvailable);
                            }
                        }
                    }
                    this.phoneState.CurrentState = CallStatus.Inactive;
                    $("#mainPhoneContainer").hide();
                    this.showHidePhoneStatus(false);
                    this.isExtensionNumber = false;
                    this.phoneState.CurrentCallerRecentActivity = null;
                    this.sessionManager.ActivityItemsRelatedBreadCrumbs = [];
                }
            }
            if (this.phoneState.CurrentState === 1)
                this.resizePhoneStatusPanel();
        }
        catch (e) {
            ExceptionHelper.showException(null, null, false, e.message, "");
        }
    }
    showIncomingCall() {
        try {
            if (this.applicationSettingManager.isIncomingCallNotificationEnabled())
                GlobalFunctions.highlightTab(this.translateService.instant("LBL_NEW_CALL"), "assets/images/svgs/phone-pickup-green.svg", this.translateService.instant("LBL_APPLICATION_TITLE"), this.sessionManager, this.phoneState, null);
            $("#phoneIncomingContainer").empty();
            const componentRef = this.sessionManager.headerViewContainerRef.createComponent(IncomingCallComponent);
            JsPanel.create({
                container: '#phoneIncomingContainer',
                id: "phoneIncomingPanel",
                borderRadius: '5px',
                contentOverflow: 'hidden',
                content: componentRef.location.nativeElement,
                header: false,
                dragit: {
                    opacity: 0.6,
                    handles: '.phone-container',
                    containment: [-47, -0, 0, 0]
                },
                resizeit: false
            });
            this.resizeIncomingCallPanel();
        }
        catch (e) {
            ExceptionHelper.showException(null, null, false, e.message, "");
        }
    }
    resizeIncomingCallPanel() {
        if ($("#phoneIncomingPanel"))
            $("#phoneIncomingPanel").css({ top: ($(window).outerHeight() - 527) / 2, left: ($(window).outerWidth() - 350) / 2, 'background-color': 'transparent', width: 260, height: this.phoneState?.CurrentCallDto?.CalledId ? 347 : 325, 'z-index': 99999 });
    }
    showIncomingSession() {
        try {
            $("#sessionIncomingContainer").empty();
            const componentRef = this.sessionManager.headerViewContainerRef.createComponent(IncomingSessionComponent);
            JsPanel.create({
                container: '#sessionIncomingContainer',
                id: "sessionIncomingPanel",
                borderRadius: '5px',
                contentOverflow: 'hidden',
                content: componentRef.location.nativeElement,
                header: false,
                dragit: {
                    opacity: 0.6,
                    handles: '.incoming-session-container',
                    containment: [-47, -0, 0, 0]
                },
                resizeit: false
            });
            this.resizeIncomingSessionPanel();
        }
        catch (e) {
            ExceptionHelper.showException(null, null, false, e.message, "");
        }
    }
    resizeIncomingSessionPanel() {
        if ($("#sessionIncomingPanel"))
            $("#sessionIncomingPanel").css({ top: ($(window).outerHeight() - 300) / 2, left: ($(window).outerWidth() - 120) / 2, 'background-color': 'transparent', width: 250, height: 238, 'z-index': 99999 });
    }
    showRecallScreen() {
        try {
            $("#phoneRecallContainer").empty();
            const componentRef = this.sessionManager.headerViewContainerRef.createComponent(RecallComponent);
            JsPanel.create({
                container: '#phoneRecallContainer',
                id: "phoneRecallPanel",
                borderRadius: '5px',
                content: componentRef.location.nativeElement,
                contentOverflow: 'hidden',
                header: false,
                dragit: {
                    opacity: 0.6,
                    handles: '.recall-container',
                    containment: [-47, -0, 0, 0]
                },
                resizeit: false
            });
            this.resizeRecallPanel();
        }
        catch (e) {
            ExceptionHelper.showException(null, null, false, e.message, "");
        }
    }
    resizeRecallPanel() {
        if ($("#phoneRecallPanel"))
            $("#phoneRecallPanel").css({ top: ($(window).outerHeight() - 280) / 2, left: ($(window).outerWidth() - 220) / 2, 'background-color': 'transparent', width: 250, height: this.translateService.currentLang === LanaguageCode.NL_CODE ? 285 : 263, 'z-index': 99999 });
    }
    updateEmployeeStatus() {
        if (this.employeeService.loggedInEmployee != null) {
            let updateEmployeeStatusRequest = new UpdateEmployeeStatusRequest();
            updateEmployeeStatusRequest.EmployeeStatus = this.sessionManager.employeeStatus.getEmployeeStatus();
            if (!GlobalFunctions.isEmpty(this.phoneState.CurrentCallDto) && !GlobalFunctions.isEmpty(this.phoneState.CurrentCallDto.StartDateTime) && this.phoneState.CurrentState === CallStatus.Active)
                updateEmployeeStatusRequest.EmployeeStatus.CurrentCallStartTime = this.phoneState.CurrentCallDto.StartDateTime;
            if (this.sessionManager.selectedRole != null && !GlobalFunctions.isEmpty(this.sessionManager.selectedRole.Name))
                updateEmployeeStatusRequest.EmployeeStatus.CurrentRole = this.sessionManager.selectedRole.Name;
            this.setEmployeePhoneStatus(updateEmployeeStatusRequest.EmployeeStatus);
            this.employeeService.updateEmployeeAvailabilityStatus(updateEmployeeStatusRequest);
        }
    }
    setEmployeePhoneStatus(employeeStatus) {
        if (employeeStatus != null) {
            if (this.phoneState != null && this.phoneState.SelectedPhoneStatus != null) {
                employeeStatus.PhoneStatus = this.toPhoneStatus(this.phoneState.SelectedPhoneStatus.key);
                employeeStatus.PhoneAuxCode = this.phoneState.SelectedPhoneStatus.code;
            }
            else {
                employeeStatus.PhoneStatus = PhoneStatus.Offline;
                employeeStatus.PhoneAuxCode = "";
            }
        }
    }
    toPhoneStatus(key) {
        let phoneStatus = PhoneStatus.NotAvailable;
        switch (key) {
            case "0":
            case "2":
                phoneStatus = PhoneStatus.NotAvailable;
                break;
            case "1":
                phoneStatus = PhoneStatus.Available;
                break;
        }
        return phoneStatus;
    }
    getPhonePrefixNumber() {
        let applyPhoneNumberPrefix = this.applicationSettingManager.getApplicationSettingValueByKey("APPLYPREFIXDIGITFORPHONE");
        if (!GlobalFunctions.isEmpty(applyPhoneNumberPrefix) && applyPhoneNumberPrefix.toLowerCase() == "true") {
            let prefixValue = this.applicationSettingManager.getApplicationSettingValueByKey("PHONEPREFIXVALUE");
            if (!GlobalFunctions.isEmpty(prefixValue))
                return prefixValue;
        }
        return '';
    }
    setScreenToCenter() {
        if (this.phoneState.CurrentState == CallStatus.Ringing) {
            this.phoneState.LeftMargin = "-" + (($(window).outerWidth() - 120) / 2) + "px";
            ;
            this.phoneState.TopMargin = (($(window).outerHeight() - 300) / 2) + "px";
        }
    }
    setScreenPosition(left, top) {
        this.phoneState.LeftMargin = left + "px";
        this.phoneState.TopMargin = top + "px";
    }
    createSessionErrorCallback() {
        console.log("phone manager: save session error callback");
        let exception = new Object();
        exception.message = this.translateService.instant("LBL_ERROR_MSG");
        let message = this.translateService.instant("LBL_CREATE_ERROR_MSG");
        message = GlobalFunctions.formatStringValue(message, [this.translateService.instant("LBL_SESSION")]);
        message = this.translateService.instant(message);
        exception.HelpText = message;
    }
    // Project Controller methods    
    //Resolve caller Id >>
    updateSearchStatus(result) {
        try {
            if (result.ActiveHandlers.length == 0) {
                if (this.phoneState.IsCallerIdResolved == false) {
                    this.phoneState.CurrentCaller.Name = this.translateService.instant("LBL_NO_PERSON_FOUND");
                    this.phoneState.CurrentCaller.Item = null;
                    this.phoneState.CurrentCaller;
                }
            }
        }
        catch (e) {
            ExceptionHelper.showException(null, null, false, e.message, "");
        }
    }
    personResponse(result) {
        console.log("Person response received {0}", result);
        if (result != null && result.Details != null && result.Details.FormalName != null) {
            this.phoneState.IsCallerIdResolved = true;
            this.phoneState.CurrentCaller.Name = GlobalFunctions.getCallerName(result, this.applicationSettingManager?.getObjectGrammerSetting("Person_CallerID"));
            this.phoneState.CurrentCaller.Item = result;
            this.phoneState.CurrentCaller.ItemType = EntityFqdn.Decos_Kcs_Persons_Entities_Person;
            if (this.phoneState.CurrentState != CallStatus.Ringing)
                this.loadResolvedItem(this.phoneState.CurrentCaller);
        }
    }
    organizationResponse(result) {
        try {
            console.log("Organization response received {0}", result);
            if (result != null) {
                this.phoneState.IsCallerIdResolved = true;
                this.phoneState.CurrentCaller.Name = result.Name;
                this.phoneState.CurrentCaller.Item = result;
                this.phoneState.CurrentCaller.ItemType = EntityFqdn.Decos_Kcs_Organizations_Entities_Organization;
                if (this.phoneState.CurrentState != CallStatus.Ringing)
                    this.loadResolvedItem(this.phoneState.CurrentCaller);
            }
        }
        catch (e) {
            ExceptionHelper.showException(null, null, false, e.message, "");
        }
    }
    resolveCaller(callerIdDto) {
        try {
            if (callerIdDto != null) {
                this.phoneState.IsCallerIdResolved = false;
                this.phoneState.CurrentCaller.Item = null;
                if (callerIdDto.Anonymous == false && callerIdDto.CallerDetails != null && callerIdDto.CallerDetails.length > 0) {
                    let callerInfo = callerIdDto.CallerDetails[0];
                    let partialDto = new Object();
                    partialDto.Id = callerInfo.ObjectId;
                    ;
                    partialDto.ObjectSource = callerInfo.ObjectSource;
                    if (callerInfo.ObjectType.toUpperCase().indexOf("PERSON") != -1)
                        this.personService.fetchDetail(partialDto, this.personResponse);
                    else
                        this.organizationService.fetchDetail(partialDto, this.organizationResponse);
                }
                else {
                    this.phoneState.IsCallerIdResolved = true;
                    let employee = null;
                    if (!GlobalFunctions.isEmpty(callerIdDto.Id))
                        employee = this.cacheManager.getEmployeeByContactNumber(callerIdDto.Id);
                    if (employee == null) {
                        if (this.phoneState.IsCiscoPhoneEnabled) {
                            if (!GlobalFunctions.isEmpty(callerIdDto.Id))
                                this.phoneState.IsCallerIdResolved = false;
                            else
                                this.phoneState.CurrentCaller.Name = this.translateService.instant("LBL_NO_PERSON_FOUND");
                        }
                        else
                            this.phoneState.CurrentCaller.Name = this.translateService.instant("LBL_NO_PERSON_FOUND");
                    }
                    else
                        this.phoneState.CurrentCaller.Name = employee.Surname;
                    this.phoneState.CurrentCaller;
                }
            }
        }
        catch (e) {
            ExceptionHelper.showException(null, null, false, e.message, "");
        }
    }
    setCallFailedStateAndDisplayMessage(callFailedCause) {
        this.phoneState.IsCallFailed = true;
        if (!GlobalFunctions.isEmpty(callFailedCause)) {
            switch (callFailedCause) {
                case CallStatus.Failed:
                    {
                        this.failedCallMessageTitle = this.translateService.instant("LBL_INVALID_NUMBER");
                        this.failedCallMessageDescription = this.translateService.instant("LBL_CALL_FAILED_MESSAGE");
                        break;
                    }
                case CallStatus.Busy:
                    {
                        this.failedCallMessageTitle = this.translateService.instant("LBL_BUSY_NUMBER");
                        this.failedCallMessageDescription = this.translateService.instant("LBL_CALL_BUSY_MESSAGE");
                        break;
                    }
                case CallStatus.NotReachable:
                    {
                        this.failedCallMessageTitle = this.translateService.instant("LBL_NOT_REACHABLE_NUMBER");
                        this.failedCallMessageDescription = this.translateService.instant("LBL_CALL_NOT_REACHABLE_MESSAGE");
                        break;
                    }
            }
        }
    }
    resolveBasicCaller(callerIdDto) {
        try {
            this.phoneService.pickupCallRequest(this.phoneState.CurrentCallDto);
            this.phoneState.CurrentState = CallStatus.Active;
            this.phoneState.SelectedPhoneStatus = this.phoneState.GetPhoneStatus(PhoneStatus.NotAvailable, null);
            this.changeAvailabilityStatus();
            if (!this.isValidExtensionNumber(this.phoneState.CurrentCallDto)) {
                this.sessionManager.startSessionIfPossible("notype", ScreenMode.None);
                this.sessionManager.currentCallerId = this.phoneState?.CurrentCallDto?.CallerId?.Id;
                this.sessionManager.currentCallId = this.phoneState?.CurrentCallDto?.CallId;
                this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactPhoneNumber = this.sessionManager?.currentCallerId;
            }
            //Navigate person/orginzation
            if (callerIdDto != null && callerIdDto.Anonymous == false && callerIdDto.CallerDetails != null && callerIdDto.CallerDetails.length > 0) {
                let callerInfo = callerIdDto.CallerDetails[0];
                let partialDto = new BaseDto();
                partialDto.Id = callerInfo.ObjectId;
                partialDto.Partial = true;
                partialDto.ObjectSource = callerInfo.ObjectSource;
                this.sessionManager.selectedEntity = partialDto;
                if (callerInfo.ObjectType.toUpperCase().indexOf("PERSON") != -1)
                    this.router.navigate([RoutePath.DETAIL_PATH, EntityName.PERSON, partialDto.Id]);
                else
                    this.router.navigate([RoutePath.DETAIL_PATH, EntityName.ORGANIZATION, partialDto.Id]);
            }
        }
        catch (e) {
            ExceptionHelper.showException(null, null, false, e.message, "");
        }
    }
    //Phone event(s) >>
    newCallEvent(message) {
        console.log("Received incoming call event: {0}", message);
        if (this.phoneState.CurrentState != CallStatus.Unregistered) {
            this.phoneState.CurrentCallDto = message.CallDto;
            if (this.phoneState.IsPhoneBasicFeatureEnabled && !this.sessionManager.isSessionStart) {
                this.updateCallerDetail(message.CallDto.CallerId.Id, this.translateService.instant("LBL_PERSON_FOUND") + "...", null);
                this.resolveBasicCaller(message.CallDto.CallerId);
            }
            else {
                this.phoneState.CurrentState = CallStatus.Ringing;
                this.updateCallerDetail(message.CallDto.CallerId.Id, this.translateService.instant("LBL_PERSON_FOUND") + "...", null);
                this.resolveCaller(message.CallDto.CallerId);
                this.showIncomingCall();
                if (this.sessionManager.isCallerRecentActivityFeatureEnabled && this.applicationSettingManager.isCallerRecentActivityEnabled())
                    this.router.navigate([`${RoutePath.ACTIVITY_PATH}/${message.CallDto.CallerId.Id}`]);
                this.phoneState.TransferSessionManagerDto = null;
            }
        }
    }
    endCallEvent(message) {
        console.log("Received end call event: {0}", message);
        if (this.phoneState.CurrentState != CallStatus.Inactive) {
            if (this.phoneState.IsPhoneBasicFeatureEnabled) {
                this.phoneState.CurrentState = CallStatus.Inactive;
                console.log("A365: End call event received so changing phone state to Inactive");
                return;
            }
            if (!GlobalFunctions.isEmpty(message) && !GlobalFunctions.isEmpty(message.CallDto) && message.CallDto.Status === CallStatus.Transfer) {
                this.phoneState.CurrentState = CallStatus.Transfer;
                this.sessionManager.phoneTransferStatus = CallStatus.Transfer;
                this.showHidePhoneStatus(false);
                this.endTransfer();
            }
            else {
                this.isExtensionNumber = this.isValidExtensionNumber(this.phoneState.CurrentCallDto);
                const isDialingState = this.phoneState.CurrentState === CallStatus.Dialing;
                this.phoneState.PreviousCallDto = null;
                this.phoneState.PreviousCaller = null;
                this.phoneState.CurrentCallDto = null;
                this.phoneState.StateBeforeAttendedTransfer = CallStatus.Inactive;
                this.phoneState.WarmTransferCallConnected = false;
                this.phoneState.IsCallFailed = false;
                this.phoneState.CurrentState = CallStatus.Inactive;
                this.showHidePhoneStatus(false);
                $("#mainPhoneContainer").hide();
                if (!this.phoneState.IsCiscoPhoneEnabled || isDialingState || this.isExtensionNumber)
                    this.phoneState.PhoneAvailableStatus = PhoneStatus.Available;
                if (!this.isExtensionNumber && !this.phoneState.IsCiscoPhoneEnabled) {
                    if (this.phoneState.IsMitelPhoneEnabled || this.phoneState.IsAvayaPhoneEnabled)
                        this.phoneState.PhoneAvailableStatus = PhoneStatus.NotAvailable;
                    else
                        this.updatePhoneAvailabilityStatus(PhoneStatus.NotAvailable);
                }
                if (this.sessionManager.isSessionStart) {
                    if (!this.isExtensionNumber)
                        this.sessionManager.contactSessionNotesState.isContactSessionNotesHighlighted = true;
                }
                else if (this.router.url.includes(`/${RoutePath.LIST_PATH}/${RoutePath.ACTIVITY_PATH}`))
                    this.router.navigate([RoutePath.DASHBOARD]);
                this.isExtensionNumber = false;
                this.phoneState.CurrentCallerRecentActivity = null;
                this.phoneState.TransferSessionManagerDto = null;
                this.sessionManager.ActivityItemsRelatedBreadCrumbs = [];
                if (!GlobalFunctions.isEmpty(message.CallDto.Query) && message.CallDto.Query == "Diverted") {
                    this.phoneState.SelectedPhoneStatus = jlinq.from(this.phoneState.PhoneStatusList).equals("code", "0").first();
                    let key = this.phoneState.SelectedPhoneStatus.key === "2" ? PhoneStatus.NotAvailable : this.phoneState.SelectedPhoneStatus.key;
                    this.updatePhoneAvailabilityStatus(key, this.phoneState.SelectedPhoneStatus.code);
                }
            }
        }
        else if (!GlobalFunctions.isEmpty(message) && !GlobalFunctions.isEmpty(message.CallDto) && message.CallDto.Status == CallStatus.Dialing && !GlobalFunctions.isEmpty(message.CallDto.CallerId) && GlobalFunctions.isEmpty(message.CallDto.CallerId.Id))
            this.phoneState.PhoneAvailableStatus = PhoneStatus.Available;
    }
    callStatusChangedEvent(message) {
        console.log("Received call status changed event: {0}", message);
        if (!GlobalFunctions.isEmpty(message.CallDto.IsCustomerHangedUp) && message.CallDto.IsCustomerHangedUp == true) {
            this.notificationMessageManager.addnotificationMessagePanel("error", this.translateService.instant("LBL_CUSTOMER_HANG_UP_CALL"));
            setTimeout(() => this.notificationMessageManager.removenotificationMessagePanel(), 5000);
        }
        console.log("Call status changed event: calldto status : " + message.CallDto.Status);
        if (message.CallDto.Status === CallStatus.Cancelled)
            setTimeout(() => this.cancelCall(false, false), 500);
        else if (message.CallDto.Status === CallStatus.Dialing)
            this.phoneState.PhoneAvailableStatus = PhoneStatus.NotAvailable;
        else if (message.CallDto.Status === CallStatus.Failed || message.CallDto.Status === CallStatus.Busy || message.CallDto.Status === CallStatus.NotReachable)
            this.setCallFailedStateAndDisplayMessage(message.CallDto.Status);
        else {
            let currentCallDto = jQuery.extend(true, {}, this.phoneState.CurrentCallDto);
            let currentCallState = jQuery.extend(true, {}, this.phoneState.CurrentState);
            this.phoneState.CurrentCallDto = message.CallDto;
            this.phoneState.CurrentState = message.CallDto.Status;
            if (!GlobalFunctions.isEmpty(this.phoneState.CurrentCallDto) && !GlobalFunctions.isEmpty(this.phoneState.CurrentCallDto.CallerId)) {
                console.log("this.phoneState.CurrentCallDto caller id details: " + this.phoneState.CurrentCallDto.CallerId.Id);
                if (this.phoneState.CurrentCallDto.CallerId.IsCallerChanged) {
                    this.updateCallerDetail(this.phoneState.CurrentCallDto.CallerId.Id, this.translateService.instant("LBL_PERSON_FOUND") + "...", null);
                    this.resolveCaller(this.phoneState.CurrentCallDto.CallerId);
                }
            }
            if (message.CallDto.Status == CallStatus.Active) {
                console.log("Call status changed event: calldto details: " + message.CallDto);
                if (!GlobalFunctions.isEmpty(message.CallDto.ServerCallStatus) && message.CallDto.ServerCallStatus == CallStatus.AttendedTransfer && this.phoneState.PreviousCallDto == null) {
                    console.log("Call status changed event: received attended transfer status");
                    this.updateDialerDetail(message.CallDto.CallerId.Id, this.translateService.instant("LBL_NO_PERSON_FOUND"), null);
                    this.phoneState.PreviousCallDto = jQuery.extend(true, {}, currentCallDto);
                    this.phoneState.PreviousCaller = jQuery.extend(true, {}, this.phoneState.CurrentCaller);
                    this.phoneState.CurrentCaller = jQuery.extend(true, {}, this.phoneState.CurrentDialer);
                    this.phoneState.StateBeforeAttendedTransfer = currentCallState;
                    this.sessionManager.phoneTransferStatus = CallStatus.AttendedTransfer;
                    this.phoneState.WarmTransferCallConnected = true;
                }
                else if (this.phoneState.PreviousCallDto != null) {
                    console.log("Call status changed event: previous call dto not null");
                    this.phoneState.WarmTransferCallConnected = true;
                    this.phoneState.CurrentCaller = jQuery.extend(true, {}, this.phoneState.CurrentDialer);
                }
                else if (!this.isValidExtensionNumber(this.phoneState.CurrentCallDto)) {
                    this.sessionManager.startSessionIfPossible("notype", ScreenMode.None);
                    if (this.sessionManager.minutes == 0 && this.sessionManager.seconds < 2)
                        this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactType = "Phone";
                    if ((GlobalFunctions.isEmpty(this.sessionManager.currentCallerId) || this.sessionManager.currentCallerId.length < 10) && !GlobalFunctions.isEmpty(this.phoneState.CurrentCallDto.CallerId) && !GlobalFunctions.isEmpty(this.phoneState.CurrentCallDto.CallerId.Id)) {
                        this.sessionManager.currentCallerId = this.phoneState.CurrentCallDto.CallerId.Id;
                        this.sessionManager.currentCallId = this.phoneState.CurrentCallDto.CallId;
                    }
                    if (!this.router.url.includes(RoutePath.ACTIVITY_PATH) || !this.sessionManager.isActivityFound) {
                        if (this.phoneState.CurrentCaller.Item != null && !this.isCallerLoaded)
                            this.loadResolvedItem(this.phoneState.CurrentCaller);
                    }
                    if (this.phoneState.IsCiscoPhoneEnabled) {
                        this.phoneState.PhoneAvailableStatus = PhoneStatus.Available;
                        this.updatePhoneAvailabilityStatus(PhoneStatus.NotAvailable);
                    }
                }
                this.showHidePhoneStatus(true);
                $("#mainPhoneContainer").hide();
                if (!this.phoneState.IsCiscoPhoneEnabled || this.isValidExtensionNumber(this.phoneState.CurrentCallDto))
                    this.phoneState.PhoneAvailableStatus = PhoneStatus.NotAvailable;
                if ((GlobalFunctions.isEmpty(this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactPhoneNumber) || this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactPhoneNumber.length < 10) && !GlobalFunctions.isEmpty(this.sessionManager.currentCallerId)) {
                    setTimeout(() => {
                        this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactPhoneNumber = this.sessionManager.currentCallerId;
                        this.sessionManager.contactSessionNotesState.ContactHistoryDto.CallId = this.sessionManager.currentCallId;
                    }, 10);
                }
                if (this.applicationSettingManager.isCustomerOM() && !GlobalFunctions.isEmpty(this.phoneState.CurrentCallerRecentActivity))
                    this.updateContactSessionNotes();
                //Make consulted employee as a part of current session
                if (this.phoneState.WarmTransferCallConnected && this.applicationSettingManager.isEmployeeAutoLinkEnabled() && this.phoneState.CurrentCaller != null) {
                    let employee = this.cacheManager.getEmployeeByContactNumber(this.phoneState.CurrentCaller.PhoneNumber);
                    if (employee != null)
                        this.sessionManager.addItemsToDetailViewCacheList(employee, "EMPLOYEE", true);
                }
            }
            else if (message.CallDto.Status == CallStatus.Hold) {
                if (this.phoneState.PreviousCallDto != null) {
                    this.phoneState.WarmTransferCallConnected = false;
                    this.phoneState.CurrentCallDto = jQuery.extend(true, {}, this.phoneState.PreviousCallDto);
                    this.phoneState.CurrentCaller = jQuery.extend(true, {}, this.phoneState.PreviousCaller);
                    this.phoneState.PreviousCaller = null;
                    this.phoneState.PreviousCallDto = null;
                    this.showHidePhoneStatus(true);
                }
            }
            this.phoneState.IsCallFailed = false;
        }
        this.changeAvailabilityStatus();
    }
    recallEvent(message) {
        console.log("Received recall event: {0}", message);
        this.phoneState.CurrentCallDto = message.CallDto;
        this.phoneState.CurrentState = CallStatus.Recall;
        this.showHidePhoneStatus(false);
        this.showRecallScreen();
    }
    transferSessionEvent(message) {
        console.log("Received transfer session event: {0}", message);
        if (!GlobalFunctions.isEmpty(message.TransferSessionManagerDto) && !GlobalFunctions.isEmpty(message.TransferSessionManagerDto.Session)) {
            this.phoneState.TransferSessionManagerDto = message.TransferSessionManagerDto;
            if (this.phoneState.CurrentState !== CallStatus.Ringing)
                this.showIncomingSession();
        }
        ;
    }
    //<< Phone event(s)
    updateContactSessionNotes() {
        if (GlobalFunctions.isEmpty(this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactPerson))
            this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactPerson = this.phoneState.CurrentCallerRecentActivity.ContactPerson;
        if (GlobalFunctions.isEmpty(this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactPhoneNumber))
            this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactPhoneNumber = this.phoneState.CurrentCallerRecentActivity.ContactPhoneNumber;
    }
    registerPhoneEvents() {
        this.phoneService.setNewCallEventCallback(this.newCallEvent);
        this.phoneService.setEndCallEventCallback(this.endCallEvent);
        this.phoneService.setCallStatusChangedEventCallback(this.callStatusChangedEvent);
        this.phoneService.setRecallEventCallback(this.recallEvent);
        this.phoneService.setTransferSessionEventCallback(this.transferSessionEvent);
    }
    setPhoneStatusAction(action) {
        if (this.phoneState.PhoneStatusActionList?.length > 0) {
            let phoneAction = jlinq.from(this.phoneState.PhoneStatusActionList).equals("Action", action).first();
            if (phoneAction && phoneAction.Enabled) {
                let phoneStatus = jlinq.from(this.phoneState.PhoneStatusList).equals("id", phoneAction.StatusId).first();
                if (phoneStatus) {
                    this.phoneState.SelectedPhoneStatus = phoneStatus;
                    let key = phoneStatus.key === "2" ? PhoneStatus.NotAvailable : phoneStatus.key;
                    this.updatePhoneAvailabilityStatus(key, phoneStatus.code);
                }
            }
        }
    }
    getPhoneRegisterValue() {
        let phoneRegisterValue = "";
        try {
            let autoFillRegisterValueWith = this.applicationSettingManager.getApplicationSettingValueByKey("AUTOFILLREGISTERVALUEWITH");
            if (!GlobalFunctions.isEmpty(autoFillRegisterValueWith)) {
                switch (autoFillRegisterValueWith) {
                    case "1": //Extension
                        {
                            if (!GlobalFunctions.isEmpty(this.employeeService.loggedInEmployee) && !GlobalFunctions.isEmpty(this.employeeService.loggedInEmployee.ExtensionNumber))
                                phoneRegisterValue = this.employeeService.loggedInEmployee.ExtensionNumber;
                            break;
                        }
                    case "2": //LogOnName
                        {
                            let cookie = JSON.parse(GlobalFunctions.getCookie(LocalStorageKey.SESSION_TOKEN));
                            if (!GlobalFunctions.isEmpty(cookie))
                                phoneRegisterValue = cookie.LogOnName;
                            break;
                        }
                    case "3": //EmailAddress
                        {
                            if (!GlobalFunctions.isEmpty(this.employeeService.loggedInEmployee) && !GlobalFunctions.isEmpty(this.employeeService.loggedInEmployee.EmailAddress))
                                phoneRegisterValue = this.employeeService.loggedInEmployee.EmailAddress;
                            break;
                        }
                }
            }
        }
        catch (e) {
            console.error(e);
        }
        return phoneRegisterValue;
    }
    getPhoneRegisterPlaceholder() {
        let placeholder = "";
        try {
            let autoFillRegisterValueWith = this.applicationSettingManager.getApplicationSettingValueByKey("AUTOFILLREGISTERVALUEWITH");
            if (!GlobalFunctions.isEmpty(autoFillRegisterValueWith)) {
                switch (autoFillRegisterValueWith) {
                    case "1": //Extension
                        {
                            placeholder = this.translateService.instant("LBL_PLACEHOLDER_EXTENSION");
                            break;
                        }
                    case "2": //LogOnName
                        {
                            placeholder = this.translateService.instant("LBL_PLACEHOLDER_USERNAME");
                            break;
                        }
                    case "3": //EmailAddress
                        {
                            placeholder = this.translateService.instant("LBL_EMAIL_ADDRESS");
                            break;
                        }
                }
            }
        }
        catch (e) {
            console.error(e);
        }
        return placeholder;
    }
    clearPhoneState() {
        this.phoneState.CurrentCallDto = null;
        this.phoneState.CurrentCaller = new PhoneCallerDetailDto();
    }
};
PhoneManager = __decorate([
    Injectable({
        providedIn: 'root'
    })
], PhoneManager);
export { PhoneManager };
//# sourceMappingURL=phone-manager.js.map