var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Injectable } from "@angular/core";
import { BaseService } from "../services/base-service";
const JsPanel = require('../../../../node_modules/jspanel4/dist/jspanel.min.js');
let NotificationMessageManager = class NotificationMessageManager extends BaseService {
    constructor(zone, router, httpClient, eventProvider) {
        super(zone, router, httpClient, eventProvider);
        this.zone = zone;
        this.router = router;
        this.httpClient = httpClient;
        this.eventProvider = eventProvider;
    }
    addnotificationMessagePanel(type, message) {
        try {
            $("#notificationMessagePanel").empty();
            let element = "<div id='toast-container' class='toast-top-center'><div class='toast toast-" + type + "' style='display: block;'><div class='toast-message'>" + message + "</div></div></div>";
            this.notificationMessagePanel = JsPanel.create({
                borderRadius: '5px 5px 0px 0px',
                id: "messagePanel",
                size: { width: 'auto', height: 'auto' },
                header: false,
                contentOverflow: 'hidden',
                load: { type: type, message: message },
                resizeit: {
                    minWidth: 500,
                    minHeight: 500,
                    containment: '#applicationBody',
                    stack: '.jsPanel',
                    opacity: 0.6,
                    disable: true,
                    resize: (event, ui) => {
                    },
                },
                dragit: { containment: '#applicationBody', handle: '', stack: '.jsPanel', opacity: 0.6 },
                container: '#notificationMessagePanel',
                controls: { buttons: 'closeonly' },
                title: '',
                content: element
            });
            this.notificationMessagePanel.on('click', function () {
                this.notificationMessagePanel.close();
                this.notificationMessagePanel = null;
            });
        }
        catch (e) {
            console.error("Notification Message Exception " + e);
        }
    }
    removenotificationMessagePanel() {
        this.notificationMessagePanel.close();
        this.notificationMessagePanel = null;
    }
};
NotificationMessageManager = __decorate([
    Injectable({
        providedIn: 'root'
    })
], NotificationMessageManager);
export { NotificationMessageManager };
//# sourceMappingURL=notification-message-manager.js.map