var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Injectable } from '@angular/core';
import { cloneDeep } from "lodash";
import { BehaviorSubject } from 'rxjs';
import { map } from 'rxjs/operators';
import { environment } from '../../../environments/environment';
import { GlobalFunctions } from '../../shared/global-functions';
import { OperationType } from '../enums/common-enums';
import { EntityFqdn } from '../enums/core-enums';
import { RoleSetting } from '../models/common/role-setting';
import { ContentType } from '../models/jkc-object/jkc-object';
import { BaseService } from '../services/base-service';
let IntegrationSettingManager = class IntegrationSettingManager extends BaseService {
    constructor(zone, router, httpClient, eventProvider) {
        super(zone, router, httpClient, eventProvider);
        this.zone = zone;
        this.router = router;
        this.httpClient = httpClient;
        this.eventProvider = eventProvider;
        this.roleSetting = new RoleSetting();
        this.integrationSetings = [];
        this.contactQuestionAnswerList = null;
        this.handlerSettingCached = false;
        this.handerSettingsDictionary = {};
        this.getQuestions = () => {
            let questions = [];
            if (this.contactQuestionAnswerList != null && this.contactQuestionAnswerList.length > 0) {
                this.contactQuestionAnswerList.forEach(contactQuestionAnswer => {
                    if (!GlobalFunctions.isEmpty(contactQuestionAnswer.Question))
                        questions.push(contactQuestionAnswer.Question);
                });
            }
            return cloneDeep(questions);
        };
        this.getAnswers = question => {
            let answers = [];
            if (this.contactQuestionAnswerList != null && this.contactQuestionAnswerList.length > 0)
                for (let i = 0; i < this.contactQuestionAnswerList.length; i++) {
                    if (!GlobalFunctions.isEmpty(this.contactQuestionAnswerList[i].Question) && !GlobalFunctions.isEmpty(question) && this.contactQuestionAnswerList[i].Question.toLowerCase() === question.toLowerCase()) {
                        answers = cloneDeep(this.contactQuestionAnswerList[i].AnswerList);
                        break;
                    }
                }
            return answers;
        };
        this.contactQuestionAnswerReceived = (response) => {
            if (!GlobalFunctions.isEmpty(response) && !GlobalFunctions.isEmpty(response.QuestionAnswerList))
                this.contactQuestionAnswerList = response.QuestionAnswerList;
        };
        this.setDomainConfiguration = (value) => {
            if (GlobalFunctions.isEmpty(value))
                return;
            let domainConfig = JSON.parse(value);
            let domains = this.getIntegrationSetting(EntityFqdn.Decos_Kcs_Domains_Entities_Domain, "DOMAINCONFIGURATION");
            if (domainConfig.Domains != null && domainConfig.Domains.length > 0) {
                if (GlobalFunctions.isEmpty(domains))
                    domains = [];
                for (let i = 0; i < domainConfig.Domains.length; i++) {
                    domainConfig.Domains[i].HasAddRights = GlobalFunctions.hasRight(ContentType.Domain, OperationType.Add, "Decos.Kcs.Domains." + domainConfig.Domains[i].Name);
                    domainConfig.Domains[i].Fields = null;
                    domains.push(domainConfig.Domains[i]);
                }
            }
            this.addIntegrationSetting(EntityFqdn.Decos_Kcs_Domains_Entities_Domain, "DOMAINCONFIGURATION", domains);
        };
        this.getDomainScreenSetting = (domainName, screenName) => {
            let screen = null;
            let domains = this.getIntegrationSetting(EntityFqdn.Decos_Kcs_Domains_Entities_Domain, "DOMAINCONFIGURATION");
            if (domains != null && domains.length > 0) {
                let domain = jlinq.from(domains).equals("Name", domainName).first();
                if (domain != null)
                    screen = cloneDeep(jlinq.from(domain.Screens).equals("Type", screenName).first());
            }
            return screen;
        };
        this.setDomainObjectInfo = (domainObject) => {
            if (domainObject != null && !GlobalFunctions.isEmpty(domainObject.ObjectSource)) {
                let objectSourceParts = domainObject.ObjectSource.split('.');
                let domains = this.getIntegrationSetting(EntityFqdn.Decos_Kcs_Domains_Entities_Domain, "DOMAINCONFIGURATION");
                if (domains != null && domains.length > 0) {
                    let domain = jlinq.from(domains).equals("Name", objectSourceParts[objectSourceParts.length - 1]).first();
                    if (domain != null) {
                        domainObject.BackgroundColor = domain.Color;
                        domainObject.Legendcharacter = domain.Letter;
                        domainObject.Tooltiptext = domain.Name;
                    }
                }
            }
        };
    }
    addIntegrationSetting(entityFqdn, setting, value) {
        let key = entityFqdn + "_" + setting.toUpperCase();
        this.integrationSetings[key] = value;
    }
    getIntegrationSetting(entityFqdn, setting) {
        let retValue = '';
        const key = entityFqdn + '_' + setting.toUpperCase();
        if (this.integrationSetings[key] != null)
            retValue = this.integrationSetings[key];
        return retValue;
    }
    cacheHandlerSettings() {
        if (this.handlerSettingCached == false) {
            this.handerSettingsDictionary = {};
            return this.httpClient.get(environment.oData_config + '/HandlerSettings', { headers: this.getHeader() }).pipe(map(data => {
                if (data?.length > 0) {
                    for (let index = 0; index < data.length; index++) {
                        if (data[index].IsEncrypted)
                            data[index].Value = GlobalFunctions.encryptOrDecryptUsingXOR(data[index].Value);
                        const settingKey = GlobalFunctions.getEntityFqdnFromSourceFqdn(data[index].NamespaceFqdn);
                        if (settingKey == EntityFqdn.Decos_Kcs_Domains_Entities_Domain)
                            this.setDomainConfiguration(data[index].Value);
                        else
                            this.addIntegrationSetting(settingKey, data[index].Name, data[index].Value);
                    }
                    this.setTicketConfiguration();
                    this.setRoleConfiguration();
                    this.handlerSettingCached = true;
                }
            }));
        }
        else
            return new BehaviorSubject(true);
    }
    setTicketConfiguration() {
        let result = this.getIntegrationSetting(EntityFqdn.Decos_Kcs_Tickets_Entities_Ticket, "TICKETSCONFIGURATION");
        if (GlobalFunctions.isEmpty(result))
            return;
        let ticketConfig = JSON.parse(result);
        ticketConfig.TicketGroupTitle = this.getIntegrationSetting(EntityFqdn.Decos_Kcs_Tickets_Entities_Ticket, "TITLETEXT");
        if (ticketConfig.TicketTypes != null && ticketConfig.TicketTypes.length > 0) {
            for (let i = 0; i < ticketConfig.TicketTypes.length; i++)
                ticketConfig.TicketTypes[i].HasAddRight = ticketConfig.TicketTypes[i].IsPublished && GlobalFunctions.hasRight(ContentType.Ticket, OperationType.Add, ticketConfig.TicketTypes[i].Id);
        }
        this.addIntegrationSetting(EntityFqdn.Decos_Kcs_Tickets_Entities_Ticket, "TICKETSCONFIGURATION", ticketConfig);
    }
    ;
    setRoleConfiguration() {
        this.roleSetting.setSettings(this.getIntegrationSetting(EntityFqdn.Decos_Kcs_ContactHistory_Entities_ContactHistory, 'DEFAULTROLES'));
    }
    clear() {
        this.roleSetting = new RoleSetting();
        this.integrationSetings = [];
        this.contactQuestionAnswerList = null;
        this.handlerSettingCached = false;
    }
    ;
};
IntegrationSettingManager = __decorate([
    Injectable({
        providedIn: 'root'
    })
], IntegrationSettingManager);
export { IntegrationSettingManager };
//# sourceMappingURL=integration-setting-manager.js.map