var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Injectable } from "@angular/core";
import { GlobalFunctions } from "src/app/shared/global-functions";
import { EntityFqdn } from "../enums/core-enums";
import { TaskHandlerType } from "../enums/task-enum";
let FormatManager = class FormatManager {
    constructor(cacheManager, employeeService, applicationSettingManager, sessionManager, convertToGenderTextPipe, datePipe, downloadService, translateService) {
        this.cacheManager = cacheManager;
        this.employeeService = employeeService;
        this.applicationSettingManager = applicationSettingManager;
        this.sessionManager = sessionManager;
        this.convertToGenderTextPipe = convertToGenderTextPipe;
        this.datePipe = datePipe;
        this.downloadService = downloadService;
        this.translateService = translateService;
    }
    setHandler(contentType, result) {
        try {
            switch (contentType.toUpperCase()) {
                case "TASK":
                    this.setTaskHandlerName(result);
                    break;
                case "CONTACTMOMENT":
                    this.setContactHistoryHandlerName(result);
                    break;
                case "NOTEENTITY":
                case "FILEDOCUMENT":
                    this.setCreatedBy(result);
                    break;
                case "SOCIALMEDIAHISTORY":
                    this.setSocialMediaHandler(result);
                    break;
            }
        }
        catch (e) {
            console.error(e.message);
        }
    }
    setContactHistoryHandlerName(result) {
        if (result != null && result.length > 0) {
            for (let index = 0; index < result.length; index++) {
                let handler = result[index].HandlerDto;
                if (handler != null) {
                    let userId = handler.UserId;
                    if (userId != null && userId != '') {
                        const employeeDto = this.cacheManager.getEmployeeById(userId);
                        if (!GlobalFunctions.isEmpty(employeeDto))
                            result[index].HandlerDto.HandlerObject = employeeDto;
                        else {
                            const mailboxDto = this.cacheManager.getTaskMailboxById(userId);
                            if (!GlobalFunctions.isEmpty(mailboxDto))
                                result[index].HandlerDto.HandlerObject = mailboxDto;
                        }
                    }
                }
            }
        }
    }
    setTaskHandlerName(result) {
        if (result != null && result.length > 0) {
            for (let index = 0; index < result.length; index++) {
                let currentHandlerList = result[index].CurrentHandlerList;
                if (currentHandlerList != null && currentHandlerList.length > 0) {
                    let handlerList = "";
                    for (let index1 = 0; index1 < currentHandlerList.length; index1++) {
                        if (currentHandlerList[index1].HandlerType == TaskHandlerType.Employee || currentHandlerList[index1].HandlerType == "Employee") {
                            let employee = this.cacheManager.getEmployeeById(currentHandlerList[index1].HandlerId);
                            if (employee != null && employee != undefined) {
                                if (handlerList == "")
                                    handlerList = employee.Surname;
                                else
                                    handlerList += ", " + employee.Surname;
                            }
                        }
                        else if (currentHandlerList[index1].HandlerType == TaskHandlerType.Department || currentHandlerList[index1].HandlerType == "Department") {
                            let department = this.cacheManager.getDepartmentById(currentHandlerList[index1].HandlerId);
                            if (department != null && department != undefined) {
                                if (handlerList == "")
                                    handlerList = department.Name;
                                else
                                    handlerList += ", " + department.Name;
                            }
                        }
                        else if (currentHandlerList[index1].HandlerType == TaskHandlerType.Mailbox || currentHandlerList[index1].HandlerTyp === "Mailbox") {
                            let mailbox = this.cacheManager.getTaskMailboxById(currentHandlerList[index1].HandlerId);
                            if (mailbox) {
                                if (handlerList === "")
                                    handlerList = mailbox.Name;
                                else
                                    handlerList += ", " + mailbox.Name;
                            }
                        }
                        else if (currentHandlerList[index1].HandlerType == TaskHandlerType.Email || currentHandlerList[index1].HandlerType === "Email") {
                            if (handlerList === "")
                                handlerList = currentHandlerList[index1].HandlerId;
                            else
                                handlerList += ", " + currentHandlerList[index1].HandlerId;
                        }
                    }
                }
            }
        }
    }
    setCreatedBy(result) {
        if (this.cacheManager != undefined && result != null && result.length > 0) {
            for (let index = 0; index < result.length; index++) {
                let createdBy = this.cacheManager.getEmployeeById(result[index].CreatedById);
                if (createdBy == null)
                    result[index].CreatedBy = result[index].CreatedById;
                else
                    result[index].CreatedBy = createdBy.StringRepresentation;
            }
        }
    }
    setSocialMediaHandler(result) {
        if (this.cacheManager == undefined)
            return;
        for (let index = 0; index < result.length; index++) {
            if (result[index].ReplyBy == 'Handler') {
                let employee = this.cacheManager.getEmployeeById(result[index].UserId);
                if (employee != null) {
                    let employeeList = new Array();
                    employeeList.push(employee);
                    result[index].UserName = employee.StringRepresentation;
                    result[index].UserPicture = employee.PictureData;
                }
            }
        }
    }
    parseValue(value, privateFieldName, privateFields) {
        if (!GlobalFunctions.isEmpty(privateFields)) {
            if (privateFields.indexOf("|" + privateFieldName + "|") !== -1)
                value = "";
        }
        return GlobalFunctions.isEmpty(value) ? "" : value;
    }
    setTag(contentType, result) {
        try {
            let isTagFeatureEnabled = this.applicationSettingManager.tagSetting.tagList.length > 0;
            if (isTagFeatureEnabled && result != null && result.length > 0) {
                for (let index = 0; index < result.length; index++) {
                    result[index].TagList = this.applicationSettingManager.tagSetting.searchTagById(result[index].Tags);
                    let TagString = '';
                    result[index].TagList.forEach(tag => {
                        TagString += tag.text + ' ';
                    });
                    result[index].TagListText = TagString;
                }
            }
        }
        catch (e) {
            console.error(e.message);
        }
    }
    setStringPresentation(result, key) {
        try {
            if (result != null && result.length > 0) {
                let grammerValue = this.applicationSettingManager.getObjectGrammerSetting(key);
                for (let i = 0; i < result.length; i++)
                    GlobalFunctions.setStringPresentation(result[i], grammerValue);
            }
        }
        catch (e) {
            console.error(e.message);
        }
    }
    ;
    setEmployee(result) {
        try {
            if (result != null && result.length > 0) {
                for (let index = 0; index < result.length; index++)
                    result[index] = this.cacheManager.getEmployeeById(result[index].Id);
            }
        }
        catch (e) {
            console.error(e.message);
        }
    }
    ;
    mergeTaskTemplate(template) {
        let parsedTemplate = template;
        try {
            if (!GlobalFunctions.isEmpty(template)) {
                parsedTemplate = parsedTemplate.replace(/{{ContactSessionNotes.Note}}/g, !GlobalFunctions.isEmpty(this.sessionManager.contactSessionNotesState.ContactHistoryDto.Notes) ? this.sessionManager.contactSessionNotesState.ContactHistoryDto.Notes : '').
                    replace(/{{ContactSessionNotes.PhoneNumber}}/g, !GlobalFunctions.isEmpty(this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactPhoneNumber) ? this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactPhoneNumber : '').
                    replace(/{{ContactSessionNotes.Name}}/g, !GlobalFunctions.isEmpty(this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactPerson) ? this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactPerson : '').
                    replace(/{{ContactSessionNotes.Question}}/g, !GlobalFunctions.isEmpty(this.sessionManager.contactSessionNotesState.ContactHistoryDto.Subject) ? this.sessionManager.contactSessionNotesState.ContactHistoryDto.Subject : '').
                    replace(/{{ContactSessionNotes.QuestionRemark}}/g, !GlobalFunctions.isEmpty(this.sessionManager.contactSessionNotesState.ContactHistoryDto.SubjectFreeText) ? this.sessionManager.contactSessionNotesState.ContactHistoryDto.SubjectFreeText : '').
                    replace(/{{ContactSessionNotes.Answer}}/g, !GlobalFunctions.isEmpty(this.sessionManager.contactSessionNotesState.ContactHistoryDto.Memo) ? this.sessionManager.contactSessionNotesState.ContactHistoryDto.Memo : '').
                    replace(/{{ContactSessionNotes.AnswerRemark}}/g, !GlobalFunctions.isEmpty(this.sessionManager.contactSessionNotesState.ContactHistoryDto.MemoFreeText) ? this.sessionManager.contactSessionNotesState.ContactHistoryDto.MemoFreeText : '').
                    replace(/{{ContactSessionNotes.CreatedBy}}/g, !GlobalFunctions.isEmpty(this.employeeService.loggedInEmployee.LoggedInUserName) ? this.employeeService.loggedInEmployee.LoggedInUserName : '');
            }
        }
        catch (e) {
            console.error(e.message);
        }
        return parsedTemplate;
    }
    ;
    mergeTemplateFields(template) {
        let parsedTemplate = template;
        try {
            if (!GlobalFunctions.isEmpty(template)) {
                let person = GlobalFunctions.getLastPersonFromSession(this.sessionManager.detailViewCachedEntityList);
                if (person) {
                    person.Details.FormalName.GenderAnnotation = this.getGenderAnnotation(person.Details.FormalName.Gender);
                    parsedTemplate = parsedTemplate.replace(/{{Person_Surname}}/g, this.parseValue(person?.Details?.FormalName?.Surname, 'SURNAME', '')).
                        replace(/{{Person_FirstName}}/g, this.parseValue(person?.Details?.FormalName?.FirstNames[0], 'FIRSTNAMES[0]', person.PrivateFields)).
                        replace(/{{Person_Initials}}/g, this.parseValue(person?.Details?.AddressName?.Initials, 'INITIALS', '')).
                        replace(/{{Person_Prefix}}/g, this.parseValue(person?.Details?.FormalName?.Prefix, 'PREFIX', '')).
                        replace(/{{Person_Gender}}/g, this.parseValue(this.convertToGenderTextPipe.transform(person?.Details?.FormalName?.Gender), 'GENDER', person.PrivateFields)).
                        replace(/{{Person_GenderAnnotation}}/g, this.parseValue(person?.Details?.FormalName?.GenderAnnotation, 'GENDERANNOTATION', '')).
                        replace(/{{Person_PhoneNumber}}/g, this.parseValue(person?.PhoneNumber, 'PHONENUMBER', person.PrivateFields)).
                        replace(/{{Person_MobileNumber}}/g, this.parseValue(person?.MobileNumber, 'MOBILENUMBER', person.PrivateFields)).
                        replace(/{{Person_EmailAddress}}/g, this.parseValue(person?.EmailAddress, 'EMAILADDRESS', person.PrivateFields)).
                        replace(/{{Person_BsnNumber}}/g, this.parseValue(person?.AdministeredPersonDto?.ServiceNumber, 'SERVICENUMBER', person.PrivateFields)).
                        replace(/{{Person_DateOfBirth}}/g, this.parseValue(this.datePipe.transform(person?.Details?.DateOfBirth), 'DATEOFBIRTH', person.PrivateFields));
                    parsedTemplate = parsedTemplate.replace(/{{Person_Residential_City}}/g, this.parseValue(person?.ResidentialAddress?.Address?.City, 'CITY', person.PrivateFields)).
                        replace(/{{Person_Residential_ZipCode}}/g, this.parseValue(person?.ResidentialAddress?.Address?.ZipCode, 'ZIPCODE', person.PrivateFields)).
                        replace(/{{Person_Residential_HouseNumber}}/g, this.parseValue(person?.ResidentialAddress?.Address?.HouseNumber, 'HOUSENUMBER', person.PrivateFields)).
                        replace(/{{Person_Residential_StreetName}}/g, this.parseValue(person?.ResidentialAddress?.Address?.StreetName, 'STREETNAME', person.PrivateFields)).
                        replace(/{{Person_Residential_State}}/g, this.parseValue(person?.ResidentialAddress?.Address?.State, 'STATE', person.PrivateFields)).
                        replace(/{{Person_Residential_HouseNumberAddition}}/g, this.parseValue(person?.ResidentialAddress?.Address?.HouseNumberAddition, 'ADJUNCT', person.PrivateFields)).
                        replace(/{{Person_Residential_CountryId}}/g, this.parseValue(person?.ResidentialAddress?.Address?.Country?.Name, 'COUNTRYID', '')).
                        replace(/{{Person_Residential_POBoxNumber}}/g, this.parseValue(person?.ResidentialAddress?.Address?.POBoxNumber, 'POBOXNUMBER', ''));
                    parsedTemplate = parsedTemplate.replace(/{{Person_Registration_City}}/g, this.parseValue(person?.RegistrationAddress?.Address?.City, 'CITY', person.PrivateFields)).
                        replace(/{{Person_Registration_ZipCode}}/g, this.parseValue(person?.RegistrationAddress?.Address?.ZipCode, 'ZIPCODE', person.PrivateFields)).
                        replace(/{{Person_Registration_HouseNumber}}/g, this.parseValue(person?.RegistrationAddress?.Address?.HouseNumber, 'HOUSENUMBER', person.PrivateFields)).
                        replace(/{{Person_Registration_StreetName}}/g, this.parseValue(person?.RegistrationAddress?.Address?.StreetName, 'STREETNAME', person.PrivateFields)).
                        replace(/{{Person_Registration_State}}/g, this.parseValue(person?.RegistrationAddress?.Address?.State, 'STATE', person.PrivateFields)).
                        replace(/{{Person_Registration_HouseNumberAddition}}/g, this.parseValue(person?.RegistrationAddress?.Address?.HouseNumberAddition, 'ADJUNCT', person.PrivateFields)).
                        replace(/{{Person_Registration_CountryId}}/g, this.parseValue(person?.RegistrationAddress?.Address?.Country?.Name, 'COUNTRYID', '')).
                        replace(/{{Person_Registration_POBoxNumber}}/g, this.parseValue(person?.RegistrationAddress?.Address?.POBoxNumber, 'POBOXNUMBER', ''));
                    parsedTemplate = parsedTemplate.replace(/{{Person_Correspondence_City}}/g, this.parseValue(person?.CorrespondenceAddress?.Address?.City, 'CITY', person.PrivateFields)).
                        replace(/{{Person_Correspondence_ZipCode}}/g, this.parseValue(person?.CorrespondenceAddress?.Address?.ZipCode, 'ZIPCODE', person.PrivateFields)).
                        replace(/{{Person_Correspondence_HouseNumber}}/g, this.parseValue(person?.CorrespondenceAddress?.Address?.HouseNumber, 'HOUSENUMBER', person.PrivateFields)).
                        replace(/{{Person_Correspondence_StreetName}}/g, this.parseValue(person?.CorrespondenceAddress?.Address?.StreetName, 'STREETNAME', person.PrivateFields)).
                        replace(/{{Person_Correspondence_State}}/g, this.parseValue(person?.CorrespondenceAddress?.Address?.State, 'STATE', person.PrivateFields)).
                        replace(/{{Person_Correspondence_HouseNumberAddition}}/g, this.parseValue(person?.CorrespondenceAddress?.Address?.HouseNumberAddition, 'ADJUNCT', person.PrivateFields)).
                        replace(/{{Person_Correspondence_CountryId}}/g, this.parseValue(person?.CorrespondenceAddress?.Address?.Country?.Name, 'COUNTRYID', '')).
                        replace(/{{Person_Correspondence_POBoxNumber}}/g, this.parseValue(person?.CorrespondenceAddress?.Address?.POBoxNumber, 'POBOXNUMBER', ''));
                }
                let organization = GlobalFunctions.getLastOrganizationFromSession(this.sessionManager.detailViewCachedEntityList);
                if (organization) {
                    parsedTemplate = parsedTemplate.replace(/{{Organization_Name}}/g, this.parseValue(organization.Name, 'NAME', '')).
                        replace(/{{Organization_Identification}}/g, this.parseValue(organization?.AdministeredOrganizationDto?.Identification, 'IDENTIFICATION', organization.PrivateFields)).
                        replace(/{{Organization_PhoneNumber}}/g, this.parseValue(organization?.PhoneNumber, 'PHONENUMBER', organization.PrivateFields)).
                        replace(/{{Organization_MobileNumber}}/g, this.parseValue(organization?.MobileNumber, 'MOBILENUMBER', '')).
                        replace(/{{Organization_EmailAddress}}/g, this.parseValue(organization?.EmailAddress, 'EMAILADDRESS', organization.PrivateFields)).
                        replace(/{{Organization_FaxNumber}}/g, this.parseValue(organization?.FaxNumber, 'FAXNUMBER', organization.PrivateFields));
                    parsedTemplate = parsedTemplate.replace(/{{Organization_Registration_City}}/g, this.parseValue(organization?.RegistrationAddress?.Address.City, 'CITY', '')).
                        replace(/{{Organization_Registration_ZipCode}}/g, this.parseValue(organization?.RegistrationAddress?.Address?.ZipCode, 'ZIPCODE', organization.PrivateFields)).
                        replace(/{{Organization_Registration_HouseNumber}}/g, this.parseValue(organization?.RegistrationAddress?.Address?.HouseNumber, 'HOUSENUMBER', organization.PrivateFields)).
                        replace(/{{Organization_Registration_StreetName}}/g, this.parseValue(organization?.RegistrationAddress?.Address?.StreetName, 'STREETNAME', organization.PrivateFields)).
                        replace(/{{Organization_Registration_State}}/g, this.parseValue(organization?.RegistrationAddress?.Address?.State, 'STATE', organization.PrivateFields)).
                        replace(/{{Organization_Registration_HouseNumberAddition}}/g, this.parseValue(organization?.RegistrationAddress?.Address?.HouseNumberAddition, 'ADJUNCT', '')).
                        replace(/{{Organization_Registration_CountryId}}/g, this.parseValue(organization?.RegistrationAddress?.Address?.Country?.Name, 'COUNTRYID', '')).
                        replace(/{{Organization_Registration_POBoxNumber}}/g, this.parseValue(organization?.RegistrationAddress?.Address?.POBoxNumber, 'POBOXNUMBER', ''));
                    parsedTemplate = parsedTemplate.replace(/{{Organization_Correspondence_City}}/g, this.parseValue(organization?.CorrespondenceAddress?.Address?.City, 'CITY', '')).
                        replace(/{{Organization_Correspondence_ZipCode}}/g, this.parseValue(organization?.CorrespondenceAddress?.Address?.ZipCode, 'ZIPCODE', organization.PrivateFields)).
                        replace(/{{Organization_Correspondence_HouseNumber}}/g, this.parseValue(organization?.CorrespondenceAddress?.Address?.HouseNumber, 'HOUSENUMBER', organization.PrivateFields)).
                        replace(/{{Organization_Correspondence_StreetName}}/g, this.parseValue(organization?.CorrespondenceAddress?.Address?.StreetName, 'STREETNAME', organization.PrivateFields)).
                        replace(/{{Organization_Correspondence_State}}/g, this.parseValue(organization?.CorrespondenceAddress?.Address?.State, 'STATE', organization.PrivateFields)).
                        replace(/{{Organization_Correspondence_HouseNumberAddition}}/g, this.parseValue(organization?.CorrespondenceAddress?.Address?.HouseNumberAddition, 'ADJUNCT', '')).
                        replace(/{{Organization_Correspondence_CountryId}}/g, this.parseValue(organization?.CorrespondenceAddress?.Address?.Country?.Name, 'COUNTRYID', '')).
                        replace(/{{Organization_Correspondence_POBoxNumber}}/g, this.parseValue(organization?.CorrespondenceAddress?.Address?.POBoxNumber, 'POBOXNUMBER', ''));
                }
                let handler = this.employeeService.loggedInEmployee;
                if (!GlobalFunctions.isEmpty(handler)) {
                    parsedTemplate = parsedTemplate.replace(/{{Handler_Initials}}/g, this.parseValue(handler.Initials, '', '')).
                        replace(/{{Handler_Prefix}}/g, this.parseValue(handler.Prefix, 'PREFIX', handler.PrivateFields)).
                        replace(/{{Handler_LastName}}/g, this.parseValue(handler.Surname, 'SURNAME', handler.PrivateFields)).
                        replace(/{{Handler_FullName}}/g, this.parseValue(handler.Surname + ", " + handler.FirstName, '', '')).
                        replace(/{{Handler_EmailAddress}}/g, this.parseValue(handler.EmailAddress, 'EMAILADDRESS', handler.PrivateFields)).
                        replace(/{{Handler_PhoneNumber}}/g, this.parseValue(handler.PhoneNumber, 'PHONENUMBER', handler.PrivateFields)).
                        replace(/{{Handler_JobDescription}}/g, this.parseValue(handler.Function, 'FUNCTION', handler.PrivateFields));
                }
            }
        }
        catch (e) {
            console.error(e.message);
        }
        // Remove only truly empty <div> tags (ignore those containing <br>)
        parsedTemplate = parsedTemplate.replace(/<div>(?:\s|&nbsp;)*<\/div>/gi, '');
        return parsedTemplate;
    }
    removePrivacyDataFromObject(objectItem, entityFqdn) {
        try {
            if (objectItem != null && !GlobalFunctions.isEmpty(objectItem.PrivateFields)) {
                switch (entityFqdn) {
                    case EntityFqdn.Decos_Kcs_Persons_Entities_Person:
                        {
                            if (objectItem.PrivateFields.indexOf("|SERVICENUMBER|") !== -1)
                                objectItem.AdministeredPersonDto.ServiceNumber = "";
                            if (objectItem.PrivateFields.indexOf("|GENDER|") !== -1)
                                objectItem.Details.FormalName.Gender = "";
                            if (objectItem.PrivateFields.indexOf("|DATEOFBIRTH|") !== -1)
                                objectItem.Details.DateOfBirth = "";
                            if (objectItem.PrivateFields.indexOf("|ZIPCODE|") !== -1 || objectItem.PrivateFields.indexOf("|ADDRESS|") !== -1) {
                                if (!GlobalFunctions.isEmpty(objectItem.ResidentialAddress))
                                    objectItem.ResidentialAddress.Address.ZipCode = "";
                                if (!GlobalFunctions.isEmpty(objectItem.RegistrationAddress))
                                    objectItem.RegistrationAddress.Address.ZipCode = "";
                                if (!GlobalFunctions.isEmpty(objectItem.CorrespondenceAddress))
                                    objectItem.CorrespondenceAddress.Address.ZipCode = "";
                            }
                            if (objectItem.PrivateFields.indexOf("|HOUSENUMBER|") !== -1 || objectItem.PrivateFields.indexOf("|ADDRESS|") !== -1) {
                                if (!GlobalFunctions.isEmpty(objectItem.ResidentialAddress))
                                    objectItem.ResidentialAddress.Address.HouseNumber = "";
                                if (!GlobalFunctions.isEmpty(objectItem.RegistrationAddress))
                                    objectItem.RegistrationAddress.Address.HouseNumber = "";
                                if (!GlobalFunctions.isEmpty(objectItem.CorrespondenceAddress))
                                    objectItem.CorrespondenceAddress.Address.HouseNumber = "";
                            }
                            break;
                        }
                    case EntityFqdn.Decos_Kcs_Organizations_Entities_Organization:
                        {
                            if (objectItem.PrivateFields.indexOf("|IDENTIFICATION|") !== -1 && !GlobalFunctions.isEmpty(objectItem.AdministeredOrganizationDto))
                                objectItem.AdministeredOrganizationDto.Identification = "";
                            if (objectItem.PrivateFields.indexOf("|ZIPCODE|") !== -1 || objectItem.PrivateFields.indexOf("|ADDRESS|") !== -1) {
                                if (!GlobalFunctions.isEmpty(objectItem.RegistrationAddress))
                                    objectItem.RegistrationAddress.Address.ZipCode = "";
                                if (!GlobalFunctions.isEmpty(objectItem.CorrespondenceAddress))
                                    objectItem.CorrespondenceAddress.Address.ZipCode = "";
                            }
                            if (objectItem.PrivateFields.indexOf("|HOUSENUMBER|") !== -1 || objectItem.PrivateFields.indexOf("|ADDRESS|") !== -1) {
                                if (!GlobalFunctions.isEmpty(objectItem.RegistrationAddress))
                                    objectItem.RegistrationAddress.Address.HouseNumber = "";
                                if (!GlobalFunctions.isEmpty(objectItem.CorrespondenceAddress))
                                    objectItem.CorrespondenceAddress.Address.HouseNumber = "";
                            }
                            break;
                        }
                    case EntityFqdn.Decos_Kcs_Employees_Entities_Employee:
                        {
                            if (objectItem.PrivateFields.indexOf("|SURNAME|") !== -1)
                                objectItem.Surname = "";
                            if (objectItem.PrivateFields.indexOf("|FIRSTNAME|") !== -1)
                                objectItem.FirstName = "";
                            if (objectItem.PrivateFields.indexOf("|PREFIX|") !== -1)
                                objectItem.Prefix = "";
                            if (objectItem.PrivateFields.indexOf("|NOTE|") !== -1)
                                objectItem.Note = "";
                            if (objectItem.PrivateFields.indexOf("|SKILLS|") !== -1)
                                objectItem.Skills = "";
                            if (objectItem.PrivateFields.indexOf("|DEPARTMENTNAME|") !== -1 && objectItem.Department != null)
                                objectItem.Department.Name = "";
                            if (objectItem.PrivateFields.indexOf("|PHONENUMBER|") !== -1)
                                objectItem.PhoneNumber = "";
                            if (objectItem.PrivateFields.indexOf("|MOBILENUMBER|") !== -1)
                                objectItem.MobileNumber = "";
                            if (objectItem.PrivateFields.indexOf("|EXTENSIONNUMBER|") !== -1)
                                objectItem.ExtensionNumber = "";
                            if (objectItem.PrivateFields.indexOf("|ROOMNUMBER|") !== -1)
                                objectItem.RoomNumber = "";
                            if (objectItem.PrivateFields.indexOf("|EMAILADDRESS|") !== -1)
                                objectItem.EmailAddress = "";
                            if (objectItem.PrivateFields.indexOf("|DATEOFBIRTH|") !== -1)
                                objectItem.DateOfBirth = "";
                            if (objectItem.PrivateFields.indexOf("|FUNCTION|") !== -1)
                                objectItem.Function = "";
                            if (objectItem.PrivateFields.indexOf("|EXTRAINFO|") !== -1)
                                objectItem.ExtraInfo = "";
                            break;
                        }
                }
            }
        }
        catch (e) {
            console.error(e.message);
        }
        return objectItem;
    }
    ;
    // Social Media
    setUserDetail(result, cacheManager) {
        if (result != null && result.length > 0 && this.employeeService.isEmployeesReceived) {
            result.forEach(socialMediaDto => {
                // Set Handler Name
                if (!GlobalFunctions.isEmpty(socialMediaDto.MessageHandling) && !GlobalFunctions.isEmpty(socialMediaDto.MessageHandling.HandlerId)) {
                    if (cacheManager != undefined) {
                        let handlerObject = cacheManager.getEmployeeById(socialMediaDto.MessageHandling.HandlerId);
                        if (handlerObject != null)
                            socialMediaDto.HandlerName = handlerObject.StringRepresentation;
                    }
                }
                //Set Picture
                if (socialMediaDto.User.Picture == null || socialMediaDto.User.Picture == '') {
                    socialMediaDto.User.Picture = './assets/images/nophoto.png';
                }
                else if (socialMediaDto.User.Picture != './assets/images/nophoto.png' && socialMediaDto.User.Picture.indexOf('DownloadFile') < 0 && socialMediaDto.User.Picture.toLowerCase().indexOf('http') < 0) {
                    let url = "";
                    url = this.downloadService.DOWNLOAD_API_URL.replace('{0}', socialMediaDto.User.Picture);
                    socialMediaDto.User.Picture = url + "&extension=" + ".jpg";
                }
                //In case of Published message, Replace Page name with Hamdler name if message is published from JKC
                if (socialMediaDto.IsPublishedMessage && !GlobalFunctions.isEmpty(socialMediaDto.MessageHandling) && !GlobalFunctions.isEmpty(socialMediaDto.MessageHandling.HandlerId)) {
                    socialMediaDto.User = this.getUserDetail(socialMediaDto.User, socialMediaDto.MessageHandling.HandlerId);
                }
            });
        }
    }
    // Social Media
    getUserDetail(user, newUserId) {
        if (user != null) {
            let employee = this.cacheManager.getEmployeeById(newUserId);
            if (employee != null) {
                let employeeList = [];
                employeeList.push(employee);
                user.Name = employee.StringRepresentation;
                user.Picture = employee.PictureData;
            }
        }
        return user;
    }
    getGenderAnnotation(gender) {
        let genderAnnotation = "";
        if (!GlobalFunctions.isEmpty(gender))
            switch (gender) {
                case 0:
                    genderAnnotation = this.translateService.instant("LBL_SIR");
                    break;
                case 1:
                    genderAnnotation = this.translateService.instant("LBL_MADAM");
                    break;
                case 2:
                    genderAnnotation = this.translateService.instant("LBL_SIR") + "/" + this.translateService.instant("LBL_MADAM");
                    break;
            }
        return genderAnnotation;
    }
};
FormatManager = __decorate([
    Injectable({
        providedIn: 'root'
    })
], FormatManager);
export { FormatManager };
//# sourceMappingURL=format-manager.js.map