var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Injectable } from "@angular/core";
import { environment } from "../../../environments/environment";
import { GlobalFunctions } from "../../shared/global-functions";
import { UrlHelper } from "../../shared/helper/url-helper";
let FileManager = class FileManager {
    constructor(fileService, translateService, applicationSettingManager) {
        this.fileService = fileService;
        this.translateService = translateService;
        this.applicationSettingManager = applicationSettingManager;
    }
    setFilePickerCallback(callback, value, meta, editor, entityName) {
        const input = document.createElement('input');
        input.setAttribute('type', 'file');
        input.setAttribute('accept', 'image/*');
        input.style.display = 'none';
        document.body.appendChild(input);
        input.onchange = () => {
            const file = input.files?.[0];
            const size = file.size / 1024;
            const extension = file.name.split('.').pop()?.toLowerCase() || '';
            const x = document.getElementsByClassName("tox-dialog__footer-start");
            const lastHtmlElement = x[x.length - 1];
            const whitelistedExtension = this.applicationSettingManager.getApplicationSettingValueByKey("WhitelistedImageExtensionsForUpload");
            if (size > 4096)
                lastHtmlElement.innerHTML = `<p style='color:red;'>${this.translateService.instant("LBL_IMAGE_SIZE_ERROR_MSG")}</p>`;
            else if (file.type.indexOf("image") == -1 || (!GlobalFunctions.isEmpty(whitelistedExtension) && whitelistedExtension.toLowerCase().indexOf(extension.toLowerCase()) === -1))
                lastHtmlElement.innerHTML = `<p style='color:red;'>${this.translateService.instant("LBL_IMAGE_TYPE_ERROR_MSG")}</p>`;
            else {
                const reader = new FileReader();
                reader.onload = () => {
                    const blobCache = editor.editorUpload.blobCache;
                    const blobInfo = blobCache.create(entityName, file, reader.result?.toString().split(',')[1]);
                    blobCache.add(blobInfo);
                    callback(blobInfo.blobUri(), { title: file.name, alt: file.name });
                    lastHtmlElement.innerHTML = '';
                };
                reader.readAsDataURL(file);
            }
        };
        input.click();
    }
    // UploadHandler for tinymce
    setFileUploadHandler(blobInfo, progress, basePath, source) {
        return new Promise(async (resolve, reject) => {
            try {
                const file = new File([blobInfo.blob()], blobInfo.filename(), { type: blobInfo.blob().type });
                const formData = new FormData();
                formData.append('file', file);
                const files = await this.fileService.uploadFileAsync(formData, UrlHelper.getUploadFileURL(environment.api_url, source, GlobalFunctions.getSessionTokenAsString()));
                resolve(basePath + files[0].fileName); // Return uploaded image URL
            }
            catch (e) {
                console.error(e);
                reject({ message: this.translateService.instant('LBL_ERROR_MSG'), remove: true });
            }
        });
    }
};
FileManager = __decorate([
    Injectable({
        providedIn: 'root'
    })
], FileManager);
export { FileManager };
//# sourceMappingURL=file-manager.js.map