var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Injectable } from "@angular/core";
import { OutboxComponent } from "src/app/components/common/outbox/outbox.component";
import { ProfileComponent } from "src/app/components/common/profile/profile.component";
import { LinkEmailToCaseComponent } from "src/app/components/domain/email/link-to-case/link-email-to-case.component";
import { ReassignMessageComponent } from "src/app/components/domain/social-media/reassign-message/reassign-message.component";
import { SubSink } from "subsink";
import { BaseComponent } from "../../components/base-component";
import { EntityHistoryComponent } from "../../components/common/entity-history/entity-history.component";
import { LinkContactInfoComponent } from "../../components/common/link-contact-info/link-contact-info.component";
import { LinkUnlinkEntityComponent } from "../../components/common/link-unlink-entity/link-unlink-entity.component";
import { ManageBlockWiseLocalGroupPrivilegeComponent } from "../../components/common/manage-block-wise-local-group-privilege/manage-block-wise-local-group-privilege.component";
import { ManageLocalGroupPrivilegeComponent } from "../../components/common/manage-local-group-privilege/manage-local-group-privilege.component";
import { MergeDataComponent } from "../../components/common/merge-data/merge-data.component";
import { MergeLetterTemplateComponent } from "../../components/common/merge-letter-template/merge-letter-template.component";
import { MessageboxComponent } from "../../components/common/messagebox/messagebox.component";
import { PrintComponent } from "../../components/common/print/print.component";
import { RoleComponent } from "../../components/common/role/role.component";
import { UpdateContactInfoComponent } from "../../components/common/update-contact-info/update-contact-info.component";
import { ViewerComponent } from "../../components/common/viewer/viewer.component";
import { CaseAddEditComponent } from "../../components/domain/case/add-edit/case-add-edit.component";
import { ContactHistoryBulkDeleteComponent } from "../../components/domain/contact-history/bulk-delete/contact-history-bulk-delete.component";
import { ContactHistoryEditComponent } from "../../components/domain/contact-history/edit/contact-history-edit.component";
import { DocumentAddComponent } from "../../components/domain/document/add/document-add.component";
import { DomainAddEditComponent } from "../../components/domain/domain/add-edit/domain-add-edit.component";
import { EmailBasketComponent } from "../../components/domain/email/basket/email-basket.component";
import { EmployeePanelComponent } from "../../components/domain/employee/panel/employee-panel.component";
import { EmployeePopupComponent } from "../../components/domain/employee/popup/employee-popup.component";
import { FileAddEditComponent } from "../../components/domain/file/add-edit/file-add-edit.component";
import { IssueAddComponent } from "../../components/domain/issue/add/issue-add.component";
import { LinkAddEditComponent } from "../../components/domain/link/add-edit/link-add-edit.component";
import { NoteAddEditComponent } from "../../components/domain/note/add-edit/note-add-edit.component";
import { OrganizationAddEditComponent } from "../../components/domain/organization/add-edit/organization-add-edit.component";
import { RepresentativeAddComponent } from "../../components/domain/organization/add-representative/organization-add-representative.component";
import { PersonAddEditComponent } from "../../components/domain/person/add-edit/person-add-edit.component";
import { AddSocialMediaMessageComponent } from "../../components/domain/social-media/add-social-media-message/add-social-media-message.component";
import { BulkReplyComponent } from "../../components/domain/social-media/bulk-reply/bulk-reply.component";
import { TaskBulkHandleComponent } from "../../components/domain/task/bulk-handle/task-bulk-handle.component";
import { TaskForwardComponent } from "../../components/domain/task/forward/task-forward.component";
import { AppointmentAddEditNativeComponent } from "../../components/domain/task/subdomains/appointment/add-edit/native/appointment-add-edit-native.component";
import { AppointmentAddEditQmaticComponent } from "../../components/domain/task/subdomains/appointment/add-edit/qmatic/appointment-add-edit-qmatic.component";
import { AppointmentAddEditSmartCjmComponent } from "../../components/domain/task/subdomains/appointment/add-edit/smart-cjm/appointment-add-edit-smart-cjm.component";
import { AppointmentHandleComponent } from "../../components/domain/task/subdomains/appointment/handle/appointment-handle.component";
import { AssignmentAddEditComponent } from "../../components/domain/task/subdomains/assignment/add-edit/assignment-add-edit.component";
import { AssignmentHandleComponent } from "../../components/domain/task/subdomains/assignment/handle/assignment-handle.component";
import { CallbackNoteAddEditComponent } from "../../components/domain/task/subdomains/callback-note/add-edit/callback-note-add-edit.component";
import { CallbackNoteHandleComponent } from "../../components/domain/task/subdomains/callback-note/handle/callback-note-handle.component";
import { InformationRequestAddEditComponent } from "../../components/domain/task/subdomains/information-request/add-edit/information-request-add-edit.component";
import { InformationRequestHandleComponent } from "../../components/domain/task/subdomains/information-request/handle/information-request-handle.component";
import { ReportImprovementAddEditComponent } from "../../components/domain/task/subdomains/report-improvement/add-edit/report-improvement-add-edit.component";
import { ReportImprovementHandleComponent } from "../../components/domain/task/subdomains/report-improvement/handle/report-improvement-handle.component";
import { SessionSaveComponent } from "../../components/domain/task/subdomains/session/save/session-save.component";
import { ThemeAddEditComponent } from "../../components/domain/theme/add-edit/theme-add-edit.component";
import { TicketAddEditComponent } from "../../components/domain/ticket/add-edit/ticket-add-edit.component";
import { TicketAttachToEmailComponent } from "../../components/domain/ticket/attach-to-email/ticket-attach-to-email.component";
import { TicketHandleComponent } from "../../components/domain/ticket/handle/ticket-handle.component";
import { TicketLinkEntityComponent } from "../../components/domain/ticket/link-entity/ticket-link-entity.component";
import { BroadCastEventKeys } from "../../shared/constants";
import { GlobalFunctions } from "../../shared/global-functions";
import { DialogHelper } from "../../shared/helper/dialog-helper";
import { JkcPanel } from "../../shared/helper/jkc-panel-helper";
import { ScreenMode } from "../enums/common-enums";
import { EntityFqdn } from "../enums/core-enums";
import { EmailType } from "../enums/global-enum";
import { UIState } from "../enums/session-enum";
import { MakeAppointmentExternalRequest } from "../models/common/make-appointment-external-request";
import { TicketDto } from "../models/ticket/ticketDto";
import { PopularNumberPanelComponent } from "../../components/domain/employee/popular-number/panel/popularnumber-panel.component";
const JsPanel = require('../../../../node_modules/jspanel4/dist/jspanel.min.js');
let DialogManager = class DialogManager extends BaseComponent {
    constructor(cacheManager, sessionManager, applicationFeatureManager, applicationSettingManager, integrationSettingManager, phoneManager, shortcutManager, taskService, dialog, translateService, router, zone, eventProvider, serviceManager) {
        super(translateService, router, zone, dialog, null, null);
        this.cacheManager = cacheManager;
        this.sessionManager = sessionManager;
        this.applicationFeatureManager = applicationFeatureManager;
        this.applicationSettingManager = applicationSettingManager;
        this.integrationSettingManager = integrationSettingManager;
        this.phoneManager = phoneManager;
        this.shortcutManager = shortcutManager;
        this.taskService = taskService;
        this.dialog = dialog;
        this.translateService = translateService;
        this.router = router;
        this.zone = zone;
        this.eventProvider = eventProvider;
        this.serviceManager = serviceManager;
        this.openContactHistorySource = '';
        this.subs = new SubSink();
        this.startSessionResponseReceived = this.startSessionResponseReceived.bind(this);
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.REMOVE_COMPONENT).subscribe(() => this.removeComponent());
    }
    openJsPanelOrDialog(dialogName, editMode = false, editedData = null, handleOpenEvent = false, viewContainerRef = null, component = null) {
        let dialog = null;
        let dialogParts = dialogName.split(':');
        let dialogTypeName = dialogParts[0].toUpperCase();
        switch (dialogTypeName) {
            case "ADD_PERSON":
                {
                    if (GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) || !this.sessionManager.jkcParentPanel.parameters.IsUsed) {
                        this.sessionManager.jkcParentPanel = new JkcPanel(this.sessionManager.contactSessionNotesState, null, editMode, null, null, null, 'addPersonHeader', 'addPersonFooter', '-42px', '11.2%', '25%', '50%', null, '50%');
                        this.openJkcParentPanelDialogue(PersonAddEditComponent, 'addPersonContainer', viewContainerRef);
                    }
                    else {
                        this.popupIsAlreadyOpenMessage();
                    }
                    break;
                }
            case "ADD_TICKET":
                {
                    let editedTicketData = GlobalFunctions.isEmpty(editedData) ? null : editedData;
                    if (GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) || !this.sessionManager.jkcParentPanel.parameters.IsUsed) {
                        this.sessionManager.jkcParentPanel = new JkcPanel(this.sessionManager.contactSessionNotesState, null, false, editedTicketData.TicketType, editedTicketData, null, 'addTicketHeader', 'addTicketFooter', '-42px', '1.2%', '15%', '70%', null, '70%');
                        this.openJkcParentPanelDialogue(TicketAddEditComponent, 'addTicketContainer', viewContainerRef);
                    }
                    else
                        this.popupIsAlreadyOpenMessage();
                    break;
                }
            case "ADD_ISSUE":
                {
                    if (GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) || !this.sessionManager.jkcParentPanel.parameters.IsUsed) {
                        this.sessionManager.jkcParentPanel = new JkcPanel(this.sessionManager.contactSessionNotesState, null, false, null, null, null, 'addIssueHeader', null, '-42px', '1.2%', '15%', '70%', null, '70%');
                        this.openJkcParentPanelDialogue(IssueAddComponent, 'addIssueContainer', viewContainerRef);
                    }
                    else
                        this.popupIsAlreadyOpenMessage();
                    break;
                }
            case "SHORT_CUT_DIALOG":
                {
                    DialogHelper.openDialog(this.dialog, component, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { shortCutItemsList: this.shortcutManager.getShortcutDetails(this.phoneManager, this.applicationFeatureManager) });
                    break;
                }
            case "FEEDBACK_DIALOG":
                {
                    DialogHelper.openDialog(this.dialog, component, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), null);
                    break;
                }
            case "EMPLOYEE_POPUP_PANEL":
                {
                    DialogHelper.openDialog(this.dialog, EmployeePanelComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { isSearchSelected: false }, 'employeePanelComponent').afterClosed().subscribe(innerResult => {
                        if (innerResult?.targetButton != undefined && innerResult?.targetButton == "ADD_CALLBACKNOTE")
                            this.openJsPanelOrDialog("ADD_CALLBACKNOTE", null, null, null, viewContainerRef);
                        else if (innerResult?.targetButton != undefined && innerResult?.targetButton == "ADD_APPOINTMENT")
                            this.openJsPanelOrDialog("ADD_APPOINTMENT", null, null, null, viewContainerRef);
                        else if (innerResult?.emailId != undefined && innerResult?.targetButton == "SEND_EMAIL" && GlobalFunctions.checkRights('Email'))
                            this.loadSendEmailDialog(innerResult.emailId);
                    });
                    break;
                }
            case "SEARCH_EMPLOYEE_POPUP_PANEL":
                {
                    dialog = DialogHelper.openDialog(this.dialog, EmployeePanelComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { isSearchSelected: true }, 'employeePanelComponent');
                    break;
                }
            case "POPULAR_NUMBER_POPUP_PANEL":
                {
                    DialogHelper.openDialog(this.dialog, PopularNumberPanelComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { selectedItem: editedData }, 'popularNumberPanelComponent').afterClosed().subscribe(result => {
                        if (result?.emailId != undefined && result?.targetButton == "SEND_EMAIL" && GlobalFunctions.checkRights('Email'))
                            this.loadSendEmailDialog(result.emailId);
                        else if (result?.targetButton != undefined)
                            this.openJsPanelOrDialog(result.targetButton);
                    });
                    break;
                }
            case "ADD_CALLBACKNOTE":
                {
                    if (GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) || !this.sessionManager.jkcParentPanel.parameters.IsUsed) {
                        this.sessionManager.jkcParentPanel = new JkcPanel(this.sessionManager.contactSessionNotesState, editedData, editMode, 'callbacknote', null, null, 'addTaskHeader', 'addTaskFooter', '-42px', '1.2%', '15%', '70%', null, '70%');
                        this.openJkcParentPanelDialogue(CallbackNoteAddEditComponent, 'addTaskContainer', viewContainerRef);
                    }
                    else
                        DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_APPLICATION_TITLE'), textMsg: this.translateService.instant('LBL_RESTRICT_MULTIPLE_WINDOW_MESSAGE') });
                    break;
                }
            case "ADD_INFORMATIONREQUEST":
                {
                    if (GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) || !this.sessionManager.jkcParentPanel.parameters.IsUsed) {
                        this.sessionManager.jkcParentPanel = new JkcPanel(this.sessionManager.contactSessionNotesState, editedData, false, null, null, null, 'addInformationRequestHeader', 'addInformationRequestFooter', '-42px', '1.2%', '15%', '70%', null, '70%');
                        this.openJkcParentPanelDialogue(InformationRequestAddEditComponent, 'addInformationRequestContainer', viewContainerRef);
                    }
                    else
                        this.popupIsAlreadyOpenMessage();
                    break;
                }
            case "ADD_ORGANIZATION":
                {
                    if (GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) || !this.sessionManager.jkcParentPanel.parameters.IsUsed) {
                        this.sessionManager.jkcParentPanel = new JkcPanel(this.sessionManager.contactSessionNotesState, null, editMode, null, null, null, 'addOrganizationHeader', 'addOrganizationFooter', '-42px', '11.2%', '25%', '50%', null, '50%');
                        this.openJkcParentPanelDialogue(OrganizationAddEditComponent, 'addOrganizationContainer', viewContainerRef);
                    }
                    else
                        this.popupIsAlreadyOpenMessage();
                    break;
                }
            case "END_SESSION_DIALOG":
                {
                    this.openEndSessionDialog();
                    break;
                }
            case "SAVE_SESSION_DIALOG":
                {
                    this.openSaveSessionDialog();
                    break;
                }
            case "ADD_APPOINTMENT":
                {
                    // SMART CJM TYPE
                    if (this.applicationSettingManager.isSmartCJMEnabled()) {
                        if (GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) || !this.sessionManager.jkcParentPanel.parameters.IsUsed) {
                            this.sessionManager.jkcParentPanel = new JkcPanel(this.sessionManager.contactSessionNotesState, editedData, editMode, 'appointment', null, null, 'addTaskHeader', 'addTaskFooter', '-42px', '1.2%', '15%', '70%', null, '70%');
                            this.openJkcParentPanelDialogue(AppointmentAddEditSmartCjmComponent, 'addTaskContainer', viewContainerRef);
                        }
                        else
                            this.popupIsAlreadyOpenMessage();
                    }
                    // QMATIC TYPE
                    else if (this.applicationSettingManager.isQmaticEnabled()) {
                        if (GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) || !this.sessionManager.jkcParentPanel.parameters.IsUsed) {
                            this.sessionManager.jkcParentPanel = new JkcPanel(this.sessionManager.contactSessionNotesState, null, false, 'appointment', null, null, 'addTaskHeader', 'addTaskFooter', '-42px', '1.2%', '15%', '70%', null, '70%');
                            this.openJkcParentPanelDialogue(AppointmentAddEditQmaticComponent, 'addTaskContainer', viewContainerRef);
                        }
                        else
                            this.popupIsAlreadyOpenMessage();
                    }
                    else {
                        // JCC TYPE
                        if (this.applicationSettingManager.isJCCEnabled()) {
                            const cachedEntities = this.sessionManager.detailViewCachedEntityList;
                            if (cachedEntities?.length > 0 && jlinq.from(cachedEntities).starts("value", GlobalFunctions.toContentType("PERSON")).any()) {
                                let caseId = '';
                                const caseEntity = GlobalFunctions.getLastCaseEntityFromSession(cachedEntities);
                                const personEntities = GlobalFunctions.getLastPersonFromSession(cachedEntities);
                                if (caseEntity)
                                    caseId = caseEntity.ObjectSource.toLowerCase().indexOf("connect") === -1 ? caseEntity.Id : caseEntity.Identification;
                                const request = new MakeAppointmentExternalRequest();
                                request.BsnNumber = personEntities.AdministeredPersonDto != null && !GlobalFunctions.isEmpty(personEntities.AdministeredPersonDto.ServiceNumber) && personEntities.AdministeredPersonDto.ServiceNumber != '0' ? personEntities.AdministeredPersonDto.ServiceNumber : "";
                                request.CaseNumber = caseId;
                                if (!editMode)
                                    request.CustomerInformation = GlobalFunctions.getCustomerInformationForExternalAppointment(personEntities);
                                else {
                                    request.AppointmentId = this.sessionManager.selectedEntity.Id;
                                    request.RequestId = "WIJZIGAFSPRAAK";
                                }
                                this.taskService.startSessionResponseCallbacks(this.startSessionResponseReceived);
                                this.taskService.makeAppointmentExternal(request);
                                this.openContactHistorySource = "JccAppointment";
                                if (this.sessionManager.isSessionStart)
                                    this.openEndSessionDialog();
                            }
                            else
                                DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant("LBL_APPOINTMENT"), textMsg: this.translateService.instant("LBL_MSG_FIRST_SELECT_A_PERSON") });
                        }
                        // EXTERNAL TYPE
                        else {
                            const externalAppointmentUrl = this.applicationSettingManager.getApplicationSettingValueByKey("EXTERNALAPPOINTMENTURL");
                            if (!GlobalFunctions.isEmpty(externalAppointmentUrl)) {
                                this.sessionManager.startSessionIfPossible("TASK", ScreenMode.Add);
                                window.open(externalAppointmentUrl, "_blank");
                            }
                            // NATIVE TYPE
                            else {
                                if (GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) || !this.sessionManager.jkcParentPanel.parameters.IsUsed) {
                                    this.sessionManager.jkcParentPanel = new JkcPanel(this.sessionManager.contactSessionNotesState, editedData, editMode, 'appointment', null, null, 'addTaskHeader', 'addTaskFooter', '-42px', '1.2%', '15%', '70%', null, '70%');
                                    this.openJkcParentPanelDialogue(AppointmentAddEditNativeComponent, 'addTaskContainer', viewContainerRef);
                                }
                                else
                                    this.popupIsAlreadyOpenMessage();
                            }
                        }
                    }
                    break;
                }
            case "ADD_CASE":
                {
                    if (GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) || !this.sessionManager.jkcParentPanel.parameters.IsUsed) {
                        this.sessionManager.jkcParentPanel = new JkcPanel(this.sessionManager.contactSessionNotesState, null, false, null, null, null, 'addCaseHeader', 'addCaseFooter', '-42px', '11.2%', '25%', '50%', null, '50%');
                        this.openJkcParentPanelDialogue(CaseAddEditComponent, 'addCaseContainer', viewContainerRef);
                    }
                    else
                        this.popupIsAlreadyOpenMessage();
                    break;
                }
            case "ADD_DOCUMENT":
                {
                    if (GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) || !this.sessionManager.jkcParentPanel.parameters.IsUsed) {
                        this.sessionManager.jkcParentPanel = new JkcPanel(this.sessionManager.contactSessionNotesState, null, false, null, null, null, 'addDocumentHeader', 'addDocumentFooter', '-42px', '1.2%', '15%', '70%', null, '70%');
                        this.openJkcParentPanelDialogue(DocumentAddComponent, 'addDocumentContainer', viewContainerRef);
                    }
                    else
                        this.popupIsAlreadyOpenMessage();
                    break;
                }
            case "ADD_NOTE":
                {
                    if (GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) || !this.sessionManager.jkcParentPanel.parameters.IsUsed) {
                        this.sessionManager.jkcParentPanel = new JkcPanel(this.sessionManager.contactSessionNotesState, editedData, editMode, 'callbacknote', null, null, 'createNoteHeader', 'createNoteFooter', '-42px', '1.2%', '15%', '70%', null, '70%');
                        this.openJkcParentPanelDialogue(NoteAddEditComponent, 'addNoteContainer', viewContainerRef);
                    }
                    else
                        this.popupIsAlreadyOpenMessage();
                    break;
                }
            case "OUTBOX_DIALOG":
                {
                    DialogHelper.openDialog(this.dialog, OutboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState)).afterClosed().subscribe(innerResult => {
                        if (innerResult != undefined && innerResult.targetButton != undefined && innerResult.targetButton == "OUTBOX_DIALOG")
                            this.openJsPanelOrDialog("OUTBOX_DIALOG");
                    });
                    break;
                }
            case "PROFILE_DIALOG":
                {
                    DialogHelper.openDialog(this.dialog, ProfileComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), null).afterClosed().subscribe(innerResult => {
                        if (innerResult != undefined && innerResult.targetButton != undefined && innerResult.targetButton == "PROFILE_DIALOG")
                            this.openJsPanelOrDialog("PROFILE_DIALOG");
                    });
                    break;
                }
            case "EMAIL_DIALOG":
                {
                    if (handleOpenEvent)
                        return;
                    if (GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) || !this.sessionManager.jkcParentPanel.parameters.IsUsed) {
                        let baskItemList = this.sessionManager.getMarkedItems(this.sessionManager.getBasketItems());
                        this.sessionManager.jkcParentPanel = new JkcPanel(this.sessionManager.contactSessionNotesState, null, false, EmailType.Send, baskItemList, null, 'emailBasketHeader', 'emailBasketFooter', '-42px', '1.2%', '15%', '70%', null, '70%');
                        this.openJkcParentPanelDialogue(EmailBasketComponent, 'emailBasketContainer', viewContainerRef);
                    }
                    else
                        this.popupIsAlreadyOpenMessage();
                    break;
                }
            case "PRINT_DIALOG":
                {
                    if (handleOpenEvent)
                        return;
                    dialog = DialogHelper.openDialog(this.dialog, PrintComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { outboxItems: this.sessionManager.getMarkedItems(this.sessionManager.getBasketItems()) });
                    break;
                }
            case "ADD_FILE":
                {
                    if (GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) || !this.sessionManager.jkcParentPanel.parameters.IsUsed) {
                        this.sessionManager.jkcParentPanel = new JkcPanel(this.sessionManager.contactSessionNotesState, null, editMode, null, null, null, 'addFileHeader', 'addFileFooter', '-42px', '1.2%', '15%', '70%', null, '70%');
                        this.openJkcParentPanelDialogue(FileAddEditComponent, 'addFileContainer', viewContainerRef);
                    }
                    else
                        this.popupIsAlreadyOpenMessage();
                    break;
                }
            case "ADD_THEME":
                {
                    if (GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) || !this.sessionManager.jkcParentPanel.parameters.IsUsed) {
                        this.sessionManager.jkcParentPanel = new JkcPanel(this.sessionManager.contactSessionNotesState, null, editMode, null, null, null, 'createThemeHeader', 'createThemeFooter', '-42px', '1.2%', '15%', '70%', null, '70%');
                        this.openJkcParentPanelDialogue(ThemeAddEditComponent, 'themeContainer', viewContainerRef);
                    }
                    else
                        this.popupIsAlreadyOpenMessage();
                    break;
                }
            case "ADD_LINK":
                {
                    if (GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) || !this.sessionManager.jkcParentPanel.parameters.IsUsed) {
                        this.sessionManager.jkcParentPanel = new JkcPanel(this.sessionManager.contactSessionNotesState, null, editMode, null, null, null, 'addlinkHeader', 'addLinkFooter', '-42px', '1.2%', '15%', '70%', null, '70%');
                        this.openJkcParentPanelDialogue(LinkAddEditComponent, 'addLinkContainer', viewContainerRef);
                    }
                    else
                        this.popupIsAlreadyOpenMessage();
                    break;
                }
            case "ARRANGE_THEME_SECTIONS":
                {
                    DialogHelper.openDialog(this.dialog, component, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), null);
                    break;
                }
            case "FILTER_COLUMN_LIST":
                {
                    DialogHelper.openDialog(this.dialog, component, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { filterOptions: editedData });
                    break;
                }
            case "ADD_SOCIALMEDIA":
                {
                    if (GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) || !this.sessionManager.jkcParentPanel.parameters.IsUsed) {
                        this.sessionManager.jkcParentPanel = new JkcPanel(this.sessionManager.contactSessionNotesState, null, editMode, null, null, null, 'addSocialMediaHeader', 'addSocialMediaFooter', '-42px', '1.2%', '15%', '70%', null, '70%');
                        this.openJkcParentPanelDialogue(AddSocialMediaMessageComponent, 'addSocialMediaContainer', viewContainerRef);
                    }
                    else
                        this.popupIsAlreadyOpenMessage();
                    break;
                }
            case "ATTACH_TO_EMAIL":
                {
                    DialogHelper.openDialog(this.dialog, TicketAttachToEmailComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { viewContainerRef });
                    break;
                }
            case "ENTITY_HISTORY":
                {
                    DialogHelper.openDialog(this.dialog, EntityHistoryComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), null);
                    break;
                }
            case "MERGE_LETTER":
                {
                    DialogHelper.openDialog(this.dialog, MergeLetterTemplateComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), null);
                    break;
                }
            case "ADD_ASSIGNMENT":
                {
                    if (this.sessionManager.selectedEntity?.MessageHandling?.HandlerId != undefined)
                        this.HandlerIsAlreadyAssignedMessage();
                    else if (GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) || !this.sessionManager.jkcParentPanel.parameters.IsUsed) {
                        this.sessionManager.jkcParentPanel = new JkcPanel(this.sessionManager.contactSessionNotesState, editedData, false, null, null, null, 'addAssignmentHeader', 'addAssignmentFooter', '-42px', '1.2%', '15%', '70%', null, '70%');
                        this.openJkcParentPanelDialogue(AssignmentAddEditComponent, 'addAssignmentContainer', viewContainerRef);
                    }
                    else
                        this.popupIsAlreadyOpenMessage();
                    break;
                }
            case "ADD_DOMAIN":
                {
                    let editedDomainData = GlobalFunctions.isEmpty(editedData) ? null : editedData;
                    if (GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) || !this.sessionManager.jkcParentPanel.parameters.IsUsed) {
                        this.sessionManager.jkcParentPanel = new JkcPanel(this.sessionManager.contactSessionNotesState, null, false, editedDomainData, editedDomainData, null, 'addDomainHeader', 'addDomainFooter', '-42px', '1.2%', '15%', '70%', null, '70%');
                        this.openJkcParentPanelDialogue(DomainAddEditComponent, 'addDomainContainer', viewContainerRef);
                    }
                    else
                        this.popupIsAlreadyOpenMessage();
                    break;
                }
        }
        ;
        return dialog;
    }
    openSaveSessionDialog() {
        if (!this.sessionManager.isSessionStart)
            return;
        let description = "";
        if (this.applicationFeatureManager.isShowNextEmailFeatureEnabled && !GlobalFunctions.isEmpty(this.sessionManager.selectedEntity) && !GlobalFunctions.isEmpty(this.sessionManager.selectedEntity.RelatedEntityFqdn) && GlobalFunctions.getObjectTypeName(this.sessionManager.selectedEntity.RelatedEntityFqdn).toLowerCase() == "email" && !GlobalFunctions.isEmpty(this.sessionManager.selectedEntity.Header.Subject))
            description = this.sessionManager.selectedEntity.Header.Subject;
        DialogHelper.openDialog(this.dialog, SessionSaveComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { uiObject: null, uiState: null, calledDialog: null, defaultDescription: description, clickedFrom: '' }, 'sessionSaveComponent');
    }
    ;
    openEndSessionDialog() {
        if (!this.phoneManager.isExtensionNumber) {
            this.sessionManager.contactSessionNotesState.isContactSessionNotesHighlighted = true;
            this.sessionManager.isSessionStart = true;
        }
        else
            console.log("Not opening contact history due to call with extension number");
    }
    showEndSessionDialog() {
        let messageInfo = DialogHelper.getMessage(this.translateService.instant("LBL_LOGOUT"), this.translateService.instant("LBL_SAVE_SESSION_BEFORE_LOGOUT_MESSAGE"), true, null, null, null, null, this.translateService);
        DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), messageInfo).afterClosed().subscribe(result => {
            if (result)
                this.eventProvider.BroadcastEvent(BroadCastEventKeys.LOGOUT);
            else
                this.openEndSessionDialog();
        });
    }
    showLogoutDialog() {
        let messageInfo = DialogHelper.getMessage(this.translateService.instant("LBL_LOGOUT"), this.translateService.instant("LBL_MSG_SIGN_OUT"), true, null, null, null, null, this.translateService);
        return DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), messageInfo);
    }
    openJkcParentPanelDialogue(component, entityContainerId, viewContainerRef) {
        this.componentRef = viewContainerRef.createComponent(component);
        const element = this.componentRef.location.nativeElement;
        $("#jkcParentPanelContainer").empty();
        this.jkcParentPanel = JsPanel.create({
            borderRadius: '5px 5px 0px 0px',
            id: "jkcParentPanel",
            header: false,
            content: element,
            container: '#jkcParentPanelContainer',
            contentOverflow: 'hidden',
            dragit: {
                opacity: 0.6,
                containment: [-47, 0, 0, 0],
                handles: '.jspanel-header',
                start: () => $("#jkcParentPanel").css({ 'transition': 'unset' })
            },
            resizeit: {
                containment: [-47, 0, 0, 0],
                minWidth: 500,
                minHeight: 500,
                resize: () => this.eventProvider.BroadcastEvent(BroadCastEventKeys.JSPANEL_RESIZE),
                start: () => $("#jkcParentPanel").css({ 'transition': 'unset' })
            }
        });
        if ($("#jkcParentPanel"))
            this.sessionManager.jkcParentPanel.setInitialJsPanelStyle();
    }
    removeComponent() {
        if (this.componentRef != null)
            this.componentRef.destroy();
    }
    openJkcChildPanelDialogue(component, entityContainerId, viewContainerRef) {
        const componentRef = viewContainerRef.createComponent(component);
        const element = componentRef.location.nativeElement;
        $("#jkcChildPanelContainer").empty();
        this.jkcChildPanel = JsPanel.create({
            borderRadius: '5px 5px 0px 0px',
            id: "jkcChildPanel",
            header: false,
            content: element,
            container: '#jkcChildPanelContainer',
            contentOverflow: 'hidden',
            dragit: {
                opacity: 0.6,
                containment: [-47, 0, 0, 0],
                handles: '.jspanel-header',
                start: () => $("#jkcChildPanel").css({ 'transition': 'unset' })
            },
            resizeit: {
                containment: [-47, 0, 0, 0],
                minWidth: 500,
                minHeight: 500,
                resize: () => this.eventProvider.BroadcastEvent(BroadCastEventKeys.JSPANEL_RESIZE),
                start: () => $("#jkcChildPanel").css({ 'transition': 'unset' })
            }
        });
        if ($("#jkcChildPanel") != null) {
            if (this.sessionManager.contactSessionNotesState.UIState == 1)
                this.sessionManager.jkcChildPanel.setInitialJsPanelStyle('#jkcChildPanel');
            else
                this.sessionManager.jkcChildPanel.setInitialJsPanelStyle('#jkcChildPanel');
        }
    }
    ;
    closeParentJsPanel() {
        if (this.jkcParentPanel != null)
            this.jkcParentPanel.close();
    }
    openRolePreference() {
        return DialogHelper.openDialog(this.dialog, RoleComponent, '50%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState));
    }
    startSessionResponseReceived(response) {
        console.warn(response);
        if (response?.SessionObject) {
            if (this.sessionManager.isSessionStart) {
                let messageInfo = DialogHelper.getMessage(this.translateService.instant("LBL_MSGEXTERNALINCOMINGSESSIONCONFIRMATION"), this.translateService.instant("LBL_APPOINTMENT"), true, null, null, null, null, this.translateService);
                DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), messageInfo).afterClosed().subscribe(result => {
                    if (result)
                        this.openSaveSessionDialog();
                });
                this.sessionManager.loadSession(response.SessionObject, this, this.viewContainerRef, true);
            }
            else {
                if (response.SessionObject?.Link)
                    window.open(response.SessionObject.Link, "_blank");
                else
                    this.sessionManager.loadSession(response.SessionObject, this, this.viewContainerRef, true);
            }
        }
    }
    openUISession(item, viewContainerRef) {
        let sessionData = JSON.parse(item.SessionObject.SessionData);
        if (sessionData != null && sessionData.UIObject != null) {
            switch (sessionData.UIObject.UIState) {
                case UIState.CallbackNote:
                    this.openSessionDialog("ADD_CALLBACKNOTE", sessionData.UIObject.UIObject, viewContainerRef);
                    break;
                case UIState.Appointment:
                    this.openSessionDialog("ADD_APPOINTMENT", sessionData.UIObject.UIObject, viewContainerRef);
                    break;
                case UIState.Ticket:
                    this.openSessionDialog("ADD_TICKET", sessionData.UIObject.UIObject, viewContainerRef);
                    break;
                case UIState.InformationRequestion:
                    this.openSessionDialog("ADD_INFORMATIONREQUEST", sessionData.UIObject.UIObject, viewContainerRef);
                    break;
                case UIState.Assignment:
                    this.openSessionDialog("ADD_ASSIGNMENT", sessionData.UIObject.UIObject, viewContainerRef);
                    break;
                case UIState.SendEmail:
                    this.openEmailBasket(viewContainerRef, sessionData.UIObject.UIObject, EmailType.Send);
                    break;
                case UIState.Note:
                    this.openSessionDialog("ADD_NOTE", sessionData.UIObject.UIObject, viewContainerRef);
                    break;
                case UIState.ReportImprovement:
                    this.openSessionDialog("ADD_REPORTIMPROVEMENT", sessionData.UIObject.UIObject, viewContainerRef);
                    break;
                case UIState.Theme:
                    this.openSessionDialog("ADD_THEME", sessionData.UIObject.UIObject, viewContainerRef);
                    break;
                case UIState.File:
                    this.openSessionDialog("ADD_FILE", sessionData.UIObject.UIObject, viewContainerRef);
                    break;
                case UIState.Organization:
                    this.openSessionDialog("ADD_ORGANIZATION", sessionData.UIObject.UIObject, viewContainerRef);
                    break;
                case UIState.Person:
                    this.openSessionDialog("ADD_PERSON", sessionData.UIObject.UIObject, viewContainerRef);
            }
        }
    }
    openSessionDialog(dialogName, uiObject, viewContainerRef) {
        switch (dialogName.toUpperCase()) {
            case "ADD_CALLBACKNOTE":
                {
                    if (GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) || !this.sessionManager.jkcParentPanel.parameters.IsUsed) {
                        this.sessionManager.jkcParentPanel = new JkcPanel(this.sessionManager.contactSessionNotesState, uiObject, false, 'callbacknote', null, null, 'addTaskHeader', 'addTaskFooter', '10px', '1.2%', '15%', '70%', null, '70%');
                        this.openJkcParentPanelDialogue(CallbackNoteAddEditComponent, 'addTaskContainer', viewContainerRef);
                    }
                    else
                        this.popupIsAlreadyOpenMessage();
                    break;
                }
            case "ADD_APPOINTMENT":
                {
                    if (GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) || !this.sessionManager.jkcParentPanel.parameters.IsUsed) {
                        this.sessionManager.jkcParentPanel = new JkcPanel(this.sessionManager.contactSessionNotesState, uiObject, false, 'appointment', null, null, 'addTaskHeader', 'addTaskFooter', '-42px', '1.2%', '15%', '70%', null, '70%');
                        this.openJkcParentPanelDialogue(AppointmentAddEditNativeComponent, 'addTaskContainer', viewContainerRef);
                    }
                    else
                        this.popupIsAlreadyOpenMessage();
                    break;
                }
            case "ADD_TICKET":
                {
                    let ticketConfiguration;
                    ticketConfiguration = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Tickets_Entities_Ticket, "TICKETSCONFIGURATION");
                    let ticketType = jlinq.from(ticketConfiguration.TicketTypes).equals("Title", uiObject.title).first();
                    if (GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) || !this.sessionManager.jkcParentPanel.parameters.IsUsed) {
                        this.sessionManager.jkcParentPanel = new JkcPanel(this.sessionManager.contactSessionNotesState, uiObject, false, ticketType, new TicketDto(), null, 'addTicketHeader', 'addTicketFooter', '-42px', '1.2%', '15%', '70%', null, '70%');
                        this.openJkcParentPanelDialogue(TicketAddEditComponent, 'addTicketContainer', viewContainerRef);
                    }
                    else
                        this.popupIsAlreadyOpenMessage();
                    break;
                }
            case "ADD_INFORMATIONREQUEST":
                {
                    if (GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) || !this.sessionManager.jkcParentPanel.parameters.IsUsed) {
                        this.sessionManager.jkcParentPanel = new JkcPanel(this.sessionManager.contactSessionNotesState, uiObject, false, null, null, null, 'addInformationRequestHeader', 'addInformationRequestFooter', '-42px', '1.2%', '15%', '70%', null, '70%');
                        this.openJkcParentPanelDialogue(InformationRequestAddEditComponent, 'addInformationRequestContainer', viewContainerRef);
                    }
                    else
                        this.popupIsAlreadyOpenMessage();
                    break;
                }
            case "ADD_NOTE":
                {
                    if (GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) || !this.sessionManager.jkcParentPanel.parameters.IsUsed) {
                        this.sessionManager.jkcParentPanel = new JkcPanel(this.sessionManager.contactSessionNotesState, uiObject, false, null, null, null, 'createNoteHeader', 'createNoteFooter', '-42px', '1.2%', '15%', '70%', null, '70%');
                        this.openJkcParentPanelDialogue(NoteAddEditComponent, 'addNoteContainer', viewContainerRef);
                    }
                    else
                        this.popupIsAlreadyOpenMessage();
                    break;
                }
            case "ADD_REPORTIMPROVEMENT":
                {
                    DialogHelper.openDialog(this.dialog, ReportImprovementAddEditComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { selectedEntity: this.sessionManager.selectedEntity, editMode: false, improvementSessionData: uiObject });
                    break;
                }
            case "ADD_THEME":
                {
                    if (GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) || !this.sessionManager.jkcParentPanel.parameters.IsUsed) {
                        this.sessionManager.jkcParentPanel = new JkcPanel(this.sessionManager.contactSessionNotesState, uiObject, false, null, null, null, 'createThemeHeader', 'createThemeFooter', '-42px', '1.2%', '15%', '70%', null, '70%');
                        this.openJkcParentPanelDialogue(ThemeAddEditComponent, 'themeContainer', viewContainerRef);
                    }
                    else
                        this.popupIsAlreadyOpenMessage();
                    break;
                }
            case "ADD_FILE":
                {
                    if (GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) || !this.sessionManager.jkcParentPanel.parameters.IsUsed) {
                        this.sessionManager.jkcParentPanel = new JkcPanel(this.sessionManager.contactSessionNotesState, uiObject, false, null, null, null, 'addFileHeader', 'addFileFooter', '-42px', '20.2%', '25%', '40%', '60%', '40%');
                        this.openJkcParentPanelDialogue(FileAddEditComponent, 'addFileContainer', viewContainerRef);
                    }
                    else
                        this.popupIsAlreadyOpenMessage();
                    break;
                }
            case "ADD_ORGANIZATION":
                {
                    if (GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) || !this.sessionManager.jkcParentPanel.parameters.IsUsed) {
                        this.sessionManager.jkcParentPanel = new JkcPanel(this.sessionManager.contactSessionNotesState, uiObject, false, null, null, null, 'addOrganizationHeader', 'addOrganizationFooter', '-42px', '11.2%', '25%', '50%', null, '50%');
                        this.openJkcParentPanelDialogue(OrganizationAddEditComponent, 'addOrganizationContainer', viewContainerRef);
                    }
                    else
                        this.popupIsAlreadyOpenMessage();
                    break;
                }
            case "ADD_PERSON":
                {
                    if (GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) || !this.sessionManager.jkcParentPanel.parameters.IsUsed) {
                        this.sessionManager.jkcParentPanel = new JkcPanel(this.sessionManager.contactSessionNotesState, uiObject, false, null, null, null, 'addPersonHeader', 'addPersonFooter', '-42px', '11.2%', '25%', '50%', null, '50%');
                        this.openJkcParentPanelDialogue(PersonAddEditComponent, 'addPersonContainer', viewContainerRef);
                    }
                    else
                        this.popupIsAlreadyOpenMessage();
                    break;
                }
            case "ADD_ASSIGNMENT":
                {
                    if (GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) || !this.sessionManager.jkcParentPanel.parameters.IsUsed) {
                        this.sessionManager.jkcParentPanel = new JkcPanel(this.sessionManager.contactSessionNotesState, uiObject, false, null, null, null, 'addAssignmentHeader', 'addAssignmentFooter', '-42px', '1.2%', '15%', '70%', null, '70%');
                        this.openJkcParentPanelDialogue(AssignmentAddEditComponent, 'addAssignmentContainer', viewContainerRef);
                    }
                    else
                        this.popupIsAlreadyOpenMessage();
                    break;
                }
            case "ADD_DOMAIN":
                {
                    let domains = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Domains_Entities_Domain, "DOMAINCONFIGURATION");
                    let ticketType = jlinq.from(domains).equals("Name", uiObject.title).first();
                    if (GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) || !this.sessionManager.jkcParentPanel.parameters.IsUsed) {
                        this.sessionManager.jkcParentPanel = new JkcPanel(this.sessionManager.contactSessionNotesState, uiObject, false, ticketType, new TicketDto(), null, 'addTicketHeader', 'addTicketFooter', '-42px', '1.2%', '15%', '70%', null, '70%');
                        this.openJkcParentPanelDialogue(DomainAddEditComponent, 'addTicketContainer', viewContainerRef);
                    }
                    else
                        this.popupIsAlreadyOpenMessage();
                    break;
                }
        }
    }
    openEmailBasket(viewContainerRef, emailObjectVal = null, emailTypeVal = null, outlookItemsVal = null, emailTemplate = null) {
        let outlookItems = outlookItemsVal == null || outlookItemsVal.length == 0 ? this.sessionManager.getMarkedItems(this.sessionManager.getBasketItems()) : outlookItemsVal;
        if (GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) || !this.sessionManager.jkcParentPanel.parameters.IsUsed) {
            this.sessionManager.jkcParentPanel = new JkcPanel(this.sessionManager.contactSessionNotesState, emailObjectVal, false, emailTypeVal, outlookItems, null, 'emailBasketHeader', 'emailBasketFooter', '-42px', '1.2%', '15%', '70%', null, '70%');
            this.sessionManager.jkcParentPanel.parameters.EntityParameter = emailTemplate;
            this.openJkcParentPanelDialogue(EmailBasketComponent, 'emailBasketContainer', viewContainerRef);
        }
        else
            this.popupIsAlreadyOpenMessage();
    }
    openAddCbnPanelWithSelectedTemplate(selectedTemplateData, viewContainerRef) {
        if (GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) || !this.sessionManager.jkcParentPanel.parameters.IsUsed) {
            this.sessionManager.jkcParentPanel = new JkcPanel(this.sessionManager.contactSessionNotesState, null, false, 'callbacknote', null, null, 'addTaskHeader', 'addTaskFooter', '-42px', '1.2%', '15%', '70%', null, '70%');
            this.sessionManager.jkcParentPanel.parameters.EntityParameter = selectedTemplateData;
            this.openJkcParentPanelDialogue(CallbackNoteAddEditComponent, 'addTaskContainer', viewContainerRef);
        }
        else
            this.popupIsAlreadyOpenMessage();
    }
    processOutBoxItems() {
        let outboxItems = this.sessionManager.getBasketItems();
        if (outboxItems != null && outboxItems.length > 0) {
            outboxItems.forEach(basketItem => {
                if (basketItem.Item != null && basketItem.Item != undefined) {
                    basketItem.Item.IsMarked = true;
                    if (basketItem.Item.Partial === true && !GlobalFunctions.isNumber(basketItem.Type) && !GlobalFunctions.isEmpty(basketItem.Type)) {
                        let type = GlobalFunctions.getObjectTypeName(basketItem.Type);
                        if (type.toLowerCase() == 'employee')
                            basketItem.Item = this.cacheManager.getEmployeeById(basketItem.Item.Id);
                        else {
                            basketItem.Item.fetchDetailResponseReceived = (detailObj) => {
                                if (type.toLowerCase() == 'person')
                                    this.sessionManager.setBreadcrumbGrammer(detailObj);
                                if (basketItem.Item.Id == detailObj.Id)
                                    basketItem.Item = detailObj;
                            };
                            let entityName = "";
                            entityName = this.serviceManager.getInstance(type.toLowerCase());
                            entityName.setMultipleFetchDetailResponseCallback(basketItem.Item.fetchDetailResponseReceived);
                            entityName.fetchDetail(basketItem.Item);
                        }
                    }
                }
            });
        }
        return outboxItems;
    }
    openJkcViewerPanelDialogue(viewEntity, viewContainerRef) {
        $("#jkcViewerPanelContainer").empty();
        this.sessionManager.jkcViewerPanel = new JkcPanel(this.sessionManager.contactSessionNotesState, viewEntity, false, null, null, null, 'viewerHeader', null, '-42px', '1.2%', '35%', '30%', null, '50%');
        const componentRef = viewContainerRef.createComponent(ViewerComponent);
        const element = componentRef.location.nativeElement;
        this.sessionManager.viewerPanel = JsPanel.create({
            borderRadius: '5px 5px 0px 0px',
            id: "jkcViewerPanel",
            header: false,
            content: element,
            container: '#jkcViewerPanelContainer',
            contentOverflow: 'hidden',
            dragit: {
                opacity: 0.6,
                containment: [-47, 0, 0, 0],
                handles: '.jspanel-header',
            },
            resizeit: {
                containment: [-47, 0, 0, 0],
                minWidth: 500,
                minHeight: 500,
                handles: 'w, sw, s, se, e'
            }
        });
        if ($("#jkcViewerPanel") != null)
            this.sessionManager.jkcViewerPanel.setInitialJsPanelStyle('#jkcViewerPanel');
    }
    linkUnlink(linkUnlinkActionType, linkedEntityList = null) {
        DialogHelper.openDialog(this.dialog, LinkUnlinkEntityComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { selectedEntity: this.sessionManager.selectedEntity, linkUnlinkActionType: linkUnlinkActionType, linkedEntityList: linkedEntityList });
    }
    loadSendEmailDialog(emailId) {
        if (GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) || !this.sessionManager.jkcParentPanel.parameters.IsUsed) {
            this.sessionManager.jkcParentPanel = new JkcPanel(this.sessionManager.contactSessionNotesState, null, false, EmailType.Send, emailId, null, 'emailBasketHeader', 'emailBasketFooter', '-42px', '1.2%', '15%', '70%', null, '70%');
            this.openJkcParentPanelDialogue(EmailBasketComponent, 'emailBasketContainer', this.sessionManager.headerViewContainerRef);
        }
        else
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_APPLICATION_TITLE'), textMsg: this.translateService.instant('LBL_RESTRICT_MULTIPLE_WINDOW_MESSAGE') });
    }
    openEmployeeDetailPopUp(employeeId) {
        if (employeeId) {
            const employee = this.cacheManager.getEmployeeById(employeeId);
            DialogHelper.openDialog(this.dialog, EmployeePopupComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), employee).afterClosed().subscribe(result => {
                if (result?.emailId != undefined && result?.targetButton == "SEND_EMAIL" && GlobalFunctions.checkRights('Email'))
                    this.loadSendEmailDialog(result.emailId);
                else if (result?.targetButton != undefined)
                    this.openJsPanelOrDialog(result.targetButton);
            });
        }
    }
    updateContactDetail(phoneNumber, emailAddress) {
        return DialogHelper.openDialog(this.dialog, UpdateContactInfoComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { phoneNumber, emailAddress });
    }
    ;
    openLinkContactInfo(contactType, clickedFrom = '') {
        DialogHelper.openDialog(this.dialog, LinkContactInfoComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { contactType, clickedFrom });
    }
    manageBlockWiseLocalGroupPrivilege(localUserGroups, manageLocalGroupPrivilege, editorContent) {
        return DialogHelper.openDialog(this.dialog, ManageBlockWiseLocalGroupPrivilegeComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { localUserGroups, manageLocalGroupPrivilege, editorContent });
    }
    manageLocalGroupPrivilege(localUserGroups, privilegedGroupIds) {
        DialogHelper.openDialog(this.dialog, ManageLocalGroupPrivilegeComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { localUserGroups: localUserGroups, privilegedGroupIds: privilegedGroupIds });
    }
    HandlerIsAlreadyAssignedMessage() {
        let messageInfo = DialogHelper.getMessage(this.translateService.instant("LBL_APPLICATION_TITLE"), this.translateService.instant("LBL_RESTRICT_ADD_ASSIGNMENT"), false, null, null, null, null, this.translateService);
        DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), messageInfo);
    }
    popupIsAlreadyOpenMessage() {
        let messageInfo = DialogHelper.getMessage(this.translateService.instant("LBL_APPLICATION_TITLE"), this.translateService.instant("LBL_RESTRICT_MULTIPLE_WINDOW_MESSAGE"), false, false, null, null, null, this.translateService);
        DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), messageInfo);
    }
    addRepresentative(organizationId) {
        DialogHelper.openDialog(this.dialog, RepresentativeAddComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { organizationId, editMode: false });
    }
    ;
    bulkDeleteContactHistory(resultList) {
        DialogHelper.openDialog(this.dialog, ContactHistoryBulkDeleteComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { resultList });
    }
    editEmployeeFromContextMenu(component, viewContainerRef) {
        if (GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) || !this.sessionManager.jkcParentPanel.parameters.IsUsed) {
            this.sessionManager.jkcParentPanel = new JkcPanel(this.sessionManager.contactSessionNotesState, null, false, null, null, null, 'createEmployeeHeader', 'createEmployeeFooter', '-42px', '6.2%', '15%', '60%', '70%', '60%');
            this.openJkcParentPanelDialogue(component, 'updateEmployeeContainer', viewContainerRef);
        }
        else
            this.popupIsAlreadyOpenMessage();
    }
    addImprovement(editMode) {
        DialogHelper.openDialog(this.dialog, ReportImprovementAddEditComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { editMode, selectedEntity: this.sessionManager.selectedEntity, improvementSessionData: null });
    }
    ;
    handleTask(contentType, viewContainerRef) {
        if (GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) || !this.sessionManager.jkcParentPanel.parameters.IsUsed) {
            if (contentType == "APPOINTMENT") {
                this.sessionManager.jkcParentPanel = new JkcPanel(this.sessionManager.contactSessionNotesState, null, false, 'handleAppointment', null, null, 'handleAppointmentHeader', 'handleAppointmentFooter', '-42px', '1.2%', '15%', '70%', null, '70%');
                this.openJkcParentPanelDialogue(AppointmentHandleComponent, 'handleAppointmentContainer', viewContainerRef);
            }
            else if (contentType == "ASSIGNMENT") {
                this.sessionManager.jkcParentPanel = new JkcPanel(this.sessionManager.contactSessionNotesState, null, false, 'handleAssignment', null, null, 'handleAssignmentHeader', 'handleAssignmentFooter', '-42px', '1.2%', '15%', '70%', null, '70%');
                this.openJkcParentPanelDialogue(AssignmentHandleComponent, 'handleAssignmentContainer', viewContainerRef);
            }
            else if (contentType == "CALLBACKNOTE") {
                this.sessionManager.jkcParentPanel = new JkcPanel(this.sessionManager.contactSessionNotesState, null, false, 'handleCallbackNote', null, null, 'handleCallbackNoteHeader', 'handleCallbackNoteFooter', '-42px', '1.2%', '15%', '70%', null, '70%');
                this.openJkcParentPanelDialogue(CallbackNoteHandleComponent, 'handleCallbackNoteContainer', viewContainerRef);
            }
            else if (contentType == "INFORMATIONREQUEST") {
                this.sessionManager.jkcParentPanel = new JkcPanel(this.sessionManager.contactSessionNotesState, null, false, 'handleInformationRequest', null, null, 'handleInformationRequestHeader', 'handleInformationRequestFooter', '-42px', '1.2%', '15%', '70%', null, '70%');
                this.openJkcParentPanelDialogue(InformationRequestHandleComponent, 'handleInformationRequestContainer', viewContainerRef);
            }
            else if (contentType == "REPORTIMPROVEMENT") {
                this.sessionManager.jkcParentPanel = new JkcPanel(this.sessionManager.contactSessionNotesState, null, false, 'handleReportImprovement', null, null, 'handleReportImprovementHeader', 'handleReportImprovementFooter', '-42px', '1.2%', '15%', '70%', null, '70%');
                this.openJkcParentPanelDialogue(ReportImprovementHandleComponent, 'handleReportImprovementContainer', viewContainerRef);
            }
        }
        else
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_APPLICATION_TITLE'), textMsg: this.translateService.instant('LBL_RESTRICT_MULTIPLE_WINDOW_MESSAGE') });
    }
    ;
    openForwardTaskPopUp() {
        DialogHelper.openDialog(this.dialog, TaskForwardComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState));
    }
    ;
    openAssignEmailPopUp() {
        DialogHelper.openDialog(this.dialog, TaskForwardComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState));
    }
    ;
    addDocumentFromContextMenu(viewContainerRef) {
        if (GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) || !this.sessionManager.jkcParentPanel.parameters.IsUsed) {
            this.sessionManager.jkcParentPanel = new JkcPanel(this.sessionManager.contactSessionNotesState, null, false, null, null, null, 'addDocumentHeader', 'addDocumentFooter', '-42px', '1.2%', '15%', '70%', null, '70%');
            this.openJkcParentPanelDialogue(DocumentAddComponent, 'addDocumentContainer', viewContainerRef);
        }
        else
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_APPLICATION_TITLE'), textMsg: this.translateService.instant('LBL_RESTRICT_MULTIPLE_WINDOW_MESSAGE') });
    }
    ;
    bulkHandle(resultList) {
        DialogHelper.openDialog(this.dialog, TaskBulkHandleComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { resultList });
    }
    ;
    bulkReplyMessage(selectedSocialEntities) {
        DialogHelper.openDialog(this.dialog, BulkReplyComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { selectedSocialEntities });
    }
    editContactHistoryFromContextMenu(viewContainerRef) {
        if (GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) || !this.sessionManager.jkcParentPanel.parameters.IsUsed) {
            this.sessionManager.jkcParentPanel = new JkcPanel(this.sessionManager.contactSessionNotesState, null, false, null, null, null, 'editContactHistoryHeader', 'editContactHistoryFooter', '-42px', '1.2%', '15%', '70%', null, '70%');
            this.openJkcParentPanelDialogue(ContactHistoryEditComponent, 'editContactHistoryContainer', viewContainerRef);
        }
        else
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_APPLICATION_TITLE'), textMsg: this.translateService.instant('LBL_RESTRICT_MULTIPLE_WINDOW_MESSAGE') });
    }
    ;
    openAddTicket(ticketType, viewContainerRef) {
        if (GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) || !this.sessionManager.jkcParentPanel.parameters.IsUsed) {
            this.sessionManager.jkcParentPanel = new JkcPanel(this.sessionManager.contactSessionNotesState, null, false, ticketType, new TicketDto(), null, 'addTicketHeader', 'addTicketFooter', '-42px', '1.2%', '15%', '70%', null, '70%');
            this.openJkcParentPanelDialogue(TicketAddEditComponent, 'addTicketContainer', viewContainerRef);
        }
        else
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_APPLICATION_TITLE'), textMsg: this.translateService.instant('LBL_RESTRICT_MULTIPLE_WINDOW_MESSAGE') });
    }
    openLinkTicketPopUp(isFrom) {
        DialogHelper.openDialog(this.dialog, TicketLinkEntityComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { isOpenedFrom: isFrom });
    }
    openLinkEmailPopUp() {
        DialogHelper.openDialog(this.dialog, LinkEmailToCaseComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState));
    }
    addEmailAsCase(viewContainerRef) {
        if (GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) || !this.sessionManager.jkcParentPanel.parameters.IsUsed) {
            this.sessionManager.jkcParentPanel = new JkcPanel(this.sessionManager.contactSessionNotesState, null, false, null, null, null, 'addCaseHeader', 'addCaseFooter', '-42px', '1.2%', '15%', '70%', null, '70%');
            this.openJkcParentPanelDialogue(CaseAddEditComponent, 'addCaseContainer', viewContainerRef);
        }
        else
            this.popupIsAlreadyOpenMessage();
    }
    ;
    openReassignMessage() {
        DialogHelper.openDialog(this.dialog, ReassignMessageComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState));
    }
    ;
    handleTicket(viewContainerRef) {
        if (GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) || !this.sessionManager.jkcParentPanel.parameters.IsUsed) {
            this.sessionManager.jkcParentPanel = new JkcPanel(this.sessionManager.contactSessionNotesState, null, false, 'handleTicket', null, null, 'handleTicketHeader', 'handleTicketFooter', '-42px', '1.2%', '15%', '70%', null, '70%');
            this.openJkcParentPanelDialogue(TicketHandleComponent, 'handleTicketContainer', viewContainerRef);
        }
        else
            this.popupIsAlreadyOpenMessage();
    }
    ;
    openMergeData(mergeType) {
        DialogHelper.openDialog(this.dialog, MergeDataComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { mergeType }).afterClosed().subscribe(result => {
            if (result) {
                this.sessionManager.selectedEntity.Partial = true;
                this.eventProvider.BroadcastEvent(BroadCastEventKeys.RELOAD_ENTITY_DETAIL);
            }
        });
    }
    ;
    openPhoneHoldWarningMessage() {
        DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant("LBL_PHONE"), textMsg: this.translateService.instant("LBL_PHONE_HANGUP_WARNING") });
    }
    ;
};
DialogManager = __decorate([
    Injectable({
        providedIn: 'root'
    })
], DialogManager);
export { DialogManager };
//# sourceMappingURL=dialog-manager.js.map