var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Injectable } from "@angular/core";
import { ChatIncomingComponent } from "../../components/domain/chat/incoming/chat-incoming.component";
import { ChatMessengerComponent } from "../../components/domain/chat/messenger/chat-messenger.component";
const JsPanel = require('../../../../node_modules/jspanel4/dist/jspanel.min.js');
let ChatManager = class ChatManager {
    constructor() {
        this.closeChat = () => {
            $("#chatContainer").empty();
        };
    }
    initJSPanel(viewContainerRef) {
        this.viewContainerRef = viewContainerRef;
    }
    showIncomingChat() {
        try {
            $("#chatContainer").empty();
            const componentRef = this.viewContainerRef.createComponent(ChatIncomingComponent);
            const element = componentRef.location.nativeElement;
            JsPanel.create({
                borderRadius: '5px 5px 0px 0px',
                id: "incomingChatPanel",
                size: { width: 'auto', height: 'auto' },
                header: false,
                contentOverflow: 'hidden',
                dragit: { containment: '#applicationBody', handles: '.jspanel-header', stack: '.jsPanel', opacity: 0.6 },
                container: '#chatContainer',
                controls: { buttons: 'closeonly' },
                title: '',
                content: element
            });
            setTimeout(() => {
                if ($("#incomingChatPanel") != null)
                    $("#incomingChatPanel").css({ top: ($(window).outerHeight() - 300) / 2, left: ($(window).outerWidth() - 220) / 2, 'background-color': 'transparent', width: 260, height: 286 });
            }, 1);
        }
        catch (e) {
            console.error(e);
        }
    }
    ;
    showChat() {
        try {
            $("#chatContainer").empty();
            const componentRef = this.viewContainerRef.createComponent(ChatMessengerComponent);
            const element = componentRef.location.nativeElement;
            JsPanel.create({
                borderRadius: '5px 5px 0px 0px',
                id: "chatPanel",
                size: { width: 'auto', height: 'auto' },
                header: false,
                contentOverflow: 'inherit',
                resizeit: {
                    disable: true
                },
                dragit: { containment: [0, 0, -87], handles: '.jspanel-header', stack: '.jsPanel', opacity: 0.6 },
                container: '#chatContainer',
                controls: { buttons: 'closeonly' },
                title: '',
                content: element
            });
            setTimeout(() => {
                let chatPanelElement = $('#chatPanel');
                if (chatPanelElement != null) {
                    let topPosition = $(window).height() - $("#chatForm").height() - $("#chatHeader").height() - 3;
                    $("#chatPanel").css({ 'background-color': 'transparent', 'width': '22%', 'top': topPosition + 'px', 'left': '0' });
                }
            }, 1);
        }
        catch (e) {
            console.error(e);
        }
    }
    ;
    resizeChatContent() {
        let newHeight = $("#chatPanel").height() - $("#chatHeader").height() - $("#chatFooter").height();
        if ($("#chatLiveState") != null)
            newHeight = newHeight - $("#chatLiveState").height();
        $("#chatBody").height(newHeight + "px");
    }
    ;
    closeIncomingChat() {
        $("#chatContainer").empty();
    }
    ;
};
ChatManager = __decorate([
    Injectable({
        providedIn: 'root'
    })
], ChatManager);
export { ChatManager };
//# sourceMappingURL=chat-manager.js.map