var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Injectable } from '@angular/core';
import { environment } from '../../../environments/environment';
import { GlobalFunctions } from '../../shared/global-functions';
import { OperationType } from '../enums/common-enums';
import { ContentType } from '../models/jkc-object/jkc-object';
let X2JS = require('x2js');
let CacheManager = class CacheManager {
    constructor(employeeService, applicationSettingManager) {
        this.employeeService = employeeService;
        this.applicationSettingManager = applicationSettingManager;
        this.relatedResultList = [];
        this.employeeList = [];
        this.departmentList = [];
        this.popularEmployeeList = null;
        this.managerList = [];
        this.taskMailboxList = [];
        this.roleList = [];
        this.geoVendors = [];
        this.alphabets = ['a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm'];
        this.alphabetCounter = 0;
        this.dashboardCachedItemList = [];
        this.kcsUrl = window.location.protocol + '//' + window.location.host;
        this.layerStyles = {
            "a": { color: "Red (rood)", externalGraphic: this.kcsUrl + 'assets/map/pdok/bag/sq8a.png', fillColor: "#ff0e13", strokeColor: "#990003" },
            "b": { color: "Lavender (lavendel)", externalGraphic: this.kcsUrl + 'assets/map/pdok/bag/sq8b.png', fillColor: "#a69dff", strokeColor: "#544c99" },
            "c": { color: "Yellow (geel)", externalGraphic: this.kcsUrl + 'assets/map/pdok/bag/sq8c.png', fillColor: "#fff30a", strokeColor: "#b3aa00" },
            "d": { color: "Green (groen)", externalGraphic: this.kcsUrl + 'assets/map/pdok/bag/sq8d.png', fillColor: "#4fff03", strokeColor: "#2f9902" },
            "e": { color: "Pink (roze)", externalGraphic: this.kcsUrl + 'assets/map/pdok/bag/sq8e.png', fillColor: "#ffbfbf", strokeColor: "#bf7373" },
            "f": { color: "Sky blue (hemelsblauw)", externalGraphic: this.kcsUrl + 'assets/map/pdok/bag/sq8f.png', fillColor: "#4de3ff", strokeColor: "#0098b3" },
            "g": { color: "Orange (oranje)", externalGraphic: this.kcsUrl + 'assets/map/pdok/bag/sq8g.png', fillColor: "#ff7f16", strokeColor: "#bf5600" },
            "h": { color: "Blue (blauw)", externalGraphic: this.kcsUrl + 'assets/map/pdok/bag/sq8h.png', fillColor: "#0036dd", strokeColor: "#002699" },
            "i": { color: "Light green (lichtgroen)", externalGraphic: this.kcsUrl + 'assets/map/pdok/bag/sq8i.png', fillColor: "#bbff9a", strokeColor: "#88cc66" },
            "j": { color: "Magenta (magenta)", externalGraphic: this.kcsUrl + 'assets/map/pdok/bag/sq8j.png', fillColor: "#ff0dc0", strokeColor: "#b30083" },
            "k": { color: "Azure (lichtblauw)", externalGraphic: this.kcsUrl + 'assets/map/pdok/bag/sq8k.png', fillColor: "#c7f5ff", strokeColor: "#3db2cc" },
            "l": { color: "Light yellow (lichtgeel)", externalGraphic: this.kcsUrl + 'assets/map/pdok/bag/sq8l.png', fillColor: "#FAFF60", strokeColor: "#ccc57a" },
            "m": { color: "Gray (grijs)", externalGraphic: this.kcsUrl + 'assets/map/pdok/bag/sq8m.png', fillColor: "#878787", strokeColor: "#bfbfbf" }
        };
        this.configuredLayers = {
            //Bag WFS
            "ligplaats": {
                fillOpacity: 0.3, objectLayer: false
            },
            "pand": {
                fillOpacity: 0.3, objectLayer: false
            },
            "standplaats": {
                fillOpacity: 0.3, objectLayer: false
            },
            "woonplaats": {
                fillOpacity: 0.01, objectLayer: false, minZoom: 6
            },
            //Bestuurlijkegrenzen WFS
            "provincies": {
                fillOpacity: 0.01, objectLayer: false, minZoom: 6
            },
            "landsgrens": {
                fillOpacity: 0.01, objectLayer: false, minZoom: 6
            },
            "gemeenten": {
                fillOpacity: 0.01, objectLayer: false, minZoom: 6
            },
            //Haarlem WFS
            "bag_pand": {
                fillOpacity: 0.3, objectLayer: false
            },
            "bevolkingsopbouw": {
                fillOpacity: 0.01, objectLayer: false, minZoom: 6
            },
            "huishoudens": {
                fillOpacity: 0.01, objectLayer: false, minZoom: 6
            },
            "parkeerzones": {
                fillOpacity: 0.01, objectLayer: false, minZoom: 6
            },
            "postcode4": {
                fillOpacity: 0.01, objectLayer: false, minZoom: 6
            },
            "postcode6": {
                fillOpacity: 0.01, objectLayer: false, minZoom: 6
            },
            //Amstelveen WFS 
            "amstelveen_wijken": {
                fillOpacity: 0.01, objectLayer: false, minZoom: 6
            },
            "bag_panden": {
                fillOpacity: 0.3, objectLayer: false
            },
            "bag_ligplaatsen": {
                fillOpacity: 0.3, objectLayer: false
            },
            "bag_standplaatsen": {
                fillOpacity: 0.3, objectLayer: false
            },
            "cbs_wijken": {
                fillOpacity: 0.01, objectLayer: false, minZoom: 6
            },
            "dgdialog_wegvakonderdelen": {
                fillOpacity: 0.3, objectLayer: false
            },
            "gbka_bag_v": {
                fillOpacity: 0.3, objectLayer: false
            },
            //hardenberg WFS
            "archeolog_waarden": {
                fillOpacity: 0.01, objectLayer: false, minZoom: 6
            },
            "archeologie_beleid_hdb": {
                fillOpacity: 0.01, objectLayer: false, minZoom: 6
            },
            "archeologische_monumenten": {
                fillOpacity: 0.01, objectLayer: false, minZoom: 6
            },
            "bis_loc_gegevens": {
                fillOpacity: 0.3, objectLayer: false
            },
            "bis_rap_gegevens": {
                fillOpacity: 0.3, objectLayer: false
            },
            "gbkoh_v": {
                fillOpacity: 0.3, objectLayer: false
            },
            "hoofdgroenstr_2013_v": {
                fillOpacity: 0.3, objectLayer: false
            },
            "hoofdgroenstr_v": {
                fillOpacity: 0.3, objectLayer: false
            },
            "kadastrale_kaart": {
                fillOpacity: 0.01, objectLayer: false, minZoom: 6
            },
            "projecten_extern": {
                fillOpacity: 0.01, objectLayer: false, minZoom: 6
            }
        };
        this.completedManagersFetch = this.completedManagersFetch.bind(this);
        this.completedEmployeesFetch = this.completedEmployeesFetch.bind(this);
        this.completedDepartmentsFetch = this.completedDepartmentsFetch.bind(this);
        this.completedTaskMailboxesFetch = this.completedTaskMailboxesFetch.bind(this);
    }
    fillPopularEmployeeList() {
        let empList = [];
        let popularNumberList = [];
        let empData = this.applicationSettingManager.getApplicationSettingValueByKey("POPULARNUMBER");
        if (!GlobalFunctions.isEmpty(empData)) {
            let x2js = new X2JS();
            let popularData = x2js.xml2js(empData);
            if (!GlobalFunctions.isEmpty(popularData.PopularNumbers.Number)) {
                if (!Array.isArray(popularData.PopularNumbers.Number) && (typeof (popularData.PopularNumbers.Number === 'object'))) {
                    popularNumberList.push(popularData.PopularNumbers.Number);
                    popularData.PopularNumbers.Number = popularNumberList;
                }
                popularData.PopularNumbers.Number.forEach(emp => {
                    let popularEmployee = {};
                    popularEmployee.Id = emp._Id;
                    popularEmployee.StringRepresentation = emp._Name;
                    popularEmployee.Surname = emp._Name;
                    popularEmployee.FunctionWithDepartment = emp._Department;
                    popularEmployee.PhoneNumber = emp._Work;
                    popularEmployee.ExtensionNumber = emp._Extension;
                    popularEmployee.EmailAddress = emp._EmailAddress;
                    popularEmployee.Note = emp._Notes;
                    popularEmployee.WorkingHours = emp._WorkingTime;
                    popularEmployee.MobileNumber = emp._MobileNumber;
                    popularEmployee.PictureData = 'assets/images/popularAvatar.png';
                    popularEmployee.IsPopular = true;
                    popularEmployee.Order = emp._Order;
                    empList.push(popularEmployee);
                });
                empList = empList.sort((x, y) => { return (x.Order - y.Order); });
            }
        }
        return empList;
    }
    ;
    completedEmployeesFetch() {
        let privateFields = GlobalFunctions.getAllowedDataRights(ContentType.Employee, OperationType.PrivateField);
        let settingValue = this.applicationSettingManager.getObjectGrammerSetting("EmployeeDto_Popup");
        if (!GlobalFunctions.isEmpty(privateFields)) {
            if (privateFields.indexOf("|FIRSTNAME|") !== -1)
                settingValue = settingValue.replace('{FirstName}', '');
            if (privateFields.indexOf("|SURNAME|") !== -1)
                settingValue = settingValue.replace('{Surname}', '');
            if (privateFields.indexOf("|PREFIX|") !== -1)
                settingValue = settingValue.replace('{Prefix}', '');
        }
        if (settingValue.indexOf(',') == 0 || settingValue.indexOf(',') == settingValue.length - 1)
            settingValue = settingValue.replace(',', '');
        this.employeeList = this.employeeService.getEmployeeList();
        if (this.employeeList != null && this.employeeList.length > 0) {
            this.employeeList.forEach(employeeSelected => {
                let value = GlobalFunctions.setGrammarForBaseDto(employeeSelected, settingValue);
                GlobalFunctions.setValueByPropertyName("StringRepresentation", employeeSelected, value);
                employeeSelected.text = value;
                employeeSelected.PrivateFields = privateFields;
            });
            this.employeeList = jlinq.from(this.employeeList).sort("StringRepresentation").select();
        }
    }
    completedDepartmentsFetch() {
        this.departmentList = this.employeeService.getDepartmentList();
        if (this.departmentList != null && this.departmentList.length > 0) {
            this.departmentList.forEach(departmentSelected => {
                let value = GlobalFunctions.setGrammarForBaseDto(departmentSelected, "{Name}");
                GlobalFunctions.setValueByPropertyName("StringRepresentation", departmentSelected, value);
                departmentSelected.text = value;
            });
            this.departmentList = jlinq.from(this.departmentList).sort("Name").select();
        }
    }
    completedManagersFetch() {
        this.managerList = this.employeeService.getManagerList();
        if (this.managerList != null && this.managerList.length > 0) {
            this.managerList.forEach(function (managerSelected) {
                let value = GlobalFunctions.setGrammarForBaseDto(managerSelected, "{Name}");
                GlobalFunctions.setValueByPropertyName("StringRepresentation", managerSelected, value);
                managerSelected.text = value;
            });
        }
    }
    completedTaskMailboxesFetch() {
        this.taskMailboxList = this.employeeService.getTaskMailboxList();
        if (this.taskMailboxList != null && this.taskMailboxList.length > 0) {
            this.taskMailboxList.forEach(mailboxSelected => {
                let value = GlobalFunctions.setGrammarForBaseDto(mailboxSelected, "{Name}");
                GlobalFunctions.setValueByPropertyName("StringRepresentation", mailboxSelected, value);
                mailboxSelected.text = value;
            });
            this.taskMailboxList = jlinq.from(this.taskMailboxList).sort("Name").select();
        }
    }
    getEmployeeList(isActive) {
        let employeeList = this.employeeList;
        if (this.employeeList?.length === 0)
            this.employeeService.fetchEmployeesFromDatabase(this.completedEmployeesFetch);
        if (this.employeeList.length > 0 && !GlobalFunctions.isEmpty(isActive) && isActive == true)
            employeeList = jlinq.from(this.employeeList).contains("IsDeleted", "false").select();
        return employeeList;
    }
    ;
    getEmployeeDataList(completedEmployeesFetchedData) {
        if (this.employeeList == null || this.employeeList.length == 0) {
            this.employeeService.fetchEmployeesFromDatabase(this.completedEmployeesFetch).subscribe(() => {
                if (completedEmployeesFetchedData)
                    completedEmployeesFetchedData();
            });
        }
        else {
            if (completedEmployeesFetchedData)
                completedEmployeesFetchedData();
        }
    }
    ;
    getPopularEmployeeList() {
        if (this.popularEmployeeList == null)
            this.popularEmployeeList = this.fillPopularEmployeeList();
        return this.popularEmployeeList;
    }
    ;
    getPopularEmployeeById(employeeId) {
        let employee = null;
        let popularNumberList = this.getPopularEmployeeList();
        if (popularNumberList.length > 0) {
            for (let index = 0; index < popularNumberList.length; index++) {
                if (popularNumberList[index].Id == employeeId) {
                    employee = popularNumberList[index];
                    break;
                }
            }
            return employee;
        }
    }
    ;
    getDepartmentList() {
        return this.departmentList;
    }
    ;
    getManagerList() {
        return this.managerList;
    }
    ;
    getTaskMailboxList(onlyActive = true) {
        let filterTaskMailboxList = [];
        if (this.taskMailboxList.length > 0) {
            if (onlyActive)
                filterTaskMailboxList = jlinq.from(this.taskMailboxList).equals("IsActive", true).select();
            else
                filterTaskMailboxList = this.taskMailboxList;
        }
        return filterTaskMailboxList;
    }
    ;
    setEmployeeList(val) {
        this.employeeList = val;
    }
    ;
    getEmployeeById(employeeId) {
        let employee = null;
        if (this.employeeList != null && this.employeeList.length > 0) {
            for (let index = 0; index < this.employeeList.length; index++) {
                if (this.employeeList[index].Id == employeeId) {
                    employee = this.employeeList[index];
                    break;
                }
            }
        }
        return employee;
    }
    ;
    getEmployeeByEmailId(employeeEmailId) {
        let employee = null;
        if (this.employeeList != null && this.employeeList.length > 0)
            employee = jlinq.from(this.employeeList).starts("EmailAddress", employeeEmailId).first();
        return employee;
    }
    ;
    getEmployeeByContactNumber(contactNumber) {
        let employee = null;
        if (!GlobalFunctions.isEmpty(contactNumber) && this.employeeList != null && this.employeeList.length > 0) {
            contactNumber = GlobalFunctions.parseContactNumber(contactNumber);
            for (let index = 0; index < this.employeeList.length; index++) {
                if (!this.employeeList[index].IsDeleted && ((this.employeeList[index].ExtensionNumber == contactNumber) || (GlobalFunctions.parseContactNumber(this.employeeList[index].PhoneNumber) == contactNumber) || (GlobalFunctions.parseContactNumber(this.employeeList[index].MobileNumber) == contactNumber))) {
                    employee = this.employeeList[index];
                    break;
                }
            }
        }
        return employee;
    }
    ;
    getEmployeeByName(employeeName) {
        let employee = null;
        if (this.employeeList != null && this.employeeList.length > 0) {
            for (let index = 0; index < this.employeeList.length; index++) {
                //-- For employee name in format "Firstname Prefix Surname"
                if (this.employeeList[index].FirstName == employeeName.split(" ")[0] && this.employeeList[index].Surname == employeeName.split(" ")[2]) {
                    employee = this.employeeList[index];
                    break;
                }
                //-- For employee name in format "Surname, Firstname Prefix"
                else if (this.employeeList[index].Surname == employeeName.split(" ")[0].replace(/,\s*$/, "") && this.employeeList[index].FirstName == employeeName.split(" ")[1]) {
                    employee = this.employeeList[index];
                    break;
                }
            }
        }
        return employee;
    }
    ;
    getDepartmentById(departmentId) {
        let department = null;
        if (!GlobalFunctions.isEmpty(departmentId)) {
            if (this.departmentList != null && this.departmentList.length > 0) {
                for (let index = 0; index < this.departmentList.length; index++) {
                    if (this.departmentList[index].Id.toLowerCase() == departmentId.toLowerCase()) {
                        department = this.departmentList[index];
                        break;
                    }
                }
            }
        }
        return department;
    }
    ;
    getMembersOfDepartment(departmentId) {
        let members = [];
        if (this.employeeList != null && this.employeeList.length > 0) {
            for (let index = 0; index < this.employeeList.length; index++) {
                if (this.employeeList[index].DepartmentId == departmentId)
                    members.push(this.employeeList[index].Id);
            }
        }
        return members;
    }
    ;
    getManagerById(managerId) {
        let manager = null;
        if (this.managerList != null && this.managerList.length > 0) {
            for (let index = 0; index < this.managerList.length; index++) {
                if (this.managerList[index].Id == managerId) {
                    manager = this.managerList[index];
                    break;
                }
            }
        }
        return manager;
    }
    ;
    getTaskMailboxById(mailboxId) {
        let mailbox = null;
        if (this.taskMailboxList != null && this.taskMailboxList.length > 0) {
            for (let index = 0; index < this.taskMailboxList.length; index++) {
                if (this.taskMailboxList[index].Id == mailboxId) {
                    mailbox = this.taskMailboxList[index];
                    break;
                }
            }
        }
        return mailbox;
    }
    ;
    addToDashboardCache(type, items) {
        this.dashboardCachedItemList[type] = items;
    }
    ;
    addItemToDashboardCache(type, item) {
        if (!GlobalFunctions.isEmpty(type)) {
            let items = this.dashboardCachedItemList[type];
            if (items == null && items == undefined)
                items = new Array();
            item.Order = items.length + 1;
            items.push(item);
            this.dashboardCachedItemList[type] = items;
        }
    }
    ;
    getFromDashboardCache(type) {
        return this.dashboardCachedItemList[type];
    }
    ;
    getItemFromDashboardCache(type, item) {
        let dashboardItem = null;
        if (!GlobalFunctions.isEmpty(type)) {
            let items = this.dashboardCachedItemList[type];
            if (items != null && items != undefined) {
                for (let i = 0; i < items.length; i++) {
                    if (items[i].Id == item.EntityId && items[i].ObjectSource == item.EntitySource) {
                        dashboardItem = items[i];
                        break;
                    }
                }
                ;
            }
        }
        return dashboardItem;
    }
    ;
    updateItemInDashboardCache(type, item) {
        if (!GlobalFunctions.isEmpty(type)) {
            const items = this.dashboardCachedItemList[type];
            if (items != null && items != undefined) {
                for (let i = 0; i < items.length; i++) {
                    if (items[i].Id == item.Id && items[i].ObjectSource == item.ObjectSource) {
                        items[i].StringRepresentation = item.StringRepresentation;
                        break;
                    }
                }
                ;
            }
        }
    }
    ;
    removeDashboardCache() {
        this.dashboardCachedItemList['notification'] = null;
    }
    ;
    removeItemFromDashboardCache(type, item) {
        if (!GlobalFunctions.isEmpty(type)) {
            let favouriteItem = this.getItemFromDashboardCache(type, item);
            if (favouriteItem != null && favouriteItem != undefined) {
                let items = this.dashboardCachedItemList[type];
                let index = items.indexOf(favouriteItem);
                if (index != -1) {
                    items.splice(index, 1);
                    this.dashboardCachedItemList[type] = items;
                }
            }
        }
    }
    ;
    updateDashboardCache(item) {
        if (!GlobalFunctions.isEmpty(item)) {
            this.updateItemInDashboardCache("MostSelectedByEveryone", item);
            this.updateItemInDashboardCache("MostSelectedByMe", item);
            this.updateItemInDashboardCache("MostSelectedByRole", item);
            this.updateItemInDashboardCache("MyFavourite", item);
            this.applicationSettingManager.dashboardSetting.updateWebpartData("Important", item);
            if (!GlobalFunctions.isEmpty(item.ObjectSource) && item.ObjectSource.toUpperCase().indexOf('THEMES') > 0)
                this.applicationSettingManager.dashboardSetting.updateWebpartData("Themepage", item);
            if (!GlobalFunctions.isEmpty(item.ObjectSource) && item.ObjectSource.toUpperCase().indexOf('NOTES') > 0)
                this.applicationSettingManager.dashboardSetting.updateWebpartData("Noteentity", item);
            if (!GlobalFunctions.isEmpty(item.ObjectSource) && item.ObjectSource.toUpperCase().indexOf('FILES') > 0)
                this.applicationSettingManager.dashboardSetting.updateWebpartData("Fileentity", item);
            if (!GlobalFunctions.isEmpty(item.ObjectSource) && item.ObjectSource.toUpperCase().indexOf('LINK') > 0)
                this.applicationSettingManager.dashboardSetting.updateWebpartData("Link", item);
        }
    }
    getNotificationForPrivacyContactHistory() {
        let note = null;
        let notificationList = this.getFromDashboardCache('notification');
        if (!notificationList)
            return;
        notificationList.forEach(notification => {
            if (notification.NoteEntity != null && notification.NoteEntity.NoteType == '3')
                note = notification;
        });
        return note;
    }
    getRelatedEntityById(id, type) {
        let relatedEntity = null;
        if (this.relatedResultList == null || this.relatedResultList[type.toUpperCase()] == null)
            return;
        relatedEntity = jlinq.from(this.relatedResultList[type.toUpperCase()]).starts("Id", id).first();
        return relatedEntity;
    }
    updateEmployee(employeeDto) {
        if (this.employeeList != null && this.employeeList.length > 0) {
            for (let index = 0; index < this.employeeList.length; index++) {
                if (this.employeeList[index].Id === employeeDto.Id) {
                    this.employeeList[index].ExtraInfo = employeeDto.ExtraInfo;
                    this.employeeList[index].Note = employeeDto.Note;
                    this.employeeList[index].WorkingHours = employeeDto.WorkingHours;
                    this.employeeList[index].SkillsJson = employeeDto.SkillsJson;
                    this.employeeList[index].Skills = employeeDto.Skills;
                    break;
                }
            }
        }
    }
    ;
    getRandomLayerStyle() {
        let layerStyle = {};
        try {
            if (this.alphabetCounter == this.alphabets.length)
                this.alphabetCounter = 0;
            let foundLayerStyle = this.layerStyles[this.alphabets[this.alphabetCounter]];
            let marker = {};
            marker["id"] = "decos" + this.alphabetCounter.toString();
            marker["name"] = "decos" + this.alphabetCounter.toString();
            marker["externalGraphic"] = foundLayerStyle.externalGraphic;
            marker["graphicHeight"] = 8;
            marker["graphicWidth"] = 8;
            marker["graphicYOffset"] = -8;
            marker["pointRadius"] = 1;
            layerStyle["markerStyle"] = marker;
            layerStyle["fillColor"] = foundLayerStyle.fillColor;
            layerStyle["strokeColor"] = foundLayerStyle.strokeColor;
            this.alphabetCounter = this.alphabetCounter + 1;
        }
        catch (e) {
            console.error(e);
        }
        return layerStyle;
    }
    createWFSLayer(response, url) {
        let layers = null;
        try {
            let x2js = new X2JS();
            let responseJson = x2js.xml2js(response);
            if (responseJson && responseJson.WFS_Capabilities && responseJson.WFS_Capabilities.FeatureTypeList) {
                layers = [];
                let LayerList = GlobalFunctions.ConvertToArrayIfOnlySingleObject(responseJson.WFS_Capabilities.FeatureTypeList.FeatureType);
                for (let i = 0; i < LayerList.length; i++) {
                    let layerAttributes = {};
                    let layer = LayerList[i];
                    if (layer) {
                        let layerStyle = this.getRandomLayerStyle();
                        let layerTitle = typeof layer.Title === 'object' ? layer.Title.__text : layer.Title;
                        let layerName = typeof layer.Name === 'object' ? layer.Name.__text : layer.Name;
                        let ns = "_xmlns" + ':' + layerName.split(':')[0];
                        let id = responseJson.WFS_Capabilities.ServiceIdentification.Title.__text + "_" + layerTitle + "_WFS";
                        id = id.toUpperCase();
                        id = id.replace(/ /g, '');
                        layerAttributes["id"] = id;
                        layerAttributes["layertype"] = "WFS";
                        layerAttributes["name"] = layerTitle;
                        layerAttributes["url"] = url;
                        layerAttributes["featureType"] = layerName.split(':')[1];
                        layerAttributes["featureNS"] = responseJson.WFS_Capabilities[ns];
                        //layerAttributes["geometryName"] = "geometrie";
                        layerAttributes["minZoom"] = 12;
                        layerAttributes["objectLayer"] = true;
                        layerAttributes["strokeColor"] = layerStyle["strokeColor"];
                        layerAttributes["strokeWidth"] = 2.0;
                        layerAttributes["strokeOpacity"] = 0.6;
                        layerAttributes["fillColor"] = layerStyle["fillColor"];
                        if (this.configuredLayers[layerTitle.toLowerCase()]) {
                            let configuredLayer = this.configuredLayers[layerTitle.toLowerCase()];
                            if (configuredLayer.fillOpacity)
                                layerAttributes["fillOpacity"] = configuredLayer.fillOpacity;
                            if (configuredLayer.objectLayer != null)
                                layerAttributes["objectLayer"] = configuredLayer.objectLayer;
                            if (configuredLayer.minZoom)
                                layerAttributes["minZoom"] = configuredLayer.minZoom;
                            if (configuredLayer.minResolution)
                                layerAttributes["minResolution"] = configuredLayer.minResolution;
                            if (configuredLayer.strokeWidth)
                                layerAttributes["strokeWidth"] = configuredLayer.strokeWidth;
                        }
                        layerAttributes["visibility"] = true;
                        layerAttributes["isBaseLayer"] = false;
                        layerAttributes["singleTile"] = true;
                        layerAttributes["markerStyle"] = layerStyle["markerStyle"];
                        layerAttributes["visible"] = false;
                        layers.push(layerAttributes);
                    }
                }
            }
        }
        catch (e) {
            console.error(e);
        }
        return layers;
    }
    createWMSLayer(response, url) {
        let layers = null;
        try {
            let x2js = new X2JS();
            let responseJson = x2js.xml2js(response);
            if (responseJson && responseJson.WMS_Capabilities && responseJson.WMS_Capabilities.Capability.Layer && responseJson.WMS_Capabilities.Capability.Layer.Layer) {
                layers = [];
                let LayerList = GlobalFunctions.ConvertToArrayIfOnlySingleObject(responseJson.WMS_Capabilities.Capability.Layer.Layer);
                for (let i = 0; i < LayerList.length; i++) {
                    let layerAttributes = {};
                    let layer = LayerList[i];
                    if (layer) {
                        let id = responseJson.WMS_Capabilities.Service.Title + "_" + layer.Title + "_WMS";
                        id = id.toUpperCase();
                        id = id.replace(/ /g, '');
                        layerAttributes["id"] = id;
                        layerAttributes["layertype"] = "WMS";
                        layerAttributes["name"] = layer.Title;
                        layerAttributes["url"] = url;
                        layerAttributes["layers"] = layer.Title;
                        layerAttributes["transparent"] = true;
                        layerAttributes["format"] = "image/png";
                        layerAttributes["visibility"] = true;
                        layerAttributes["isBaseLayer"] = false;
                        layerAttributes["singleTile"] = true;
                        layerAttributes["visible"] = false;
                        layers.push(layerAttributes);
                    }
                }
            }
        }
        catch (e) {
            console.error(e);
        }
        return layers;
    }
    createLayer(response, url, layerType) {
        let layers = [];
        try {
            switch (layerType.toUpperCase()) {
                case "WFS":
                    layers = this.createWFSLayer(response, url);
                    break;
                case "WMS":
                    layers = this.createWMSLayer(response, url);
                    break;
            }
        }
        catch (e) {
            console.error(e);
        }
        return layers;
    }
    getLayerTypeFromUrl(urlAddress) {
        let layerType = "wfs";
        if (urlAddress.toLowerCase().indexOf("wfs") > -1)
            layerType = "wfs";
        else if (urlAddress.toLowerCase().indexOf("wms") > -1)
            layerType = "wms";
        return layerType;
    }
    isVendorExist(vendorName) {
        let isExist = false;
        if (this.geoVendors && this.geoVendors.length > 0) {
            for (let i = 0; i < this.geoVendors.length; i++) {
                let vendor = this.geoVendors[i];
                if (vendor.name == vendorName) {
                    isExist = true;
                    break;
                }
            }
        }
        return isExist;
    }
    fetchLayers(connectSystemCode, connectPwd) {
        if (this.geoVendors == null && this.employeeService.loggedInEmployee && this.employeeService.loggedInEmployee.LogonUserName) {
            this.geoVendors = [];
            let loggedInUser = this.employeeService.loggedInEmployee.LogonUserName;
            const x2js = new X2JS();
            let geoLayerSettingsXml = this.applicationSettingManager.getApplicationSettingValueByKey("GeoLayerSettings");
            if (!GlobalFunctions.isEmpty(geoLayerSettingsXml)) {
                let geoLayerSettingsJson = x2js.xml2js(geoLayerSettingsXml);
                if (geoLayerSettingsJson && geoLayerSettingsJson.GeoVendors && geoLayerSettingsJson.GeoVendors.GeoVendor) {
                    geoLayerSettingsJson.GeoVendors.GeoVendor = GlobalFunctions.ConvertToArrayIfOnlySingleObject(geoLayerSettingsJson.GeoVendors.GeoVendor);
                    let geoVendor, niceName, urlAddress, finalUrl, qs;
                    if (geoLayerSettingsJson.GeoVendors.GeoVendor.length > 0) {
                        try {
                            for (let i = 0; i < geoLayerSettingsJson.GeoVendors.GeoVendor.length; i++) {
                                geoVendor = geoLayerSettingsJson.GeoVendors.GeoVendor[i];
                                niceName = geoVendor._Name;
                                let urlAddress2 = geoVendor._UrlAddress;
                                urlAddress = geoVendor._UrlAddress;
                                if (urlAddress.indexOf('?') > 0)
                                    qs = '&request=GetCapabilities';
                                else
                                    qs = '?request=GetCapabilities';
                                if (urlAddress.indexOf('aspx/wfs') > 0) {
                                    qs += '&systemcode=' + connectSystemCode + '&username=' + loggedInUser + '&pwd=' + connectPwd;
                                    urlAddress2 = urlAddress2 + '?systemcode=' + connectSystemCode + '&username=' + loggedInUser + '&pwd=' + connectPwd;
                                }
                                finalUrl = environment.geo_proxy;
                                this.applicationSettingManager.getGeoData(finalUrl).subscribe(result => {
                                    if (result && result.data && !GlobalFunctions.isEmpty(result.data)) {
                                        if (!this.isVendorExist(result.niceName)) {
                                            let layerType = this.getLayerTypeFromUrl(urlAddress);
                                            let layers = this.createLayer(result.data, urlAddress2, layerType);
                                            if (layers) {
                                                let vendor = new Object();
                                                vendor.name = niceName;
                                                vendor.title = layers[0]["id"].split("_")[0];
                                                vendor.id = "GeoVendor_" + this.geoVendors.length;
                                                vendor.layers = layers;
                                                this.geoVendors.push(vendor);
                                            }
                                        }
                                    }
                                });
                            }
                        }
                        catch (e) {
                            console.error(e);
                        }
                    }
                }
            }
        }
    }
    ;
    fetchCacheData() {
        this.employeeService.fetchManagers(this.completedManagersFetch).subscribe();
        this.employeeService.fetchDepartments(this.completedDepartmentsFetch).subscribe();
        this.employeeService.fetchTaskMailboxes(this.completedTaskMailboxesFetch).subscribe();
        this.employeeService.fetchEmployeesFromDatabase(this.completedEmployeesFetch).subscribe();
    }
    ;
    clear() {
        this.relatedResultList = [];
        this.roleList = [];
        this.dashboardCachedItemList = [];
    }
};
CacheManager = __decorate([
    Injectable({
        providedIn: 'root'
    })
], CacheManager);
export { CacheManager };
//# sourceMappingURL=cache-manager.js.map