var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Injectable } from "@angular/core";
import { LocalStorageKey, RoutePath } from "../shared/constants";
import { GlobalFunctions } from "../shared/global-functions";
import { BooleanHelper } from "../shared/helper/boolean-helper";
let AuthGuard = class AuthGuard {
    constructor(router, sessionManager) {
        this.router = router;
        this.sessionManager = sessionManager;
    }
    canActivate(route, state) {
        if (!GlobalFunctions.isEmpty(JSON.parse(localStorage.getItem(LocalStorageKey.SESSION_TOKEN)))) {
            if (GlobalFunctions.isEmpty(localStorage.getItem(LocalStorageKey.REDIRECT_URL)) && this.isDeepLink(state.url))
                localStorage.setItem(LocalStorageKey.APP_REFRESHED, 'true');
            const isApplicationRefreshed = localStorage.getItem(LocalStorageKey.APP_REFRESHED);
            if ((state.url === '/dashboard' && !this.sessionManager.isAppLoaded) || (!GlobalFunctions.isEmpty(isApplicationRefreshed) && BooleanHelper.stringToBoolean(isApplicationRefreshed))) {
                localStorage.removeItem(LocalStorageKey.APP_REFRESHED);
                // If the app was refreshed (e.g., via browser reopen or F5), redirect to /loading to reinitialize state.
                // Only allow direct access to /loading if already on it.
                if (state.url == '/loading')
                    return true;
            }
            else if (!this.isAllowedURLS(state.url) && !this.isDeepLink()) {
                this.sessionManager.isValiduser = true;
            }
            else {
                this.sessionManager.isValiduser = true;
                if (localStorage.getItem(LocalStorageKey.APP_INIT_VIEW) === 'login' && !this.isDeepLink())
                    localStorage.setItem(LocalStorageKey.REDIRECT_URL, '/');
                return true;
            }
        }
        const cookie = GlobalFunctions.getServerSideCookie('Redirect_Url');
        if (!GlobalFunctions.isEmpty(cookie) && this.isDeepLink(cookie)) {
            localStorage.setItem(LocalStorageKey.REDIRECT_URL, cookie);
            localStorage.setItem(LocalStorageKey.DEEPLINK, cookie);
        }
        else
            localStorage.setItem(LocalStorageKey.REDIRECT_URL, state.url);
        this.router.navigate([RoutePath.LOGIN]);
        return false;
    }
    isDeepLink(url = localStorage.getItem(LocalStorageKey.REDIRECT_URL)) {
        if (url?.includes(RoutePath.DETAIL_PATH))
            return url.includes('appointment/') || url.includes('assignment/') || url.includes('callbacknote/') || url.includes('informationrequest/') || url.includes('reportimprovement/') || url.includes('ticket/') || url.includes('person?');
        else
            return false;
    }
    isAllowedURLS(url) {
        return url === '/dashboard' || url === '/loading';
    }
};
AuthGuard = __decorate([
    Injectable({
        providedIn: 'root'
    })
], AuthGuard);
export { AuthGuard };
//# sourceMappingURL=auth.guard.js.map