var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { AlternateSearchType, ContextMenuView, DateCompareType, DocumentFormat, ScreenMode } from '../../../../core/enums/common-enums';
import { EntityFqdn } from '../../../../core/enums/core-enums';
import { ContextMenu } from '../../../../core/models/common/context-menu';
import { DateCriteriaDto } from '../../../../core/models/common/date-criteria';
import { SearchDto } from '../../../../core/models/common/searchDto';
import { StringCriteriaDto } from '../../../../core/models/common/string-criteria';
import { FilterList } from '../../../../core/models/filter/filter-list';
import { ContentType, TicketSearchField } from '../../../../core/models/jkc-object/jkc-object';
import { BroadCastEventKeys } from '../../../../shared/constants';
import { GlobalFunctions } from '../../../../shared/global-functions';
import { DialogHelper } from '../../../../shared/helper/dialog-helper';
import { BaseSearchResultComponent } from '../../../common/base-search-result.component';
import { MessageboxComponent } from '../../../common/messagebox/messagebox.component';
import { PrintComponent } from '../../../common/print/print.component';
import { CreateExportReportRequest } from '../../../../core/models/report/create-export-report-request';
let TicketSearchResultComponent = class TicketSearchResultComponent extends BaseSearchResultComponent {
    constructor(router, dialog, datePipe, sortManager, ticketService, searchService, cacheManager, sessionManager, formatManager, eventProvider, activatedRoute, employeeService, translateService, changeDetectorRef, applicationSettingManager, integrationSettingManager, localSearchResultDataService, downloadService) {
        super(translateService, changeDetectorRef, sessionManager, router, activatedRoute, eventProvider, sortManager, applicationSettingManager, employeeService, formatManager, cacheManager, integrationSettingManager, datePipe, searchService);
        this.router = router;
        this.dialog = dialog;
        this.datePipe = datePipe;
        this.sortManager = sortManager;
        this.ticketService = ticketService;
        this.searchService = searchService;
        this.cacheManager = cacheManager;
        this.sessionManager = sessionManager;
        this.formatManager = formatManager;
        this.eventProvider = eventProvider;
        this.activatedRoute = activatedRoute;
        this.employeeService = employeeService;
        this.translateService = translateService;
        this.changeDetectorRef = changeDetectorRef;
        this.applicationSettingManager = applicationSettingManager;
        this.integrationSettingManager = integrationSettingManager;
        this.localSearchResultDataService = localSearchResultDataService;
        this.downloadService = downloadService;
        this.type = "TICKET";
        this.dateJS = Date;
        this.ticketDtoList = [];
        this.filterList = new FilterList();
        this.updateSearchQueryStatus = (dateCriteria) => {
            try {
                var criteria;
                dateCriteria.TypeOfCompareType.forEach(function (value, key) {
                    if (key != null && key == dateCriteria.CompareType)
                        criteria = value.Text;
                });
                var searchQuery = dateCriteria.Value.split(" ")[0];
                if (dateCriteria.CompareType == "5")
                    searchQuery += " - " + dateCriteria.ToDate.split(" ")[0];
                searchQuery = searchQuery ? searchQuery : dateCriteria.Value;
                this.searchStatusQuery += ' - {' + this.translateService.instant('LBL_' + dateCriteria.DisplayName) + '} ' + this.translateService.instant("LBL_" + criteria.toUpperCase()) + " " + searchQuery + " ";
            }
            catch (e) { }
        };
        this.getTicketIdFromList = (ticketList) => {
            var ticketIdList = new Array();
            if (!GlobalFunctions.isEmpty(ticketList)) {
                ticketList.forEach(function (ticketItem) {
                    if (!GlobalFunctions.isEmpty(ticketItem))
                        ticketIdList.push(ticketItem.Id);
                });
            }
            return ticketIdList;
        };
        this.createReportResponse = this.createReportResponse.bind(this);
        this.subs.sink = activatedRoute.queryParams.subscribe(queryParams => this.selectedOption = queryParams.filter || '');
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.UPDATE_SEARCH_RESULTS).subscribe(searchStatusQuery => {
            this.searchStatusQuery = searchStatusQuery;
            this.ngOnInit();
        });
    }
    ngOnInit() {
        this.type = "ticket";
        this.resultList = [];
        this.filteredSearchResult = [];
        this.sessionManager.localSearchFieldList = this.applicationSettingManager.getSearchFieldListByEntity(ContentType.Ticket);
        if (this.localSearchResultDataService.localSearchResultData.localResult?.length > 0 && this.localSearchResultDataService.localSearchResultData.contentType.toLowerCase().includes("ticket")) {
            this.sourceCount = 0;
            this.resultList = [];
            this.filterList.Filters = this.ticketService.lastAppliedFilters;
            this.filterList.FilterOptions = this.ticketService.filterOptions;
            this.searchStatusQuery = this.localSearchResultDataService.localSearchResultData.localResult[0].searchStatusQuery;
            this.searchResultFound(this.localSearchResultDataService.localSearchResultData.localResult);
            this.localSearchResultDataService.localSearchResultData.localResult = [];
            this.localSearchResultDataService.localSearchResultData.contentType = "";
        }
        else if (!GlobalFunctions.isEmpty(this.selectedOption)) {
            if (this.selectedOption == 'my')
                this.searchMyTickets();
            else
                this.searchByParam(this.selectedOption);
        }
        else {
            this.updateSearchStatus(this.activeHandlersObj);
            if (this.searchService.isAdvancedSearch) {
                this.ticketService.advancedSearch(this.searchService.advancedSearchOption.searchDto, null, null, null, this.searchResultFound, this.updateSearchStatus, () => { });
                this.searchStatusQuery = this.searchService.advancedSearchQuery;
            }
            else {
                this.searchStatusQuery = this.searchService.selectedSearchOption.searchQuery;
                this.ticketService.search(this.searchStatusQuery, false, AlternateSearchType.None, this.searchService.selectedSearchOption.sourceLocation, '', this.searchResultFound, this.updateSearchStatus, () => { });
            }
        }
        this.sessionManager.contextMenu = new ContextMenu('', 'TICKET', this.translateService, null, GlobalFunctions.getLoggedInUserId(), ContextMenuView.SearchList, this.sessionManager.customContextMenuItems, this.sessionManager, this.integrationSettingManager);
        this.timeoutIds.push(setTimeout(() => this.resize(), 300));
        let ticketConfig = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Tickets_Entities_Ticket, "TICKETSCONFIGURATION");
        this.filterList.FilterOptions = [...ticketConfig.Filters];
    }
    ngOnDestroy() {
        super.ngOnDestroy();
    }
    setResultList() {
        if (this.filterList.Filters.length > 0 && this.unfilteredList != null && this.unfilteredList.length > 0) {
            this.resultList = [];
            let appliedFilterType = [];
            for (let ft = 0; ft < this.filterList.Filters.length; ft++) {
                if (!jlinq.from(appliedFilterType).contains(this.filterList.Filters[ft].Type).any()) {
                    let filtersOfType = jlinq.from(this.filterList.Filters).equals("Type", this.filterList.Filters[ft].Type).select();
                    if (filtersOfType != null && filtersOfType.length > 0) {
                        let resultsOfType = [];
                        let filteredResultList = [];
                        if (this.resultList.length === 0)
                            filteredResultList = this.unfilteredList;
                        else
                            filteredResultList = this.resultList;
                        let keys = this.generateKeysforFilterType(filtersOfType);
                        if (filtersOfType[0].Type.toLowerCase() == this.translateService.instant("LBL_STATUS").toLowerCase() || filtersOfType[0].Type.toLowerCase() == "status") {
                            for (let fr = 0; fr < filteredResultList.length; fr++) {
                                let result = filteredResultList[fr];
                                if (result.State != null && keys.toLowerCase().indexOf('|' + result.State.toLowerCase() + '|') != -1)
                                    resultsOfType.push(result);
                            }
                        }
                        else if (filtersOfType[0].Type.toLowerCase() == this.translateService.instant("LBL_PRIORITY").toLowerCase() || filtersOfType[0].Type.toLowerCase() == "prioriteit") {
                            for (let fr = 0; fr < filteredResultList.length; fr++) {
                                let result = filteredResultList[fr];
                                if (result.Priority != null && keys.toLowerCase().indexOf('|' + result.Priority.toLowerCase() + '|') != -1)
                                    resultsOfType.push(result);
                            }
                        }
                        else {
                            for (let fr = 0; fr < filteredResultList.length; fr++) {
                                let result = filteredResultList[fr];
                                let fieldData = jlinq.from(result.FieldDataList).equals("FieldListId", filtersOfType[0].Id).first();
                                if (fieldData != null && keys.indexOf('|' + fieldData.Data + '|') != -1)
                                    resultsOfType.push(result);
                            }
                        }
                        this.resultList = filteredResultList.filter(n => resultsOfType.indexOf(n) != -1);
                    }
                    appliedFilterType.push(this.filterList.Filters[ft].Type);
                }
            }
            GlobalFunctions.remove_duplicates(this.resultList);
            this.ticketService.lastAppliedFilters = this.filterList.Filters;
            this.ticketService.filterOptions = this.filterList.FilterOptions;
        }
        else
            this.resultList = this.unfilteredList;
    }
    ;
    generateKeysforFilterType(filtersOfType) {
        let keys = '|';
        for (let flt = 0; flt < filtersOfType.length; flt++)
            keys = keys + filtersOfType[flt].Key + '|';
        return keys;
    }
    ;
    searchMyTickets() {
        this.resultList = [];
        this.sessionManager.startSessionIfPossible(this.type, ScreenMode.List);
        const searchDto = new SearchDto();
        searchDto.ObjectSource = 'my';
        this.searchStatusQuery = `${this.translateService.instant('LBL_MY')} ${this.translateService.instant('LBL_TICKETS')}`;
        this.ticketService.advancedSearch(searchDto, undefined, undefined, undefined, this.searchResultFound, this.updateSearchStatus, () => { });
    }
    ;
    searchByParam(param) {
        let searchDto = new SearchDto();
        searchDto.StringCriteriaList = [];
        searchDto.NumericCriteriaList = [];
        searchDto.DateCriteriaList = [];
        searchDto.EnumCriteriaList = [];
        this.searchService.advancedSearchQuery = '';
        switch (param.toLowerCase()) {
            case "openticketforme":
            case "openticketfordepartment":
                {
                    let handlerSearchCriteria = null;
                    handlerSearchCriteria = new StringCriteriaDto();
                    handlerSearchCriteria.IsInUse = true;
                    handlerSearchCriteria.Name = TicketSearchField.Handler;
                    handlerSearchCriteria.CompareType = 0;
                    if (param.toLowerCase() === "openticketforme")
                        handlerSearchCriteria.Value = GlobalFunctions.getLoggedInUserId();
                    else {
                        let departmentMembers = this.cacheManager.getMembersOfDepartment(this.employeeService.loggedInEmployee.DepartmentId);
                        handlerSearchCriteria.Value = departmentMembers != null && departmentMembers.length > 0 ? departmentMembers.join("','").trim() : GlobalFunctions.getLoggedInUserId();
                    }
                    searchDto.StringCriteriaList.push(handlerSearchCriteria);
                    handlerSearchCriteria = new StringCriteriaDto();
                    handlerSearchCriteria.IsInUse = true;
                    handlerSearchCriteria.Name = TicketSearchField.Status;
                    handlerSearchCriteria.CompareType = 3;
                    handlerSearchCriteria.Value = 'afgesloten';
                    searchDto.StringCriteriaList.push(handlerSearchCriteria);
                    break;
                }
            case "createdticketbyme":
            case "createdticketbydepartment":
                {
                    let createdByMeSearchCriteria = new StringCriteriaDto();
                    createdByMeSearchCriteria.IsInUse = true;
                    createdByMeSearchCriteria.CompareType = 0;
                    if (param.toLowerCase() === 'createdticketbyme') {
                        createdByMeSearchCriteria.Name = TicketSearchField.CreatedById;
                        createdByMeSearchCriteria.Value = GlobalFunctions.getLoggedInUserId();
                    }
                    else {
                        let departmentMembers = this.cacheManager.getMembersOfDepartment(this.employeeService.loggedInEmployee.DepartmentId);
                        createdByMeSearchCriteria.Name = TicketSearchField.CreatedById;
                        createdByMeSearchCriteria.Value = departmentMembers != null && departmentMembers.length > 0 ? departmentMembers.join(',').trim() : GlobalFunctions.getLoggedInUserId();
                    }
                    searchDto.StringCriteriaList.push(createdByMeSearchCriteria);
                    let dateSearchCriteria = new DateCriteriaDto();
                    dateSearchCriteria.CompareType = DateCompareType.Between;
                    dateSearchCriteria.Name = TicketSearchField.CreatedDate;
                    ;
                    dateSearchCriteria.Value = new this.dateJS().toString(this.sessionManager.defaultOptions.mdyyyyhhmmss);
                    dateSearchCriteria.ToDate = new this.dateJS().toString(this.sessionManager.defaultOptions.mdyyyyhhmmss);
                    searchDto.DateCriteriaList.push(dateSearchCriteria);
                    break;
                }
            case "handledticketbyme":
            case "handledticketbydepartment":
                {
                    let createdByMeSearchCriteria = new StringCriteriaDto();
                    createdByMeSearchCriteria.IsInUse = true;
                    createdByMeSearchCriteria.CompareType = 0;
                    if (param.toLowerCase() === 'handledticketbyme') {
                        createdByMeSearchCriteria.Name = TicketSearchField.Handler;
                        createdByMeSearchCriteria.Value = GlobalFunctions.getLoggedInUserId();
                    }
                    else {
                        let departmentMembers = this.cacheManager.getMembersOfDepartment(this.employeeService.loggedInEmployee.DepartmentId);
                        createdByMeSearchCriteria.Name = TicketSearchField.Handler;
                        createdByMeSearchCriteria.Value = departmentMembers != null && departmentMembers.length > 0 ? departmentMembers.join("','").trim() : GlobalFunctions.getLoggedInUserId();
                    }
                    searchDto.StringCriteriaList.push(createdByMeSearchCriteria);
                    let dateSearchCriteria = new DateCriteriaDto();
                    dateSearchCriteria.CompareType = DateCompareType.Between;
                    dateSearchCriteria.Name = TicketSearchField.ClosedDate;
                    dateSearchCriteria.Value = new this.dateJS().toString(this.sessionManager.defaultOptions.mdyyyyhhmmss);
                    dateSearchCriteria.ToDate = new this.dateJS().toString(this.sessionManager.defaultOptions.mdyyyyhhmmss);
                    searchDto.DateCriteriaList.push(dateSearchCriteria);
                    break;
                }
            default: {
                if (this.sessionManager.ticketFilters != null) {
                    let ticketFilter = jlinq.from(this.sessionManager.ticketFilters).equals("Id", param).first();
                    if (ticketFilter) {
                        this.ticketService.addFilterCriteriaToSearchDto(ticketFilter, searchDto);
                        this.searchStatusQuery = this.translateService.instant("LBL_FILTER") + ": " + ticketFilter.Title;
                        if (!GlobalFunctions.isEmpty(ticketFilter.Period) && ticketFilter.Period > 0)
                            this.updateSearchQueryStatus(searchDto.DateCriteriaList[0]);
                        this.ticketService.advancedSearch(searchDto, undefined, undefined, undefined, this.searchResultFound, this.updateSearchStatus, undefined);
                        return;
                    }
                }
            }
        }
        this.sessionManager.startSessionIfPossible(this.type, ScreenMode.List);
        this.ticketService.advancedSearch(searchDto, null, null, null, this.searchResultFound, this.updateSearchStatus, () => { });
        this.searchService.advancedSearchQuery += "{" + this.translateService.instant("LBL_" + param.toUpperCase()) + "}";
        this.searchStatusQuery = this.searchService.advancedSearchQuery;
    }
    ;
    executeMenuItem(key) {
        switch (key.toUpperCase()) {
            case "SENDREMINDERS":
                this.sendTicketReminder();
                break;
            case 'SENDTOEXCEL':
                this.sendToReport(DocumentFormat.Xlsx);
                break;
        }
    }
    ;
    sendToReport(documentFormat) {
        if (!GlobalFunctions.isEmpty(this.filteredSearchResult)) {
            DialogHelper.openDialog(this.dialog, PrintComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState));
            let exportReportRequest = new CreateExportReportRequest();
            exportReportRequest.DocumentFormat = documentFormat;
            exportReportRequest.SearchQuery = this.sessionManager.localSearchQuery;
            exportReportRequest.LogOnName = this.employeeService.loggedInEmployee.LoggedInUserName;
            if (this.router.url.toLowerCase().indexOf('ticket') > -1) {
                exportReportRequest.EntityIdList = this.getTicketIdFromList(this.filteredSearchResult);
                this.ticketService.createReport(exportReportRequest, this.createReportResponse);
            }
        }
    }
    ;
    createReportResponse(response) {
        this.dialog.closeAll();
        if (!GlobalFunctions.isEmpty(response) && !GlobalFunctions.isEmpty(response.DownloadTicketId))
            this.subs.sink = this.downloadService.downloadFile(response.DownloadTicketId).subscribe(res => GlobalFunctions.downloadFileAsBlob(res));
    }
    ;
    sendTicketReminder() {
        if (GlobalFunctions.isEmpty(this.filteredSearchResult)) {
            let header = this.translateService.instant("LBL_TICKET");
            let message = this.translateService.instant("LBL_MSG_TICKET_NOT_SENDING_REMINDERS").replace(/{TICKETTITLE}/g, this.translateService.instant("LBL_TICKET"));
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: header, textMsg: message });
        }
        else {
            if (this.filteredSearchResult.length > 0) {
                let message = this.translateService.instant("LBL_MSG_TICKET_SEND_REMINDERS_CONFIRMATION").replace(/{TICKETTITLE}/g, this.translateService.instant("LBL_TICKET"));
                message = GlobalFunctions.formatStringValue(message, [this.filteredSearchResult.length]);
                let header = this.translateService.instant("LBL_TICKET");
                DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: header, textMsg: message, isConfirmation: true, noButton: this.translateService.instant('LBL_NO'), yesButton: this.translateService.instant('LBL_YES') }).afterClosed().subscribe(result => {
                    if (result) {
                        let ticketIdList = [];
                        this.filteredSearchResult.forEach(ticket => {
                            if (!GlobalFunctions.isEmpty(ticket.Id))
                                ticketIdList.push(ticket.Id);
                        });
                        this.ticketService.sendReminder(ticketIdList);
                        let header = this.translateService.instant("LBL_TICKET");
                        let message = this.translateService.instant("LBL_MSG_TICKET_SEND_REMINDERS").replace(/{TICKETTITLE}/g, this.translateService.instant("LBL_TICKET"));
                        DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: header, textMsg: message });
                    }
                });
            }
        }
    }
    ;
    resize() {
        let windowHeight = $(window).height();
        $('#ticketSearchResults').height(windowHeight - 246 + 'px');
    }
};
TicketSearchResultComponent = __decorate([
    Component({
        selector: 'ticket-search-result',
        templateUrl: './ticket-search-result.component.html',
        styleUrls: ['./ticket-search-result.component.scss'],
        host: { '(window:resize)': 'resize()' }
    })
], TicketSearchResultComponent);
export { TicketSearchResultComponent };
//# sourceMappingURL=ticket-search-result.component.js.map