var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, HostListener } from '@angular/core';
import { DateCompareType, ScreenMode } from '../../../../core/enums/common-enums';
import { EntityFqdn } from '../../../../core/enums/core-enums';
import { AdvancedSearchItem } from '../../../../core/models/common/advance-serach-item';
import { DateCriteriaDto } from '../../../../core/models/common/date-criteria';
import { NumericCriteriaDto } from '../../../../core/models/common/numeric-criteria';
import { SearchDto } from '../../../../core/models/common/searchDto';
import { StringCriteriaDto } from '../../../../core/models/common/string-criteria';
import { TicketSearchField } from '../../../../core/models/jkc-object/jkc-object';
import { GlobalFunctions } from '../../../../shared/global-functions';
import { CommonHelper } from '../../../../shared/helper/common-helper';
import { JkcDatePickerHelper } from '../../../../shared/helper/jkc-date-picker-helper';
let TicketSearchCriteriaComponent = class TicketSearchCriteriaComponent {
    constructor(cacheManager, searchService, ticketService, sessionManager, translateService, applicationSettingManager, integrationSettingManager, datePipe, renderer, dateAdapter) {
        this.cacheManager = cacheManager;
        this.searchService = searchService;
        this.ticketService = ticketService;
        this.sessionManager = sessionManager;
        this.translateService = translateService;
        this.applicationSettingManager = applicationSettingManager;
        this.integrationSettingManager = integrationSettingManager;
        this.datePipe = datePipe;
        this.renderer = renderer;
        this.dateAdapter = dateAdapter;
        this.dateJS = Date;
        this.currentHandlerType = { 'option': "Employee" };
        this.handlerTags = [];
        this.handlerTagItems = [];
        this.advancedSearchMatrix = [];
        this.validationMessage = '';
        this.searchInType = this.sessionManager.ticketFilters == null ? 'My' : (this.sessionManager.ticketFilters.length > 0 ? 'Filter' : 'All');
        this.dateSearch = { 'Option': "0", 'DateField': "Registration", 'OpenedStartDatePicker': false, 'OpenedEndDatePicker': false };
        this.currentFilter = null;
        this.datePickerClosed = true;
        this.timeoutIds = [];
        this.dateClass = (cellDate, view) => {
            const day = cellDate.getDate();
            setTimeout(() => { GlobalFunctions.formatDaysWithLeadingZeros(); });
            // handle UI representation of day
            if (!GlobalFunctions.isEmpty(view) && view.toLowerCase() == 'month')
                return (day >= 1 && day <= 9) ? 'custom-cell' : '';
        };
        this.pendingTicketCountReceived = this.pendingTicketCountReceived.bind(this);
    }
    ngOnInit() {
        this.updatePendingCount();
        this.initAdvanceSearchMatrix();
        this.initializeDateRangeOption();
        this.setHandlerTags();
    }
    ngOnDestroy() {
        this.timeoutIds.forEach(timeoutId => clearTimeout(timeoutId));
    }
    setHandlerTags() {
        switch (this.currentHandlerType.option) {
            case 'Employee':
                return this.handlerTagItems = this.cacheManager.getEmployeeList(true);
            case 'Department':
                return this.handlerTagItems = this.cacheManager.getDepartmentList();
            case 'Mailbox':
                return this.handlerTagItems = this.cacheManager.getTaskMailboxList(false);
        }
    }
    changedHandlerType() {
        this.setHandlerTags();
        this.handlerTags = [];
        document.getElementById('ticketHandlerTagControl')?.focus();
    }
    ;
    search() {
        if (this.validate()) {
            this.sessionManager.startSessionIfPossible('ticket', ScreenMode.List);
            this.searchService.isAdvancedSearch = true;
            this.searchService.advanceSearch({ searchDto: this.prepareSearchDto(), searchFrom: 'dashboard', searchType: 'TICKET' });
        }
    }
    ;
    initAdvanceSearchMatrix() {
        let contactHistoryAdvancedSearchItem = null;
        //Customer Name
        contactHistoryAdvancedSearchItem = new AdvancedSearchItem();
        contactHistoryAdvancedSearchItem.SearchCriteria = new StringCriteriaDto();
        contactHistoryAdvancedSearchItem.SearchCriteria.DisplayName = "CUSTOMER";
        contactHistoryAdvancedSearchItem.SearchCriteria.IsInUse = true;
        contactHistoryAdvancedSearchItem.SearchCriteria.CompareType = 1;
        contactHistoryAdvancedSearchItem.SearchCriteria.Name = TicketSearchField.Customer;
        contactHistoryAdvancedSearchItem.TypeOfSearchCriteria = "StringCriteria";
        contactHistoryAdvancedSearchItem.PlaceholderText = this.translateService.instant("LBL_SEARCH_KEYWORD");
        this.advancedSearchMatrix.push(contactHistoryAdvancedSearchItem);
        //Third Party
        contactHistoryAdvancedSearchItem = new AdvancedSearchItem();
        contactHistoryAdvancedSearchItem.SearchCriteria = new StringCriteriaDto();
        contactHistoryAdvancedSearchItem.SearchCriteria.DisplayName = "THIRD_PARTY";
        contactHistoryAdvancedSearchItem.SearchCriteria.IsInUse = true;
        contactHistoryAdvancedSearchItem.SearchCriteria.CompareType = 1;
        contactHistoryAdvancedSearchItem.SearchCriteria.Name = TicketSearchField.ThirdParty;
        contactHistoryAdvancedSearchItem.TypeOfSearchCriteria = "StringCriteria";
        contactHistoryAdvancedSearchItem.PlaceholderText = this.translateService.instant("LBL_SEARCH_KEYWORD");
        this.advancedSearchMatrix.push(contactHistoryAdvancedSearchItem);
        //Ticket Number
        contactHistoryAdvancedSearchItem = new AdvancedSearchItem();
        contactHistoryAdvancedSearchItem.SearchCriteria = new NumericCriteriaDto();
        contactHistoryAdvancedSearchItem.SearchCriteria.DisplayName = "NUMBER";
        contactHistoryAdvancedSearchItem.SearchCriteria.IsInUse = true;
        contactHistoryAdvancedSearchItem.SearchCriteria.CompareType = 0;
        contactHistoryAdvancedSearchItem.SearchCriteria.Value = null;
        contactHistoryAdvancedSearchItem.SearchCriteria.Name = TicketSearchField.Number;
        contactHistoryAdvancedSearchItem.TypeOfSearchCriteria = "NumericCriteria";
        contactHistoryAdvancedSearchItem.PlaceholderText = this.translateService.instant("LBL_SEARCH_KEYWORD");
        this.advancedSearchMatrix.push(contactHistoryAdvancedSearchItem);
        //Phone Number
        contactHistoryAdvancedSearchItem = new AdvancedSearchItem();
        contactHistoryAdvancedSearchItem.SearchCriteria = new StringCriteriaDto();
        contactHistoryAdvancedSearchItem.SearchCriteria.DisplayName = "PHONE_NUMBER";
        contactHistoryAdvancedSearchItem.SearchCriteria.IsInUse = true;
        contactHistoryAdvancedSearchItem.SearchCriteria.Name = TicketSearchField.ContactPhoneNumber;
        contactHistoryAdvancedSearchItem.SearchCriteria.CompareType = 1;
        contactHistoryAdvancedSearchItem.TypeOfSearchCriteria = "StringCriteria";
        contactHistoryAdvancedSearchItem.IsComparisonOperatorEnabled = false;
        contactHistoryAdvancedSearchItem.PlaceholderText = this.translateService.instant("LBL_SEARCH_KEYWORD");
        this.advancedSearchMatrix.push(contactHistoryAdvancedSearchItem);
        //Mobile Number
        contactHistoryAdvancedSearchItem = new AdvancedSearchItem();
        contactHistoryAdvancedSearchItem.SearchCriteria = new StringCriteriaDto();
        contactHistoryAdvancedSearchItem.SearchCriteria.DisplayName = "MOBILE_NUMBER";
        contactHistoryAdvancedSearchItem.SearchCriteria.IsInUse = true;
        contactHistoryAdvancedSearchItem.SearchCriteria.Name = TicketSearchField.ContactMobileNumber;
        contactHistoryAdvancedSearchItem.SearchCriteria.CompareType = 1;
        contactHistoryAdvancedSearchItem.TypeOfSearchCriteria = "StringCriteria";
        contactHistoryAdvancedSearchItem.IsComparisonOperatorEnabled = false;
        contactHistoryAdvancedSearchItem.PlaceholderText = this.translateService.instant("LBL_SEARCH_KEYWORD");
        this.advancedSearchMatrix.push(contactHistoryAdvancedSearchItem);
        //Email
        contactHistoryAdvancedSearchItem = new AdvancedSearchItem();
        contactHistoryAdvancedSearchItem.SearchCriteria = new StringCriteriaDto();
        contactHistoryAdvancedSearchItem.SearchCriteria.DisplayName = "EMAIL";
        contactHistoryAdvancedSearchItem.SearchCriteria.IsInUse = true;
        contactHistoryAdvancedSearchItem.SearchCriteria.Name = TicketSearchField.ContactEmail;
        contactHistoryAdvancedSearchItem.SearchCriteria.CompareType = 1;
        contactHistoryAdvancedSearchItem.TypeOfSearchCriteria = "StringCriteria";
        contactHistoryAdvancedSearchItem.IsComparisonOperatorEnabled = false;
        contactHistoryAdvancedSearchItem.PlaceholderText = this.translateService.instant("LBL_SEARCH_KEYWORD");
        this.advancedSearchMatrix.push(contactHistoryAdvancedSearchItem);
        //Question
        contactHistoryAdvancedSearchItem = new AdvancedSearchItem();
        contactHistoryAdvancedSearchItem.SearchCriteria = new StringCriteriaDto();
        contactHistoryAdvancedSearchItem.SearchCriteria.DisplayName = "DESCRIPTION";
        contactHistoryAdvancedSearchItem.SearchCriteria.IsInUse = true;
        contactHistoryAdvancedSearchItem.SearchCriteria.Name = TicketSearchField.Description;
        contactHistoryAdvancedSearchItem.SearchCriteria.CompareType = 1;
        contactHistoryAdvancedSearchItem.TypeOfSearchCriteria = "StringCriteria";
        contactHistoryAdvancedSearchItem.IsComparisonOperatorEnabled = false;
        contactHistoryAdvancedSearchItem.PlaceholderText = this.translateService.instant("LBL_SEARCH_KEYWORD");
        this.advancedSearchMatrix.push(contactHistoryAdvancedSearchItem);
        //Answer
        contactHistoryAdvancedSearchItem = new AdvancedSearchItem();
        contactHistoryAdvancedSearchItem.SearchCriteria = new StringCriteriaDto();
        contactHistoryAdvancedSearchItem.SearchCriteria.DisplayName = "RESULT";
        contactHistoryAdvancedSearchItem.SearchCriteria.IsInUse = true;
        contactHistoryAdvancedSearchItem.SearchCriteria.Name = TicketSearchField.Result;
        contactHistoryAdvancedSearchItem.SearchCriteria.CompareType = 1;
        contactHistoryAdvancedSearchItem.TypeOfSearchCriteria = "StringCriteria";
        contactHistoryAdvancedSearchItem.IsComparisonOperatorEnabled = false;
        contactHistoryAdvancedSearchItem.PlaceholderText = this.translateService.instant("LBL_SEARCH_KEYWORD");
        this.advancedSearchMatrix.push(contactHistoryAdvancedSearchItem);
    }
    ;
    prepareSearchDto() {
        let searchDto = new SearchDto();
        searchDto.StringCriteriaList = [];
        searchDto.NumericCriteriaList = [];
        searchDto.DateCriteriaList = [];
        searchDto.EnumCriteriaList = [];
        this.searchService.advancedSearchQuery = '';
        let searchContentType = new Object();
        searchContentType.SearchCriteriaField = [];
        for (let item in this.advancedSearchMatrix) {
            if (this.advancedSearchMatrix[item].SearchCriteria.Value != null && this.advancedSearchMatrix[item].SearchCriteria.Value != "") {
                if (this.advancedSearchMatrix[item].SearchCriteria.TypeOfCompareType[this.advancedSearchMatrix[item].SearchCriteria.CompareType].criteriaChanged) {
                    let searchField = new Object();
                    searchField._Name = this.advancedSearchMatrix[item].SearchCriteria.Name;
                    searchField._Value = this.advancedSearchMatrix[item].SearchCriteria.CompareType;
                    searchContentType.SearchCriteriaField.push(searchField);
                }
                if (!GlobalFunctions.isEmpty(this.searchService.advancedSearchQuery))
                    this.searchService.advancedSearchQuery += ' , ';
                this.setAdvancedSearchQuery(this.advancedSearchMatrix[item].SearchCriteria, this.advancedSearchMatrix[item].TypeOfSearchCriteria);
                switch (this.advancedSearchMatrix[item].TypeOfSearchCriteria) {
                    case 'StringCriteria':
                        searchDto.StringCriteriaList.push(this.advancedSearchMatrix[item].SearchCriteria);
                        break;
                    case 'NumericCriteria':
                        searchDto.NumericCriteriaList.push(this.advancedSearchMatrix[item].SearchCriteria);
                        break;
                    case 'DateCriteria':
                        searchDto.DateCriteriaList.push(this.advancedSearchMatrix[item].SearchCriteria);
                        break;
                    case 'EnumCriteria':
                        searchDto.EnumCriteriaList.push(this.advancedSearchMatrix[item].SearchCriteria);
                        break;
                }
            }
        }
        //Handler
        if (this.handlerTags && this.handlerTags.length > 0) {
            let handlerSearchCriteria = new StringCriteriaDto();
            handlerSearchCriteria.IsInUse = true;
            handlerSearchCriteria.DisplayName = "HANDLER";
            handlerSearchCriteria.Name = TicketSearchField.Handler;
            handlerSearchCriteria.CompareType = 1;
            handlerSearchCriteria.Value = "";
            let handlerList = "";
            for (let i = 0; i < this.handlerTags.length; i++) {
                if (GlobalFunctions.isEmpty(handlerSearchCriteria.Value)) {
                    handlerSearchCriteria.Value = this.handlerTags[i].Id;
                    handlerList = "'" + this.handlerTags[i].text + "'";
                }
                else {
                    handlerSearchCriteria.Value += ";" + this.handlerTags[i].Id;
                    handlerList += ",'" + this.handlerTags[i].text + "'";
                }
            }
            searchDto.StringCriteriaList.push(handlerSearchCriteria);
            if (!GlobalFunctions.isEmpty(this.searchService.advancedSearchQuery))
                this.searchService.advancedSearchQuery += ' , ';
            this.searchService.advancedSearchQuery += "{" + this.translateService.instant("LBL_HANDLER") + "}: " + (handlerList.slice(0, -1));
        }
        //Date
        if (!GlobalFunctions.isEmpty(this.dateSearch.FromDate) && !GlobalFunctions.isEmpty(this.dateSearch.ToDate)) {
            let dateSearchCriteria = new DateCriteriaDto();
            dateSearchCriteria.CompareType = DateCompareType.Between;
            if (this.dateSearch.DateField === "Registration") {
                dateSearchCriteria.DisplayName = "REGISTRATION_DATE";
                dateSearchCriteria.Name = TicketSearchField.CreatedDate;
                ;
            }
            else {
                dateSearchCriteria.Name = TicketSearchField.ClosedDate;
                dateSearchCriteria.DisplayName = "HANDLED_DATE";
            }
            dateSearchCriteria.Value = this.dateSearch.FromDate.toString('M/d/yyyy HH:mm:ss');
            dateSearchCriteria.ToDate = this.dateSearch.ToDate.toString('M/d/yyyy HH:mm:ss');
            searchDto.DateCriteriaList.push(dateSearchCriteria);
            if (!GlobalFunctions.isEmpty(this.searchService.advancedSearchQuery))
                this.searchService.advancedSearchQuery += ' , ';
            this.setAdvancedSearchQuery(dateSearchCriteria, "DateCriteria");
        }
        ;
        switch (this.searchInType) {
            case 'Created': {
                const createdByMeSearchCriteria = new StringCriteriaDto();
                createdByMeSearchCriteria.IsInUse = true;
                createdByMeSearchCriteria.DisplayName = "CREATED";
                createdByMeSearchCriteria.Name = TicketSearchField.CreatedById;
                createdByMeSearchCriteria.CompareType = 0;
                createdByMeSearchCriteria.Value = GlobalFunctions.getLoggedInUserId();
                searchDto.StringCriteriaList.push(createdByMeSearchCriteria);
                break;
            }
            case 'Filter': {
                this.ticketService.addFilterCriteriaToSearchDto(this.currentFilter, searchDto);
                this.searchService.advancedSearchQuery = this.translateService.instant("LBL_FILTER") + ": " + this.currentFilter.Title;
                break;
            }
            case 'My': {
                const handlerSearchCriteria = new StringCriteriaDto();
                handlerSearchCriteria.IsInUse = true;
                handlerSearchCriteria.DisplayName = "HANDLER";
                handlerSearchCriteria.Name = TicketSearchField.Handler;
                handlerSearchCriteria.CompareType = 1;
                handlerSearchCriteria.Value = GlobalFunctions.getLoggedInUserId();
                searchDto.StringCriteriaList.push(handlerSearchCriteria);
                break;
            }
        }
        if (GlobalFunctions.isEmpty(this.searchService.advancedSearchQuery)) {
            switch (this.searchInType) {
                case "All":
                    this.searchService.advancedSearchQuery = this.translateService.instant("LBL_ALL") + " " + this.translateService.instant("LBL_TICKETS");
                    break;
                case "Created":
                    this.searchService.advancedSearchQuery = this.translateService.instant("LBL_CREATED_BY_ME");
                    break;
                case "My":
                    this.searchService.advancedSearchQuery = this.translateService.instant("LBL_MY") + " " + this.translateService.instant("LBL_TICKETS");
                    break;
            }
        }
        return searchDto;
    }
    ;
    changeVisibility(advancedSearchItem) {
        advancedSearchItem.IsToDateInputBoxEnabled = false;
        advancedSearchItem.SearchCriteria.TypeOfCompareType[advancedSearchItem.SearchCriteria.CompareType].criteriaChanged = true;
        if (advancedSearchItem.IsCalenderEnabled && advancedSearchItem.SearchCriteria.CompareType == 5) {
            advancedSearchItem.IsToDateInputBoxEnabled = true;
        }
    }
    ;
    validate() {
        let count = 0;
        this.validationMessage = '';
        for (let item in this.advancedSearchMatrix) {
            if (this.advancedSearchMatrix[item].IsRequired)
                break;
            if (this.advancedSearchMatrix[item].TypeOfSearchCriteria == "DateCriteria") {
                if (GlobalFunctions.isEmpty(this.advancedSearchMatrix[item].FromDate)) {
                    this.advancedSearchMatrix[item].SearchCriteria.Value = this.advancedSearchMatrix[item].FromDate;
                    count++;
                }
                else
                    this.advancedSearchMatrix[item].SearchCriteria.Value = this.advancedSearchMatrix[item].FromDate;
                if (this.advancedSearchMatrix[item].SearchCriteria.CompareType == 5) {
                    if (GlobalFunctions.isEmpty(this.advancedSearchMatrix[item].ToDate)) {
                        this.advancedSearchMatrix[item].SearchCriteria.ToDate = this.advancedSearchMatrix[item].ToDate;
                        count++;
                    }
                    else
                        this.advancedSearchMatrix[item].SearchCriteria.ToDate = this.advancedSearchMatrix[item].ToDate;
                }
                else
                    this.advancedSearchMatrix[item].SearchCriteria.ToDate = this.advancedSearchMatrix[item].ToDate = "";
            }
            else if (GlobalFunctions.isEmpty(this.advancedSearchMatrix[item].SearchCriteria.Value) || this.advancedSearchMatrix[item].SearchCriteria.Value == 0)
                count++;
        }
        if (count < this.advancedSearchMatrix.length) {
            for (let item in this.advancedSearchMatrix) {
                if (this.advancedSearchMatrix[item].SearchCriteria.Value != undefined && this.advancedSearchMatrix[item].SearchCriteria.Value != "") {
                    if (this.advancedSearchMatrix[item].TypeOfSearchCriteria != "DateCriteria" && this.advancedSearchMatrix[item].TypeOfSearchCriteria != "NumericCriteria") {
                        if (this.advancedSearchMatrix[item].SearchCriteria.CompareType != 0 && this.advancedSearchMatrix[item].SearchCriteria.Value.length < 3) {
                            this.validationMessage = this.translateService.instant("LBL_QUERY_LENGTH_ADVANCED_SEARCH_ERROR");
                            break;
                        }
                    }
                    if (this.advancedSearchMatrix[item].RegularExpressionValidator != null) {
                        //if (!this.isValid(this.advancedSearchMatrix[item].SearchCriteria.Value, this.advancedSearchMatrix[item].RegularExpressionValidator)) {
                        //  this.validationMessage = this.advancedSearchMatrix[item].ValidationMessage;
                        //  break;
                        //}
                    }
                }
            }
        }
        if (!GlobalFunctions.isEmpty(this.dateSearch.FromDate) || !GlobalFunctions.isEmpty(this.dateSearch.ToDate)) {
            if (GlobalFunctions.isEmpty(this.dateSearch.FromDate))
                this.validationMessage = this.translateService.instant("LBL_WRONG_DATE_FORMAT_ERROR");
            else if (GlobalFunctions.isEmpty(this.dateSearch.ToDate))
                this.validationMessage = this.translateService.instant("LBL_WRONG_DATE_FORMAT_ERROR");
            else if (this.dateSearch.ToDate < this.dateSearch.FromDate)
                this.validationMessage = this.translateService.instant("LBL_INVALID_DATE_BETWEEN_ERROR");
        }
        else
            this.validationMessage = this.translateService.instant("LBL_REPORT_HELP_TEXT4");
        if (this.searchInType === "Filter" && !this.validationMessage && !this.currentFilter)
            this.validationMessage = this.translateService.instant("LBL_SELECT_ANY_FILTER");
        return this.validationMessage ? false : true;
    }
    ;
    setAdvancedSearchQuery(searchDto, TypeOfSearchCriteria) {
        try {
            let criteria;
            let searchQuery;
            searchDto.TypeOfCompareType.forEach((value, key) => {
                if (key != null && key == searchDto.CompareType)
                    criteria = value.Text;
            });
            let searchDtoToDate;
            if (TypeOfSearchCriteria == "DateCriteria") {
                searchQuery = this.datePipe.transform(searchDto.Value, this.sessionManager.defaultOptions.defaultDateFormat, "", CommonHelper.getLanguageCode());
                searchQuery = GlobalFunctions.removeDotAfterMonth(searchQuery);
                if (searchDto.CompareType == "5") {
                    searchDtoToDate = this.datePipe.transform(searchDto.ToDate, this.sessionManager.defaultOptions.defaultDateFormat, "", CommonHelper.getLanguageCode());
                    searchDtoToDate = GlobalFunctions.removeDotAfterMonth(searchDtoToDate);
                    searchQuery += " - " + searchDtoToDate;
                }
            }
            searchQuery = searchQuery ? searchQuery : searchDto.Value;
            this.searchService.advancedSearchQuery += '{' + this.translateService.instant('LBL_' + searchDto.DisplayName) + '} ' + this.translateService.instant("LBL_" + criteria.toUpperCase()) + " " + "'" + searchQuery + "'" + " ";
        }
        catch (e) { }
    }
    ;
    openDatePicker(isStartDate) {
        if (isStartDate)
            this.dateSearch.OpenedStartDatePicker = !this.dateSearch.OpenedStartDatePicker;
        else
            this.dateSearch.OpenedEndDatePicker = !this.dateSearch.OpenedEndDatePicker;
    }
    ;
    changeStartDate(inputId) {
        GlobalFunctions.setDateFormat(inputId, this.dateSearch.FromDate, this.sessionManager.defaultOptions.defaultDateFormat, this.datePipe);
        if (this.dateSearch.Option === "0" && !GlobalFunctions.isEmpty(this.dateSearch.FromDate) && GlobalFunctions.isEmpty(this.dateSearch.ToDate))
            this.dateSearch.ToDate = this.dateSearch.FromDate;
        JkcDatePickerHelper.isDatePickerClosed = true;
    }
    ;
    clickedOut() {
        setTimeout(() => {
            //date format will not change when click outside.
            if (!GlobalFunctions.isEmpty(this.dateSearch.FromDate))
                GlobalFunctions.setDateFormat("selectStartDatePicker", this.dateSearch.FromDate, this.sessionManager.defaultOptions.defaultDateFormat, this.datePipe);
            if (!GlobalFunctions.isEmpty(this.dateSearch.ToDate))
                GlobalFunctions.setDateFormat("selectEndDatePicker", this.dateSearch.ToDate, this.sessionManager.defaultOptions.defaultDateFormat, this.datePipe);
        }, 10);
    }
    changeDateOption() {
        switch (this.dateSearch.Option) {
            case "0":
                {
                    this.dateSearch.FromDate = null;
                    this.dateSearch.ToDate = null;
                    break;
                }
            case "1":
                {
                    this.dateSearch.FromDate = new Date();
                    this.dateSearch.ToDate = new Date();
                    break;
                }
            case "2":
                {
                    let fromDate = new this.dateJS();
                    fromDate.setDate(fromDate.getDate() - 1);
                    this.dateSearch.FromDate = fromDate;
                    this.dateSearch.ToDate = fromDate;
                    break;
                }
            case "3":
                {
                    let fromDate = new this.dateJS();
                    fromDate.setDate(fromDate.getDate() - 1);
                    this.dateSearch.FromDate = fromDate;
                    this.dateSearch.ToDate = new Date();
                    break;
                }
            case "4":
                {
                    let fromDate = new Date();
                    fromDate.setDate(fromDate.getDate() - 7);
                    this.dateSearch.FromDate = fromDate;
                    this.dateSearch.ToDate = new Date();
                    break;
                }
            case "5":
                {
                    let fromDate = new this.dateJS();
                    fromDate.setDate(fromDate.getDate() - 30);
                    this.dateSearch.FromDate = fromDate;
                    this.dateSearch.ToDate = new Date();
                    break;
                }
        }
        this.clickedOut();
    }
    ;
    initializeDateRangeOption() {
        this.dateSearch.Option = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Tickets_Entities_Ticket, "DEFAULTSEARCHDATERANGE") || '0';
        this.changeDateOption();
    }
    updatePendingCount() {
        if (this.applicationSettingManager.refreshCountSetting.Ticket.OnMenu) {
            this.messageId = GlobalFunctions.createGuid();
            this.sessionManager.pendingCount.MyTicketCount = "...";
            this.ticketService.getPendingTicketCount(this.messageId, this.pendingTicketCountReceived);
        }
    }
    ;
    pendingTicketCountReceived(message) {
        if (message?.MessageId == this.messageId)
            this.ticketService.updatePendingTicketCount(message.PendingItemsCountDtoList);
    }
    ;
    initDatePickerState(event, inputId) {
        this.clickedOut();
        JkcDatePickerHelper.setOverlayBackgroundColor(false, this.renderer);
        JkcDatePickerHelper.isDatePickerClosed = false;
        this.dateAdapter.setLocale(CommonHelper.getLanguageCode());
    }
};
__decorate([
    HostListener("document:click")
], TicketSearchCriteriaComponent.prototype, "clickedOut", null);
TicketSearchCriteriaComponent = __decorate([
    Component({
        selector: 'ticket-search-criteria',
        templateUrl: './ticket-search-criteria.component.html',
        styleUrls: ['./ticket-search-criteria.component.scss']
    })
], TicketSearchCriteriaComponent);
export { TicketSearchCriteriaComponent };
//# sourceMappingURL=ticket-search-criteria.component.js.map