var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
import { Component, Inject } from '@angular/core';
import { MAT_DIALOG_DATA } from '@angular/material/dialog';
import { RecordSelection } from 'src/app/core/enums/common-enums';
import { SubSink } from 'subsink';
import { EntityFqdn } from '../../../../core/enums/core-enums';
import { EmailSource } from '../../../../core/enums/global-enum';
import { SearchObject } from '../../../../core/models/common/search-objectDto';
import { ContentType } from '../../../../core/models/jkc-object/jkc-object';
import { RoutePath } from '../../../../shared/constants';
import { GlobalFunctions } from '../../../../shared/global-functions';
import { DialogHelper } from '../../../../shared/helper/dialog-helper';
import { BaseDialogComponent } from '../../../common/base-dialog.component';
import { SearchPopupComponent } from '../../../common/search-popup/search-popup.component';
let TicketLinkEntityComponent = class TicketLinkEntityComponent extends BaseDialogComponent {
    constructor(router, dialog, chatService, ticketService, sessionManager, shortcutManager, dialogData, translateService, dialogRef) {
        super();
        this.router = router;
        this.dialog = dialog;
        this.chatService = chatService;
        this.ticketService = ticketService;
        this.sessionManager = sessionManager;
        this.shortcutManager = shortcutManager;
        this.dialogData = dialogData;
        this.translateService = translateService;
        this.dialogRef = dialogRef;
        this.linkTypeTags = [];
        this.linkTypeError = '';
        this.linkType = "Ticket";
        this.ticketEntity = null;
        this.linkToTicketTitle = this.translateService.instant("LBL_LINK_TO_TICKET").replace(/{TICKETTITLE}/g, this.translateService.instant("LBL_TICKET"));
        this.subs = new SubSink();
        this.linkToTicketResponseReceived = this.linkToTicketResponseReceived.bind(this);
    }
    ngOnInit() {
        this.sessionManager.showUIOnTop = false;
        this.openSearchPopup(this.linkType);
        this.shortcutManager.bind('LBL_SHORTCUT_SAVE_BUTTON', () => this.linkEntityToTicket());
    }
    ngOnDestroy() {
        this.subs.unsubscribe();
        this.shortcutManager.unbind('LBL_SHORTCUT_SAVE_BUTTON');
    }
    searchLinkType() {
        this.openSearchPopup(this.linkType);
    }
    ;
    openSearchPopup(entity) {
        DialogHelper.openDialog(this.dialog, SearchPopupComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { name: entity, recordSelection: RecordSelection.Single }).afterClosed().subscribe(searchEntity => {
            if (!GlobalFunctions.isEmpty(searchEntity)) {
                GlobalFunctions.setPlaceholder("#linkTypeControl", "");
                this.linkTypeTags = [];
                searchEntity.StringRepresentation = searchEntity.Description;
                searchEntity.text = searchEntity.StringRepresentation;
                this.ticketEntity = searchEntity;
                this.linkTypeTags.push(searchEntity);
                this.linkEntityToTicket();
            }
        });
    }
    ;
    linkEntityToTicket() {
        if (this.linkTypeTags.length > 0) {
            let destinationEntityList = [];
            this.startSpinner();
            let sourceEntity = new SearchObject(this.ticketEntity.Id, this.ticketEntity.RelatedEntityFqdn, this.ticketEntity.ObjectSource, this.ticketEntity.ExternalId);
            if (GlobalFunctions.isEmpty(this.dialogData.isOpenedFrom))
                destinationEntityList.push(new SearchObject(this.sessionManager.selectedEntity.Id, GlobalFunctions.toContentType(GlobalFunctions.getObjectTypeName(this.sessionManager.selectedEntity.RelatedEntityFqdn)), this.sessionManager.selectedEntity.ObjectSource, ""));
            else if (this.dialogData.isOpenedFrom.toLowerCase().indexOf('chat') >= 0)
                destinationEntityList.push(new SearchObject(this.chatService.chatMessage.Id, ContentType.Chat, this.chatService.chatMessage.ObjectSource, ""));
            this.ticketService.linkRelatedEntity(sourceEntity, destinationEntityList, this.linkToTicketResponseReceived);
        }
    }
    ;
    linkToTicketResponseReceived(response) {
        this.stopSpinner();
        if (response.Result == 0) {
            if (!GlobalFunctions.isEmpty(response.EntityId) && this.sessionManager.selectedEntity != null && !GlobalFunctions.isEmpty(this.sessionManager.selectedEntity.RelatedEntityFqdn) && GlobalFunctions.toContentType(GlobalFunctions.getObjectTypeName(this.sessionManager.selectedEntity.RelatedEntityFqdn)) == ContentType.Email) {
                this.sessionManager.removeFromDetailViewCachedEntityList(this.sessionManager.selectedEntity.Id);
                this.sessionManager.selectedEntity.Id = response.EntityId;
                if (this.sessionManager.selectedEntity.Header != null) {
                    this.sessionManager.selectedEntity.Header.Id = response.EntityId;
                    this.sessionManager.selectedEntity.Header.EmailSource = EmailSource[EmailSource.Archive];
                }
                this.sessionManager.addItemsToDetailViewCacheList(this.sessionManager.selectedEntity, GlobalFunctions.toString(EntityFqdn[EntityFqdn.Decos_Kcs_Email_Entities_Email]), true);
            }
            let ticketDetailUrl = `${RoutePath.DETAIL_PATH}/ticket/${this.ticketEntity.Id}`;
            this.sessionManager.loadedFromRelatedView = false;
            this.sessionManager.selectedEntity = this.ticketEntity;
            this.sessionManager.selectedEntity.locationUrl = ticketDetailUrl;
            this.sessionManager.addBreadcrumbItems([this.ticketEntity], null, RoutePath.DETAIL_PATH);
            this.router.navigate([ticketDetailUrl]);
            this.close();
            this.sessionManager.addEntityToSession(this.sessionManager.selectedEntity, "Ticket");
        }
        else
            this.linkTypeError = "LBL_MESSAGE_LINK_TO_ENTITY_FAILED";
    }
    ;
    close(result) {
        this.dialogRef.close(result);
    }
};
TicketLinkEntityComponent = __decorate([
    Component({
        selector: 'ticket-link-entity',
        templateUrl: './ticket-link-entity.component.html',
        styleUrls: ['./ticket-link-entity.component.scss']
    }),
    __param(6, Inject(MAT_DIALOG_DATA))
], TicketLinkEntityComponent);
export { TicketLinkEntityComponent };
//# sourceMappingURL=ticket-link-entity.component.js.map