var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, ViewChild } from '@angular/core';
import { SubSink } from 'subsink';
import { FieldDataType, HandlerType, OperationType, ScreenMode } from '../../../../core/enums/common-enums';
import { EntityFqdn } from '../../../../core/enums/core-enums';
import { TicketStatus } from '../../../../core/enums/ticket-enum';
import { TicketHandlerDto } from '../../../../core/models/ticket/ticket-handlerDto';
import { TicketHistoryDto } from '../../../../core/models/ticket/ticket-historyDto';
import { BroadCastEventKeys, EntityName, RoutePath } from '../../../../shared/constants';
import { GlobalFunctions } from '../../../../shared/global-functions';
import { DialogHelper } from '../../../../shared/helper/dialog-helper';
import { ExceptionHelper } from '../../../../shared/helper/exception-helper';
import { BaseDialogComponent } from '../../../common/base-dialog.component';
import { MessageboxComponent } from '../../../common/messagebox/messagebox.component';
let TicketHandleComponent = class TicketHandleComponent extends BaseDialogComponent {
    constructor(router, dialog, cacheManager, eventProvider, ticketService, dialogManager, sessionManager, shortcutManager, translateService, applicationSettingManager, integrationSettingManager) {
        super();
        this.router = router;
        this.dialog = dialog;
        this.cacheManager = cacheManager;
        this.eventProvider = eventProvider;
        this.ticketService = ticketService;
        this.dialogManager = dialogManager;
        this.sessionManager = sessionManager;
        this.shortcutManager = shortcutManager;
        this.translateService = translateService;
        this.applicationSettingManager = applicationSettingManager;
        this.integrationSettingManager = integrationSettingManager;
        this.dateJS = Date;
        this.title = '';
        this.reasonList = [];
        this.answerList = [];
        this.reasonIndex = null;
        this.answerIndex = null;
        this.enableReasonValidation = false;
        this.enableAnswerValidation = false;
        this.ticketDto = this.sessionManager.selectedEntity;
        this.ticketHandleOption = 'Completed';
        this.ticketHandlingStatusTitle = this.translateService.instant('LBL_ANSWER');
        this.answerFreeText = '';
        this.reasonFreeText = '';
        this.validationMessage = '';
        this.hasReassignRights = false;
        this.handlerTypeOption = this.applicationSettingManager.getUIHandlerTypeOption();
        this.handlerTags = [];
        this.handlerTagItems = [];
        this.reassignReasonFreeText = '';
        this.enableReassignReasonValidation = false;
        this.reassignReasonList = [];
        this.reassignReasonIndex = null;
        this.currentHandlerType = 'Employee';
        this.assignedHandler = null;
        this.fieldDataTypeEnum = FieldDataType;
        this.subs = new SubSink();
        this.timeoutIds = [];
        this.enableDepartmentNameInHandler = this.applicationSettingManager.isDepartmentNameInHandlerEnabled();
        this.handleTicketResponse = this.handleTicketResponse.bind(this);
        this.assignTicketResponse = this.assignTicketResponse.bind(this);
        this.attemptTicketResponse = this.attemptTicketResponse.bind(this);
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.JSPANEL_RESIZE).subscribe(() => this.resize());
    }
    ngOnInit() {
        try {
            if (this.ticketDto?.HistoryList?.length > 0) {
                this.ticketDto.HistoryList.sort((a, b) => a.DateRecorded < b.DateRecorded ? 1 : -1);
                this.assignedHandler = jlinq.from(this.ticketDto.HistoryList).equals("Status", 1).first();
            }
            this.sessionManager.startSessionIfPossible("TICKET", ScreenMode.Edit);
            this.title = (this.ticketDto.TicketTypeText + " (" + this.translateService.instant('LBL_HANDLE') + ")").toUpperCase();
            this.shortcutManager.bind('LBL_SHORTCUT_SAVE_BUTTON', () => this.save());
            this.subs.sink = this.integrationSettingManager.cacheHandlerSettings().subscribe(() => this.initialize());
            this.setHandlerTags();
        }
        catch (exception) {
            ExceptionHelper.showException(this.dialog, exception, true);
        }
    }
    ngOnDestroy() {
        this.shortcutManager.unbind('LBL_SHORTCUT_SAVE_BUTTON');
        this.subs.unsubscribe();
        this.timeoutIds.forEach(timeoutId => clearTimeout(timeoutId));
    }
    ticketHandleOptionChanged() {
        this.enableAnswerValidation = false;
        this.enableReasonValidation = false;
        this.enableReassignReasonValidation = false;
        switch (this.ticketHandleOption) {
            case 'Completed':
                {
                    this.ticketHandlingStatusTitle = this.translateService.instant('LBL_ANSWER');
                    this.changeAnswerOption();
                    break;
                }
            case 'NotCompleted':
                {
                    this.ticketHandlingStatusTitle = this.translateService.instant('LBL_REASON');
                    this.changeReasonOption();
                    break;
                }
            case 'Reassign':
                {
                    this.ticketHandlingStatusTitle = this.translateService.instant('LBL_REASON');
                    this.changeReassignReasonOption();
                    break;
                }
        }
    }
    ;
    changeReasonOption() {
        if (this.reasonIndex != null) {
            this.selectedReason = this.reasonList[this.reasonIndex];
            this.enableReasonValidation = (this.reasonList.length == (this.reasonIndex + 1));
        }
    }
    ;
    changeAnswerOption() {
        if (this.answerIndex != null) {
            this.selectedAnswer = this.answerList[this.answerIndex];
            this.enableAnswerValidation = (this.answerList.length == (this.answerIndex + 1));
        }
    }
    ;
    close() {
        this.dialogManager.removeComponent();
        this.sessionManager.closeJkcParentPanel();
    }
    ;
    save() {
        try {
            this.validationMessage = "";
            if ((this.ticketHandleOption == 'Reassign' && this.handlerTags.length === 0) || this.form.invalid)
                return;
            switch (this.ticketHandleOption) {
                case 'Completed':
                    {
                        this.handleTicketRequest();
                        break;
                    }
                case 'NotCompleted':
                    {
                        this.attemptTicketRequest();
                        break;
                    }
                case 'Reassign':
                    {
                        this.reassignTicket();
                        break;
                    }
            }
        }
        catch (exception) {
            ExceptionHelper.showException(this.dialog, exception, true);
        }
    }
    ;
    handleEscKey() {
        if (!GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) && this.sessionManager.jkcParentPanel.parameters.IsPanelExpanded)
            this.timeoutIds.push(setTimeout(() => this.close(), 10));
    }
    ;
    handleTicketRequest() {
        this.startSpinner();
        let ticketHistoryDto = new TicketHistoryDto();
        ticketHistoryDto.TicketId = this.ticketDto.Id;
        ticketHistoryDto.DateRecorded = new this.dateJS().toString('M/d/yyyy HH:mm:ss');
        ticketHistoryDto.Status = TicketStatus.Handled;
        ticketHistoryDto.Reason = this.selectedAnswer;
        ticketHistoryDto.ReasonFreeText = this.answerFreeText;
        ticketHistoryDto.CreatedById = GlobalFunctions.getLoggedInUserId();
        ticketHistoryDto.StatusFieldId = jlinq.from(this.ticketDto.TicketType.Fields).equals("Title", "Status").first().Id;
        this.ticketService.handleTicket(ticketHistoryDto, this.handleTicketResponse);
    }
    ;
    handleTicketResponse(result) {
        this.stopSpinner();
        this.eventProvider.BroadcastEvent(BroadCastEventKeys.FETCH_TICKET_STATISTIC);
        if (result?.Result == 0) {
            this.removeFromBreadcrumbList();
            this.close();
            this.router.navigate([RoutePath.DASHBOARD, RoutePath.LIST_PATH, EntityName.TICKET], { queryParams: { filter: 'my' } });
        }
        else {
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_TICKET'), textMsg: this.translateService.instant('LBL_MSG_FAILED_HANDLE_TICKET').replace(/{TICKETTITLE}/g, this.translateService.instant('LBL_TICKET')) });
            this.close();
        }
    }
    ;
    removeFromBreadcrumbList() {
        if (this.sessionManager.BreadcrumbItems && this.sessionManager.BreadcrumbItems.length > 0 && this.sessionManager.BreadcrumbItems.length > (this.sessionManager.selectedBreadcrumbIndex + 1) && this.sessionManager.BreadcrumbItems[this.sessionManager.selectedBreadcrumbIndex + 1][0].sourceUrl.indexOf('/list/ticket') != -1) {
            let index = this.sessionManager.selectedBreadcrumbIndex;
            let currentBreadcrumItem = this.sessionManager.BreadcrumbItems[index];
            this.sessionManager.BreadcrumbItems[index][0].isDeleted = true;
            if (index < this.sessionManager.BreadcrumbItems.length)
                index = index + 1;
            let breadCrumbItems = this.sessionManager.BreadcrumbItems[index];
            if (breadCrumbItems != undefined || breadCrumbItems != null) {
                breadCrumbItems.forEach(breadCrumbItem => {
                    if (currentBreadcrumItem != undefined && currentBreadcrumItem[0].itemData != null && breadCrumbItem.itemData.ObjectSourceDto != null && currentBreadcrumItem[0].itemData.Id == breadCrumbItem.itemData.ObjectSourceDto.Id) {
                        if (breadCrumbItems.length == 1)
                            breadCrumbItems[0].isDeleted = true;
                        else {
                            let index = breadCrumbItems.indexOf(breadCrumbItem);
                            breadCrumbItems.splice(index, 1);
                        }
                    }
                });
            }
        }
    }
    ;
    attemptTicketRequest() {
        let ticketHistoryDto = new TicketHistoryDto();
        ticketHistoryDto.TicketId = this.ticketDto.Id;
        ticketHistoryDto.DateRecorded = new this.dateJS().toString('M/d/yyyy HH:mm:ss');
        ticketHistoryDto.Status = TicketStatus.Attempted;
        ticketHistoryDto.Reason = this.selectedReason;
        ticketHistoryDto.ReasonFreeText = this.reasonFreeText;
        ticketHistoryDto.CreatedById = GlobalFunctions.getLoggedInUserId();
        this.startSpinner();
        this.ticketService.attemptTicket(ticketHistoryDto, this.attemptTicketResponse);
    }
    ;
    attemptTicketResponse(result) {
        this.stopSpinner();
        if (result?.Result == 0) {
            this.close();
            this.router.navigate([RoutePath.DASHBOARD, RoutePath.LIST_PATH, EntityName.TICKET], { queryParams: { filter: 'my' } });
        }
        else {
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_TICKET'), textMsg: this.translateService.instant('LBL_MSG_FAILED_ATTEMPT_TICKET').replace(/{TICKETTITLE}/g, this.translateService.instant('LBL_TICKET')) });
            this.close();
        }
    }
    ;
    reassignTicket() {
        if (this.handlerTags.length > 0) {
            let ticketHandlerList = [];
            let ticketHandlerDto = new TicketHandlerDto();
            ticketHandlerDto.HandlerId = this.handlerTags[0].Id;
            ticketHandlerDto.HandlerType = HandlerType[this.currentHandlerType];
            ticketHandlerList.push(ticketHandlerDto);
            let ticketHistoryDto = new TicketHistoryDto();
            ticketHistoryDto.TicketId = this.ticketDto.Id;
            ticketHistoryDto.Reason = this.selectedReassignReason;
            ticketHistoryDto.ReasonFreeText = this.reassignReasonFreeText;
            ticketHistoryDto.DateRecorded = new this.dateJS().toString('M/d/yyyy HH:mm:ss');
            ticketHistoryDto.Status = TicketStatus.Reassigned;
            ticketHistoryDto.CreatedById = GlobalFunctions.getLoggedInUserId();
            this.startSpinner();
            this.ticketService.assignTicket(ticketHistoryDto, ticketHandlerList, this.assignTicketResponse);
        }
    }
    ;
    assignTicketResponse(result) {
        this.stopSpinner();
        this.eventProvider.BroadcastEvent(BroadCastEventKeys.FETCH_TICKET_STATISTIC);
        if (result?.Result == 0) {
            this.close();
            this.router.navigate([RoutePath.DASHBOARD, RoutePath.LIST_PATH, EntityName.TICKET], { queryParams: { filter: 'my' } });
            if (!GlobalFunctions.isEmpty(this.sessionManager.BreadcrumbItems))
                this.sessionManager.BreadcrumbItems[this.sessionManager.selectedBreadcrumbIndex][0].isDeleted = true;
        }
        else
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_TICKET'), textMsg: this.translateService.instant('LBL_MSG_FAILED_ASSIGN_TICKET').replace(/{TICKETTITLE}/g, this.translateService.instant('LBL_TICKET')) });
    }
    ;
    setHandlerTags() {
        switch (this.currentHandlerType) {
            case 'Employee':
                return this.handlerTagItems = this.cacheManager.getEmployeeList(true);
            case 'Department':
                return this.handlerTagItems = this.cacheManager.getDepartmentList();
            case 'Mailbox':
                return this.handlerTagItems = this.cacheManager.getTaskMailboxList();
        }
    }
    changedHandlerType() {
        this.setHandlerTags();
        this.handlerTags = [];
        document.getElementById("assignHandlerTagsInputControl")?.focus();
    }
    ;
    changeReassignReasonOption() {
        if (this.reassignReasonIndex != null) {
            this.selectedReassignReason = this.reassignReasonList[this.reassignReasonIndex];
            this.enableReassignReasonValidation = (this.reassignReasonList.length == (this.reassignReasonIndex + 1));
        }
    }
    ;
    searchEmployee() {
        this.dialogManager.openJsPanelOrDialog('SEARCH_EMPLOYEE_POPUP_PANEL').afterClosed().subscribe(result => {
            if (result?.selectedEmployee) {
                result.selectedEmployee.text = result.selectedEmployee.StringRepresentation;
                this.handlerTags.push(result.selectedEmployee);
            }
        });
    }
    ;
    initialize() {
        this.setDefaultReason();
        this.setDefaultAnswer();
        this.setDefaultReassignReason();
        this.setReassignRights();
    }
    ;
    setDefaultReason() {
        try {
            this.timeoutIds.push(setTimeout(() => this.resize(), 300));
            let result = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Tickets_Entities_Ticket, "DEFAULTFAILEDATTEMPTREASONS");
            if (result != null && result != "") {
                result = result.replace(/\n/g, "\r");
                let splitResult = result.split("\r");
                if (splitResult != null && splitResult.length > 0) {
                    for (let index = 0; index < splitResult.length; index++) {
                        if (splitResult[index] != '')
                            this.reasonList.push(splitResult[index]);
                    }
                }
            }
            this.reasonList.push(this.translateService.instant('LBL_OTHER'));
            this.changeReasonOption();
        }
        catch (e) { }
    }
    ;
    setDefaultAnswer() {
        try {
            let result = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Tickets_Entities_Ticket, "DEFAULTANSWERS");
            if (result != null && result != "") {
                result = result.replace(/\n/g, "\r");
                let splitResult = result.split("\r");
                if (splitResult != null && splitResult.length > 0) {
                    for (let index = 0; index < splitResult.length; index++) {
                        if (splitResult[index] != '')
                            this.answerList.push(splitResult[index]);
                    }
                }
            }
            this.answerList.push(this.translateService.instant('LBL_OTHER'));
            this.changeAnswerOption();
        }
        catch (e) { }
    }
    ;
    setDefaultReassignReason() {
        let result = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Tickets_Entities_Ticket, "DEFAULTNOTFORMEREASONS");
        if (!GlobalFunctions.isEmpty(result)) {
            result = result.replace(/\n/g, "\r");
            let splitResult = result.split("\r");
            if (splitResult != null && splitResult.length > 0) {
                for (let index = 0; index < splitResult.length; index++) {
                    if (splitResult[index] != '')
                        this.reassignReasonList.push(splitResult[index]);
                }
            }
        }
        this.reassignReasonList.push(this.translateService.instant('LBL_OTHER'));
        this.changeReassignReasonOption();
    }
    ;
    setReassignRights() {
        let contentType = GlobalFunctions.toString(EntityFqdn[EntityFqdn.Decos_Kcs_Tickets_Entities_Ticket]);
        this.hasReassignRights = GlobalFunctions.hasRight(contentType, OperationType.Reassign, "");
    }
    ;
    resize() {
        let windowHeight = $(window).height();
        $("#jkcParentPanel").css({ 'max-height': (windowHeight - parseInt(this.sessionManager.jkcParentPanel?.parameters?.TopSpace) - 100 + "px") });
        let newHeight = $("#jkcParentPanel").height() - $("#handleTicketHeader").height() - $("#handleTicketFooter").height() + "px";
        $("#handleTicketContainer").height(newHeight);
        $('#' + this.sessionManager.jkcParentPanel?.parameters?.HeaderId).css({ 'width': ($("#jkcParentPanel").width()) });
        $('#' + this.sessionManager.jkcParentPanel?.parameters?.FooterId).css({ 'width': ($("#jkcParentPanel").width()) });
    }
};
__decorate([
    ViewChild('form')
], TicketHandleComponent.prototype, "form", void 0);
TicketHandleComponent = __decorate([
    Component({
        selector: 'ticket-handle',
        templateUrl: './ticket-handle.component.html',
        styleUrls: ['./ticket-handle.component.scss'],
        host: { '(window:resize)': 'resize()' }
    })
], TicketHandleComponent);
export { TicketHandleComponent };
//# sourceMappingURL=ticket-handle.component.js.map