var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { BaseDetailComponent } from 'src/app/components/common/base-detail.component';
import { ContextMenuView, ThemeSectionDefaultPosition, ThemeSectionType } from 'src/app/core/enums/common-enums';
import { EntityFqdn } from 'src/app/core/enums/core-enums';
import { ContextMenu } from 'src/app/core/models/common/context-menu';
import { BroadCastEventKeys, Parameters, RoutePath } from 'src/app/shared/constants';
import { GlobalFunctions } from 'src/app/shared/global-functions';
import { DialogHelper } from 'src/app/shared/helper/dialog-helper';
import { ExceptionHelper } from 'src/app/shared/helper/exception-helper';
import { ArrangeThemeSectionComponent } from '../associated-view/arrange-theme-section/arrange-theme-section.component';
let ThemeDetailComponent = class ThemeDetailComponent extends BaseDetailComponent {
    constructor(router, userService, sessionManager, eventProvider, themeService, integrationSettingManager, changeDetectorRef, systemComponentService, userSettingManager, dialog, contextMenuService, searchService, phoneManager, dialogManager, translateService, activatedRoute) {
        super(phoneManager, dialogManager, translateService);
        this.router = router;
        this.userService = userService;
        this.sessionManager = sessionManager;
        this.eventProvider = eventProvider;
        this.themeService = themeService;
        this.integrationSettingManager = integrationSettingManager;
        this.changeDetectorRef = changeDetectorRef;
        this.systemComponentService = systemComponentService;
        this.userSettingManager = userSettingManager;
        this.dialog = dialog;
        this.contextMenuService = contextMenuService;
        this.searchService = searchService;
        this.phoneManager = phoneManager;
        this.dialogManager = dialogManager;
        this.translateService = translateService;
        this.activatedRoute = activatedRoute;
        this.timeoutIds = [];
        this.sectionsList = ["", "Employee", "FileEntity", "NoteEntity", "Organization", "Product", "QuestionAnswer", "Link", "Theme", "News", "PopularNumber"];
        this.linkEntityList = [];
        this.relatedEntities = [];
        this.groupedLinkEntities = {};
        this.localUserGroups = this.userService.getNativeUsergroupList();
        this.recentlyAddedDays = 1;
        this.loadingEntities = false;
        this.getThemeDetailResponse = this.getThemeDetailResponse.bind(this);
        this.getThemeLinkedItemsResponse = this.getThemeLinkedItemsResponse.bind(this);
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.RELOAD_ENTITY_DETAIL).subscribe(() => this.ngOnInit());
    }
    ngOnInit() {
        this.subs.sink = this.activatedRoute.params.subscribe(params => {
            if (params.domain.toLowerCase() === Parameters.THEME) {
                try {
                    this.startSpinner();
                    this.loadingEntities = true;
                    let result = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Themes_Entities_Theme, "RECENTLYADDEDDURATION");
                    if (!GlobalFunctions.isEmpty(result))
                        this.recentlyAddedDays = Number.parseInt(result);
                    if (!GlobalFunctions.isEmpty(this.sessionManager.selectedEntity)) {
                        document.getElementById('theme-detail-description').style.display = 'none';
                        const partial = new Object();
                        partial.Id = this.sessionManager.selectedEntity.Id;
                        partial.ObjectSource = this.sessionManager.selectedEntity.ObjectSource;
                        partial.Name = this.sessionManager.selectedEntity.StringRepresentation;
                        this.themeService.connect().then(() => this.themeService.fetchDetail(partial, this.getThemeDetailResponse));
                    }
                }
                catch (e) {
                    console.error(e);
                }
            }
        });
    }
    ngOnDestroy() {
        this.subs.unsubscribe();
        this.timeoutIds.forEach(timeoutId => clearTimeout(timeoutId));
    }
    getThemeDetailResponse(result) {
        if (result) {
            this.sessionManager.selectedEntity = result;
            this.sessionManager.addItemToSession(result);
            this.systemComponentService.getEntityLinkItems(this.sessionManager.selectedEntity.RelatedEntityFqdn.toString(), this.sessionManager.selectedEntity.Id, this.sessionManager.selectedEntity.ObjectSource, this.getThemeLinkedItemsResponse);
            const detailEntityType = GlobalFunctions.getObjectTypeName(this.sessionManager.selectedEntity.RelatedEntityFqdn);
            const oldContentType = GlobalFunctions.toContentType(detailEntityType);
            this.sessionManager.contextMenu = new ContextMenu(oldContentType, detailEntityType, this.translateService, this.sessionManager.selectedEntity, GlobalFunctions.getLoggedInUserId, ContextMenuView.Detail, this.sessionManager.customContextMenuItems, this.sessionManager, this.integrationSettingManager);
            this.contextMenuService.loadActionButton(detailEntityType);
            this.parseThemepageDescription(this.sessionManager.selectedEntity);
            this.eventProvider.BroadcastEvent(BroadCastEventKeys.LOAD_SELECTED_ENTITY_IN_DETAIL, this.sessionManager.selectedEntity);
            this.timeoutIds.push(setTimeout(() => this.resize(), 300));
        }
        else {
            let exception = ExceptionHelper.create(this.translateService.instant("LBL_THEME_NOT_FOUND"), this.translateService.instant("LBL_THEME_NOT_FOUND_MESSAGE"), this.translateService.instant("LBL_THEME"));
            ExceptionHelper.showException(this.dialog, exception, true).afterClosed().subscribe(() => this.router.navigate([RoutePath.DASHBOARD]));
        }
        this.stopSpinner();
    }
    getThemeLinkedItemsResponse(response) {
        if (response?.EntityLinkList?.length > 0) {
            this.linkEntityList = [];
            for (let index = 0; index < response.EntityLinkList.length; index++) {
                for (let s = 0; s < this.sessionManager.selectedEntity.Settings.length; s++) {
                    let curentEntity = GlobalFunctions.getObjectTypeName(response.EntityLinkList[index].TargetObject.ObjectContentType);
                    curentEntity = curentEntity.toUpperCase() == 'ITEM' ? 'News' : curentEntity;
                    let hasRights = curentEntity == "PopularNumber" ? GlobalFunctions.checkRights("Employee") : GlobalFunctions.checkRights(curentEntity);
                    if (hasRights && this.sectionsList[this.sessionManager.selectedEntity.Settings[s].SectionType] == curentEntity) {
                        let entityContent = new Object();
                        entityContent.entityName = curentEntity;
                        entityContent.content = this.setSourceInformation(response.EntityLinkList[index].TargetObject.ObjectItem);
                        entityContent.content.LastChangedDate = response.EntityLinkList[index].LastChangedDate;
                        this.linkEntityList.push(entityContent);
                    }
                }
            }
            this.groupedLinkEntities = jlinq.from(this.linkEntityList).group("entityName");
        }
        else {
            this.linkEntityList = [];
            this.groupedLinkEntities = jlinq.from(this.linkEntityList).group("entityName");
        }
        let userSetting = this.userSettingManager.getUserSettingValueByKey("ThemeSectionArrangement");
        if (GlobalFunctions.isEmpty(userSetting)) {
            this.sessionManager.selectedEntity.Settings.sort((a, b) => {
                if (a.Ordering > b.Ordering)
                    return 1;
                if (a.Ordering < b.Ordering)
                    return -1;
                return 0;
            });
        }
        this.relatedEntities = [];
        for (let x = 0; x < this.sessionManager.selectedEntity.Settings.length; x++) {
            let entityType = this.sectionsList[this.sessionManager.selectedEntity.Settings[x].SectionType];
            if (!GlobalFunctions.isEmpty(entityType)) {
                let hasRights = entityType == "PopularNumber" ? GlobalFunctions.checkRights("Employee") : GlobalFunctions.checkRights(entityType);
                if (hasRights) {
                    let entityTypeCaps = entityType.toUpperCase();
                    let themeRelatedEntity = {
                        'entityType': entityType,
                        'entityTitle': entityTypeCaps == "QUESTIONANSWER" ? this.translateService.instant("LBL_QUESTION_ANSWERS") : this.translateService.instant("LBL_" + entityTypeCaps),
                        'entityObject': this.groupedLinkEntities[entityTypeCaps] == undefined ? [] : this.groupedLinkEntities[entityTypeCaps].sort(function (x, y) { return x.content.StringRepresentation > y.content.StringRepresentation; }),
                        'entityAllItems': '',
                        'entityRecentItems': '',
                        'showRecentItems': true,
                        'recentText': this.translateService.instant("LBL_RECENT_ITEMS")
                    };
                    themeRelatedEntity.entityRecentItems = this.getRecentItems(themeRelatedEntity.entityObject);
                    themeRelatedEntity.entityAllItems = themeRelatedEntity.entityObject;
                    this.relatedEntities.push(themeRelatedEntity);
                }
            }
        }
        if (!GlobalFunctions.isEmpty(userSetting)) {
            let tempThemeReletedEntityList = this.relatedEntities;
            for (let section in ThemeSectionDefaultPosition) {
                if (GlobalFunctions.isNumber(section) && userSetting.indexOf(";" + section) == -1 && userSetting.indexOf(section + ";") == -1 && userSetting.indexOf(section + "|") == -1)
                    userSetting = userSetting + ";" + section;
            }
            this.relatedEntities = [];
            let order = 0;
            let leftSide = (userSetting.split('|')[0]).split(';');
            if (!GlobalFunctions.isEmpty(leftSide) && leftSide.length > 0) {
                leftSide.forEach(section => {
                    let relatedEntity = jlinq.from(tempThemeReletedEntityList).equals("entityType", ThemeSectionType[section]).select();
                    if (!GlobalFunctions.isEmpty(relatedEntity)) {
                        this.relatedEntities.push(relatedEntity[0]);
                        order++;
                    }
                });
                this.leftPaneDivider = order;
            }
            let rightSide = (userSetting.split('|')[1]).split(';');
            if (!GlobalFunctions.isEmpty(rightSide) && rightSide.length > 0) {
                rightSide.forEach(section => {
                    let relatedEntity = jlinq.from(tempThemeReletedEntityList).equals("entityType", ThemeSectionType[section]).select();
                    if (!GlobalFunctions.isEmpty(relatedEntity)) {
                        this.relatedEntities.push(relatedEntity[0]);
                        order++;
                    }
                });
                this.rightPaneDivider = this.relatedEntities.length - this.leftPaneDivider;
            }
        }
        else if (this.relatedEntities.length > 0) {
            this.leftPaneDivider = Math.ceil(this.relatedEntities.length / 2);
            this.rightPaneDivider = this.relatedEntities.length - this.leftPaneDivider;
        }
        if (this.leftPaneDivider <= 0) {
            this.leftPaneDivider = Math.ceil(this.relatedEntities.length / 2);
            this.rightPaneDivider = this.relatedEntities.length - this.leftPaneDivider;
        }
        this.loadingEntities = false;
    }
    parseThemepageDescription(themepage) {
        this.timeoutIds.push(setTimeout(() => {
            if (!GlobalFunctions.isEmpty(themepage) && !GlobalFunctions.isEmpty(themepage.FormattedDescription)) {
                let doc = new DOMParser().parseFromString(themepage.FormattedDescription, 'text/html');
                doc = this.addLockIconForBlocks(doc, themepage.ManageLocalGroupPrivilege);
                const element = document.getElementById('theme-detail-description');
                element.innerHTML = themepage.FormattedDescription;
                element.style.display = 'block';
                this.highlightKeyword();
                this.resizeImage();
            }
        }, 500));
    }
    highlightKeyword() {
        const query = this.searchService.selectedSearchOption ? this.searchService.selectedSearchOption.searchQuery : "";
        $('#theme-detail-description').highlight(query, 'highlightSearchTerm');
        $('#theme-detail-description table').css({ width: 'auto', height: 'auto' });
    }
    addLockIconForBlocks(document, manageLocalGroupPrivilegeData) {
        if (!GlobalFunctions.isEmpty(this.localUserGroups) && !GlobalFunctions.isEmpty(manageLocalGroupPrivilegeData)) {
            let allBlockWiseAssignedLocalGroups = manageLocalGroupPrivilegeData.split(';');
            if (!GlobalFunctions.isEmpty(allBlockWiseAssignedLocalGroups)) {
                let allSections = document.getElementsByTagName('section');
                if (!GlobalFunctions.isEmpty(allSections)) {
                    let title = this.translateService.instant("LBL_CLICK_TO_SEE_LOCAL_GROUP");
                    for (let i = 0; i < allSections.length; i++) {
                        let htmlContent = "";
                        for (let j = 0; j < allBlockWiseAssignedLocalGroups.length; j++) {
                            let blockWiseAssignedLocalGroups = allBlockWiseAssignedLocalGroups[j].split('|');
                            if (!GlobalFunctions.isEmpty(blockWiseAssignedLocalGroups) && blockWiseAssignedLocalGroups.length == 2 && blockWiseAssignedLocalGroups[0] == allSections[i].id && !GlobalFunctions.isEmpty(blockWiseAssignedLocalGroups[1])) {
                                for (let k = 0; k < this.localUserGroups.length; k++) {
                                    if (blockWiseAssignedLocalGroups[1].indexOf(this.localUserGroups[k].Id) != -1)
                                        htmlContent += "<li class='localgroupNameListLi'><div class='fieldValueWithEllipsis localgroupNameListDiv' title='" + this.localUserGroups[k].Name + "'>" + this.localUserGroups[k].Name + "</div> </li>";
                                }
                                break;
                            }
                        }
                        allSections[i].innerHTML = "<div class='dropdown divDisplayLocalGroupName' id='localgroupMenu' >"
                            + "<a role='button' class='lockIcon jkcUnlockBlue jkcSizeSmall' id='lockIcon" + allSections[i].id + "'  title='" + title + "' (click)='showLocalList(\"" + allSections[i].id + "\")' name=" + allSections[i].id + "></a>"
                            + "<ul id='" + allSections[i].id + "localgroupList' class='localgroupList dropdown-menu selectMenuCall' style='width:auto; font-size:15px; margin-top:-10px;'>"
                            + "<li></li>"
                            + htmlContent
                            + "</ul>"
                            + "</div>"
                            + allSections[i].innerHTML;
                    }
                    this.timeoutIds.push(setTimeout(() => this.adjustLocalGroupPopupPosition(), 1500));
                }
            }
        }
        return document;
    }
    ;
    showLocalList(id) {
        $("#" + id.target.name + "localgroupList").toggle();
        id.preventDefault();
        id.stopPropagation();
    }
    adjustLocalGroupPopupPosition() {
        let allOpenedPopups = $('.localgroupList');
        let themeDetailScreenWidth = $('#themeDetail').width();
        if (!GlobalFunctions.isEmpty(allOpenedPopups) && themeDetailScreenWidth > 0) {
            let maxWidthAllowed = (themeDetailScreenWidth * 70) / 100;
            for (let i = 0; i < allOpenedPopups.length; i++) {
                let tempWidth = $('#' + allOpenedPopups[i].id).width();
                if (tempWidth > 0) {
                    if (tempWidth > maxWidthAllowed) {
                        allOpenedPopups[i].style.left = ((themeDetailScreenWidth * 30) / 100) + "px";
                        allOpenedPopups[i].style.width = ((themeDetailScreenWidth * 70) / 100) + "px";
                    }
                    else
                        allOpenedPopups[i].style.left = (themeDetailScreenWidth - tempWidth - 10) + "px";
                }
            }
        }
    }
    resize() {
        const windowHeight = window.innerHeight;
        $("#themeDetailMainPanel").height(windowHeight - 100 + 'px');
        this.resizeImage();
    }
    resizeImage() {
        try {
            this.timeoutIds.push(setTimeout(() => {
                const img = $("#theme-detail-description").find("img");
                if (!GlobalFunctions.isEmpty(img)) {
                    $(img).css("max-width", "100%");
                    $(img).css('height', 'auto');
                }
                this.changeDetectorRef.detectChanges();
            }, 300));
        }
        catch (e) {
            console.error(e);
        }
    }
    setSourceInformation(itemObject) {
        if (itemObject) {
            let result = [];
            result.push(itemObject);
            this.sessionManager.setBgColorBasedOnObjectSource(result);
            itemObject = result[0];
        }
        return itemObject;
    }
    getRecentItems(entityList) {
        let recentlyAddedDays = GlobalFunctions.isNumber(this.recentlyAddedDays) ? +this.recentlyAddedDays : 1;
        let _MS_PER_DAY = 1000 * 60 * 60 * 24;
        let today = Date.now();
        let recentEntites = [];
        for (let e = 0; e < entityList.length; e++) {
            let entityDate = new Date(entityList[e].content.LastChangedDate);
            let entityDateFormat = Date.UTC(entityDate.getFullYear(), entityDate.getMonth(), entityDate.getDate());
            let todayDateFormat = Date.UTC(today.getFullYear(), today.getMonth(), today.getDate());
            if (Math.floor((todayDateFormat - entityDateFormat) / _MS_PER_DAY) < recentlyAddedDays)
                recentEntites.push(entityList[e]);
        }
        return recentEntites;
    }
    arrangeThemeSection() {
        DialogHelper.openDialog(this.dialog, ArrangeThemeSectionComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState)).afterClosed().subscribe(result => {
            if (result)
                this.ngOnInit();
        });
    }
    navigateToHeading(headingId) {
        try {
            const heading = document.getElementById(headingId);
            if (heading)
                heading.scrollIntoView({ behavior: 'smooth', block: 'start' });
        }
        catch (e) {
            console.error(e);
        }
    }
};
ThemeDetailComponent = __decorate([
    Component({
        selector: 'theme-detail',
        templateUrl: './theme-detail.component.html',
        styleUrls: ['./theme-detail.component.scss'],
        host: { '(window:resize)': 'resize()' }
    })
], ThemeDetailComponent);
export { ThemeDetailComponent };
//# sourceMappingURL=theme-detail.component.js.map