var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { GlobalFunctions } from '../../../../../shared/global-functions';
import { ExceptionHelper } from '../../../../../shared/helper/exception-helper';
import { BaseRelatedViewComponent } from '../base-related-view';
let PopularNumberComponent = class PopularNumberComponent extends BaseRelatedViewComponent {
    constructor(router, cacheManager, employeeService, sessionManager, translateService, dialogManager) {
        super(router, sessionManager, translateService);
        this.router = router;
        this.cacheManager = cacheManager;
        this.employeeService = employeeService;
        this.sessionManager = sessionManager;
        this.translateService = translateService;
        this.dialogManager = dialogManager;
        this.popularNumbers = [];
        this.popularNumberEntityTitle = this.translateService.instant("LBL_POPULAR_NUMBER");
    }
    ngOnInit() {
        const popularNumbers = [];
        for (let e = 0; e < this.relatedEntity.entityObject.length; e++)
            popularNumbers.push(this.cacheManager.getPopularEmployeeById(this.relatedEntity.entityObject[e].content.Id));
        this.popularNumbers = popularNumbers;
    }
    select(type, item) {
        try {
            if (item) {
                if (!GlobalFunctions.isEmpty(type)) {
                    this.dialogManager.openJsPanelOrDialog('POPULAR_NUMBER_POPUP_PANEL', false, item);
                }
            }
        }
        catch (e) {
            ExceptionHelper.showException(null, null, false, e.message, "");
        }
    }
    recentToggle(relatedEntity) {
        super.recentToggle(relatedEntity);
        this.ngOnInit();
    }
};
PopularNumberComponent = __decorate([
    Component({
        selector: 'popularnumber-related-view',
        templateUrl: './popularnumber.component.html',
        styleUrls: ['./popularnumber.component.scss']
    })
], PopularNumberComponent);
export { PopularNumberComponent };
//# sourceMappingURL=popularnumber.component.js.map