var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, Input } from "@angular/core";
import { RoutePath } from "../../../../shared/constants";
import { GlobalFunctions } from "../../../../shared/global-functions";
import { ExceptionHelper } from "../../../../shared/helper/exception-helper";
let BaseRelatedViewComponent = class BaseRelatedViewComponent {
    constructor(router, sessionManager, translateService) {
        this.router = router;
        this.sessionManager = sessionManager;
        this.translateService = translateService;
    }
    select(type, fqdn, item) {
        try {
            if (item) {
                if (!GlobalFunctions.isEmpty(type)) {
                    item.RelatedEntityFqdn = fqdn;
                    type = type.toLowerCase();
                    this.sessionManager.loadedFromRelatedView = true;
                    this.sessionManager.selectedEntity = item;
                    this.sessionManager.selectedEntity.Partial = true;
                    item.locationUrl = `${RoutePath.DETAIL_PATH}/${type}/${item.Id}`;
                    this.sessionManager.addBreadcrumbItems([item], null, RoutePath.DETAIL_PATH);
                    this.router.navigate([item.locationUrl]);
                }
            }
        }
        catch (e) {
            ExceptionHelper.showException(null, null, false, e.message, "");
        }
    }
    openInPopUp(url) {
        if (url != "")
            GlobalFunctions.popUpCenter(url, 1024, 550);
    }
    recentToggle(relatedEntity) {
        if (relatedEntity.showRecentItems) {
            relatedEntity.recentText = this.translateService.instant('LBL_SHOW_ALL').toLowerCase();
            relatedEntity.entityObject = relatedEntity.entityRecentItems;
        }
        else {
            relatedEntity.recentText = this.translateService.instant('LBL_RECENT_ITEMS').toLowerCase();
            relatedEntity.entityObject = relatedEntity.entityAllItems;
        }
        relatedEntity.showRecentItems = !relatedEntity.showRecentItems;
    }
};
__decorate([
    Input()
], BaseRelatedViewComponent.prototype, "relatedEntity", void 0);
BaseRelatedViewComponent = __decorate([
    Component({
        selector: 'base-related-view',
        template: 'base-related-view'
    })
], BaseRelatedViewComponent);
export { BaseRelatedViewComponent };
//# sourceMappingURL=base-related-view.js.map