var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, ViewChild } from '@angular/core';
import { BaseDialogComponent } from 'src/app/components/common/base-dialog.component';
import { MessageboxComponent } from 'src/app/components/common/messagebox/messagebox.component';
import { EntityFqdn } from 'src/app/core/enums/core-enums';
import { TaskHandlerType, TaskReplyBy, TaskStatus } from 'src/app/core/enums/task-enum';
import { AttachmentDto } from 'src/app/core/models/attachment/attachmentDto';
import { BaseDto } from 'src/app/core/models/common/baseDto';
import { TaskHandlerDto } from 'src/app/core/models/task/task-handlerDto';
import { TaskHistoryDto } from 'src/app/core/models/task/task-historyDto';
import { BroadCastEventKeys, RoutePath, SideMenuItem } from 'src/app/shared/constants';
import { GlobalFunctions } from 'src/app/shared/global-functions';
import { DialogHelper } from 'src/app/shared/helper/dialog-helper';
import { ExceptionHelper } from 'src/app/shared/helper/exception-helper';
import { OperationType, ScreenMode } from '../../../../../../core/enums/common-enums';
import { ContentType, TaskDtoSource } from 'src/app/core/models/jkc-object/jkc-object';
let InformationRequestHandleComponent = class InformationRequestHandleComponent extends BaseDialogComponent {
    constructor(router, dialog, dialogRef, taskService, phoneManager, cacheManager, dialogManager, searchService, eventProvider, sessionManager, shortcutManager, translateService, applicationSettingManager, localSearchResultDataService) {
        super();
        this.router = router;
        this.dialog = dialog;
        this.dialogRef = dialogRef;
        this.taskService = taskService;
        this.phoneManager = phoneManager;
        this.cacheManager = cacheManager;
        this.dialogManager = dialogManager;
        this.searchService = searchService;
        this.eventProvider = eventProvider;
        this.sessionManager = sessionManager;
        this.shortcutManager = shortcutManager;
        this.translateService = translateService;
        this.applicationSettingManager = applicationSettingManager;
        this.localSearchResultDataService = localSearchResultDataService;
        this.dateJS = Date;
        this.taskDto = this.sessionManager.selectedEntity;
        this.fileAttachments = [];
        this.uploadedFiles = [];
        this.isCreator = GlobalFunctions.getLoggedInUserId() === this.taskDto.CreatedById;
        this.taskStatus = "NotCompleted";
        this.isHtmlDetected = false;
        this.timeoutIds = [];
        this.isAllowedToProcessTask = false;
        this.informationRequestResponse = this.informationRequestResponse.bind(this);
        this.informationRequestErrorCallback = this.informationRequestErrorCallback.bind(this);
    }
    ngOnInit() {
        this.timeoutIds.push(setTimeout(() => this.resize(), 300));
        this.sessionManager.startSessionIfPossible("TASK", ScreenMode.Edit);
        this.shortcutManager.bind('LBL_SHORTCUT_SAVE_BUTTON', () => this.save());
        document.getElementById("answerFieldTextArea")?.focus();
        this.phoneManager.setPhoneStatusAction("0");
        this.scrollToBottomOfConversationAndFocus();
        this.isAllowTaskToHandle();
    }
    ngOnDestroy() {
        this.shortcutManager.unbind('LBL_SHORTCUT_SAVE_BUTTON');
        this.timeoutIds.forEach(timeoutId => clearTimeout(timeoutId));
    }
    loadLastSelectedSearchResult() {
        let index = this.sessionManager.selectedBreadcrumbIndex;
        let currentBreadcrumItem = this.sessionManager.BreadcrumbItems[index];
        this.sessionManager.BreadcrumbItems[index][0].isDeleted = true;
        if (index < this.sessionManager.BreadcrumbItems.length)
            index = index + 1;
        let breadCrumbItems = this.sessionManager.BreadcrumbItems[index];
        if (breadCrumbItems != undefined || breadCrumbItems != null)
            breadCrumbItems.forEach(breadCrumbItem => {
                if (currentBreadcrumItem != undefined && currentBreadcrumItem[0].itemData != null && breadCrumbItem.itemData.ObjectSourceDto != null && currentBreadcrumItem[0].itemData.Id == breadCrumbItem.itemData.ObjectSourceDto.Id) {
                    if (breadCrumbItems.length == 1)
                        breadCrumbItems[0].isDeleted = true;
                    else {
                        index = breadCrumbItems.indexOf(breadCrumbItem);
                        breadCrumbItems.splice(index, 1);
                    }
                }
            });
        this.localSearchResultDataService.localSearchResultData.localResult = [];
        this.localSearchResultDataService.localSearchResultData.contentType = "";
        if (breadCrumbItems != null && breadCrumbItems.length > 0) {
            this.localSearchResultDataService.localSearchResultData.contentType = breadCrumbItems[0].sourceUrl.substring(breadCrumbItems[0].sourceUrl.lastIndexOf("/") + 1);
            breadCrumbItems.forEach((breadCrumbItem, i) => {
                if (!breadCrumbItem.isDeleted)
                    this.localSearchResultDataService.localSearchResultData.localResult.push(breadCrumbItem.itemData);
                this.localSearchResultDataService.localSearchResultData.contentType = breadCrumbItem.sourceUrl.substring(breadCrumbItem.sourceUrl.lastIndexOf("/") + 1);
            });
            breadCrumbItems[0].isSelected = true;
            this.sessionManager.addBreadcrumbTypeItems(breadCrumbItems, false);
            GlobalFunctions.navigateWithOptionalQueryParam(this.router, breadCrumbItems[0].sourceUrl);
        }
    }
    ;
    informationRequestResponse(response) {
        this.stopSpinner();
        this.eventProvider.BroadcastEvent(BroadCastEventKeys.FETCH_TASK_STATISTIC);
        this.eventProvider.BroadcastEvent(BroadCastEventKeys.FETCH_CONTACT_STATISTIC);
        if (response?.Result == 0) {
            if (this.taskDto.CurrentStatus == TaskStatus.Replied && this.isCreator && this.sessionManager.pendingCount.MyUnreplyScheduledWorkCount > 0)
                this.sessionManager.pendingCount.MyUnreplyScheduledWorkCount--;
            this.close();
            if (this.applicationSettingManager.autoIgnoreSession)
                this.sessionManager.autoIgnoreSession(this.dialogRef, this.dialogManager, this.cacheManager, this.phoneManager);
            else if (this.isCreator === false && this.sessionManager.BreadcrumbItems.length > 0 && this.sessionManager.BreadcrumbItems.length > (this.sessionManager.selectedBreadcrumbIndex + 1) && this.sessionManager.BreadcrumbItems[this.sessionManager.selectedBreadcrumbIndex + 1][0].sourceUrl.indexOf('/list/task') != -1)
                this.loadLastSelectedSearchResult();
            else
                this.router.navigate([RoutePath.DASHBOARD, RoutePath.LIST_PATH, SideMenuItem.TASK], { queryParams: { filter: 'my' } });
        }
        else
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_TASK'), textMsg: this.translateService.instant('LBL' + GlobalFunctions.formatStringValue(this.translateService.instant("LBL_MSG_HANDLE_TASK_FAILED"), [this.translateService.instant("LBL_INFORMATION_REQUEST")])) });
    }
    ;
    informationRequestErrorCallback() {
        let exception = ExceptionHelper.create(this.translateService.instant("LBL_ERROR_MSG"), this.translateService.instant("LBL_HANDLE_TASK_ERROR_MSG"), this.translateService.instant("LBL_TASK"));
        ExceptionHelper.showException(this.dialog, exception, true);
    }
    ;
    replyInformationRequest() {
        let taskHistoryDto = new TaskHistoryDto();
        taskHistoryDto.DateRecorded = new this.dateJS().toString(this.sessionManager.defaultOptions.mdyyyyhhmmss);
        taskHistoryDto.Status = this.isCreator ? TaskStatus.Unhandled : TaskStatus.Replied;
        taskHistoryDto.CreatedById = GlobalFunctions.getLoggedInUserId();
        taskHistoryDto.ReasonFreeText = this.responseMessageText;
        taskHistoryDto.ReplyBy = this.isCreator ? TaskReplyBy.User : TaskReplyBy.Handler;
        let taskHandlers = this.taskDto.TaskHistoryList[this.taskDto.TaskHistoryList.length - 1].TaskHandlerList;
        if (taskHandlers != null && taskHandlers.length > 0) {
            for (let h = 0; h < taskHandlers.length; h++) {
                let taskHandler = new TaskHandlerDto();
                taskHandler.HandlerId = taskHandlers[h].HandlerId;
                taskHandler.HandlerType = taskHandlers[h].HandlerType;
                let baseDtoObject = new BaseDto();
                baseDtoObject.Id = taskHandler.HandlerId;
                taskHandler.HandlerObject = baseDtoObject;
                taskHistoryDto.TaskHandlerList = [];
                taskHistoryDto.TaskHandlerList.push(taskHandler);
            }
        }
        let updatedTaskDto = { ...this.taskDto };
        updatedTaskDto.TaskHistoryList = [];
        updatedTaskDto.TaskHistoryList.push(taskHistoryDto);
        updatedTaskDto.CurrentStatus = this.isCreator ? TaskStatus.Unhandled : TaskStatus.Replied;
        if (this.fileAttachments.length > 0) {
            updatedTaskDto.AttachmentList = [];
            for (let i = 0; i < this.fileAttachments.length; i++) {
                const attachment = new AttachmentDto();
                attachment.OnServer = !GlobalFunctions.isEmpty(this.fileAttachments[i].id);
                attachment.FileName = this.fileAttachments[i].fileNameOnServer;
                attachment.Name = this.fileAttachments[i].text;
                attachment.IsMarked = true;
                attachment.RelatedEntityFqdn = EntityFqdn.Decos_Kcs_Notes_Entities_InformationResponse;
                updatedTaskDto.AttachmentList.push(attachment);
            }
        }
        this.taskService.replyInformationRequest(updatedTaskDto, this.informationRequestResponse, this.informationRequestErrorCallback);
    }
    ;
    handleInformationRequest() {
        let taskHistoryDto = new TaskHistoryDto();
        taskHistoryDto.DateRecorded = new this.dateJS().toString(this.sessionManager.defaultOptions.mdyyyyhhmmss);
        taskHistoryDto.Status = TaskStatus.Handled;
        taskHistoryDto.CreatedById = GlobalFunctions.getLoggedInUserId();
        let taskHandler = new TaskHandlerDto();
        taskHandler.HandlerId = GlobalFunctions.getLoggedInUserId();
        taskHandler.HandlerType = TaskHandlerType.Employee;
        let baseDtoObject = new BaseDto();
        baseDtoObject.Id = taskHandler.HandlerId;
        taskHandler.HandlerObject = baseDtoObject;
        taskHistoryDto.TaskHandlerList = [];
        taskHistoryDto.TaskHandlerList.push(taskHandler);
        let updatedTaskDto = { ...this.taskDto };
        updatedTaskDto.TaskHistoryList = [];
        updatedTaskDto.TaskHistoryList.push(taskHistoryDto);
        updatedTaskDto.CurrentStatus = TaskStatus.Handled;
        // updatedTaskDto.Result = this.selectedAnswer;
        this.taskService.handleTask(updatedTaskDto, this.informationRequestResponse, this.informationRequestErrorCallback);
    }
    ;
    save() {
        if (!this.form.invalid) {
            this.isHtmlDetected = GlobalFunctions.detectHtmlInjection(this.responseMessageText);
            if (this.isHtmlDetected)
                console.log("ERROR: INFORMATION REQUEST(PROCESS) : HTML injection detected");
            else {
                this.startSpinner();
                if (this.taskStatus === "NotCompleted")
                    this.replyInformationRequest();
                else
                    this.handleInformationRequest();
            }
        }
    }
    ;
    handleEscKey() {
        if (!GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) && this.sessionManager.jkcParentPanel?.parameters?.IsPanelExpanded)
            this.close();
    }
    ;
    onTagClick(tag) {
        this.applicationSettingManager.tagSetting.handleAction(tag, this.sessionManager, this.searchService, this.dialogManager, this.eventProvider);
    }
    ;
    onUpload(file) {
        this.startSpinner();
        this.errorMessage = '';
        this.uploadedFiles[this.uploadedFiles.length] = file.name;
    }
    ;
    onSuccess(response) {
        this.fileAttachments.push({ text: this.uploadedFiles[this.uploadedFiles.length - 1], fileNameOnServer: response[0].fileName });
        this.errorMessage = '';
        this.stopSpinner();
    }
    ;
    onError(error) {
        this.uploadedFiles.splice(this.uploadedFiles.length - 1, 1);
        this.errorMessage = GlobalFunctions.getFileUploadErrorText(error, this.translateService);
        this.stopSpinner();
    }
    ;
    scrollToBottomOfConversationAndFocus() {
        this.timeoutIds.push(setTimeout(() => {
            let taskHistoryListElement = $('#informationRequestTaskHistoryList');
            if (taskHistoryListElement && taskHistoryListElement[0])
                taskHistoryListElement.scrollTop(taskHistoryListElement[0].scrollHeight + 30);
            $("#responseMessageTextId").focus();
        }, 300));
    }
    ;
    resize() {
        let windowHeight = $(window).height();
        $("#jkcParentPanel").css({ 'max-height': (windowHeight - parseInt(this.sessionManager.jkcParentPanel?.parameters?.TopSpace) - 100 + "px") });
        let newHeight = $("#jkcParentPanel").height() - $("#handleInformationRequestHeader").height() - $("#handleInformationRequestFooter").height() + "px";
        $("#handleInformationRequestContainer").height(newHeight);
        $('#' + this.sessionManager.jkcParentPanel?.parameters?.HeaderId).css({ 'width': ($("#jkcParentPanel").width()) });
        $('#' + this.sessionManager.jkcParentPanel?.parameters?.FooterId).css({ 'width': ($("#jkcParentPanel").width()) });
    }
    close() {
        this.dialogManager.removeComponent();
        this.sessionManager.closeJkcParentPanel();
    }
    isAllowTaskToHandle() {
        this.isAllowedToProcessTask = false;
        if (this.isCreator || GlobalFunctions.hasRight(ContentType.Task, OperationType.CanHandleAnyTask, TaskDtoSource.InformationRequest))
            this.isAllowedToProcessTask = true;
    }
};
__decorate([
    ViewChild('form')
], InformationRequestHandleComponent.prototype, "form", void 0);
InformationRequestHandleComponent = __decorate([
    Component({
        selector: 'information-request-handle',
        templateUrl: './information-request-handle.component.html',
        styleUrls: ['./information-request-handle.component.scss'],
        host: { '(window:resize)': 'resize()' }
    })
], InformationRequestHandleComponent);
export { InformationRequestHandleComponent };
//# sourceMappingURL=information-request-handle.component.js.map