var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, ViewChild } from '@angular/core';
import { SubSink } from 'subsink';
import { BaseDialogComponent } from '../../../../../../components/common/base-dialog.component';
import { MessageboxComponent } from '../../../../../../components/common/messagebox/messagebox.component';
import { SearchPopupComponent } from '../../../../../../components/common/search-popup/search-popup.component';
import { FileUploadSource, OperationType, RecordSelection, ScreenMode } from '../../../../../../core/enums/common-enums';
import { EntityFqdn } from '../../../../../../core/enums/core-enums';
import { PublishTo } from '../../../../../../core/enums/notes-enum';
import { CreateTaskAction, MainEntityType, TaskHandlerType, TaskReplyBy, TaskStatus, TaskType } from '../../../../../../core/enums/task-enum';
import { AttachmentDto } from '../../../../../../core/models/attachment/attachmentDto';
import { CreateTaskRequest } from '../../../../../../core/models/case/case-task-request';
import { BaseDto } from '../../../../../../core/models/common/baseDto';
import { InformationRequestDto } from '../../../../../../core/models/common/information-requestDto';
import { RelatedEntityDto } from '../../../../../../core/models/common/related-enityDto';
import { RequiredFields } from '../../../../../../core/models/common/required-fields';
import { JsonDtoType, SourceType } from '../../../../../../core/models/jkc-object/jkc-object';
import { TaskHandlerDto } from '../../../../../../core/models/task/task-handlerDto';
import { TaskHistoryDto } from '../../../../../../core/models/task/task-historyDto';
import { BroadCastEventKeys, EntityName, LanaguageCode, RoutePath, TinyMCE } from '../../../../../../shared/constants';
import { GlobalFunctions } from '../../../../../../shared/global-functions';
import { CommonHelper } from '../../../../../../shared/helper/common-helper';
import { DialogHelper } from '../../../../../../shared/helper/dialog-helper';
import { JkcDatePickerHelper } from '../../../../../../shared/helper/jkc-date-picker-helper';
import { RepresentativeAddComponent } from '../../../../organization/add-representative/organization-add-representative.component';
let InformationRequestAddEditComponent = class InformationRequestAddEditComponent extends BaseDialogComponent {
    constructor(router, dialog, taskService, cacheManager, personService, dialogManager, sessionManager, shortcutManager, formatManager, employeeService, formattedBSNPipe, translateService, integrationSettingManager, applicationSettingManager, personFormattedAddressWithLabelPipe, organizationFormattedAddressWithLabel, eventProvider, fileService, datePipe, renderer, searchService, dateAdapter, fileManager) {
        super();
        this.router = router;
        this.dialog = dialog;
        this.taskService = taskService;
        this.cacheManager = cacheManager;
        this.personService = personService;
        this.dialogManager = dialogManager;
        this.sessionManager = sessionManager;
        this.shortcutManager = shortcutManager;
        this.formatManager = formatManager;
        this.employeeService = employeeService;
        this.formattedBSNPipe = formattedBSNPipe;
        this.translateService = translateService;
        this.integrationSettingManager = integrationSettingManager;
        this.applicationSettingManager = applicationSettingManager;
        this.personFormattedAddressWithLabelPipe = personFormattedAddressWithLabelPipe;
        this.organizationFormattedAddressWithLabel = organizationFormattedAddressWithLabel;
        this.eventProvider = eventProvider;
        this.fileService = fileService;
        this.datePipe = datePipe;
        this.renderer = renderer;
        this.searchService = searchService;
        this.dateAdapter = dateAdapter;
        this.fileManager = fileManager;
        this.dateJS = Date;
        this.relationTypeOptions = ['Person', 'Organization'];
        this.handlerTags = [];
        this.handlerTagItems = [];
        this.editedTaskData = this.sessionManager.jkcParentPanel?.parameters?.EditedData;
        this.title = this.editedTaskData == null ? this.translateService.instant("LBL_ADD_INFORMATION_REQUEST").toUpperCase() : this.translateService.instant("LBL_EDIT").toUpperCase() + ' ' + this.translateService.instant("LBL_INFORMATION_REQUEST").toUpperCase();
        this.currentRelationType = 'Person';
        this.currentHandlerType = 'Employee';
        this.showPersonCreateType = true;
        this.searchEntityTags = [];
        this.handlerTypeOption = this.applicationSettingManager.getUIHandlerTypeOption();
        this.taskDto = new InformationRequestDto();
        this.representativeList = [];
        this.showMandatoryField = false;
        this.mainEntityObject = null;
        this.fileAttachments = [];
        this.uploadedFiles = [];
        this.taskType = "informationrequest";
        this.priorities = [
            { priorityValue: 1, priorityText: this.translateService.instant("LBL_LOW") },
            { priorityValue: 2, priorityText: this.translateService.instant("LBL_MEDIUM") },
            { priorityValue: 3, priorityText: this.translateService.instant("LBL_HIGH") }
        ];
        this.priorityValue = 2;
        this.publishToList = [
            { publishToValue: PublishTo.Myself, publishToText: this.translateService.instant("LBL_MYSELF") },
            { publishToValue: PublishTo.MyDepartment, publishToText: this.translateService.instant("LBL_MY_DEPARTMENT") },
            { publishToValue: PublishTo.Everyone, publishToText: this.translateService.instant("LBL_EVERYONE") }
        ];
        this.templates = [];
        this.requiredFields = new RequiredFields();
        this.currentTemplate = null;
        this.externalHandlerTags = [];
        this.requiredCallbackDate = null;
        this.confidentialityLevel = 0;
        this.subs = new SubSink();
        this.uploadedFile = null;
        this.minDate = new Date();
        this.datePickerClosed = true;
        this.customerQuestionFieldId = 'tinymceIR' + GlobalFunctions.getGuid();
        this.timeoutIds = [];
        this.enableDepartmentNameInHandler = this.applicationSettingManager.isDepartmentNameInHandlerEnabled();
        this.fetchPersonDetailResponse = this.fetchPersonDetailResponse.bind(this);
        this.addInformationRequestResponse = this.addInformationRequestResponse.bind(this);
        this.relatedRepresentatives = this.relatedRepresentatives.bind(this);
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.JSPANEL_RESIZE).subscribe(() => this.resize());
    }
    ngOnInit() {
        this.taskDto.PublishTo = PublishTo.Myself;
        this.timeoutIds.push(setTimeout(() => this.resize(), 300));
        this.sessionManager.startSessionIfPossible("TASK", this.sessionManager.jkcParentPanel?.parameters?.EditedData == null ? ScreenMode.Add : ScreenMode.Edit);
        this.sessionManager.jkcParentPanel.parameters.Scope = this;
        this.templates = this.applicationSettingManager.getTaskTemplates(EntityFqdn.Decos_Kcs_Tasks_Entities_InformationRequest);
        if (!this.editedTaskData) {
            this.displayNumberOnUI(null, null);
            if (this.sessionManager.selectedEntity && this.sessionManager.selectedEntity.ObjectSource && this.sessionManager.selectedEntity.ObjectSource.toLowerCase().indexOf("employee") > -1) {
                let items = [];
                this.sessionManager.selectedEntity.text = this.sessionManager.selectedEntity.StringRepresentation;
                items.push(this.sessionManager.selectedEntity);
                this.handlerTags = items;
            }
            if (GlobalFunctions.isEmpty(this.handlerTags)) {
                let lastEmployee = GlobalFunctions.getLastEmployeeFromSession(this.sessionManager.detailViewCachedEntityList);
                if (!GlobalFunctions.isEmpty(lastEmployee))
                    this.handlerTags = [lastEmployee];
            }
            this.selectOptionsFromFindList();
            this.setCustomerQuestion();
            this.setTaskDetailFromSocialMedia();
            this.setTaskQuestionFromTicket();
            if (GlobalFunctions.isEmpty(this.taskDto.CustomerOrOrganizationName) && !GlobalFunctions.isEmpty(this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactPerson))
                this.taskDto.CustomerOrOrganizationName = this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactPerson;
            if (GlobalFunctions.isEmpty(this.taskDto.ContactEmail) && !GlobalFunctions.isEmpty(this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactEmail))
                this.taskDto.ContactEmail = this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactEmail;
        }
        else
            this.loadEditTaskData(this.editedTaskData);
        this.initEditor();
        this.registerDialogShortcutKey();
        if (this.searchEntityTags && this.searchEntityTags.length > 0)
            document.getElementById(this.customerQuestionFieldId)?.focus();
        else
            document.getElementById('customerNameValue')?.focus();
        this.taskDto.ContactPerson = this.taskDto.ContactPerson?.split('/')[1];
        this.setHandlerTags();
    }
    ngOnDestroy() {
        this.subs.unsubscribe();
        this.shortcutManager.unbind('LBL_SHORTCUT_SAVE_BUTTON');
        this.timeoutIds.forEach(timeoutId => clearTimeout(timeoutId));
    }
    disableWeekendDates(date, mode) {
        return (mode === 'day' && (date.getDay() === 0 || date.getDay() === 6));
    }
    ;
    changeRepresentative() {
        if (this.selectedRepresentative?.value?.toUpperCase() == 'NEW') {
            if (this.currentRelationType == 'Organization') {
                DialogHelper.openDialog(this.dialog, RepresentativeAddComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { organizationId: this.taskDto.MainEntityId, editMode: false }).afterClosed().subscribe(representative => {
                    if (representative) {
                        this.relatedRepresentatives([representative]);
                        this.selectedRepresentative = representative;
                    }
                    this.registerDialogShortcutKey();
                });
            }
        }
        else {
            if (this.selectedRepresentative) {
                if (this.selectedRepresentative.AdministeredPersonDto)
                    this.taskDto.CustomerBSN = this.formattedBSNPipe.transform(this.selectedRepresentative.AdministeredPersonDto.ServiceNumber);
                else if (this.selectedRepresentative.OtherPersonDto && this.selectedRepresentative.OtherPersonDto.Identification != '')
                    this.taskDto.CustomerBSN = this.selectedRepresentative.OtherPersonDto.Identification;
                this.taskDto.ContactAddress = this.personFormattedAddressWithLabelPipe.transform(this.selectedRepresentative, false) || '';
                this.displayNumberOnUI(this.selectedRepresentative.PhoneNumber, this.selectedRepresentative.MobileNumber);
                this.taskDto.ContactPerson = this.selectedRepresentative.StringRepresentation;
                if (!GlobalFunctions.isEmpty(this.selectedRepresentative.Details?.DateOfBirth) && GlobalFunctions.validDate(this.selectedRepresentative.Details.DateOfBirth))
                    this.taskDto.CustomerDateOfBirth = new this.dateJS(this.selectedRepresentative.Details.DateOfBirth);
                else
                    this.taskDto.CustomerDateOfBirth = null;
            }
        }
    }
    ;
    addDefaultRepresentative() {
        this.representativeList.push({ StringRepresentation: this.translateService.instant("LBL_NEW"), value: "new" });
    }
    ;
    displayNumberOnUI(phoneNumber, mobileNumber) {
        if (!GlobalFunctions.isEmpty(phoneNumber) && GlobalFunctions.isEmpty(this.phoneNumber))
            this.phoneNumber = $.trim(phoneNumber);
        if (!GlobalFunctions.isEmpty(mobileNumber) && GlobalFunctions.isEmpty(this.mobileNumber))
            this.mobileNumber = $.trim(mobileNumber);
        if (!GlobalFunctions.isEmpty(this.sessionManager.currentCallerId)) {
            if (GlobalFunctions.isMobileNumber(this.sessionManager.currentCallerId))
                this.mobileNumber = this.sessionManager.currentCallerId;
            else
                this.phoneNumber = this.sessionManager.currentCallerId;
        }
        if (!GlobalFunctions.isEmpty(this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactPhoneNumber)) {
            let numbers = this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactPhoneNumber.split('/');
            for (let i = 0; i < numbers.length; i++) {
                if (GlobalFunctions.isMobileNumber(numbers[i]))
                    this.mobileNumber = numbers[i];
                else
                    this.phoneNumber = numbers[i];
            }
        }
    }
    ;
    relatedRepresentatives(result) {
        if (result?.length > 0) {
            const getGrammerValue = this.applicationSettingManager.getObjectGrammerSetting("PersonDto_CallbackNote");
            if (!GlobalFunctions.isEmpty(getGrammerValue)) {
                for (let i = 0; i < result.length; i++) {
                    GlobalFunctions.setStringPresentation(result[i], getGrammerValue);
                    this.representativeList.push(result[i]);
                }
                this.selectedRepresentative = this.representativeList[this.representativeList.length - 1];
            }
            this.changeRepresentative();
        }
    }
    ;
    showPersonDeceasedWarning(personEntity) {
        if (personEntity.Details == null || !GlobalFunctions.isPersonDeceased(personEntity.Details.DateOfExpiration))
            return;
        if (personEntity.ConfidentialityLevel != 0)
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_INFORMATION_REQUEST'), textMsg: this.translateService.instant('LBL_WARNING_PERSON_DECEASED_CLASSIFIED'), isConfirmation: true, noButton: this.translateService.instant('LBL_NO'), yesButton: this.translateService.instant('LBL_YES') });
        else
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_INFORMATION_REQUEST'), textMsg: this.translateService.instant('LBL_WARNING_PERSON_DECEASED'), isConfirmation: true, noButton: this.translateService.instant('LBL_NO'), yesButton: this.translateService.instant('LBL_YES') }).afterClosed().subscribe(result => {
                if (!result && this.searchEntityTags.length > 0)
                    this.personTagRemoved(this.searchEntityTags[0]);
                document.getElementById('findFromSelectOption')?.focus();
            });
    }
    ;
    showPersonClassifiedWarning(personEntity) {
        if (personEntity.ConfidentialityLevel == 0)
            return;
        DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_INFORMATION_REQUEST'), textMsg: this.translateService.instant('LBL_WARNING_PERSON_CLASSIFIED'), isConfirmation: true, noButton: this.translateService.instant('LBL_NO'), yesButton: this.translateService.instant('LBL_YES') }).afterClosed().subscribe(result => {
            if (!result && this.searchEntityTags.length > 0)
                this.personTagRemoved(this.searchEntityTags[0]);
            document.getElementById("findFromSelectOption")?.focus();
        });
    }
    ;
    setTaskDetailFromSocialMedia() {
        if (GlobalFunctions.isEmpty(this.taskDto.CustomerOrOrganizationName) && GlobalFunctions.isEmpty(this.taskDto.CustomerQuestion)) {
            let result = GlobalFunctions.getLastSocialMediaHistoryRecord(this.sessionManager.detailViewCachedEntityList);
            if (!GlobalFunctions.isEmpty(result)) {
                this.taskDto.CustomerOrOrganizationName = result.User.Name;
                this.taskDto.CustomerQuestion = result.Message.Message;
            }
        }
    }
    ;
    setTaskQuestionFromTicket() {
        if (GlobalFunctions.isEmpty(this.taskDto.CustomerQuestion)) {
            let result = GlobalFunctions.getLastTicketFromSession(this.sessionManager.detailViewCachedEntityList);
            if (!GlobalFunctions.isEmpty(result))
                this.taskDto.CustomerQuestion = result.Description;
        }
    }
    ;
    fetchPersonDetailResponse(result) {
        this.stopSpinner();
        this.mainEntityObject = result;
        this.displayNumberOnUI(result.PhoneNumber, result.MobileNumber);
    }
    ;
    assignEmail(searchEntity, relationshipType) {
        let email = "";
        let cachedEntities = this.sessionManager.detailViewCachedEntityList;
        if (cachedEntities != null && cachedEntities.length > 0) {
            if (GlobalFunctions.isSessionContainsEmailRecord(cachedEntities)) {
                let emailObject = GlobalFunctions.getFirstEmailFromSession(cachedEntities);
                email = !GlobalFunctions.isEmpty(emailObject.Header) ? emailObject.Header.From : "";
            }
        }
        if (GlobalFunctions.isEmpty(email) && !GlobalFunctions.isEmpty(searchEntity)) {
            if (relationshipType == "Person")
                email = !GlobalFunctions.isEmpty(searchEntity.EmailAddress) ? searchEntity.EmailAddress : "";
            else if (relationshipType == "Organization")
                email = !GlobalFunctions.isEmpty(searchEntity.EmailAddress) ? searchEntity.EmailAddress : "";
        }
        return email;
    }
    fetchPersonDetail(entity) {
        let partialDto = new Object();
        partialDto.Id = entity.Id;
        partialDto.ObjectSource = entity.ObjectSource;
        this.personService.fetchDetail(partialDto, this.fetchPersonDetailResponse);
    }
    ;
    setMainEntity(searchEntity, relationshipType) {
        this.representativeList.length = 0;
        if (relationshipType == "")
            relationshipType = this.currentRelationType;
        let selectedEntityName = "";
        this.searchEntityTags = [];
        let searchEntitySelected = [];
        if (searchEntity != null) {
            document.getElementById('divContactAddress')?.setAttribute('readonly', 'true');
            if (relationshipType == 'Person') {
                if (searchEntity.Partial == true && GlobalFunctions.isEmpty(searchEntity.PhoneNumber)) {
                    this.startSpinner();
                    this.fetchPersonDetail(searchEntity);
                }
                if (GlobalFunctions.isPersonDeceased(searchEntity.Details.DateOfExpiration))
                    this.showPersonDeceasedWarning(searchEntity);
                else if (searchEntity.ConfidentialityLevel != 0)
                    this.showPersonClassifiedWarning(searchEntity);
                let getGrammerValue = this.applicationSettingManager.getObjectGrammerSetting("PersonDto_CallbackNote");
                if (!GlobalFunctions.isEmpty(getGrammerValue)) {
                    GlobalFunctions.setStringPresentation(searchEntity, getGrammerValue);
                    selectedEntityName = searchEntity.StringRepresentation;
                    if (!GlobalFunctions.isEmpty(searchEntity.Details) && !GlobalFunctions.isEmpty(searchEntity.Details.FormalName) && !GlobalFunctions.isEmpty(searchEntity.Details.FormalName.Gender)) {
                        if (searchEntity.Details.FormalName.Gender === 0)
                            selectedEntityName = this.translateService.instant("LBL_MR") + " " + selectedEntityName;
                        else if (searchEntity.Details.FormalName.Gender === 1)
                            selectedEntityName = this.translateService.instant("LBL_MRS") + " " + selectedEntityName;
                        else
                            selectedEntityName = this.translateService.instant("LBL_MR") + "/" + this.translateService.instant("LBL_MRS") + " " + selectedEntityName;
                    }
                }
            }
            else {
                if (GlobalFunctions.hasRight(GlobalFunctions.toContentType("Person"), OperationType.Add))
                    this.addDefaultRepresentative();
                selectedEntityName = searchEntity.Name;
                this.personService.clearCallbacks();
                this.personService.searchRelatedRepresentativeRequest(this.relatedRepresentatives, searchEntity);
            }
            this.taskDto.CustomerOrOrganizationName = selectedEntityName;
            searchEntitySelected.push({ text: selectedEntityName });
            this.searchEntityTags = searchEntitySelected;
            this.setSearchEntityProperties(searchEntity, relationshipType);
        }
        this.taskDto.ContactEmail = this.assignEmail(searchEntity, relationshipType);
    }
    ;
    setSearchEntityProperties(searchEntitySelected, relationshipType) {
        switch (relationshipType) {
            case 'Person':
                this.fillPersonInfo(searchEntitySelected);
                break;
            case 'Organization':
                this.fillOrganizationInfo(searchEntitySelected);
                break;
        }
    }
    ;
    fillPersonInfo(selectedEntity) {
        if (selectedEntity) {
            let person = GlobalFunctions.setEntityType(selectedEntity, JsonDtoType.Person);
            if (!person)
                return;
            this.mainEntityObject = person;
            this.confidentialityLevel = person.ConfidentialityLevel;
            this.taskDto.MainEntityId = person.Id;
            this.taskDto.MainEntitySource = person.ObjectSource;
            if (!GlobalFunctions.isEmpty(person.Details.DateOfBirth) && GlobalFunctions.validDate(person.Details.DateOfBirth))
                this.taskDto.CustomerDateOfBirth = new this.dateJS(person.Details.DateOfBirth);
            else
                this.taskDto.CustomerDateOfBirth = null;
            this.taskDto.CustomerBSN = this.formattedBSNPipe.transform(person.AdministeredPersonDto.ServiceNumber);
            this.taskDto.ContactAddress = this.personFormattedAddressWithLabelPipe.transform(person, false) || '';
            this.displayNumberOnUI(person.PhoneNumber, person.MobileNumber);
        }
    }
    ;
    openSearchPopup() {
        DialogHelper.openDialog(this.dialog, SearchPopupComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { name: this.currentRelationType, recordSelection: RecordSelection.Single }).afterClosed().subscribe(searchEntity => {
            this.setMainEntity(searchEntity, "");
            document.getElementById("findFromSelectOption")?.focus();
        });
    }
    ;
    clearSelectedEntity() {
        this.taskDto.CustomerOrOrganizationName = null;
        this.taskDto.CustomerBSN = null;
        this.taskDto.CustomerKVKNumber = null;
        this.taskDto.CustomerDateOfBirth = null;
        this.taskDto.ContactAddress = null;
        this.taskDto.ContactEmail = null;
        if (GlobalFunctions.isEmpty(this.sessionManager.currentCallerId)) {
            this.phoneNumber = null;
            this.mobileNumber = null;
            this.taskDto.ContactPhoneNumber = null;
        }
        document.getElementById('divContactAddress')?.removeAttribute('readonly');
    }
    ;
    setMainEntityPerson() {
        if (this.selectedFindFrom == "Related") {
            let mainEntityPerson = GlobalFunctions.getLastPersonFromSession(this.sessionManager.detailViewCachedEntityList);
            this.setMainEntity(mainEntityPerson, "Person");
        }
    }
    ;
    setMainEntityOrganization() {
        if (this.selectedFindFrom == "Related") {
            let mainEntityOrganization = GlobalFunctions.getLastOrganizationFromSession(this.sessionManager.detailViewCachedEntityList);
            this.setMainEntity(mainEntityOrganization, "Organization");
        }
    }
    ;
    personTagRemoved(tag) {
        this.representativeList.length = 0;
        this.searchEntityTags = [];
        if (this.confidentialityLevel != 0)
            this.confidentialityLevel = 0;
        this.clearSelectedEntity();
    }
    ;
    setHandlerTags() {
        switch (this.currentHandlerType) {
            case 'Employee':
                return this.handlerTagItems = this.cacheManager.getEmployeeList(true);
            case 'Department':
                return this.handlerTagItems = this.cacheManager.getDepartmentList();
            case 'Mailbox':
                return this.handlerTagItems = this.cacheManager.getTaskMailboxList();
        }
    }
    changedHandlerType() {
        this.setHandlerTags();
        this.handlerTags = [];
        document.getElementById('assignHandlerInfoReqTagsInputControl')?.focus();
    }
    ;
    registerDialogShortcutKey() {
        this.shortcutManager.bind('LBL_SHORTCUT_SAVE_BUTTON', () => this.addInformationRequest());
    }
    ;
    update() {
        this.representativeList = [];
        this.selectedRepresentative = null;
        switch (this.selectedFindFrom) {
            case "ManualEntry":
                {
                    if (this.selectedFindFrom == "ManualEntry") {
                        if (this.currentRelationType == "Person")
                            document.getElementById('customerNameValue')?.focus();
                        else
                            document.getElementById('organizationNameValue')?.focus();
                    }
                    break;
                }
            case "Search":
                {
                    if (this.selectedFindFrom == "Search") {
                        this.openSearchPopup();
                        this.selectedFindFrom = "SelectAny";
                    }
                    break;
                }
        }
        this.searchEntityTags = [];
        this.clearSelectedEntity();
    }
    ;
    fillOrganizationInfo(selectedEntity) {
        if (selectedEntity != null) {
            let organization = GlobalFunctions.setEntityType(selectedEntity, JsonDtoType.Organization);
            if (organization.Partial != true)
                this.mainEntityObject = organization;
            this.taskDto.MainEntityId = organization.Id;
            this.taskDto.MainEntitySource = organization.ObjectSource;
            this.taskDto.CustomerKVKNumber = organization.AdministeredOrganizationDto.Identification;
            if (organization.RegistrationAddress != null)
                this.taskDto.ContactAddress = this.organizationFormattedAddressWithLabel.transform(organization, false) || '';
            if (!GlobalFunctions.isEmpty(organization.PhoneNumber))
                this.phoneNumber = !GlobalFunctions.isEmpty(this.sessionManager.currentCallerId) && !GlobalFunctions.isMobileNumber(this.sessionManager.currentCallerId) ? this.sessionManager.currentCallerId : organization.PhoneNumber;
        }
    }
    ;
    selectOptionsFromFindList() {
        let result = GlobalFunctions.isSessionContainsPersonOrganizationRecord(this.sessionManager.detailViewCachedEntityList);
        if (result) {
            this.selectedFindFrom = "Related";
            let mainEntityPerson = GlobalFunctions.getLastPersonFromSession(this.sessionManager.detailViewCachedEntityList);
            if (mainEntityPerson) {
                this.currentRelationType = "Person";
                this.setMainEntity(mainEntityPerson, "Person");
            }
            else {
                this.currentRelationType = "Organization";
                let mainEntityOrganization = GlobalFunctions.getLastOrganizationFromSession(this.sessionManager.detailViewCachedEntityList);
                this.setMainEntity(mainEntityOrganization, "Organization");
            }
        }
        else
            this.selectedFindFrom = "ManualEntry";
    }
    ;
    addInformationRequest() {
        if (GlobalFunctions.editorIsEmpty(this.taskDto.CustomerQuestion) || this.handlerTags.length === 0 || this.form.invalid)
            return;
        this.taskDto.TaskType = TaskType[TaskType.InformationRequest];
        this.taskDto.CreateTaskAction = CreateTaskAction.ThroughNote;
        this.taskDto.CurrentStatus = TaskStatus.Unhandled;
        this.taskDto.Priority = this.priorityValue;
        this.taskDto.PriorityText = this.priorities[this.priorityValue - 1].priorityText;
        if (this.editedTaskData == null) {
            this.taskDto.CreatedDate = new this.dateJS().toString(this.sessionManager.defaultOptions.mdyyyyhhmmss);
            this.taskDto.Tags = this.sessionManager.getTags();
            this.taskDto.CreatedById = GlobalFunctions.getLoggedInUserId();
        }
        else
            this.taskDto.CreatedDate = this.editedTaskData.CreatedDate;
        if (this.employeeService.loggedInEmployee != null) {
            let baseDtoObject = new BaseDto();
            baseDtoObject.Id = this.taskDto.CreatedById;
            let loggedInEmployee = this.cacheManager.getEmployeeById(this.taskDto.CreatedById);
            if (!GlobalFunctions.isEmpty(loggedInEmployee))
                baseDtoObject.StringRepresentation = loggedInEmployee.StringRepresentation;
            this.taskDto.CreatedBy = baseDtoObject;
        }
        this.taskDto.MainEntityType = MainEntityType[this.currentRelationType];
        if (!GlobalFunctions.isEmpty(this.requiredCallbackDate))
            this.taskDto.RequiredCallbackDate = new this.dateJS(this.requiredCallbackDate).toString('M/d/yyyy HH:mm:ss');
        if (this.currentRelationType == "Organization" && this.taskDto.ContactPerson != null && this.taskDto.ContactPerson != '')
            this.taskDto.ContactPerson = this.taskDto.CustomerOrOrganizationName + "/" + this.taskDto.ContactPerson;
        else
            this.taskDto.ContactPerson = this.taskDto.CustomerOrOrganizationName;
        this.assignContactNumberInTaskDto();
        let taskHistoryDto = new TaskHistoryDto();
        taskHistoryDto.DateRecorded = new this.dateJS().toString(this.sessionManager.defaultOptions.mdyyyyhhmmss);
        taskHistoryDto.CreatedById = GlobalFunctions.getLoggedInUserId();
        taskHistoryDto.TaskHandlerList = [];
        taskHistoryDto.StatusText = this.translateService.instant("LBL_UNHANDLED");
        taskHistoryDto.Status = TaskStatus.Unhandled;
        taskHistoryDto.ReasonFreeText = this.taskDto.CustomerQuestion.replace(/<img[^>]*>/g, '');
        taskHistoryDto.ReplyBy = TaskReplyBy.User;
        let currentHandlerList = "";
        if (this.handlerTags != undefined && this.handlerTags != null && this.handlerTags.length > 0) {
            for (let i = 0; i < this.handlerTags.length; i++) {
                let taskHandler = new TaskHandlerDto();
                taskHandler.HandlerType = TaskHandlerType[this.currentHandlerType];
                if (this.currentHandlerType == "Email") {
                    taskHandler.HandlerId = this.handlerTags[i].text;
                    taskHandler.HandlerObject = new BaseDto();
                    taskHandler.HandlerObject.Id = taskHandler.HandlerId;
                    taskHandler.HandlerObject.StringRepresentation = taskHandler.HandlerId;
                }
                else {
                    taskHandler.HandlerId = this.handlerTags[i].Id;
                    taskHandler.HandlerObject = this.handlerTags[i];
                    if (this.currentHandlerType == "Mailbox")
                        taskHandler.DepartmentId = this.handlerTags[i].Department;
                }
                taskHistoryDto.TaskHandlerList.push(taskHandler);
                if (currentHandlerList.length === 0)
                    currentHandlerList = taskHandler.HandlerObject.StringRepresentation;
                else
                    currentHandlerList = currentHandlerList + ", " + taskHandler.HandlerObject.StringRepresentation;
            }
        }
        this.taskDto.TaskHistoryList = [];
        this.taskDto.TaskHistoryList.push(taskHistoryDto);
        let cachedEntities = this.sessionManager.detailViewCachedEntityList;
        if (cachedEntities != null && cachedEntities.length > 0) {
            this.taskDto.RelatedEntityList = [];
            cachedEntities.forEach((value, key) => {
                if (value != undefined && value.key != null && value.key != undefined && value.key.IsMarked) {
                    let relatedEntityDto = new RelatedEntityDto();
                    relatedEntityDto.RelatedEntityId = value.key.Id;
                    let actualEntityType = value.value.replace(/\./g, '_');
                    relatedEntityDto.EntityType = EntityFqdn["" + actualEntityType + ""];
                    relatedEntityDto.ObjectSource = value.key.ObjectSource;
                    relatedEntityDto.EntityTitle = GlobalFunctions.sanitizeAndTruncate(value.key.StringRepresentation);
                    this.taskDto.RelatedEntityList.push(relatedEntityDto);
                }
            });
        }
        if (this.fileAttachments.length > 0) {
            if (GlobalFunctions.isEmpty(this.taskDto.AttachmentList))
                this.taskDto.AttachmentList = [];
            for (let i = 0; i < this.fileAttachments.length; i++) {
                const attachment = new AttachmentDto();
                attachment.OnServer = !GlobalFunctions.isEmpty(this.fileAttachments[i].id);
                attachment.FileName = this.fileAttachments[i].fileNameOnServer;
                attachment.Name = this.fileAttachments[i].text;
                attachment.IsMarked = true;
                attachment.RelatedEntityFqdn = EntityFqdn.Decos_Kcs_Tasks_Entities_InformationRequest;
                this.taskDto.AttachmentList.push(attachment);
                if (!GlobalFunctions.isEmpty(this.fileAttachments[i].id)) {
                    let relatedEntityDto = new RelatedEntityDto();
                    relatedEntityDto.StringRepresentation = this.fileAttachments[i].text;
                    relatedEntityDto.RelatedEntityId = this.fileAttachments[i].id;
                    relatedEntityDto.EntityType = EntityFqdn.Decos_Kcs_Files_Entities_FileEntity;
                    relatedEntityDto.ObjectSource = SourceType.File_Cdr;
                    if (this.taskDto.RelatedEntityList)
                        this.taskDto.RelatedEntityList.push(relatedEntityDto);
                }
            }
        }
        if (GlobalFunctions.isEmpty(this.taskDto.Id)) {
            this.taskDto.Id = GlobalFunctions.createGuid().replace(/-/g, '');
            if (this.sessionManager.selectedRole != null && !GlobalFunctions.isEmpty(this.sessionManager.selectedRole.Id))
                this.taskDto.RoleId = this.sessionManager.selectedRole.Id;
        }
        if (this.validateContactNumbers(this.taskDto.ContactPhoneNumber))
            this.sendCreateTaskRequest();
        else {
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant("LBL_CALLBACK_NOTE"), textMsg: this.translateService.instant("LBL_PHONE_NUMBER_WARNING"), isConfirmation: true, noButton: this.translateService.instant('LBL_NO'), yesButton: this.translateService.instant('LBL_YES') }).afterClosed().subscribe(result => {
                if (result)
                    this.sendCreateTaskRequest();
            });
        }
    }
    ;
    validateContactNumbers(contactNumber) {
        let isValidNumber = true;
        let countryCode = this.applicationSettingManager.getApplicationSettingValueByKey("PHONECOUNTRYCODE");
        if (!GlobalFunctions.isEmpty(contactNumber)) {
            let contactNumbers = contactNumber.split('/');
            for (let i = 0; i < contactNumbers.length; i++) {
                if (!GlobalFunctions.isValidPhonenumber(contactNumbers[i], countryCode))
                    isValidNumber = false;
            }
        }
        return isValidNumber;
    }
    ;
    sendCreateTaskRequest() {
        this.startSpinner();
        let createTaskRequest = new CreateTaskRequest();
        createTaskRequest.TaskDto = this.taskDto;
        this.taskService.createTask(createTaskRequest, this.addInformationRequestResponse, () => { }, () => { });
    }
    ;
    addInformationRequestResponse(response) {
        this.stopSpinner();
        this.eventProvider.BroadcastEvent(BroadCastEventKeys.FETCH_TASK_STATISTIC);
        switch (response?.Result) {
            case 0:
                {
                    this.sessionManager.loadedFromRelatedView = false;
                    this.taskDto.Id = response.TaskId;
                    this.taskDto.CreatedDate = new this.dateJS().toString(this.sessionManager.defaultOptions.mdyyyyhhmmss);
                    this.taskDto.RelatedEntityFqdn = EntityFqdn[EntityFqdn.Decos_Kcs_Tasks_Entities_InformationRequest];
                    this.sessionManager.selectedEntity = this.taskDto;
                    this.sessionManager.selectedEntity.Partial = true;
                    this.sessionManager.selectedEntity.locationUrl = `/${RoutePath.DETAIL_PATH}/informationrequest/${this.taskDto.Id}`;
                    let selectedIndex = this.sessionManager.BreadcrumbItems.length - 1;
                    this.sessionManager.BreadcrumbItems.splice(selectedIndex, 1);
                    GlobalFunctions.setStringPresentation(this.taskDto, this.applicationSettingManager.getObjectGrammerSetting("InformationRequestDto_Breadcrumb"));
                    this.sessionManager.addBreadcrumbItems([this.taskDto], null, RoutePath.DETAIL_PATH);
                    if (this.router.url === this.sessionManager.selectedEntity.locationUrl)
                        this.eventProvider.BroadcastEvent(BroadCastEventKeys.RELOAD_ENTITY_DETAIL);
                    else
                        this.router.navigate([this.sessionManager.selectedEntity.locationUrl]);
                    this.close();
                    if (this.selectedFindFrom != "ManualEntry")
                        this.sessionManager.addEntityToSession(this.mainEntityObject, this.taskDto.MainEntityType);
                    break;
                }
            default:
                {
                    DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_INFORMATION_REQUEST'), textMsg: this.translateService.instant("LBL_MESSAGE_FAIL_SAVE_INFORMATION_REQUEST") });
                    break;
                }
        }
        this.stopSpinner();
    }
    ;
    assignContactNumberInTaskDto() {
        if (!GlobalFunctions.isEmpty(this.phoneNumber) && !GlobalFunctions.isEmpty(this.mobileNumber))
            this.taskDto.ContactPhoneNumber = this.phoneNumber + "/" + this.mobileNumber;
        else if (!GlobalFunctions.isEmpty(this.phoneNumber))
            this.taskDto.ContactPhoneNumber = this.phoneNumber;
        else
            this.taskDto.ContactPhoneNumber = this.mobileNumber;
    }
    ;
    resize() {
        $("#jkcParentPanel").css({ 'max-height': ($(window).height() - parseInt(this.sessionManager.jkcParentPanel?.parameters?.TopSpace) - 100 + "px") });
        $("#addInformationRequestContainer").height($("#jkcParentPanel").height() - $("#addInformationRequestHeader").height() - $("#addInformationRequestFooter").height() + "px");
        $(".tox-tinymce").height($("#jkcParentPanel").height() - $("#addInformationRequestHeader").height() - $("#addInformationRequestFooter").height() - 455 + "px");
        $('#' + this.sessionManager.jkcParentPanel?.parameters?.HeaderId).css({ 'width': ($("#jkcParentPanel").width()) });
        $('#' + this.sessionManager.jkcParentPanel?.parameters?.FooterId).css({ 'width': ($("#jkcParentPanel").width()) });
    }
    handleEscKey() {
        if (!GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) && this.sessionManager.jkcParentPanel?.parameters?.IsPanelExpanded)
            this.close();
    }
    ;
    searchEmployee() {
        const searchPopup = this.dialogManager.openJsPanelOrDialog('SEARCH_EMPLOYEE_POPUP_PANEL').afterClosed().subscribe(result => {
            if (result?.selectedEmployee) {
                result.selectedEmployee.text = result.selectedEmployee.StringRepresentation;
                this.handlerTags.push(result.selectedEmployee);
            }
        });
        // Set isParentPopup to false (will not open in detail view) when opening EmployeePanel from Information Request
        if (searchPopup && searchPopup.componentInstance)
            searchPopup.componentInstance.isParentPopup = false;
    }
    ;
    loadEditTaskData(taskSessionData) {
        this.taskDto = jQuery.extend(true, {}, taskSessionData);
        if (!GlobalFunctions.isEmpty(taskSessionData.CurrentHandlerList)) {
            this.taskDto.HandlerTags = [];
            for (let i = 0; i < taskSessionData.CurrentHandlerList.length; i++) {
                let handlerId = taskSessionData.CurrentHandlerList[i].HandlerId;
                if (!GlobalFunctions.isEmpty(handlerId)) {
                    let handleData = null;
                    if (taskSessionData.CurrentHandlerType == TaskHandlerType.Employee || taskSessionData.CurrentHandlerType == "Employee")
                        handleData = this.cacheManager.getEmployeeById(handlerId);
                    else if (taskSessionData.CurrentHandlerType == TaskHandlerType.Department || taskSessionData.CurrentHandlerType == "Department")
                        handleData = this.cacheManager.getDepartmentById(handlerId);
                    else if (taskSessionData.CurrentHandlerType == TaskHandlerType.Mailbox || taskSessionData.CurrentHandlerType == "Mailbox")
                        handleData = this.cacheManager.getTaskMailboxById(handlerId);
                    else if (taskSessionData.CurrentHandlerType == TaskHandlerType.Email || taskSessionData.CurrentHandlerType == "Email")
                        handleData = handlerId;
                    if (handleData != null) {
                        if (taskSessionData.CurrentHandlerType == "Email")
                            this.taskDto.HandlerTags.push({ text: handleData });
                        else {
                            handleData.text = handleData.StringRepresentation;
                            this.taskDto.HandlerTags.push(handleData);
                        }
                    }
                }
            }
        }
        if (!GlobalFunctions.isEmpty(taskSessionData.SearchEntityTags)) {
            this.taskDto.SearchEntityTags = [];
            for (let i = 0; i < taskSessionData.SearchEntityTags.length; i++) {
                this.taskDto.SearchEntityTags.push(taskSessionData.SearchEntityTags[i]);
            }
        }
        if (!GlobalFunctions.isEmpty(this.taskDto.HandlerTags))
            this.handlerTags = this.taskDto.HandlerTags;
        if (GlobalFunctions.isEmpty(this.taskDto.MainEntityId))
            this.selectedFindFrom = "ManualEntry";
        else
            this.selectedFindFrom = "Related";
        if (!GlobalFunctions.isEmpty(this.taskDto) && !GlobalFunctions.isEmpty(this.taskDto.ContactPhoneNumber)) {
            let phoneNumbers = this.taskDto.ContactPhoneNumber.split("/");
            if (phoneNumbers.length == 2) {
                if (GlobalFunctions.isMobileNumber(phoneNumbers[0])) {
                    this.mobileNumber = phoneNumbers[0];
                    this.phoneNumber = phoneNumbers[1];
                }
                else if (GlobalFunctions.isMobileNumber(phoneNumbers[1])) {
                    this.mobileNumber = phoneNumbers[1];
                    this.phoneNumber = phoneNumbers[0];
                }
                else {
                    this.phoneNumber = phoneNumbers[0];
                    this.mobileNumber = phoneNumbers[1];
                }
            }
            else {
                if (GlobalFunctions.isMobileNumber(phoneNumbers[0]))
                    this.mobileNumber = phoneNumbers[0];
                else
                    this.phoneNumber = phoneNumbers[0];
            }
        }
        this.priorityValue = this.taskDto.Priority;
        if (GlobalFunctions.isEmpty(this.taskDto.PublishTo))
            this.taskDto.PublishTo = PublishTo.Myself;
        if (!GlobalFunctions.isEmpty(this.taskDto.MainEntityType)) {
            if (typeof this.taskDto.MainEntityType === 'number')
                this.currentRelationType = MainEntityType[this.taskDto.MainEntityType];
            else
                this.currentRelationType = this.taskDto.MainEntityType;
        }
        this.currentHandlerType = this.taskDto.CurrentHandlerType;
        if (!GlobalFunctions.isEmpty(this.taskDto.SearchEntityTags))
            this.searchEntityTags = this.taskDto.SearchEntityTags;
        if (!GlobalFunctions.isEmpty(this.currentRelationType) && typeof this.currentRelationType === 'string' && this.currentRelationType.toLowerCase() == "organization") {
            let organizationDto = new Object();
            organizationDto.Id = this.taskDto.MainEntityId;
            organizationDto.ObjectSource = this.taskDto.MainEntitySource;
            organizationDto.RelatedEntityFqdn = EntityFqdn.Decos_Kcs_Organizations_Entities_Organization;
            this.personService.clearCallbacks();
            this.personService.searchRelatedRepresentativeRequest(this.relatedRepresentatives, organizationDto);
        }
        if (!GlobalFunctions.isEmpty(this.taskDto.RequiredCallbackDate))
            this.timeoutIds.push(setTimeout(() => { GlobalFunctions.setDateFormat("dueDate", this.taskDto.RequiredCallbackDate, this.sessionManager.defaultOptions.defaultDateFormat, this.datePipe); }, 100));
        if (this.taskDto.currentTemplate) {
            const foundTemplate = this.templates.find(template => template.Name === this.taskDto.currentTemplate.Name);
            if (foundTemplate)
                this.currentTemplate = foundTemplate;
        }
        if (this.taskDto.AttachmentList) {
            this.taskDto.AttachmentList.forEach(attachment => {
                this.fileAttachments.push({ id: attachment.id, text: attachment.text, fromTemplate: true });
            });
        }
    }
    ;
    setCustomerQuestion() {
        if (!GlobalFunctions.isEmpty(this.sessionManager.contactSessionNotesState.ContactHistoryDto.Notes)) {
            let copyFromSessionNote = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Tasks_Entities_Task, "PREFILLSESSIONNOTESINQUESTION");
            if (!GlobalFunctions.isEmpty(copyFromSessionNote) && copyFromSessionNote.toLowerCase() == "true")
                this.taskDto.CustomerQuestion = this.sessionManager.contactSessionNotesState.ContactHistoryDto.Notes;
        }
    }
    ;
    templateChanged() {
        this.requiredCallbackDate = null;
        if (this.fileAttachments.length > 0)
            this.fileAttachments = GlobalFunctions.removeByAttr(this.fileAttachments, 'fromTemplate', true);
        this.taskDto.CustomerQuestion = this.getHtmlBody();
        let customerQuestionContent = this.taskDto.CustomerQuestion;
        let questionBody = $(customerQuestionContent);
        if (questionBody.length > 0) {
            customerQuestionContent = '';
            questionBody.each((i, eachQuestionNode) => {
                if (eachQuestionNode.nodeName.toUpperCase() == "DIV" && !GlobalFunctions.isEmpty(eachQuestionNode.id) && eachQuestionNode.id == "newQuestionContent") {
                    if (!GlobalFunctions.isEmpty(eachQuestionNode.outerHTML) && eachQuestionNode.outerHTML.indexOf("taskSelectedTemplate") == -1 && !GlobalFunctions.isEmpty(this.currentTemplate))
                        eachQuestionNode.innerHTML = "<div id='taskSelectedTemplate'>" + this.formatManager.mergeTaskTemplate(this.currentTemplate.Content).replace(/([\"]*[\&]*amp;[amp;]*[\"]*)/g, "") + "</div>" + eachQuestionNode.innerHTML.replace(/<p><\/p><p><\/p><p><\/p> <br><br><br><br>/gi, '');
                    else {
                        eachQuestionNode.childNodes.forEach(childNode => {
                            if (childNode.nodeName.toUpperCase() == "DIV" && !GlobalFunctions.isEmpty(childNode.id) && childNode.id == "taskSelectedTemplate")
                                childNode.innerHTML = !GlobalFunctions.isEmpty(this.currentTemplate) ? this.formatManager.mergeTaskTemplate(this.currentTemplate.Content) : "";
                        });
                    }
                }
            });
            if (!GlobalFunctions.isEmpty(this.currentTemplate)) {
                if (!GlobalFunctions.isEmpty(this.currentTemplate.DueDays) && this.currentTemplate.DueDays > 0) {
                    this.requiredCallbackDate = GlobalFunctions.addWorkDays(this.currentTemplate.DueDays);
                    this.timeoutIds.push(setTimeout(() => { GlobalFunctions.setDateFormat("dueDate", this.requiredCallbackDate, this.sessionManager.defaultOptions.defaultDateFormat, this.datePipe); }, 100));
                }
                if (!GlobalFunctions.isEmpty(this.currentTemplate.Attachments) && this.currentTemplate.Attachments.length > 0) {
                    let attachments = [];
                    for (let i = 0; i < this.currentTemplate.Attachments.length; i++)
                        attachments.push({ id: this.currentTemplate.Attachments[i].Id, text: this.currentTemplate.Attachments[i].Name, fileNameOnServer: this.currentTemplate.Attachments[i].Path, fromTemplate: true });
                    this.fileAttachments = this.fileAttachments.concat(attachments);
                }
                if (this.currentTemplate.RequiredFields?.length > 0)
                    this.requiredFields = GlobalFunctions.setRequiredFieldsFromTaskTemplate(this.currentTemplate);
                else
                    this.requiredFields = new RequiredFields();
                if (this.currentTemplate.HandlerIds?.length > 0) {
                    this.handlerTags = [];
                    let handlerType = GlobalFunctions.setHandlerListFromTaskTemplate(this.currentTemplate, this.cacheManager, this.handlerTags);
                    this.currentHandlerType = handlerType;
                }
            }
        }
        questionBody.each((i, eachQuestionNode) => {
            if (eachQuestionNode.nodeName.toUpperCase() == "#TEXT")
                customerQuestionContent += eachQuestionNode.data;
            else
                customerQuestionContent += eachQuestionNode.outerHTML;
        });
        this.taskDto.CustomerQuestion = customerQuestionContent;
    }
    ;
    getHtmlBody() {
        return "<div id='newQuestionContent'><p></p><p></p><p></p><p></p> <br/><br/><br/><br/></div>";
    }
    ;
    initEditor() {
        this.tinymceOptions = {
            plugins: TinyMCE.PLUGINS,
            toolbar: TinyMCE.TASK_TOOLBAR,
            font_size_formats: TinyMCE.FONT_SIZE_FORMATS,
            font_family_formats: TinyMCE.FONT_FAMILY_FORMATS,
            contextmenu: false,
            browser_spellcheck: true,
            force_br_newlines: false,
            forced_root_block: 'div',
            paste_data_images: true,
            base_url: '/tinymce',
            iframe_aria_text: GlobalFunctions.removeHTMLTags(this.taskDto.CustomerQuestion),
            resize: false,
            elementpath: false,
            menubar: false,
            apply_source_formatting: true,
            statusbar: false,
            entity_encoding: 'raw',
            content_style: "p {margin: 0; padding: 0;} body {font: 400 15px 'Open Sans', sans-serif !important;}",
            height: $("#jkcParentPanel").height() - $("#addInformationRequestHeader").height() - $("#addInformationRequestFooter").height() - 455 + "px",
            paste_postprocess: (plugin, args) => args.node.setAttribute('id', '42'),
            file_picker_types: 'image',
            images_upload_base_path: '/cacheddata/' + GlobalFunctions.getSessionTokenAsString() + '/',
            init_instance_callback: editor => {
                GlobalFunctions.setEditorBodyHeight();
                this.editor = editor;
                editor.on('keydown', event => {
                    if (event.keyCode === 27)
                        this.close();
                });
            },
            file_picker_callback: (callback, value, meta) => {
                this.fileManager.setFilePickerCallback(callback, value, meta, this.editor, EntityName.TASK);
            },
            images_upload_handler: (blobInfo, progress) => {
                return this.fileManager.setFileUploadHandler(blobInfo, progress, this.tinymceOptions.images_upload_base_path, FileUploadSource.Task);
            }
        };
        this.resize();
        if (this.translateService.currentLang != LanaguageCode.EN_CODE)
            this.tinymceOptions.language = LanaguageCode.NL_CODE;
    }
    onUpload(file) {
        this.startSpinner();
        this.errorMessage = '';
        this.uploadedFiles[this.uploadedFiles.length] = file.name;
    }
    onSuccess(response) {
        this.fileAttachments.push({ text: this.uploadedFiles[this.uploadedFiles.length - 1], fileNameOnServer: response[0].fileName });
        this.errorMessage = '';
        this.stopSpinner();
    }
    onError(error) {
        this.uploadedFiles.splice(this.uploadedFiles.length - 1, 1);
        this.errorMessage = GlobalFunctions.getFileUploadErrorText(error, this.translateService);
        this.stopSpinner();
    }
    informationDOBChange(event, inputId) {
        GlobalFunctions.setDateFormat(inputId, event.target.value, this.sessionManager.defaultOptions.defaultDateFormat, this.datePipe);
        JkcDatePickerHelper.isDatePickerClosed = true;
    }
    initDatePickerState() {
        JkcDatePickerHelper.setMargin('135px', '-114px', 'fixed', this.renderer);
        JkcDatePickerHelper.setOverlayBackgroundColor(false, this.renderer);
        JkcDatePickerHelper.isDatePickerClosed = false;
        this.dateAdapter.setLocale(CommonHelper.getLanguageCode());
        if (!GlobalFunctions.isEmpty(this.requiredCallbackDate))
            GlobalFunctions.setDateFormat("dueDate", this.requiredCallbackDate, this.sessionManager.defaultOptions.defaultDateFormat, this.datePipe);
    }
    close() {
        this.dialogManager.removeComponent();
        this.sessionManager.closeJkcParentPanel();
    }
};
__decorate([
    ViewChild('form')
], InformationRequestAddEditComponent.prototype, "form", void 0);
InformationRequestAddEditComponent = __decorate([
    Component({
        selector: 'information-request-add-edit',
        templateUrl: './information-request-add-edit.component.html',
        styleUrls: ['./information-request-add-edit.component.scss'],
        host: { '(window:resize)': 'resize()' }
    })
], InformationRequestAddEditComponent);
export { InformationRequestAddEditComponent };
//# sourceMappingURL=information-request-add-edit.component.js.map