var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, ViewChild } from '@angular/core';
import { SubSink } from 'subsink';
import { BaseDialogComponent } from '../../../../../../components/common/base-dialog.component';
import { FileUploadSource, ScreenMode } from '../../../../../../core/enums/common-enums';
import { EntityFqdn } from '../../../../../../core/enums/core-enums';
import { CallbackNoteStatus, CreateTaskAction, SubTaskType, TaskHandlerType, TaskStatus, TaskType } from '../../../../../../core/enums/task-enum';
import { CreateTaskRequest } from '../../../../../../core/models/case/case-task-request';
import { BaseDto } from '../../../../../../core/models/common/baseDto';
import { RelatedEntityDto } from '../../../../../../core/models/common/related-enityDto';
import { TaskAssignmentDto } from '../../../../../../core/models/task/task-assignmentDto';
import { TaskHandlerDto } from '../../../../../../core/models/task/task-handlerDto';
import { TaskHistoryDto } from '../../../../../../core/models/task/task-historyDto';
import { BroadCastEventKeys, EntityName, LanaguageCode, RoutePath, TinyMCE } from '../../../../../../shared/constants';
import { GlobalFunctions } from '../../../../../../shared/global-functions';
import { CommonHelper } from '../../../../../../shared/helper/common-helper';
import { DialogHelper } from '../../../../../../shared/helper/dialog-helper';
import { MessageboxComponent } from '../../../../../common/messagebox/messagebox.component';
let AssignmentAddEditComponent = class AssignmentAddEditComponent extends BaseDialogComponent {
    constructor(router, dialog, taskService, emailService, cacheManager, eventProvider, dialogManager, sessionManager, shortcutManager, formatManager, employeeService, translateService, socialMediaService, integrationSettingManager, applicationSettingManager, fileService, fileManager) {
        super();
        this.router = router;
        this.dialog = dialog;
        this.taskService = taskService;
        this.emailService = emailService;
        this.cacheManager = cacheManager;
        this.eventProvider = eventProvider;
        this.dialogManager = dialogManager;
        this.sessionManager = sessionManager;
        this.shortcutManager = shortcutManager;
        this.formatManager = formatManager;
        this.employeeService = employeeService;
        this.translateService = translateService;
        this.socialMediaService = socialMediaService;
        this.integrationSettingManager = integrationSettingManager;
        this.applicationSettingManager = applicationSettingManager;
        this.fileService = fileService;
        this.fileManager = fileManager;
        this.dateJS = Date;
        this.handlerTags = [];
        this.handlerTagItems = [];
        this.editedTaskData = this.sessionManager.jkcParentPanel.parameters.EditedData;
        this.title = this.editedTaskData == null ? this.translateService.instant("LBL_ADD_ASSIGNMENT").toUpperCase() : this.translateService.instant("LBL_EDIT").toUpperCase() + ' ' + this.translateService.instant("LBL_ASSIGNMENT").toUpperCase();
        this.currentHandlerType = 'Employee';
        this.handlerTypeOption = this.applicationSettingManager.getUIHandlerTypeOption();
        this.taskDto = new TaskAssignmentDto();
        this.taskType = "assignment";
        this.priorities = [
            { priorityValue: 1, priorityText: this.translateService.instant("LBL_LOW") },
            { priorityValue: 2, priorityText: this.translateService.instant("LBL_MEDIUM") },
            { priorityValue: 3, priorityText: this.translateService.instant("LBL_HIGH") }
        ];
        this.priorityValue = 2;
        this.templates = [];
        this.currentTemplate = null;
        this.isSubTaskType = false;
        this.editMode = this.sessionManager.jkcParentPanel.parameters.EditMode;
        this.subs = new SubSink();
        this.uploadedFile = null;
        this.customerQuestionFieldId = 'tinymceAssignment' + GlobalFunctions.getGuid();
        this.timeoutIds = [];
        this.enableDepartmentNameInHandler = this.applicationSettingManager.isDepartmentNameInHandlerEnabled();
        this.addAssignmentResponse = this.addAssignmentResponse.bind(this);
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.JSPANEL_RESIZE).subscribe(() => this.resize());
    }
    ngOnInit() {
        this.sessionManager.startSessionIfPossible("TASK", this.sessionManager.jkcParentPanel.parameters.EditedData == null ? ScreenMode.Add : ScreenMode.Edit);
        this.sessionManager.jkcParentPanel.parameters.Scope = this;
        this.templates = this.applicationSettingManager.getTaskTemplates(EntityFqdn.Decos_Kcs_Tasks_Entities_Assignment);
        this.timeoutIds.push(setTimeout(() => this.resize(), 300));
        if (!this.editedTaskData) {
            this.initializeSubTaskType();
            if (this.sessionManager.selectedEntity?.ObjectSource?.toLowerCase().indexOf("employee") > -1) {
                let items = [];
                this.sessionManager.selectedEntity.text = this.sessionManager.selectedEntity.StringRepresentation;
                items.push(this.sessionManager.selectedEntity);
                this.handlerTags = items;
            }
            if (GlobalFunctions.isEmpty(this.handlerTags)) {
                let lastEmployee = GlobalFunctions.getLastEmployeeFromSession(this.sessionManager.detailViewCachedEntityList);
                if (!GlobalFunctions.isEmpty(lastEmployee))
                    this.handlerTags = [lastEmployee];
            }
            this.setCustomerQuestion();
            this.setTaskDetailFromSocialMedia();
            this.setTaskQuestionFromTicket();
        }
        else
            this.loadEditTaskData(this.editedTaskData);
        this.initEditor();
        this.registerDialogShortcutKey();
        document.getElementById(this.customerQuestionFieldId)?.focus();
        this.setHandlerTags();
    }
    ngOnDestroy() {
        this.shortcutManager.unbind('LBL_SHORTCUT_SAVE_BUTTON');
        this.subs.unsubscribe();
        this.timeoutIds.forEach(timeoutId => clearTimeout(timeoutId));
    }
    setTaskDetailFromSocialMedia() {
        if (GlobalFunctions.isEmpty(this.taskDto.CustomerQuestion)) {
            let result = GlobalFunctions.getLastSocialMediaHistoryRecord(this.sessionManager.detailViewCachedEntityList);
            if (!GlobalFunctions.isEmpty(result))
                this.taskDto.CustomerQuestion = result.Message.Message;
        }
    }
    ;
    setTaskQuestionFromTicket() {
        if (GlobalFunctions.isEmpty(this.taskDto.CustomerQuestion)) {
            let result = GlobalFunctions.getLastTicketFromSession(this.sessionManager.detailViewCachedEntityList);
            if (!GlobalFunctions.isEmpty(result))
                this.taskDto.CustomerQuestion = result.Description;
        }
    }
    ;
    registerDialogShortcutKey() {
        this.shortcutManager.bind('LBL_SHORTCUT_SAVE_BUTTON', () => this.addAssignment());
    }
    ;
    addAssignment() {
        if (GlobalFunctions.editorIsEmpty(this.taskDto.CustomerQuestion) || this.handlerTags.length === 0 || this.form.invalid)
            return;
        this.startSpinner();
        this.taskDto.TaskType = TaskType[TaskType.Assignment];
        this.taskDto.CreateTaskAction = CreateTaskAction.ThroughNote;
        this.taskDto.CurrentStatus = CallbackNoteStatus.Unhandled;
        this.taskDto.Priority = this.priorityValue;
        this.taskDto.PriorityText = this.priorities[this.priorityValue - 1].priorityText;
        if (this.editedTaskData == null) {
            this.taskDto.CreatedDate = new this.dateJS().toString(this.sessionManager.defaultOptions.mdyyyyhhmmss);
            this.taskDto.Tags = this.sessionManager.getTags();
        }
        else
            this.taskDto.CreatedDate = this.editedTaskData.CreatedDate;
        this.taskDto.CreatedById = GlobalFunctions.getLoggedInUserId();
        if (this.employeeService.loggedInEmployee != null) {
            let baseDtoObject = new BaseDto();
            baseDtoObject.Id = this.taskDto.CreatedById;
            let loggedInEmployee = this.cacheManager.getEmployeeById(this.taskDto.CreatedById);
            if (!GlobalFunctions.isEmpty(loggedInEmployee))
                baseDtoObject.StringRepresentation = loggedInEmployee.StringRepresentation;
            this.taskDto.CreatedBy = baseDtoObject;
        }
        let taskHistoryDto = new TaskHistoryDto();
        taskHistoryDto.DateRecorded = new this.dateJS().toString(this.sessionManager.defaultOptions.mdyyyyhhmmss);
        taskHistoryDto.CreatedById = GlobalFunctions.getLoggedInUserId();
        taskHistoryDto.TaskHandlerList = [];
        taskHistoryDto.StatusText = this.translateService.instant("LBL_UNHANDLED");
        taskHistoryDto.Status = TaskStatus.Unhandled;
        let currentHandlerList = "";
        if (this.handlerTags != undefined && this.handlerTags != null && this.handlerTags.length > 0) {
            for (let i = 0; i < this.handlerTags.length; i++) {
                let taskHandler = new TaskHandlerDto();
                taskHandler.HandlerId = this.handlerTags[i].Id;
                taskHandler.HandlerType = TaskHandlerType[this.currentHandlerType];
                taskHandler.HandlerObject = this.handlerTags[i];
                if (this.currentHandlerType == "Mailbox")
                    taskHandler.DepartmentId = this.handlerTags[i].Department;
                taskHistoryDto.TaskHandlerList.push(taskHandler);
                if (currentHandlerList.length === 0)
                    currentHandlerList = this.handlerTags[i].StringRepresentation;
                else
                    currentHandlerList = currentHandlerList + ", " + this.handlerTags[i].StringRepresentation;
            }
        }
        this.taskDto.TaskHistoryList = [];
        this.taskDto.TaskHistoryList.push(taskHistoryDto);
        let cachedEntities = this.sessionManager.detailViewCachedEntityList;
        if (cachedEntities != null && cachedEntities.length > 0) {
            this.taskDto.RelatedEntityList = [];
            cachedEntities.forEach(value => {
                if (value != undefined && value.key != null && value.key != undefined && value.key.IsMarked) {
                    let relatedEntityDto = new RelatedEntityDto();
                    relatedEntityDto.RelatedEntityId = value.key.Id;
                    let actualEntityType = value.value.replace(/\./g, '_');
                    relatedEntityDto.EntityType = EntityFqdn["" + actualEntityType + ""];
                    relatedEntityDto.ObjectSource = value.key.ObjectSource;
                    relatedEntityDto.EntityTitle = GlobalFunctions.sanitizeAndTruncate(value.key.StringRepresentation);
                    this.taskDto.RelatedEntityList.push(relatedEntityDto);
                }
            });
        }
        if (GlobalFunctions.isEmpty(this.taskDto.Id)) {
            this.taskDto.Id = GlobalFunctions.createGuid().replace(/-/g, '');
            if (!GlobalFunctions.isEmpty(this.sessionManager.selectedEntity) && !GlobalFunctions.isEmpty(this.sessionManager.selectedEntity.RelatedEntityFqdn)) {
                switch (this.sessionManager.selectedEntity.RelatedEntityFqdn) {
                    case EntityFqdn[EntityFqdn.Decos_Kcs_Email_Entities_Email]:
                        this.taskDto.SubTaskType = SubTaskType.Email;
                        break;
                    case EntityFqdn[EntityFqdn.Decos_Kcs_Documents_Entities_Document]:
                        this.taskDto.SubTaskType = SubTaskType.Post;
                        break;
                    case EntityFqdn[EntityFqdn.Decos_Kcs_SocialMedia_Entities_Facebook]:
                    case EntityFqdn[EntityFqdn.Decos_Kcs_SocialMedia_Entities_Twitter]:
                    case EntityFqdn[EntityFqdn.Decos_Kcs_SocialMedia_Entities_WhatsApp]:
                    case EntityFqdn[EntityFqdn.Decos_Kcs_SocialMedia_Entities_SocialMedia]:
                        this.taskDto.SubTaskType = SubTaskType.SocialMedia;
                        break;
                }
            }
            if (this.sessionManager.selectedRole != null && !GlobalFunctions.isEmpty(this.sessionManager.selectedRole.Id))
                this.taskDto.RoleId = this.sessionManager.selectedRole.Id;
        }
        let createTaskRequest = new CreateTaskRequest();
        createTaskRequest.TaskDto = this.taskDto;
        this.taskService.createTask(createTaskRequest, this.addAssignmentResponse, () => { }, () => { });
    }
    ;
    addAssignmentResponse(response) {
        this.stopSpinner();
        this.eventProvider.BroadcastEvent(BroadCastEventKeys.FETCH_TASK_STATISTIC);
        switch (response?.Result) {
            case 0:
                {
                    this.sendStartMessageHandlingForSocialMedia();
                    this.sessionManager.loadedFromRelatedView = false;
                    this.taskDto.Id = response.TaskId;
                    this.taskDto.CreatedDate = new this.dateJS().toString(this.sessionManager.defaultOptions.mdyyyyhhmmss);
                    this.taskDto.RelatedEntityFqdn = EntityFqdn[EntityFqdn.Decos_Kcs_Tasks_Entities_Assignment];
                    this.sessionManager.selectedEntity = this.taskDto;
                    this.sessionManager.selectedEntity.Partial = true;
                    this.sessionManager.selectedEntity.locationUrl = `/${RoutePath.DETAIL_PATH}/assignment/${this.taskDto.Id}`;
                    let selectedIndex = this.sessionManager.BreadcrumbItems.length - 1;
                    this.sessionManager.BreadcrumbItems.splice(selectedIndex, 1);
                    GlobalFunctions.setStringPresentation(this.taskDto, this.applicationSettingManager.getObjectGrammerSetting("AssignmentDto_Breadcrumb"));
                    this.sessionManager.addBreadcrumbItems([this.taskDto], null, RoutePath.DETAIL_PATH);
                    if (this.router.url === this.sessionManager.selectedEntity.locationUrl)
                        this.eventProvider.BroadcastEvent(BroadCastEventKeys.RELOAD_ENTITY_DETAIL);
                    else
                        this.router.navigate([this.sessionManager.selectedEntity.locationUrl]);
                    this.close();
                    break;
                }
            default:
                {
                    DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_ASSIGNMENT'), textMsg: this.translateService.instant("LBL_MESSAGE_FAIL_SAVE_ASSIGNMENT") });
                    break;
                }
        }
    }
    ;
    resize() {
        let windowHeight = $(window).height();
        $("#jkcParentPanel").css({ 'max-height': (windowHeight - parseInt(this.sessionManager.jkcParentPanel.parameters.TopSpace) - 100 + "px") });
        let newHeight = $("#jkcParentPanel").height() - $("#addAssignmentHeader").height() - $("#addAssignmentFooter").height() + "px";
        $("#addAssignmentContainer").height(newHeight);
        $('#' + this.sessionManager.jkcParentPanel.parameters.HeaderId).css({ 'width': ($("#jkcParentPanel").width()) });
        $('#' + this.sessionManager.jkcParentPanel.parameters.FooterId).css({ 'width': ($("#jkcParentPanel").width()) });
        let customerQuestionHeight = $("#jkcParentPanel").height() - $("#addAssignmentHeader").height() - $("#addAssignmentFooter").height() - 270;
        $('#' + this.customerQuestionFieldId).height(customerQuestionHeight + "px");
        let iframeElements = $('[id*="tox-tinymce-"]');
        if (iframeElements != null && iframeElements.length > 0) {
            let iframHeight = customerQuestionHeight - $(".tox-toolbar-grp ").height();
            if (iframeElements.length > 2)
                $(iframeElements[2]).height(iframHeight + "px");
            else
                $(iframeElements[0]).height(iframHeight + "px");
        }
    }
    handleEscKey() {
        if (!GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) && this.sessionManager.jkcParentPanel.parameters.IsPanelExpanded)
            this.close();
    }
    ;
    searchEmployee() {
        const searchPopup = this.dialogManager.openJsPanelOrDialog('SEARCH_EMPLOYEE_POPUP_PANEL');
        searchPopup.afterClosed().subscribe(result => {
            if (result?.selectedEmployee) {
                result.selectedEmployee.text = result.selectedEmployee.StringRepresentation;
                this.handlerTags.push(result.selectedEmployee);
            }
        });
        // Set isParentPopup to false (will not open in detail view) when opening EmployeePanel from Assignment
        if (searchPopup && searchPopup.componentInstance)
            searchPopup.componentInstance.isParentPopup = false;
    }
    ;
    loadEditTaskData(taskSessionData) {
        this.taskDto = jQuery.extend(true, {}, taskSessionData);
        if (!GlobalFunctions.isEmpty(taskSessionData.CurrentHandlerList)) {
            this.taskDto.HandlerTags = [];
            for (let i = 0; i < taskSessionData.CurrentHandlerList.length; i++) {
                let handlerId = taskSessionData.CurrentHandlerList[i].HandlerId;
                if (!GlobalFunctions.isEmpty(handlerId)) {
                    let handleData = null;
                    if (taskSessionData.CurrentHandlerType == TaskHandlerType.Employee || taskSessionData.CurrentHandlerType == "Employee")
                        handleData = this.cacheManager.getEmployeeById(handlerId);
                    else if (taskSessionData.CurrentHandlerType == TaskHandlerType.Department || taskSessionData.CurrentHandlerType == "Department")
                        handleData = this.cacheManager.getDepartmentById(handlerId);
                    else if (taskSessionData.CurrentHandlerType == TaskHandlerType.Mailbox || taskSessionData.CurrentHandlerType == "Mailbox")
                        handleData = this.cacheManager.getTaskMailboxById(handlerId);
                    if (handleData != null) {
                        handleData.text = handleData.StringRepresentation;
                        this.taskDto.HandlerTags.push(handleData);
                    }
                }
            }
        }
        if (!GlobalFunctions.isEmpty(this.taskDto.HandlerTags))
            this.handlerTags = this.taskDto.HandlerTags;
        this.priorityValue = this.taskDto.Priority;
        this.currentHandlerType = this.taskDto.CurrentHandlerType;
    }
    ;
    setCustomerQuestion() {
        if (!GlobalFunctions.isEmpty(this.sessionManager.contactSessionNotesState.ContactHistoryDto.Notes)) {
            let copyFromSessionNote = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Tasks_Entities_Task, "PREFILLSESSIONNOTESINQUESTION");
            if (!GlobalFunctions.isEmpty(copyFromSessionNote) && copyFromSessionNote.toLowerCase() == "true")
                this.taskDto.CustomerQuestion = this.sessionManager.contactSessionNotesState.ContactHistoryDto.Notes;
        }
    }
    ;
    setHandlerTags() {
        switch (this.currentHandlerType) {
            case 'Employee':
                return this.handlerTagItems = this.cacheManager.getEmployeeList(true);
            case 'Department':
                return this.handlerTagItems = this.cacheManager.getDepartmentList();
            case 'Mailbox':
                return this.handlerTagItems = this.cacheManager.getTaskMailboxList();
        }
    }
    changedHandlerType() {
        this.setHandlerTags();
        this.handlerTags = [];
        document.getElementById("assignHandlerCallbackTagsInputControl")?.focus();
    }
    ;
    templateChanged() {
        this.taskDto.CustomerQuestion = this.getHtmlBody();
        let customerQuestionContent = this.taskDto.CustomerQuestion;
        let questionBody = $(customerQuestionContent);
        if (questionBody.length > 0) {
            customerQuestionContent = "";
            questionBody.each((i, eachQuestionNode) => {
                if (eachQuestionNode.nodeName.toUpperCase() == "DIV" && !GlobalFunctions.isEmpty(eachQuestionNode.id) && eachQuestionNode.id == "newQuestionContent") {
                    if (!GlobalFunctions.isEmpty(eachQuestionNode.outerHTML) && eachQuestionNode.outerHTML.indexOf("taskSelectedTemplate") == -1)
                        eachQuestionNode.innerHTML = "<div id='taskSelectedTemplate'>" + this.formatManager.mergeTaskTemplate(this.currentTemplate.Content).replace(/([\"]*[\&]*amp;[amp;]*[\"]*)/g, "") + "</div>" + eachQuestionNode.innerHTML.replace(/<p><\/p><p><\/p><p><\/p> <br><br><br><br>/gi, '');
                    else {
                        eachQuestionNode.childNodes.forEach(childNode => {
                            if (childNode.nodeName.toUpperCase() == "DIV" && !GlobalFunctions.isEmpty(childNode.id) && childNode.id == "taskSelectedTemplate")
                                childNode.innerHTML = !GlobalFunctions.isEmpty(this.currentTemplate) ? this.formatManager.mergeTaskTemplate(this.currentTemplate.Content) : "";
                        });
                    }
                }
            });
        }
        questionBody.each((i, eachQuestionNode) => {
            if (eachQuestionNode.nodeName.toUpperCase() == "#TEXT")
                customerQuestionContent += eachQuestionNode.data;
            else
                customerQuestionContent += eachQuestionNode.outerHTML;
        });
        this.taskDto.CustomerQuestion = customerQuestionContent;
        if (this.currentTemplate.HandlerIds?.length > 0) {
            this.handlerTags = [];
            let handlerType = GlobalFunctions.setHandlerListFromTaskTemplate(this.currentTemplate, this.cacheManager, this.handlerTags);
            this.currentHandlerType = handlerType;
        }
    }
    ;
    sendStartMessageHandlingForSocialMedia() {
        if (this.taskDto.SubTaskType == SubTaskType.SocialMedia) {
            let messageHandlingDto = this.socialMediaService.getMessageHandlingDto(this.sessionManager.selectedEntity);
            if (messageHandlingDto) {
                messageHandlingDto.HandlerId = this.taskDto.TaskHistoryList[0].TaskHandlerList[0].HandlerId;
                this.socialMediaService.startHandlingMessage(messageHandlingDto, null);
            }
        }
    }
    ;
    initializeSubTaskType() {
        this.isSubTaskType = false;
        if (!GlobalFunctions.isEmpty(this.sessionManager.selectedEntity) && !GlobalFunctions.isEmpty(this.sessionManager.selectedEntity.RelatedEntityFqdn)) {
            switch (this.sessionManager.selectedEntity.RelatedEntityFqdn) {
                case EntityFqdn[EntityFqdn.Decos_Kcs_Email_Entities_Email]:
                    this.isSubTaskType = true;
                    this.emailService.addEmailAndRelatedPersonOrOrganizationIntoSession(this.cacheManager);
                    break;
                case EntityFqdn[EntityFqdn.Decos_Kcs_SocialMedia_Entities_Facebook]:
                case EntityFqdn[EntityFqdn.Decos_Kcs_SocialMedia_Entities_Twitter]:
                case EntityFqdn[EntityFqdn.Decos_Kcs_SocialMedia_Entities_WhatsApp]:
                case EntityFqdn[EntityFqdn.Decos_Kcs_SocialMedia_Entities_SocialMedia]:
                    this.isSubTaskType = true;
                    this.socialMediaService.addSocialMediaAndRelatedPersonOrOrganizationIntoSession();
                    break;
            }
        }
    }
    ;
    getHtmlBody() {
        return "<div id='newQuestionContent'><p></p><p></p><p></p><p></p> <br/><br/><br/><br/></div>";
    }
    ;
    initEditor() {
        this.tinymceOptions = {
            plugins: TinyMCE.PLUGINS,
            toolbar: TinyMCE.TASK_TOOLBAR,
            font_size_formats: TinyMCE.FONT_SIZE_FORMATS,
            font_family_formats: TinyMCE.FONT_FAMILY_FORMATS,
            contextmenu: false,
            browser_spellcheck: true,
            force_br_newlines: false,
            forced_root_block: 'div',
            paste_data_images: true,
            base_url: '/tinymce',
            iframe_aria_text: GlobalFunctions.removeHTMLTags(this.taskDto.CustomerQuestion),
            resize: false,
            elementpath: false,
            menubar: false,
            apply_source_formatting: true,
            statusbar: false,
            entity_encoding: 'raw',
            content_style: "p {margin: 0; padding: 0;} body {font: 400 15px 'Open Sans', sans-serif !important;}",
            height: $(window).height() - 425 + 'px',
            paste_postprocess: (plugin, args) => args.node.setAttribute('id', '42'),
            file_picker_types: 'image',
            images_upload_base_path: '/cacheddata/' + GlobalFunctions.getSessionTokenAsString() + '/',
            init_instance_callback: editor => {
                GlobalFunctions.setEditorBodyHeight();
                this.editor = editor;
                editor.on('keydown', event => {
                    if (event.keyCode === 27)
                        this.close();
                });
            },
            file_picker_callback: (callback, value, meta) => {
                this.fileManager.setFilePickerCallback(callback, value, meta, this.editor, EntityName.TASK);
            },
            images_upload_handler: (blobInfo, progress) => {
                return this.fileManager.setFileUploadHandler(blobInfo, progress, this.tinymceOptions.images_upload_base_path, FileUploadSource.Task);
            }
        };
        this.resize();
        if (this.translateService.currentLang != LanaguageCode.EN_CODE)
            this.tinymceOptions.language = LanaguageCode.NL_CODE;
    }
    openHelpUrl(key) {
        CommonHelper.openHelpUrl(key);
    }
    close() {
        this.dialogManager.removeComponent();
        this.sessionManager.closeJkcParentPanel();
    }
};
__decorate([
    ViewChild('form')
], AssignmentAddEditComponent.prototype, "form", void 0);
AssignmentAddEditComponent = __decorate([
    Component({
        selector: 'assignment-add-edit',
        templateUrl: './assignment-add-edit.component.html',
        styleUrls: ['./assignment-add-edit.component.scss'],
        host: { '(window:resize)': 'resize()' }
    })
], AssignmentAddEditComponent);
export { AssignmentAddEditComponent };
//# sourceMappingURL=assignment-add-edit.component.js.map