var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { ContextMenuView } from '../../../../../../../core/enums/common-enums';
import { ContextMenu } from '../../../../../../../core/models/common/context-menu';
import { GlobalFunctions } from '../../../../../../../shared/global-functions';
import { BaseDetailComponent } from '../../../../../../common/base-detail.component';
let AppointmentDetailQmaticComponent = class AppointmentDetailQmaticComponent extends BaseDetailComponent {
    constructor(cacheManager, phoneManager, eventProvider, searchService, sessionManager, dialogManager, translateService, contextMenuService, applicationSettingManager, integrationSettingManager) {
        super(phoneManager, dialogManager, translateService);
        this.cacheManager = cacheManager;
        this.phoneManager = phoneManager;
        this.eventProvider = eventProvider;
        this.searchService = searchService;
        this.sessionManager = sessionManager;
        this.dialogManager = dialogManager;
        this.translateService = translateService;
        this.contextMenuService = contextMenuService;
        this.applicationSettingManager = applicationSettingManager;
        this.integrationSettingManager = integrationSettingManager;
    }
    ngOnInit() {
        try {
            this.sendRelatedRequest.emit();
            this.menu.addOrUpdateMenuItem(0, this.sessionManager.selectedEntity.TaskType.toString() + 'Detail', this.translateService.instant('LBL_' + this.sessionManager.selectedEntity.TaskType.toUpperCase()), false, true, true);
            this.addMenuItem.emit(this.menu);
            const detailEntityType = GlobalFunctions.getObjectTypeName(this.sessionManager.selectedEntity.RelatedEntityFqdn);
            const oldContentType = GlobalFunctions.toContentType(detailEntityType);
            this.sessionManager.contextMenu = new ContextMenu(oldContentType, detailEntityType, this.translateService, this.sessionManager.selectedEntity, GlobalFunctions.getLoggedInUserId(), ContextMenuView.Detail, this.sessionManager.customContextMenuItems, this.sessionManager, this.integrationSettingManager);
            this.contextMenuService.loadActionButton(detailEntityType);
            this.sessionManager.selectedEntity.CurrentHandlerTextList = GlobalFunctions.getTaskHandlerNameList(this.sessionManager.selectedEntity.CurrentHandlerList, this.cacheManager);
            this.sessionManager.selectedEntity.CreatedBy = this.cacheManager.getEmployeeById(this.sessionManager.selectedEntity.CreatedById);
        }
        catch (e) {
            console.error(e);
        }
    }
    onTagClick(tag, $event) {
        this.applicationSettingManager.tagSetting.handleAction(tag, this.sessionManager, this.searchService, this.dialogManager, this.eventProvider, $event);
    }
    ;
};
AppointmentDetailQmaticComponent = __decorate([
    Component({
        selector: 'appointment-detail-qmatic',
        templateUrl: './appointment-detail-qmatic.component.html',
        styleUrls: ['./appointment-detail-qmatic.component.scss']
    })
], AppointmentDetailQmaticComponent);
export { AppointmentDetailQmaticComponent };
//# sourceMappingURL=appointment-detail-qmatic.component.js.map