var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, ViewChild } from '@angular/core';
import { SubSink } from 'subsink';
import { RecordSelection, ScreenMode } from '../../../../../../../core/enums/common-enums';
import { BroadCastEventKeys, RoutePath } from '../../../../../../../shared/constants';
import { GlobalFunctions } from '../../../../../../../shared/global-functions';
import { DialogHelper } from '../../../../../../../shared/helper/dialog-helper';
import { BaseDialogComponent } from '../../../../../../common/base-dialog.component';
import { SearchPopupComponent } from '../../../../../../common/search-popup/search-popup.component';
let AppointmentAddEditSmartCjmComponent = class AppointmentAddEditSmartCjmComponent extends BaseDialogComponent {
    constructor(router, dialog, datePipe, taskService, dialogManager, eventProvider, sessionManager, shortcutManager, translateService) {
        super();
        this.router = router;
        this.dialog = dialog;
        this.datePipe = datePipe;
        this.taskService = taskService;
        this.dialogManager = dialogManager;
        this.eventProvider = eventProvider;
        this.sessionManager = sessionManager;
        this.shortcutManager = shortcutManager;
        this.translateService = translateService;
        this.slot = null;
        this.type = 'Person';
        this.email = '';
        this.phone = '';
        this.amount = null;
        this.entity = null;
        this.product = [];
        this.findFrom = 'SelectAny';
        this.location = null;
        this.dateOfBirth = '';
        this.description = '';
        this.errorMessage = '';
        this.slots = [];
        this.amounts = [];
        this.entities = [];
        this.dateJS = Date;
        this.title = this.translateService.instant('LBL_ADD_APPOINTMENT').toUpperCase();
        this.editMode = this.sessionManager.jkcParentPanel.parameters.EditMode;
        this.editedData = this.sessionManager.jkcParentPanel.parameters.EditedData;
        this.calendarOptions = {
            allDaySlot: false,
            contentHeight: 500,
            dayHeaders: false,
            dayHeaderFormat: 'D/M dddd',
            headerToolbar: false,
            initialView: 'timeGridDay',
            locale: this.translateService.currentLang,
            plugins: GlobalFunctions.getFullCalendarPlugins(),
            scrollTime: new this.dateJS().toString('HH:mm:ss'),
            slotDuration: '00:05:00',
            slotLabelFormat: 'HH:mm',
            timeZone: 'local',
            weekends: true
        };
        this._date = new Date();
        this.subs = new SubSink();
        this.bookAppointmentResponse = this.bookAppointmentResponse.bind(this);
        this.fetchAppointmentAvailableSlotsResponse = this.fetchAppointmentAvailableSlotsResponse.bind(this);
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.JSPANEL_RESIZE).subscribe(() => this.resize());
    }
    get date() {
        return this._date;
    }
    set date(date) {
        this._date = date;
        // TODO: code should be moved into HTML pipe to prevent UI flickering
        this.timeoutIds.push(setTimeout(() => GlobalFunctions.setDateFormat('date', date, this.sessionManager.defaultOptions.defaultDateFormat, this.datePipe)));
    }
    ;
    ngOnInit() {
        try {
            this.registerDialogShortcutKey();
            this.timeoutIds.push(setTimeout(() => this.resize(), 300));
            this.sessionManager.startSessionIfPossible('TASK', !this.sessionManager.jkcParentPanel.parameters.EditedData ? ScreenMode.Add : ScreenMode.Edit);
            if (this.editMode) {
                this.title = this.translateService.instant('LBL_EDIT').toUpperCase() + ' ' + this.translateService.instant('LBL_APPOINTMENT').toUpperCase();
                this.type = this.editedData.MainEntityObject?.ObjectSource?.includes('Person') ? 'Person' : 'Organization';
                this.email = this.editedData.ContactEmail;
                this.phone = this.editedData.ContactPhoneNumber;
                this.dateOfBirth = this.editedData.CustomerDateOfBirth != '0001-01-01T00:00:00' ? this.editedData.CustomerDateOfBirth : '';
                this.location = this.editedData.location;
                this.product = [this.editedData.product];
                this.description = this.editedData.CustomerQuestion;
                this.entity = new Object();
                this.entity.Id = this.editedData.MainEntityObject.Id;
                if (this.type === 'Person') {
                    this.entity.Details = new Object();
                    this.entity.Details.FormalName = new Object();
                    this.entity.Details.FormalName.Surname = this.editedData.ContactPerson.split(' ')[1];
                    this.entity.Details.FormalName.FirstNames = [];
                    this.entity.Details.FormalName.FirstNames.push(this.editedData.ContactPerson.split(' ')[0]);
                    this.entity.StringRepresentation = this.editedData.ContactPerson;
                }
                else {
                    this.entity.Name = this.editedData.ContactPerson;
                    this.entity.StringRepresentation = this.editedData.ContactPerson;
                }
                this.entities.push(this.entity);
                this.date = new Date(this.editedData.CallBetweenStartDate);
                this.productChanged();
                this.amount = this.editedData.Amount;
            }
            else
                this.getRelatedEntities();
        }
        catch (e) {
            console.error(e);
        }
    }
    ngAfterViewInit() {
        if (this.editMode)
            this.calendar.getApi().gotoDate(this.date);
    }
    ngOnDestroy() {
        super.ngOnDestroy();
        this.subs.unsubscribe();
    }
    findFromChanged() {
        this.entity = '';
        this.entities = [];
        switch (this.findFrom) {
            case 'Search': {
                this.openSearchPopup();
                break;
            }
            case 'Related': {
                this.setRelatedEntities();
                break;
            }
        }
    }
    openSearchPopup() {
        DialogHelper.openDialog(this.dialog, SearchPopupComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { name: this.type, recordSelection: RecordSelection.Single }).afterClosed().subscribe(entity => {
            if (entity)
                this.setEntity(entity);
            this.findFrom = 'SelectAny';
        });
    }
    getRelatedEntities() {
        let cachedType = '';
        this.sessionManager.detailViewCachedEntityList.forEach(entity => {
            if (entity?.key) {
                if (entity.value.includes('Person'))
                    cachedType = 'Person';
                else if (entity.value.includes('Organization'))
                    cachedType = 'Organization';
            }
        });
        if (cachedType) {
            this.type = cachedType;
            this.findFrom = 'Related';
            this.findFromChanged();
        }
    }
    setRelatedEntities() {
        this.sessionManager.detailViewCachedEntityList.forEach(entity => {
            if (entity?.key && entity?.value.includes(this.type))
                this.setEntity(entity.key);
        });
    }
    setEntity(entity) {
        if (this.type === 'Organization')
            entity.StringRepresentation = entity.Name;
        this.entity = entity;
        this.entityChanged();
        this.entities.push(entity);
        this.timeoutIds.push(setTimeout(() => document.getElementById('entity')?.focus()));
    }
    entityChanged() {
        this.email = this.entity.EmailAddress;
        this.phone = this.entity.MobileNumber || this.entity.PhoneNumber;
        this.dateOfBirth = this.entity.Details?.DateOfBirth || '';
    }
    locationChanged() {
        this.product = [];
        this.amount = null;
        this.slot = null;
    }
    productChanged() {
        this.amounts = [];
        this.amount = null;
        if (!GlobalFunctions.isEmpty(this.product)) {
            this.amounts = Array.from({ length: this.product[0].AmountMax - this.product[0].AmountMin + 1 }, (_, index) => index + this.product[0].AmountMin);
            this.amount = this.amounts[0];
            this.changeSlots();
        }
    }
    dateChanged() {
        this.calendar.getApi().gotoDate(this.date);
        if (!GlobalFunctions.isEmpty(this.product))
            this.changeSlots();
    }
    changeSlots() {
        this.startSpinner();
        this.taskService.fetchAppointmentAvailableSlots(this.location.Uid, this.product[0].Uid, this.date, this.amount, this.fetchAppointmentAvailableSlotsResponse);
    }
    changeCalendar() {
        this.calendar.getApi().removeAllEvents();
        if (this.slot?.AppointmentDate) {
            const start = new Date(this.slot.AppointmentDate);
            const end = new Date(this.slot.AppointmentDate).setMinutes(start.getMinutes() + this.amount * this.product[0].Duration);
            this.calendar.getApi().addEvent({ start, end });
            this.calendar.getApi().scrollToTime(this.slot.AppointmentDate.split('T')[1]);
        }
    }
    save() {
        if (this.form.invalid || this.product.length === 0 || !this.slot)
            return;
        this.startSpinner();
        const bookAppointmentRequest = new Object();
        if (this.editMode) {
            bookAppointmentRequest.Uid = this.editedData.Id;
            bookAppointmentRequest.SecretKey = this.editedData.SecretKey;
            bookAppointmentRequest.ResourceId = this.editedData.ResourceId;
            if (this.editedData.ContactPhoneNumber != this.phone)
                bookAppointmentRequest.Phone = this.phone;
            if (this.editedData.ContactEmail != this.email)
                bookAppointmentRequest.Mail = this.email;
            if (this.editedData.CustomerQuestion != this.description)
                bookAppointmentRequest.Comment = this.description;
            if (this.editedData.ContactEmail != this.email)
                bookAppointmentRequest.Mail = this.email;
            if (this.editedData.CallBetweenStartDate != this.slot.AppointmentDate) {
                bookAppointmentRequest.AppointmentDateTime = this.slot.AppointmentDate;
                bookAppointmentRequest.Amount = this.amount;
            }
            if (this.editedData.MainEntityId != this.entity.Id) {
                bookAppointmentRequest.EntityId = this.entity.Id;
                if (this.type === "Person") {
                    if (this.editedData.ContactPerson.split(' ')[0] != this.entity?.Details?.FormalName?.FirstNames[0])
                        bookAppointmentRequest.FirstName = this.entity?.Details?.FormalName?.FirstNames[0];
                    if (this.editedData.ContactPerson.split(' ')[1] != this.entity?.Details?.FormalName?.Surname)
                        bookAppointmentRequest.LastName = this.entity?.Details?.FormalName?.Surname;
                }
                else {
                    bookAppointmentRequest.FirstName = this.entity.Name;
                    bookAppointmentRequest.LastName = " ";
                }
            }
            if (this.editedData.CustomerDateOfBirth != this.dateOfBirth)
                bookAppointmentRequest.DateOfBirth = this.formatDate(this.dateOfBirth);
        }
        else {
            bookAppointmentRequest.ResourceId = this.slot.Resource_Uid;
            bookAppointmentRequest.ServiceId = this.product[0].Uid;
            bookAppointmentRequest.AppointmentDateTime = this.slot.AppointmentDate;
            bookAppointmentRequest.Amount = this.amount;
            bookAppointmentRequest.FirstName = this.entity.ObjectSource.includes('Organizations') ? this.entity.Name : (this.entity?.Details?.FormalName?.FirstNames[0]);
            bookAppointmentRequest.LastName = this.entity.ObjectSource.includes('Organizations') ? ' ' : this.entity?.Details?.FormalName?.Surname;
            bookAppointmentRequest.Mail = this.email;
            bookAppointmentRequest.Phone = this.phone;
            bookAppointmentRequest.Comment = this.description;
            bookAppointmentRequest.EntityId = this.entity.Id;
            bookAppointmentRequest.Handler = this.entity.ObjectSource;
            bookAppointmentRequest.Uid = null;
            bookAppointmentRequest.DateOfBirth = this.formatDate(this.dateOfBirth);
        }
        this.taskService.bookAppointment(bookAppointmentRequest, this.bookAppointmentResponse);
    }
    bookAppointmentResponse(response) {
        if (response?.AppointmentDto) {
            this.close();
            this.sessionManager.selectedEntity = response.AppointmentDto;
            this.sessionManager.selectedEntity.locationUrl = `${RoutePath.DETAIL_PATH}/appointment`;
            this.sessionManager.addBreadcrumbItems([this.sessionManager.selectedEntity], null, this.router.url);
            if (this.editMode)
                this.eventProvider.BroadcastEvent(BroadCastEventKeys.RELOAD_ENTITY_DETAIL);
            else
                this.router.navigate([this.sessionManager.selectedEntity.locationUrl]);
        }
        this.stopSpinner();
    }
    fetchAppointmentAvailableSlotsResponse(response) {
        this.slots = [];
        this.slot = null;
        this.errorMessage = '';
        if (response?.AppointmentDateDto?.length > 0) {
            this.slots = response.AppointmentDateDto;
            this.slot = this.slots[0];
        }
        else
            this.errorMessage = this.translateService.instant('LBL_NO_AVAILABLE_TIME_SLOTS');
        let selectedDate = this.date;
        if (this.editMode && this.editedData.CallBetweenStartDate && this.editedData.CallBetweenStartDate.split('T')[0] == selectedDate.toString('yyyy-MM-dd')) {
            const existingSlot = new Object();
            existingSlot.AppointmentDate = this.editedData.CallBetweenStartDate;
            existingSlot.Resource_Uid = this.editedData.ResourceId;
            this.slots.unshift(existingSlot);
            this.slot = existingSlot;
        }
        this.changeCalendar();
        this.stopSpinner();
    }
    close() {
        this.dialogManager.removeComponent();
        this.sessionManager.closeJkcParentPanel();
    }
    resize() {
        $('#jkcParentPanel').css({ 'max-height': ($(window).height() - parseInt(this.sessionManager.jkcParentPanel.parameters.TopSpace) - 5 + 'px') });
        $('#addTaskContainer').height($('#jkcParentPanel').height() - $('#addTaskHeader').height() - $('#addTaskFooter').height() + 'px');
        this.calendarOptions.contentHeight = $('#addTaskContainer').height() - 515 + 'px';
        $('#' + this.sessionManager.jkcParentPanel.parameters.HeaderId).css({ 'width': ($('#jkcParentPanel').width()) });
        $('#' + this.sessionManager.jkcParentPanel.parameters.FooterId).css({ 'width': ($('#jkcParentPanel').width()) });
    }
    handleEscKey() {
        if (!GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) && this.sessionManager.jkcParentPanel.parameters.IsPanelExpanded)
            this.close();
    }
    disableOlderDates(date) {
        const today = new Date();
        today.setHours(0, 0, 0, 0);
        return date >= today;
    }
    registerDialogShortcutKey() {
        this.shortcutManager.bind('LBL_SHORTCUT_SAVE_BUTTON', () => this.save());
    }
    formatDate(date) {
        if (!date)
            return '';
        else if (typeof date === 'string' && date.includes('T'))
            return date.split('T')[0];
        const year = date.getFullYear();
        const month = ('0' + (date.getMonth() + 1)).slice(-2);
        const day = ('0' + date.getDate()).slice(-2);
        return `${year}-${month}-${day}`;
    }
};
__decorate([
    ViewChild('form')
], AppointmentAddEditSmartCjmComponent.prototype, "form", void 0);
__decorate([
    ViewChild('calendar')
], AppointmentAddEditSmartCjmComponent.prototype, "calendar", void 0);
AppointmentAddEditSmartCjmComponent = __decorate([
    Component({
        selector: 'appointment-add-edit-smart-cjm',
        templateUrl: './appointment-add-edit-smart-cjm.component.html',
        styleUrls: ['./appointment-add-edit-smart-cjm.component.scss'],
        host: { '(window:resize)': 'resize()' }
    })
], AppointmentAddEditSmartCjmComponent);
export { AppointmentAddEditSmartCjmComponent };
//# sourceMappingURL=appointment-add-edit-smart-cjm.component.js.map