var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, ViewChild } from '@angular/core';
import { BaseDialogComponent } from '../../../../../../common/base-dialog.component';
import { MessageboxComponent } from '../../../../../../common/messagebox/messagebox.component';
import { SearchPopupComponent } from '../../../../../../common/search-popup/search-popup.component';
import { OrganizationAddEditComponent } from '../../../../../organization/add-edit/organization-add-edit.component';
import { RepresentativeAddComponent } from '../../../../../organization/add-representative/organization-add-representative.component';
import { PersonAddEditComponent } from '../../../../../person/add-edit/person-add-edit.component';
import { OperationType, QmaticAvailabilityType, RecordSelection, ScreenMode } from '../../../../../../../core/enums/common-enums';
import { EntityFqdn, TaskSource } from '../../../../../../../core/enums/core-enums';
import { CreateTaskAction, MainEntityType, TaskStatus, TaskType } from '../../../../../../../core/enums/task-enum';
import { BaseDto } from '../../../../../../../core/models/common/baseDto';
import { FetchAvailableDateOrTimeRequest } from '../../../../../../../core/models/common/fetch-available-date-time-request';
import { MakeAppointmentExternalRequest } from '../../../../../../../core/models/common/make-appointment-external-request';
import { QmaticAppointmentDtos } from '../../../../../../../core/models/common/qmatic-appointmentDto';
import { RelatedEntityDto } from '../../../../../../../core/models/common/related-enityDto';
import { ContentType, JsonDtoType } from '../../../../../../../core/models/jkc-object/jkc-object';
import { TaskHistoryDto } from '../../../../../../../core/models/task/task-historyDto';
import { TaskDto } from '../../../../../../../core/models/task/taskDto';
import { BroadCastEventKeys, RoutePath } from '../../../../../../../shared/constants';
import { GlobalFunctions } from '../../../../../../../shared/global-functions';
import { DialogHelper } from '../../../../../../../shared/helper/dialog-helper';
import { JkcPanel } from '../../../../../../../shared/helper/jkc-panel-helper';
import { SubSink } from 'subsink';
let AppointmentAddEditQmaticComponent = class AppointmentAddEditQmaticComponent extends BaseDialogComponent {
    constructor(router, dialog, taskService, eventProvider, personService, dialogManager, sessionManager, shortcutManager, employeeService, formattedBSNPipe, viewContainerRef, translateService, applicationSettingManager, personFormattedAddressWithLabelPipe, organizationFormattedAddressWithLabelPipe) {
        super();
        this.router = router;
        this.dialog = dialog;
        this.taskService = taskService;
        this.eventProvider = eventProvider;
        this.personService = personService;
        this.dialogManager = dialogManager;
        this.sessionManager = sessionManager;
        this.shortcutManager = shortcutManager;
        this.employeeService = employeeService;
        this.formattedBSNPipe = formattedBSNPipe;
        this.viewContainerRef = viewContainerRef;
        this.translateService = translateService;
        this.applicationSettingManager = applicationSettingManager;
        this.personFormattedAddressWithLabelPipe = personFormattedAddressWithLabelPipe;
        this.organizationFormattedAddressWithLabelPipe = organizationFormattedAddressWithLabelPipe;
        this.title = '';
        this.dateJS = Date;
        this.calendarContentHeight = 500;
        this.calendarOptions = {
            allDayText: this.translateService.instant("LBL_ALL_DAY"),
            allDaySlot: false,
            contentHeight: this.calendarContentHeight,
            dayHeaders: false,
            dayHeaderFormat: 'D/M dddd',
            headerToolbar: false,
            initialView: 'timeGridDay',
            locale: this.translateService.currentLang,
            plugins: GlobalFunctions.getFullCalendarPlugins(),
            scrollTime: new this.dateJS().toString('HH:mm:ss'),
            slotDuration: '00:15:00',
            slotEventOverlap: false,
            slotLabelFormat: 'HH:mm',
            timeZone: 'local',
            weekends: true
        };
        this.isRequestSent = false;
        this.mainItemObject = null;
        this.relationTypeOptions = ['Person', 'Organization'];
        this.callbackRelationType = this.relationTypeOptions;
        this.currentRelationType = 'Person';
        this.showPersonCreateType = true;
        this.taskDto = new TaskDto();
        this.currentDate = new Date();
        this.searchEntityTags = [];
        this.enableDurationBox = true;
        this.buttonClicked = false;
        this.uniqueId = GlobalFunctions.createGuid();
        this.userId = GlobalFunctions.getLoggedInUserId();
        this.representativeList = [];
        this.ProductList = [];
        this.LocationList = [];
        this.isLocationSelected = true;
        this.AllAvailableSlots = [];
        this.availableSlot = null;
        this.appointmentLength = 15;
        this.personPrivateFields = GlobalFunctions.getAllowedDataRights(ContentType.Person, OperationType.PrivateField);
        this.organizationPrivateFields = GlobalFunctions.getAllowedDataRights(ContentType.Organization, OperationType.PrivateField);
        this.taskType = this.sessionManager.jkcParentPanel.parameters.EntitySubType;
        this.isRequestOnProductLoad = false;
        this.fromNavigationBtns = false;
        this.product = null;
        this.confidentialityLevel = 0;
        this.availableDates = [];
        this.defaultLocation = {
            "Name": this.translateService.instant("LBL_SELECT_ANY"),
            "AppointmentLength": 15
        };
        this.location = null;
        this.XmlProductList = null;
        this.createTaskStatus = '';
        this.selectedFindFrom = '';
        this.agendaItems = [];
        this.selectedRepresentative = null;
        this.rights = {
            organization: false,
            person: false
        };
        this.minDate = new Date();
        this.showPreviousDayButton = false;
        this._currentAvailability = [];
        this._selectedDateFromPicker = new Date();
        this.subs = new SubSink();
        this.showTaskResult = this.showTaskResult.bind(this);
        this.addPersonResponse = this.addPersonResponse.bind(this);
        this.selectedSlotCallback = this.selectedSlotCallback.bind(this);
        this.relatedRepresentatives = this.relatedRepresentatives.bind(this);
        this.addOrganizationResponse = this.addOrganizationResponse.bind(this);
        this.fetchProductWiseDateTimesResponse = this.fetchProductWiseDateTimesResponse.bind(this);
        this.fetchAppointmentRelatedProductResponse = this.fetchAppointmentRelatedProductResponse.bind(this);
        this.fetchAppointmentRelatedLocationResponse = this.fetchAppointmentRelatedLocationResponse.bind(this);
    }
    get currentAvailability() {
        return this._currentAvailability;
    }
    set currentAvailability(currentAvailability) {
        this._currentAvailability = currentAvailability;
        this.refreshCalendar(false);
    }
    ;
    get selectedDateFromPicker() {
        return this._selectedDateFromPicker;
    }
    set selectedDateFromPicker(selectedDateFromPicker) {
        this._selectedDateFromPicker = selectedDateFromPicker;
        this.dateChanged();
    }
    ;
    ngOnInit() {
        this.setRights();
        this.minDate.setHours(23, 59, 59, 999);
        this.title = this.translateService.instant("LBL_ADD_APPOINTMENT").toUpperCase();
        this.sessionManager.jkcParentPanel.parameters.Scope = this;
        this.sessionManager.startSessionIfPossible("TASK", ScreenMode.Add);
        setTimeout(() => this.resize(), 300);
        if (GlobalFunctions.isEmpty(this.sessionManager.appointmentLocationList))
            this.taskService.fetchLocationsRelatedToAppointment(this.fetchAppointmentRelatedLocationResponse);
        else {
            this.LocationList = Object.assign([], this.sessionManager.appointmentLocationList);
            this.LocationList.unshift(this.defaultLocation);
            if (!GlobalFunctions.isEmpty(this.LocationList) && this.LocationList.length > 1) {
                this.location = this.LocationList[1];
                this.selectedLocationChanged();
            }
            else
                this.location = this.LocationList[0];
        }
        this.selectOptionsFromFindList();
        if (GlobalFunctions.isEmpty(this.taskDto.CustomerOrOrganizationName) && !GlobalFunctions.isEmpty(this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactPerson))
            this.taskDto.CustomerOrOrganizationName = this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactPerson;
        this.registerDialogShortcutKey();
    }
    ngOnDestroy() {
        this.subs.unsubscribe();
        this.shortcutManager.unbind('LBL_SHORTCUT_SAVE_BUTTON');
    }
    setRights() {
        this.rights.organization = GlobalFunctions.checkRights('Organization', 3);
        this.rights.person = GlobalFunctions.checkRights('Person', 3);
    }
    changeRepresentative() {
        if (this.selectedRepresentative?.value?.toUpperCase() == 'NEW') {
            if (this.currentRelationType == "Organization") {
                DialogHelper.openDialog(this.dialog, RepresentativeAddComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { organizationId: this.taskDto.MainEntityId, editMode: false }).afterClosed().subscribe(representative => {
                    this.relatedRepresentatives([representative]);
                    this.selectedRepresentative = representative;
                    this.registerDialogShortcutKey();
                });
            }
        }
    }
    ;
    relatedRepresentatives(result) {
        if (result?.length > 0) {
            const getGrammerValue = this.applicationSettingManager.getObjectGrammerSetting("PersonDto_CallbackNote");
            if (!GlobalFunctions.isEmpty(getGrammerValue)) {
                for (let i = 0; i < result.length; i++) {
                    GlobalFunctions.setStringPresentation(result[i], getGrammerValue);
                    this.representativeList.push(result[i]);
                }
                this.selectedRepresentative = this.representativeList[this.representativeList.length - 1];
            }
        }
    }
    ;
    addDefaultRepresentative() {
        this.representativeList.push({ StringRepresentation: this.translateService.instant("LBL_NEW"), value: "new" });
    }
    ;
    showPersonDeceasedWarning(personEntity) {
        if (personEntity.Details == null || !GlobalFunctions.isPersonDeceased(personEntity.Details.DateOfExpiration))
            return;
        if (personEntity.ConfidentialityLevel != 0)
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_CALLBACK_NOTE'), textMsg: this.translateService.instant('LBL_WARNING_PERSON_DECEASED_CLASSIFIED'), isConfirmation: true, noButton: this.translateService.instant('LBL_NO'), yesButton: this.translateService.instant('LBL_YES') });
        else
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_CALLBACK_NOTE'), textMsg: this.translateService.instant('LBL_WARNING_PERSON_DECEASED'), isConfirmation: true, noButton: this.translateService.instant('LBL_NO'), yesButton: this.translateService.instant('LBL_YES') }).afterClosed().subscribe(result => {
                if (!result && this.searchEntityTags.length > 0)
                    this.personTagRemoved();
                document.getElementById("findFromSelectOption")?.focus();
            });
    }
    ;
    showPersonClassifiedWarning(personEntity) {
        if (personEntity.ConfidentialityLevel == 0)
            return;
        DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_CALLBACK_NOTE'), textMsg: this.translateService.instant('LBL_WARNING_PERSON_CLASSIFIED'), isConfirmation: true, noButton: this.translateService.instant('LBL_NO'), yesButton: this.translateService.instant('LBL_YES') }).afterClosed().subscribe(result => {
            if (!result && this.searchEntityTags.length > 0)
                this.personTagRemoved();
            document.getElementById("findFromSelectOption")?.focus();
        });
    }
    ;
    setMainEntity(searchEntity, relationshipType) {
        this.representativeList.length = 0;
        if (relationshipType == "")
            relationshipType = this.currentRelationType;
        let selectedEntityName = "";
        this.searchEntityTags = [];
        let searchEntitySelected = [];
        if (searchEntity != null) {
            document.getElementById("divContactAddress")?.setAttribute("readonly", "true");
            document.getElementById("divBsnNumber")?.setAttribute("readonly", "true");
            document.getElementById("divKvkNumber")?.setAttribute("readonly", "true");
            if (relationshipType == 'Person') {
                if (GlobalFunctions.isPersonDeceased(searchEntity.Details.DateOfExpiration))
                    this.showPersonDeceasedWarning(searchEntity);
                else if (searchEntity.ConfidentialityLevel != 0)
                    this.showPersonClassifiedWarning(searchEntity);
                let getGrammerValue = this.applicationSettingManager.getObjectGrammerSetting("PersonDto_CallbackNote");
                if (!GlobalFunctions.isEmpty(getGrammerValue)) {
                    GlobalFunctions.setStringPresentation(searchEntity, getGrammerValue);
                    selectedEntityName = searchEntity.StringRepresentation;
                }
            }
            else {
                if (GlobalFunctions.hasRight(GlobalFunctions.toContentType("Person"), OperationType.Add))
                    this.addDefaultRepresentative();
                selectedEntityName = searchEntity.Name;
                this.personService.clearCallbacks();
                this.personService.searchRelatedRepresentativeRequest(this.relatedRepresentatives, searchEntity);
            }
            this.taskDto.CustomerOrOrganizationName = selectedEntityName;
            searchEntitySelected.push({ text: selectedEntityName });
            this.searchEntityTags = searchEntitySelected;
            this.setSearchEntityProperties(searchEntity, relationshipType);
        }
    }
    ;
    setSearchEntityProperties(searchEntitySelected, relationshipType) {
        switch (relationshipType) {
            case 'Person':
                this.fillPersonInfo(searchEntitySelected);
                break;
            case 'Organization':
                this.fillOrganizationInfo(searchEntitySelected);
                break;
            default:
        }
    }
    ;
    fillPersonInfo(selectedEntity) {
        if (selectedEntity != null) {
            let person = GlobalFunctions.setEntityType(selectedEntity, JsonDtoType.Person);
            if (person == null)
                return;
            this.confidentialityLevel = person.ConfidentialityLevel;
            this.taskDto.MainEntityObject = person;
            this.taskDto.MainEntityId = person.Id;
            this.taskDto.MainEntitySource = person.ObjectSource;
            this.taskDto.CustomerBSN = this.formattedBSNPipe.transform(person.AdministeredPersonDto.ServiceNumber);
            this.taskDto.CustomerDateOfBirth = person.DateOfBirthText;
            if (person.ResidentialAddress != null)
                this.taskDto.ContactAddress = this.personFormattedAddressWithLabelPipe.transform(person, false) || '';
            if (!GlobalFunctions.isEmpty(person.PhoneNumber))
                this.taskDto.ContactPhoneNumber = person.PhoneNumber;
            if (!GlobalFunctions.isEmpty(person.EmailAddress))
                this.taskDto.ContactEmail = person.EmailAddress;
        }
    }
    ;
    externalAppointmentCallback(result) {
        if (result != null)
            this.showTaskResult(result);
    }
    saveTask() {
        if (this.form.invalid)
            return;
        if (!this.location || this.location == this.defaultLocation) {
            this.createTaskStatus = "LBL_MESSAGE_LOCATION_IS_NOT_SELECTED";
            return;
        }
        if (!this.product) {
            this.createTaskStatus = "LBL_MESSAGE_PRODUCT_IS_NOT_SELECTED";
            return;
        }
        if (!this.availableSlot) {
            this.createTaskStatus = "LBL_QMATIC_APPOINTMENT_STATUS_INVALID_TIME_SELECTION";
            return;
        }
        if (this.currentRelationType == "Organization" && this.taskDto.ContactPerson != null && this.taskDto.ContactPerson != '')
            this.taskDto.ContactPerson = this.taskDto.CustomerOrOrganizationName + "/" + this.taskDto.ContactPerson;
        else
            this.taskDto.ContactPerson = this.taskDto.CustomerOrOrganizationName;
        let taskHistoryDto = new TaskHistoryDto();
        taskHistoryDto.DateRecorded = new Date();
        taskHistoryDto.CreatedById = GlobalFunctions.getLoggedInUserId();
        taskHistoryDto.TaskHandlerList = [];
        taskHistoryDto.StatusText = this.translateService.instant("LBL_UNHANDLED");
        taskHistoryDto.Status = TaskStatus.Unhandled;
        this.taskDto.TaskHistoryList = [];
        this.taskDto.TaskHistoryList.push(taskHistoryDto);
        this.taskDto.CreateTaskAction = CreateTaskAction.Direct;
        this.taskDto.CurrentStatus = TaskStatus.Unhandled;
        this.taskDto.CreatedDate = new this.dateJS().toString(this.sessionManager.defaultOptions.mdyyyyhhmmss);
        this.taskDto.Tags = this.sessionManager.getTags();
        this.taskDto.CreatedById = GlobalFunctions.getLoggedInUserId();
        if (this.employeeService.loggedInEmployee != null) {
            let baseDtoObject = new BaseDto();
            baseDtoObject.Id = this.taskDto.CreatedById;
            this.taskDto.CreatedBy = baseDtoObject;
        }
        this.taskDto.RequiredCallbackDate = new this.dateJS(this.currentDate).toString(this.sessionManager.defaultOptions.mdyyyy);
        this.taskDto.CallBetweenStartDate = new this.dateJS(this.selectedStartDateTime).toString(this.sessionManager.defaultOptions.mdyyyyhhmmss);
        this.taskDto.CallBetweenEndDate = new this.dateJS(this.selectedEndDateTime).toString(this.sessionManager.defaultOptions.mdyyyyhhmmss);
        this.taskDto.MainEntityType = MainEntityType[this.currentRelationType];
        this.taskDto.ReferenceNumber = GlobalFunctions.isEmpty(this.taskDto.ReferenceNumber) ? 0 : this.taskDto.ReferenceNumber;
        this.fillRelationEntities();
        this.taskDto.TaskType = TaskType.Appointment;
        this.taskDto.TaskSource = TaskSource.Qmatic;
        this.startSpinner();
        let request = new MakeAppointmentExternalRequest();
        request.TaskDto = this.taskDto;
        request.LocationWisePublicId = this.location.PublicId;
        request.ServiceWisePublicId = this.product.PublicId;
        request.RequestId = "CREATE";
        this.taskService.setExternalAppointmentCallback(this.externalAppointmentCallback);
        this.taskService.makeAppointmentExternal(request);
    }
    ;
    dateChanged() {
        if (this.selectedDateFromPicker) {
            if (!this.opened && (this.isRequestOnProductLoad || this.fromNavigationBtns))
                return;
            let dtNow = new Date();
            this.currentDate = this.selectedDateFromPicker;
            this.currentDate.setHours(dtNow.getHours());
            this.currentDate.setMinutes(dtNow.getMinutes());
            if (this.product != null && !this.isRequestOnProductLoad && !this.fromNavigationBtns && !this.isRequestSent) {
                this.isRequestSent = true;
                this.fetchProductWiseDatesAndTimes(QmaticAvailabilityType.Time, this.currentDate);
            }
            this.showPreviousDayButton = this.minDate.getTime() <= this.selectedDateFromPicker.getTime();
        }
    }
    openSearchPopup() {
        DialogHelper.openDialog(this.dialog, SearchPopupComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { name: this.currentRelationType, recordSelection: RecordSelection.Single }).afterClosed().subscribe(searchEntity => {
            this.setMainEntity(searchEntity, "");
            document.getElementById("findFromSelectOption")?.focus();
        });
    }
    ;
    clearSelectedEntity() {
        this.taskDto.CustomerOrOrganizationName = null;
        this.taskDto.CustomerBSN = null;
        this.taskDto.CustomerKVKNumber = null;
        this.taskDto.ContactAddress = null;
        this.taskDto.ContactPhoneNumber = null;
        document.getElementById("divContactAddress")?.removeAttribute("readonly");
        document.getElementById("divBsnNumber")?.removeAttribute("readonly");
        document.getElementById("divKvkNumber")?.removeAttribute("readonly");
    }
    ;
    setMainEntityPerson() {
        if (this.selectedFindFrom == "Related") {
            let mainEntityPerson = GlobalFunctions.getLastPersonFromSession(this.sessionManager.detailViewCachedEntityList);
            this.mainItemObject = this.setMainEntity(mainEntityPerson, "Person");
        }
    }
    ;
    setMainEntityOrganization() {
        if (this.selectedFindFrom == "Related") {
            let mainEntityOrganization = GlobalFunctions.getLastOrganizationFromSession(this.sessionManager.detailViewCachedEntityList);
            this.mainItemObject = this.setMainEntity(mainEntityOrganization, "Organization");
        }
    }
    ;
    personTagRemoved() {
        this.representativeList.length = 0;
        this.searchEntityTags = [];
        if (this.confidentialityLevel != 0)
            this.confidentialityLevel = 0;
        this.clearSelectedEntity();
    }
    ;
    showTaskResult(response) {
        this.stopSpinner();
        this.eventProvider.BroadcastEvent(BroadCastEventKeys.FETCH_TASK_STATISTIC);
        switch (response?.Status) {
            case 1:
                this.close();
                this.sessionManager.loadedFromRelatedView = false;
                this.taskDto.Id = response.AppointmentId;
                this.taskDto.CreatedDate = new Date();
                this.taskDto.CallBetweenStartDate = this.selectedStartDateTime;
                this.taskDto.CallBetweenEndDate = this.selectedEndDateTime;
                this.taskDto.RequiredCallbackDate = new this.dateJS(this.taskDto.RequiredCallbackDate);
                this.taskDto.RelatedEntityFqdn = EntityFqdn[EntityFqdn.Decos_Kcs_Tasks_Entities_Appointment];
                this.taskDto.StringRepresentation = this.product.Name;
                this.sessionManager.selectedEntity = this.taskDto;
                this.sessionManager.selectedEntity.locationUrl = `${RoutePath.DETAIL_PATH}/${this.taskType.toLowerCase()}/${this.taskDto.Id}`;
                this.sessionManager.addBreadcrumbItems([this.taskDto], null, this.router.url);
                this.router.navigate([this.sessionManager.selectedEntity.locationUrl]);
                break;
            case -1:
                DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_APPOINTMENT'), textMsg: this.translateService.instant("LBL_QMATIC_APPOINTMENT_STATUS_NONE") });
                break;
            case 2:
                DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_APPOINTMENT'), textMsg: this.translateService.instant("LBL_QMATIC_APPOINTMENT_STATUS_INVALID_PRODUCT_SELECTION") });
                break;
            case 3:
                DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_APPOINTMENT'), textMsg: this.translateService.instant("LBL_QMATIC_APPOINTMENT_STATUS_INVALID_DATE_SELECTION") });
                break;
            case 4:
                DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_APPOINTMENT'), textMsg: this.translateService.instant("LBL_QMATIC_APPOINTMENT_STATUS_INVALID_TIME_SELECTION") });
                break;
            case 6:
                DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_APPOINTMENT'), textMsg: this.translateService.instant("LBL_QMATIC_APPOINTMENT_STATUS_INVALID_LOCATION_SELECTION") });
                break;
            case 7:
                DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_APPOINTMENT'), textMsg: this.translateService.instant("LBL_QMATIC_APPOINTMENT_STATUS_NONE") });
                break;
            default:
                DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_APPOINTMENT'), textMsg: this.translateService.instant("LBL_QMATIC_APPOINTMENT_STATUS_UNKNOWN_ERROR") });
                break;
        }
    }
    ;
    nextDayButtonClick() {
        this.fromNavigationBtns = true;
        this.isRequestOnProductLoad = false;
        this.currentDate.setDate(this.currentDate.getDate() + 1);
        this.selectedDateFromPicker = new Date(this.currentDate.getFullYear(), this.currentDate.getMonth(), this.currentDate.getDate());
        if (!this.enableDurationBox)
            this.buttonClicked = true;
        if (this.product != null)
            this.fetchProductWiseDatesAndTimes(QmaticAvailabilityType.Time, this.currentDate);
    }
    ;
    previousDayButtonClick() {
        this.fromNavigationBtns = true;
        this.isRequestOnProductLoad = false;
        this.currentDate.setDate(this.currentDate.getDate() - 1);
        this.selectedDateFromPicker = new Date(this.currentDate.getFullYear(), this.currentDate.getMonth(), this.currentDate.getDate());
        if (!this.enableDurationBox)
            this.buttonClicked = true;
        if (this.product != null)
            this.fetchProductWiseDatesAndTimes(QmaticAvailabilityType.Time, this.currentDate);
    }
    ;
    selectedSlotCallback(dates) {
        let dateMoment = new Date(dates.start);
        let hr = dateMoment.getHours();
        let min = dateMoment.getMinutes();
        this.startTime = dates.start.toString();
        this.selectedStartDateTime = new Date(dateMoment.getFullYear(), dateMoment.getMonth(), dateMoment.getDate(), hr, min, 0, 0);
        dateMoment = new Date(dates.end);
        hr = dateMoment.getHours();
        min = dateMoment.getMinutes();
        this.endTime = dates.end.toString();
        this.selectedEndDateTime = new Date(dateMoment.getFullYear(), dateMoment.getMonth(), dateMoment.getDate(), hr, min, 0, 0);
        this.calendar.getApi()?.getEventById('selectedEvent')?.remove();
        this.calendar.getApi()?.addEvent({
            id: 'selectedEvent',
            allDay: false,
            editable: false,
            end: new Date(dates.end),
            backgroundColor: '#34b7db',
            start: new Date(dates.start)
        });
    }
    ;
    close() {
        this.dialogManager.removeComponent();
        this.sessionManager.closeJkcParentPanel();
    }
    ;
    fillRelationEntities() {
        let cachedEntities = this.sessionManager.detailViewCachedEntityList;
        let isQmaticProductAdded = false;
        if (cachedEntities != null && cachedEntities.length > 0) {
            this.taskDto.RelatedEntityList = [];
            cachedEntities.forEach(value => {
                if (value != undefined && value.key != null && value.key != undefined && value.key.IsMarked) {
                    let relatedEntityDto = new RelatedEntityDto();
                    relatedEntityDto.RelatedEntityId = value.key.Id;
                    let actualEntityType = value.value.replace(/\./g, '_');
                    relatedEntityDto.EntityType = EntityFqdn["" + actualEntityType + ""];
                    relatedEntityDto.ObjectSource = value.key.ObjectSource;
                    this.taskDto.RelatedEntityList.push(relatedEntityDto);
                    if (relatedEntityDto.RelatedEntityId == this.product.Id && relatedEntityDto.ObjectSource == this.product.ObjectSource)
                        isQmaticProductAdded = true;
                }
            });
        }
        if (!isQmaticProductAdded && this.XmlProductList != null) {
            if (this.taskDto.RelatedEntityList == undefined)
                this.taskDto.RelatedEntityList = [];
            let qmaticProduct = jlinq.from(this.XmlProductList).starts("QmaticId", this.product.Id).first();
            if (qmaticProduct == undefined)
                return;
            let relatedEntityDto = new RelatedEntityDto();
            relatedEntityDto.RelatedEntityId = qmaticProduct.Id;
            let actualEntityType = this.product.RelatedEntityFqdn.replace(/\./g, '_');
            relatedEntityDto.EntityType = EntityFqdn["" + actualEntityType + ""];
            relatedEntityDto.ObjectSource = qmaticProduct.ObjectSource;
            this.taskDto.RelatedEntityList.push(relatedEntityDto);
        }
    }
    ;
    refreshCalendar(allowSelection) {
        GlobalFunctions.refreshCalendar(this.calendar.getApi(), this.calendarOptions, 'timeGridDay', this.agendaItems, this.currentDate, this.currentAvailability, this.calendarContentHeight, this.translateService, this.selectedSlotCallback, allowSelection, this.appointmentLength, true);
    }
    ;
    registerDialogShortcutKey() {
        this.shortcutManager.bind('LBL_SHORTCUT_SAVE_BUTTON', () => this.saveTask());
    }
    ;
    update() {
        this.representativeList = [];
        this.selectedRepresentative = null;
        switch (this.selectedFindFrom) {
            case "ManualEntry":
                {
                    if (this.selectedFindFrom == "ManualEntry") {
                        if (this.currentRelationType == "Person")
                            document.getElementById("customerNameValue")?.focus();
                        else
                            document.getElementById("organizationNameValue")?.focus();
                    }
                    break;
                }
            case "Search":
                {
                    if (this.selectedFindFrom == "Search") {
                        this.openSearchPopup();
                        this.selectedFindFrom = "SelectAny";
                    }
                    break;
                }
            case "RegisterNew":
                {
                    if (this.currentRelationType == "Organization") {
                        if (GlobalFunctions.isEmpty(this.sessionManager.jkcChildPanel) || !this.sessionManager.jkcChildPanel.parameters.IsUsed) {
                            this.sessionManager.jkcChildPanel = new JkcPanel(this.sessionManager.contactSessionNotesState, null, false, null, null, null, 'addOrganizationHeader', 'addOrganizationFooter', '115px', '11.2%', '25%', '50%', null, '50%');
                            this.sessionManager.jkcParentPanel.parameters.IsChildPanel = true;
                            this.sessionManager.jkcParentPanel.parameters.CallbackMethod = this.addOrganizationResponse;
                            this.dialogManager.openJkcChildPanelDialogue(OrganizationAddEditComponent, 'addOrganizationContainer', this.viewContainerRef);
                        }
                        else
                            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_APPLICATION_TITLE'), textMsg: this.translateService.instant('LBL_RESTRICT_MULTIPLE_WINDOW_MESSAGE') });
                    }
                    else if (this.currentRelationType == "Person") {
                        if (GlobalFunctions.isEmpty(this.sessionManager.jkcChildPanel) || !this.sessionManager.jkcChildPanel.parameters.IsUsed) {
                            this.sessionManager.jkcChildPanel = new JkcPanel(this.sessionManager.contactSessionNotesState, null, false, null, null, null, 'addPersonHeader', 'addPersonFooter', '-42px', '1.2%', '15%', '70%', null, '70%');
                            this.sessionManager.jkcParentPanel.parameters.IsChildPanel = true;
                            this.sessionManager.jkcParentPanel.parameters.CallbackMethod = this.addPersonResponse;
                            this.dialogManager.openJkcChildPanelDialogue(PersonAddEditComponent, 'addPersonContainer', this.viewContainerRef);
                        }
                        else
                            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_APPLICATION_TITLE_'), textMsg: this.translateService.instant('LBL_RESTRICT_MULTIPLE_WINDOW_MESSAGE') });
                    }
                    break;
                }
        }
        this.searchEntityTags = [];
        this.clearSelectedEntity();
    }
    ;
    addPersonResponse(selectedEntity) {
        this.setMainEntity(selectedEntity, "Person");
        this.registerDialogShortcutKey();
        if (!GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) && this.sessionManager.jkcParentPanel.parameters.IsPanelExpanded)
            document.getElementById("findFromSelectOption")?.focus();
    }
    addOrganizationResponse(selectedEntity) {
        this.setMainEntity(selectedEntity, "Organization");
        this.registerDialogShortcutKey();
        if (!GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) && this.sessionManager.jkcParentPanel.parameters.IsPanelExpanded)
            document.getElementById("findFromSelectOption")?.focus();
    }
    selectedProductChanged() {
        this.availableSlot = null;
        this.AllAvailableSlots = [];
        this.fromNavigationBtns = false;
        this.isRequestOnProductLoad = true;
        this.fetchProductWiseDatesAndTimes();
    }
    ;
    selectedLocationChanged() {
        this.product = null;
        this.isLocationSelected = true;
        this.availableSlot = null;
        this.AllAvailableSlots = [];
        this.fromNavigationBtns = false;
        this.isRequestOnProductLoad = true;
        this.fetchLocationWiseProducts();
    }
    ;
    fetchAppointmentRelatedProductResponse(result) {
        this.isLocationSelected = false;
        this.ProductList = result;
        if (!GlobalFunctions.isEmpty(this.ProductList) && this.ProductList.length > 0)
            this.product = this.ProductList[0];
        this.selectedProductChanged();
    }
    fetchProductWiseDateTimesResponse(message) {
        this.stopSpinner();
        this.availableSlot = null;
        this.AllAvailableSlots = [];
        if (!GlobalFunctions.isEmpty(message.AvailableDateList))
            this.availableDates = message.AvailableDateList;
        if (message.AvailabilityCollectionList != null && message.AvailabilityCollectionList.length > 0) {
            this.currentAvailability = message.AvailabilityCollectionList[0].Availability;
            this.AllAvailableSlots = jlinq.from(this.currentAvailability).starts("FreeBusyStatus", 1).select();
            if (this.AllAvailableSlots != null && this.AllAvailableSlots.length > 0) {
                this.availableSlot = this.AllAvailableSlots[0];
                this.currentDate = Date.parse(this.availableSlot.StartDate.split("+")[0].split(".")[0].replace("Z", ""));
                this.changeSelectedAvailableTimeSlot();
            }
            else {
                if (!GlobalFunctions.isEmpty(message.AvailabilityCollectionList[0].Availability) && message.AvailabilityCollectionList[0].Availability.length > 0) {
                    this.selectedStartDateTime = message.AvailabilityCollectionList[0].Availability[0].StartDate;
                    this.selectedEndDateTime = message.AvailabilityCollectionList[0].Availability[0].StartDate;
                }
                this.selectedSlotEndTime = "";
            }
            if (!GlobalFunctions.isEmpty(message.AvailabilityCollectionList[0].Availability) && message.AvailabilityCollectionList[0].Availability.length > 0) {
                let startdate = message.AvailabilityCollectionList[0].Availability[0].StartDate;
                if (startdate != undefined && Date.parse(message.AvailabilityCollectionList[0].Availability[0].StartDate.split("+")[0].split(".")[0].replace("Z", "")) != null) {
                    this.currentDate = Date.parse(message.AvailabilityCollectionList[0].Availability[0].StartDate.split("+")[0].split(".")[0].replace("Z", ""));
                    if (this.isRequestOnProductLoad)
                        this.selectedDateFromPicker = this.currentDate;
                }
            }
            this.appointmentLength = message.AppointmentLength.toString();
            this.agendaItems = message.AvailabilityCollectionList[0].AgendaItems;
            this.isRequestSent = false;
        }
    }
    changeSelectedAvailableTimeSlot() {
        if (this.availableSlot == undefined)
            return;
        let endate = this.availableSlot.EndDate;
        let endTimeHrs = endate.split('T')[1].split('Z')[0].split(':')[0];
        let endTimeMinutes = endate.split('T')[1].split('Z')[0].split(':')[1];
        let startTimeHrs = this.availableSlot.StartDate.split('T')[1].split('Z')[0].split(':')[0];
        let startTimeMinutes = this.availableSlot.StartDate.split('T')[1].split('Z')[0].split(':')[1];
        this.selectedStartDateTime = new Date(this.currentDate.getFullYear(), this.currentDate.getMonth(), this.currentDate.getDate(), startTimeHrs, startTimeMinutes, 0, 0);
        this.selectedEndDateTime = new Date(this.currentDate.getFullYear(), this.currentDate.getMonth(), this.currentDate.getDate(), endTimeHrs, endTimeMinutes, 0, 0);
        this.selectedSlotEndTime = endate;
    }
    ;
    fetchLocationWiseProducts() {
        if (!GlobalFunctions.isEmpty(this.location) && !GlobalFunctions.isEmpty(this.location.Name) && this.location.Name.toLowerCase() !== this.defaultLocation.Name.toLowerCase()) {
            this.taskService.fetchLocationsWiseProducts(this.location.PublicId, this.fetchAppointmentRelatedProductResponse);
        }
    }
    fetchProductWiseDatesAndTimes(qmaticAvailability = QmaticAvailabilityType.Both, selectedDate = null) {
        if (!GlobalFunctions.isEmpty(this.product) && !GlobalFunctions.isEmpty(this.product.PublicId)) {
            let request = new FetchAvailableDateOrTimeRequest();
            request.QmaticAvailabilityType = qmaticAvailability;
            request.SelectedDate = selectedDate;
            request.SelectedLocationPublicId = this.location.PublicId;
            request.SelectedServicePublicId = this.product.PublicId;
            request.Duration = this.product.Duration;
            this.isRequestSent = true;
            this.taskService.fetchProductWiseDateTimes(request, this.fetchProductWiseDateTimesResponse);
            this.startSpinner();
        }
    }
    fillOrganizationInfo(selectedEntity) {
        if (selectedEntity != null) {
            let organization = GlobalFunctions.setEntityType(selectedEntity, JsonDtoType.Organization);
            this.taskDto.MainEntityObject = organization;
            this.taskDto.MainEntityId = organization.Id;
            this.taskDto.MainEntitySource = organization.ObjectSource;
            this.taskDto.CustomerKVKNumber = organization.AdministeredOrganizationDto.Identification;
            if (organization.RegistrationAddress != null)
                this.taskDto.ContactAddress = this.organizationFormattedAddressWithLabelPipe.transform(organization, false) || '';
            if (!GlobalFunctions.isEmpty(organization.PhoneNumber))
                this.taskDto.ContactPhoneNumber = organization.PhoneNumber;
            if (!GlobalFunctions.isEmpty(organization.EmailAddress))
                this.taskDto.ContactEmail = organization.EmailAddress;
        }
    }
    ;
    selectOptionsFromFindList() {
        let result = GlobalFunctions.isSessionContainsPersonOrganizationRecord(this.sessionManager.detailViewCachedEntityList);
        if (result) {
            this.selectedFindFrom = "Related";
            let mainEntityPerson = GlobalFunctions.getLastPersonFromSession(this.sessionManager.detailViewCachedEntityList);
            if (mainEntityPerson) {
                this.currentRelationType = "Person";
                this.setMainEntity(mainEntityPerson, "Person");
            }
            else {
                this.currentRelationType = "Organization";
                let mainEntityOrganization = GlobalFunctions.getLastOrganizationFromSession(this.sessionManager.detailViewCachedEntityList);
                this.setMainEntity(mainEntityOrganization, "Organization");
            }
        }
        else
            this.selectedFindFrom = "ManualEntry";
    }
    ;
    open() {
        this.isRequestOnProductLoad = false;
        this.fromNavigationBtns = false;
        this.opened = !this.opened;
    }
    ;
    disableWeekendDates(date, mode) {
        return (mode === 'day' && (date.getDay() === 0 || date.getDay() === 6));
    }
    ;
    getDayClass(date, mode) {
        let dateAvailabilityClass = '';
        if (!GlobalFunctions.isEmpty(this.availableDates)) {
            for (let i = 0; i < this.availableDates.length; i++) {
                if (new Date(date).setHours(0, 0, 0, 0) == new Date(this.availableDates[i]).setHours(0, 0, 0, 0))
                    dateAvailabilityClass = 'dateAvailable';
            }
            let currentDate = new Date();
            if (GlobalFunctions.isEmpty(dateAvailabilityClass) && new Date(date).setHours(0, 0, 0, 0) <= currentDate.setDate(currentDate.getDate() + 30))
                dateAvailabilityClass = 'dateNotAvailable';
        }
        return dateAvailabilityClass;
    }
    ;
    resize() {
        let windowHeight = $(window).height();
        $("#jkcParentPanel").css({ 'max-height': (windowHeight - parseInt(this.sessionManager.jkcParentPanel.parameters.TopSpace) - 100 + "px") });
        let newHeight = $("#jkcParentPanel").height() - $("#addTaskHeader").height() - $("#addTaskFooter").height() + "px";
        $("#addTaskContainer").height(newHeight);
        $('#' + this.sessionManager.jkcParentPanel.parameters.HeaderId).css({ 'width': ($("#jkcParentPanel").width()) });
        $('#' + this.sessionManager.jkcParentPanel.parameters.FooterId).css({ 'width': ($("#jkcParentPanel").width()) });
    }
    handleEscKey() {
        if (!GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) && this.sessionManager.jkcParentPanel.parameters.IsPanelExpanded)
            this.close();
    }
    ;
    createQmaticAppointmentDto(mainTaskItem) {
        let qmaticAppointmentDto = new QmaticAppointmentDtos();
        if (mainTaskItem && !GlobalFunctions.isEmpty(mainTaskItem.RelatedEntityFqdn)) {
            switch (mainTaskItem.RelatedEntityFqdn) {
                case EntityFqdn[EntityFqdn.Decos_Kcs_Organizations_Entities_Organization]:
                    {
                        qmaticAppointmentDto.StringRepresentation = mainTaskItem.StringRepresentation;
                        if (typeof mainTaskItem.AdministeredOrganizationDto != undefined)
                            qmaticAppointmentDto.Id = mainTaskItem.AdministeredOrganizationDto.Identification;
                        qmaticAppointmentDto.BankAccounts = mainTaskItem.BankAccount;
                        qmaticAppointmentDto.Addresses = mainTaskItem.Address;
                        qmaticAppointmentDto.PhoneNumber = mainTaskItem.PhoneNumber;
                        qmaticAppointmentDto.EmailAddress = mainTaskItem.EmailAddress;
                        break;
                    }
                case EntityFqdn[EntityFqdn.Decos_Kcs_Persons_Entities_Person]:
                    {
                        qmaticAppointmentDto.StringRepresentation = mainTaskItem.StringRepresentation;
                        if (typeof mainTaskItem.AdministeredPersonDto != undefined)
                            qmaticAppointmentDto.Id = mainTaskItem.AdministeredPersonDto.ServiceNumber;
                        qmaticAppointmentDto.BankAccounts = mainTaskItem.BankAccount[0];
                        qmaticAppointmentDto.Addresses = mainTaskItem.ResidentialAddress;
                        qmaticAppointmentDto.PhoneNumber = mainTaskItem.PhoneNumber;
                        qmaticAppointmentDto.EmailAddress = mainTaskItem.EmailAddress;
                        if (mainTaskItem.Details && mainTaskItem.Details.FormalName)
                            qmaticAppointmentDto.Gender = mainTaskItem.Details.FormalName.GenderText;
                        if (mainTaskItem.Details)
                            qmaticAppointmentDto.DateOfBirth = mainTaskItem.Details.DateOfBirth;
                        break;
                    }
            }
        }
        return qmaticAppointmentDto;
    }
    fetchAppointmentRelatedLocationResponse(result) {
        this.sessionManager.appointmentLocationList = result;
        this.LocationList = Object.assign([], this.sessionManager.appointmentLocationList);
        this.LocationList.unshift(this.defaultLocation);
        if (!GlobalFunctions.isEmpty(this.LocationList) && this.LocationList.length > 1) {
            this.location = this.LocationList[1];
            this.selectedLocationChanged();
        }
    }
};
__decorate([
    ViewChild('form')
], AppointmentAddEditQmaticComponent.prototype, "form", void 0);
__decorate([
    ViewChild('calendar')
], AppointmentAddEditQmaticComponent.prototype, "calendar", void 0);
AppointmentAddEditQmaticComponent = __decorate([
    Component({
        selector: 'appointment-add-edit-qmatic',
        templateUrl: './appointment-add-edit-qmatic.component.html',
        styleUrls: ['./appointment-add-edit-qmatic.component.scss'],
        host: { '(window:resize)': 'resize()' }
    })
], AppointmentAddEditQmaticComponent);
export { AppointmentAddEditQmaticComponent };
//# sourceMappingURL=appointment-add-edit-qmatic.component.js.map