var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { GlobalFunctions } from '../../../../shared/global-functions';
import { CommonHelper } from '../../../../shared/helper/common-helper';
import { DialogHelper } from '../../../../shared/helper/dialog-helper';
import { BaseDialogComponent } from '../../../common/base-dialog.component';
import { MessageboxComponent } from '../../../common/messagebox/messagebox.component';
let TaskReminderComponent = class TaskReminderComponent extends BaseDialogComponent {
    constructor(dialog, taskService, sessionManager, translateService, dialogRef, searchService, datePipe, dateAdapter) {
        super();
        this.dialog = dialog;
        this.taskService = taskService;
        this.sessionManager = sessionManager;
        this.translateService = translateService;
        this.dialogRef = dialogRef;
        this.searchService = searchService;
        this.datePipe = datePipe;
        this.dateAdapter = dateAdapter;
        this.isInProcess = false;
        this.selectedTask = null;
        this.taskRemindersList = null;
        this.selectedTaskReminder = null;
        this.taskRemindersCallback = this.taskRemindersCallback.bind(this);
    }
    ngOnInit() {
        this.resize();
    }
    getTaskReminder(showAllTaskReminders = true) {
        if (showAllTaskReminders || (!showAllTaskReminders && this.isValidDate())) {
            this.taskService.setTaskRemindersCallback(this.taskRemindersCallback);
            this.taskService.getTaskReminders(!showAllTaskReminders ? this.startDate : null, !showAllTaskReminders ? this.endDate : null);
            this.startSpinner();
            this.isInProcess = true;
            this.clearData();
        }
        else
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_TASK_REMINDER'), textMsg: this.translateService.instant('LBL_WRONG_DATE_FORMAT_ERROR') });
    }
    ;
    clearData() {
        this.taskRemindersList = null;
        this.selectedTaskReminder = null;
        this.selectedTask = null;
    }
    ;
    isValidDate() {
        return this.startDate != null && this.endDate != null && this.startDate.getTime() <= this.endDate.getTime();
    }
    ;
    selectTaskReminder(taskReminder) {
        this.selectedTaskReminder = taskReminder;
        this.selectedTask = taskReminder.TaskReminderList.length > 0 ? taskReminder.TaskReminderList[0] : null;
    }
    ;
    selectTask(selectedTask) {
        this.selectedTask = selectedTask;
    }
    ;
    taskRemindersCallback(taskRemindersResponse) {
        this.stopSpinner();
        this.isInProcess = false;
        if (!this.taskRemindersList)
            this.taskRemindersList = [];
        if (taskRemindersResponse && taskRemindersResponse.TaskReminderRunList.length > 0)
            for (let i = 0; i < taskRemindersResponse.TaskReminderRunList.length; i++)
                this.taskRemindersList.push(taskRemindersResponse.TaskReminderRunList[i]);
        this.selectedTaskReminder = this.taskRemindersList.length > 0 ? this.taskRemindersList[0] : null;
        this.selectedTask = this.selectedTaskReminder && this.selectedTaskReminder.TaskReminderList && this.selectedTaskReminder.TaskReminderList.length > 0 ? this.selectedTaskReminder.TaskReminderList[0] : null;
    }
    ;
    resize() {
        let windowHeight = $(window).height();
        let newHeight = windowHeight - $("#taskReminderHeader").height() - 90;
        $("#taskReminderContainer").height(newHeight + "px");
    }
    close(result) {
        this.dialogRef.close(result);
    }
    taskReminderDOB(event, inputId) {
        GlobalFunctions.setDateFormat(inputId, event.target.value, this.sessionManager.defaultOptions.defaultDateFormat, this.datePipe);
    }
    initDatePickerState() {
        this.dateAdapter.setLocale(CommonHelper.getLanguageCode());
        if (!GlobalFunctions.isEmpty(this.startDate))
            GlobalFunctions.setDateFormat("startDatePicker", this.startDate, this.sessionManager.defaultOptions.defaultDateFormat, this.datePipe);
        if (!GlobalFunctions.isEmpty(this.endDate))
            GlobalFunctions.setDateFormat("endDatePicker", this.endDate, this.sessionManager.defaultOptions.defaultDateFormat, this.datePipe);
    }
};
TaskReminderComponent = __decorate([
    Component({
        selector: 'task-reminder',
        templateUrl: './task-reminder.component.html',
        styleUrls: ['./task-reminder.component.scss'],
        host: { '(window:resize)': 'resize()' }
    })
], TaskReminderComponent);
export { TaskReminderComponent };
//# sourceMappingURL=task-reminder.component.js.map