var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, Input } from '@angular/core';
import { RoutePath } from '../../../../shared/constants';
let TaskHistoryComponent = class TaskHistoryComponent {
    constructor(router, dialogManager, sessionManager, viewContainerRef, applicationSettingManager) {
        this.router = router;
        this.dialogManager = dialogManager;
        this.sessionManager = sessionManager;
        this.viewContainerRef = viewContainerRef;
        this.applicationSettingManager = applicationSettingManager;
        this.attempts = [];
        this.currentHistoryTab = 'ContactHistory';
    }
    select(item) {
        if (item) {
            if (this.sessionManager.isViewerFeatureEnabled && this.sessionManager.hasViewerAccess && this.applicationSettingManager.viewerSetting.loadFromRelatedItem('contacthistory'))
                this.dialogManager.openJkcViewerPanelDialogue(item, this.viewContainerRef);
            else {
                item.locationUrl = `${RoutePath.DETAIL_PATH}/contacthistory`;
                this.sessionManager.loadedFromRelatedView = true;
                this.sessionManager.selectedEntity = item;
                this.sessionManager.setBreadcrumbGrammer(item);
                this.sessionManager.addBreadcrumbItems([item], null, RoutePath.DETAIL_PATH);
                this.router.navigate([this.sessionManager.selectedEntity.locationUrl]);
            }
        }
    }
    ;
};
__decorate([
    Input()
], TaskHistoryComponent.prototype, "attempts", void 0);
TaskHistoryComponent = __decorate([
    Component({
        selector: 'task-history',
        templateUrl: './task-history.component.html',
        styleUrls: ['./task-history.component.scss']
    })
], TaskHistoryComponent);
export { TaskHistoryComponent };
//# sourceMappingURL=task-history.component.js.map