var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
import { Component, Inject, ViewChild } from '@angular/core';
import { MAT_DIALOG_DATA } from '@angular/material/dialog';
import { SubSink } from 'subsink';
import { OperationType } from '../../../../core/enums/common-enums';
import { EntityFqdn } from '../../../../core/enums/core-enums';
import { ContentType } from '../../../../core/models/jkc-object/jkc-object';
import { BulkHandleTaskRequest } from '../../../../core/models/task/bulk-handle-task-request';
import { RoutePath, SideMenuItem } from '../../../../shared/constants';
import { GlobalFunctions } from '../../../../shared/global-functions';
import { DialogHelper } from '../../../../shared/helper/dialog-helper';
import { BaseDialogComponent } from '../../../common/base-dialog.component';
import { MessageboxComponent } from '../../../common/messagebox/messagebox.component';
let TaskBulkHandleComponent = class TaskBulkHandleComponent extends BaseDialogComponent {
    constructor(router, dialog, taskService, data, sessionManager, shortcutManager, translateService, dialogRef, integrationSettingManager, datePipe) {
        super();
        this.router = router;
        this.dialog = dialog;
        this.taskService = taskService;
        this.data = data;
        this.sessionManager = sessionManager;
        this.shortcutManager = shortcutManager;
        this.translateService = translateService;
        this.dialogRef = dialogRef;
        this.integrationSettingManager = integrationSettingManager;
        this.datePipe = datePipe;
        this.dateJS = Date;
        this.answerList = [];
        this.handleUntilDate = new Date();
        this.answer = "";
        this.answerFreeText = "";
        this.answerIndex = 0;
        this.enableAnswerValidation = false;
        this.userId = GlobalFunctions.getLoggedInUserId();
        this.handleOnBehalf = false;
        this.subs = new SubSink();
        this.bulkHandleTaskResponse = this.bulkHandleTaskResponse.bind(this);
    }
    ngOnInit() {
        this.setDefaultAnswer();
        this.taskBulkHandleDateChange();
        this.shortcutManager.bind('LBL_SHORTCUT_SAVE_BUTTON', () => this.bulkHandle());
    }
    ngOnDestroy() {
        this.subs.unsubscribe();
        this.shortcutManager.unbind('LBL_SHORTCUT_SAVE_BUTTON');
    }
    changeAnswerOption() {
        this.answer = this.answerList[this.answerIndex];
        this.enableAnswerValidation = (this.answerList.length == (this.answerIndex + 1));
    }
    ;
    setDefaultAnswer() {
        let result = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Tasks_Entities_Task, "DEFAULTANSWERS");
        if (!GlobalFunctions.isEmpty(result)) {
            result = result.replace(/\n/g, "\r");
            let splitResult = result.split("\r");
            if (splitResult != null && splitResult.length > 0) {
                for (let index = 0; index < splitResult.length; index++) {
                    if (splitResult[index] != '')
                        this.answerList.push(splitResult[index]);
                }
            }
        }
        this.answerList.push(this.translateService.instant("LBL_OTHER"));
        this.changeAnswerOption();
    }
    ;
    bulkHandle() {
        if (this.form.invalid)
            return;
        this.sendBulkHandleTaskRequest(true);
    }
    ;
    sendBulkHandleTaskRequest(isCountRequired) {
        if (this.data.resultList != undefined && this.data.resultList != null && this.data.resultList.length > 0) {
            this.startSpinner();
            let isAllTasks = GlobalFunctions.hasRight(ContentType.Task, OperationType.CanBulkHandleAnyTask) ? true : false;
            let fetchDate = new this.dateJS(this.handleUntilDate);
            let handleDate = new Date(fetchDate.getFullYear(), fetchDate.getMonth(), fetchDate.getDate(), 23, 59, 59, 0);
            let count = 0;
            let taskIdList = new Array();
            if (isAllTasks) {
                for (let i = 0; i < this.data.resultList.length; i++) {
                    if (this.data.resultList[i].ScheduledWorkType != 'Session' && this.data.resultList[i].ObjectSourceDto != null && !GlobalFunctions.isEmpty(this.data.resultList[i].ObjectSourceDto.ObjectSource) && this.data.resultList[i].ObjectSourceDto.ObjectSource.toLowerCase() != 'decos.kcs.tasks.decosconnect') {
                        let taskScheduledWorkReceivedDate = new this.dateJS(this.data.resultList[i].ScheduledWorkReceivedDate);
                        if (taskScheduledWorkReceivedDate <= handleDate) {
                            count++;
                            taskIdList.push(this.data.resultList[i].Id);
                        }
                    }
                }
            }
            else {
                for (let i = 0; i < this.data.resultList.length; i++) {
                    if (this.data.resultList[i].ScheduledWorkType != 'Session' && this.data.resultList[i].ObjectSourceDto.CurrentHandlerList != undefined && this.data.resultList[i].ObjectSourceDto.CurrentHandlerList.length > 0) {
                        for (let j = 0; j < this.data.resultList[i].ObjectSourceDto.CurrentHandlerList.length; j++) {
                            if (this.data.resultList[i].ObjectSourceDto.CurrentHandlerList[j].HandlerId == this.userId) {
                                let taskScheduledWorkReceivedDate = new this.dateJS(this.data.resultList[i].ScheduledWorkReceivedDate);
                                if (taskScheduledWorkReceivedDate <= handleDate) {
                                    count++;
                                    taskIdList.push(this.data.resultList[i].Id);
                                }
                            }
                        }
                    }
                }
            }
            let message = this.translateService.instant("LBL_MSG_BULK_HANDLE");
            let header = this.translateService.instant("LBL_BULK_HANDLE");
            if (count == 0) {
                message = this.translateService.instant("LBL_MSG_BULK_HANDLE_NO_TASK");
                DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: header, textMsg: message });
            }
            else {
                message = GlobalFunctions.formatStringValue(message, [count]);
                message = this.translateService.instant(message);
                DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: header, textMsg: message, isConfirmation: true, noButton: 'LBL_NO', yesButton: 'LBL_YES' }).afterClosed().subscribe(result => {
                    if (result) {
                        let req = new BulkHandleTaskRequest();
                        req.Answer = this.answer;
                        req.AnswerFreeText = this.answerFreeText;
                        req.TaskIdList = taskIdList;
                        req.HandleOnBehalf = this.handleOnBehalf;
                        this.taskService.bulkHandleTask(req, this.bulkHandleTaskResponse, () => { });
                        this.startSpinner();
                    }
                    else
                        this.close();
                });
            }
            this.stopSpinner();
        }
    }
    ;
    bulkHandleTaskResponse(result) {
        this.stopSpinner();
        if (result) {
            switch (result.Result) {
                case 0:
                    this.close();
                    this.router.navigate([RoutePath.DASHBOARD, RoutePath.SEARCH_PATH, SideMenuItem.TASK]);
                    break;
                case 1:
                    DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant("LBL_BULK_HANDLE"), textMsg: this.translateService.instant("LBL_MSG_BULK_HANDLE_FAIL") }).afterClosed().subscribe(() => {
                        this.close();
                        this.router.navigate([RoutePath.DASHBOARD, RoutePath.LIST_PATH, SideMenuItem.TASK], { queryParams: { filter: 'my' } });
                    });
                    break;
            }
        }
    }
    ;
    close() {
        this.dialogRef.close();
    }
    taskBulkHandleDateChange() {
        this.timeoutIds.push(setTimeout(() => {
            GlobalFunctions.setDateFormat('handleUntilDatePicker', this.handleUntilDate, this.sessionManager.defaultOptions.defaultDateFormat, this.datePipe);
        }, 100));
    }
};
__decorate([
    ViewChild('form')
], TaskBulkHandleComponent.prototype, "form", void 0);
TaskBulkHandleComponent = __decorate([
    Component({
        selector: 'task-bulk-handle',
        templateUrl: './task-bulk-handle.component.html',
        styleUrls: ['./task-bulk-handle.component.scss']
    }),
    __param(3, Inject(MAT_DIALOG_DATA))
], TaskBulkHandleComponent);
export { TaskBulkHandleComponent };
//# sourceMappingURL=task-bulk-handle.component.js.map