var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, ViewChild } from '@angular/core';
import { BaseDialogComponent } from 'src/app/components/common/base-dialog.component';
import { MessageboxComponent } from 'src/app/components/common/messagebox/messagebox.component';
import { MessageMediaType, RecordOperationMode, ScreenMode } from 'src/app/core/enums/common-enums';
import { EntityFqdn } from 'src/app/core/enums/core-enums';
import { SocialMediaMessageDto } from 'src/app/core/models/social-media/social-media-message-dto';
import { CreateSocialMediaMessageRequest } from 'src/app/core/models/social-media/social-media-message-request';
import { BroadCastEventKeys } from 'src/app/shared/constants';
import { GlobalFunctions } from 'src/app/shared/global-functions';
import { DialogHelper } from 'src/app/shared/helper/dialog-helper';
import { ExceptionHelper } from 'src/app/shared/helper/exception-helper';
import { SubSink } from 'subsink';
import X2JS from 'x2js';
let AddSocialMediaMessageComponent = class AddSocialMediaMessageComponent extends BaseDialogComponent {
    constructor(sessionManager, translateService, shortcutManager, integrationSettingManager, socialMediaService, dialog, dialogManager, eventProvider) {
        super();
        this.sessionManager = sessionManager;
        this.translateService = translateService;
        this.shortcutManager = shortcutManager;
        this.integrationSettingManager = integrationSettingManager;
        this.socialMediaService = socialMediaService;
        this.dialog = dialog;
        this.dialogManager = dialogManager;
        this.eventProvider = eventProvider;
        this.title = this.translateService.instant('LBL_ADD_SOCIALMEDIA').toUpperCase();
        this.DateJS = Date;
        this.files = [];
        this.mediaType = '';
        this.facebookPageList = [];
        this.twitterPageList = [];
        this.selectedFacebookPage = 'all';
        this.selectedTwitterPage = 'all';
        this.twitPages = false;
        this.fbPages = false;
        this.facebookChecked = false;
        this.twitterChecked = false;
        this.subs = new SubSink();
        this.addSocialMediaErrorCallback = this.addSocialMediaErrorCallback.bind(this);
        this.addSocialMediaResponse = this.addSocialMediaResponse.bind(this);
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.JSPANEL_RESIZE).subscribe(() => this.resize());
    }
    ngOnInit() {
        this.sessionManager.jkcParentPanel.parameters.Scope = this;
        this.sessionManager.startSessionIfPossible("SOCIALMEDIA", ScreenMode.Add);
        try {
            this.socialmediaDto = new SocialMediaMessageDto();
            this.shortcutManager.bind('LBL_SHORTCUT_SAVE_BUTTON', () => this.createSocialMedia());
            let facebookPagesStr = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_SocialMedia_Entities_Facebook, "CONFIGUREFACEBOOKPAGES");
            let twitterPagesStr = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_SocialMedia_Entities_Twitter, "CONFIGURETWITTERACCOUNTS");
            if (!GlobalFunctions.isEmpty(facebookPagesStr)) {
                let x2js = new X2JS();
                let facebookPages = x2js.xml2js(facebookPagesStr);
                if (!GlobalFunctions.isEmpty(facebookPages) && !GlobalFunctions.isEmpty(facebookPages.FacebookPages.FacebookPage)) {
                    let pageList = GlobalFunctions.ConvertToArrayIfOnlySingleObject(facebookPages.FacebookPages.FacebookPage);
                    for (let iteration = 0; iteration < pageList.length; iteration++) {
                        if (pageList[iteration]._AllowToPublishNewPost == "true") {
                            this.fbPages = true;
                            this.facebookPageList.push({ key: pageList[iteration]._PageId, value: pageList[iteration]._SourceName });
                        }
                    }
                    if (!GlobalFunctions.isEmpty(this.facebookPageList)) {
                        if (this.facebookPageList.length > 1) {
                            this.fbPages = true;
                            this.facebookPageList.unshift({ key: 'all', value: this.translateService.instant("LBL_ALL_FACEBOOK_PAGES") });
                        }
                        else {
                            this.fbPages = true;
                            this.selectedFacebookPage = this.facebookPageList[0].key;
                        }
                    }
                }
            }
            if (!GlobalFunctions.isEmpty(twitterPagesStr)) {
                let x2js = new X2JS();
                let twitterPages = x2js.xml2js(twitterPagesStr);
                if (!GlobalFunctions.isEmpty(twitterPages) && !GlobalFunctions.isEmpty(twitterPages.TwitterAccounts.TwitterAccount)) {
                    let pageList = GlobalFunctions.ConvertToArrayIfOnlySingleObject(twitterPages.TwitterAccounts.TwitterAccount);
                    for (let iteration = 0; iteration < pageList.length; iteration++) {
                        if (pageList[iteration]._AllowToPublishNewPost == "true") {
                            this.twitPages = true;
                            this.twitterPageList.push({ key: pageList[iteration]._Id, value: pageList[iteration]._SourceName });
                        }
                    }
                    if (!GlobalFunctions.isEmpty(this.twitterPageList)) {
                        this.twitPages = true;
                        if (this.twitterPageList.length > 1)
                            this.twitterPageList.unshift({ key: 'all', value: this.translateService.instant("LBL_ALL_TWITTER_PAGES") });
                        else {
                            this.twitPages = true;
                            this.selectedTwitterPage = this.twitterPageList[0].key;
                        }
                    }
                }
            }
        }
        catch (e) {
            ExceptionHelper.showException(null, null, false, e.message, "");
        }
        this.timeoutIds.push(setTimeout(() => this.resize(), 300));
    }
    ngOnDestroy() {
        this.shortcutManager.unbind('LBL_SHORTCUT_SAVE_BUTTON');
        this.subs.unsubscribe();
        this.timeoutIds.forEach(timeoutId => clearTimeout(timeoutId));
    }
    createSocialMedia() {
        if (GlobalFunctions.isEmpty(this.mediaType))
            this.errorMessage = this.translateService.instant("LBL_MESSAGE_FAIL_CREATE_SOCIAL_MEDIA_CHANNEL_SELECTION");
        if (this.form.invalid)
            return;
        this.startSpinner();
        let req = new CreateSocialMediaMessageRequest();
        req.Mode = this.editMode ? RecordOperationMode.Edit : RecordOperationMode.New;
        req.SocialMediaType = this.mediaType;
        req.SocialMediaMessageDto = this.socialmediaDto;
        req.FacebookPage = this.selectedFacebookPage;
        req.TwitterPage = this.selectedTwitterPage;
        req.SocialMediaMessageDto.DateTime = new this.DateJS().toString(this.sessionManager.defaultOptions.mdyyyyhhmmss);
        this.socialMediaService.createSocialMedia(req, this.addSocialMediaResponse, this.addSocialMediaErrorCallback);
    }
    facebookCheckState(event) {
        this.facebookChecked = event.checked;
        this.assignMediaType();
    }
    twitterCheckState(event) {
        this.twitterChecked = event.checked;
        this.assignMediaType();
    }
    assignMediaType() {
        this.resize();
        if (this.facebookChecked && this.twitterChecked)
            this.mediaType = '0';
        else if (this.facebookChecked)
            this.mediaType = '3';
        else if (this.twitterChecked)
            this.mediaType = '2';
        else
            this.mediaType = '';
    }
    assignTwitterPage(twitterPage) {
        if (!GlobalFunctions.isEmpty(twitterPage))
            this.selectedTwitterPage = twitterPage;
    }
    assignFacebookPage(fbPage) {
        if (!GlobalFunctions.isEmpty(fbPage))
            this.selectedFacebookPage = fbPage;
    }
    addSocialMediaResponse(response) {
        this.stopSpinner();
        if (response?.Result == 0 && response?.SocialMediaMessageDto)
            this.close(false);
        else {
            let messageInfo = DialogHelper.getMessage(this.translateService.instant('LBL_SOCIAL_MEDIA'), this.translateService.instant('LBL_MESSAGE_FAIL_SAVE_SOCIAL_MEDIA'), false, null, null, null, null, this.translateService);
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), messageInfo);
        }
    }
    addSocialMediaErrorCallback() {
        let helpMessage = GlobalFunctions.formatStringValue(this.translateService.instant('LBL_ADD_ERROR_MSG'), [this.translateService.instant('LBL_SOCIAL_MEDIA')]);
        let exception = ExceptionHelper.create(this.translateService.instant('LBL_ERROR_MSG'), helpMessage, this.translateService.instant('LBL_SOCIAL_MEDIA'));
        ExceptionHelper.showException(this.dialog, exception, true);
    }
    fileRemoved(tag) {
        this.files = [];
        this.socialmediaDto.MediaList = [];
    }
    onUpload(upload) {
        this.startSpinner();
        this.files = [];
        this.socialmediaDto.MediaList = [];
        let file = new Object();
        file.text = upload.name;
        file.NameOnServer = "";
        this.files.push(file);
        this.errorMessage = '';
    }
    onError(response) {
        this.socialmediaDto.MediaList = [];
        this.files.splice(this.files.length - 1, 1);
        this.errorMessage = GlobalFunctions.getFileUploadErrorText(response, this.translateService);
        this.stopSpinner();
    }
    onSuccess(response) {
        this.socialmediaDto.MediaType = MessageMediaType.Image;
        this.socialmediaDto.MediaList.push(response[0].fileName);
        this.errorMessage = '';
        this.stopSpinner();
    }
    resize() {
        let windowHeight = $(window).height();
        $("#jkcParentPanel").css({ 'max-height': (windowHeight - parseInt(this.sessionManager.jkcParentPanel?.parameters?.TopSpace) - 100 + "px") });
        let newHeight = $("#jkcParentPanel").height() - $("#addSocialMediaHeader").height() - $("#addSocialMediaFooter").height() + "px";
        $("#addSocialMediaContainer").height(newHeight);
        $('#' + this.sessionManager.jkcParentPanel.parameters.HeaderId).css({ 'width': ($("#jkcParentPanel").width()) });
        $('#' + this.sessionManager.jkcParentPanel.parameters.FooterId).css({ 'width': ($("#jkcParentPanel").width()) });
    }
    handleEscKey() {
        if (!GlobalFunctions.isEmpty(this.sessionManager.jkcParentPanel) && this.sessionManager.jkcParentPanel.parameters.IsPanelExpanded)
            this.close(false);
    }
    close(result) {
        this.dialogManager.removeComponent();
        this.sessionManager.closeJkcParentPanel();
    }
};
__decorate([
    ViewChild('form')
], AddSocialMediaMessageComponent.prototype, "form", void 0);
AddSocialMediaMessageComponent = __decorate([
    Component({
        selector: 'add-social-media-message',
        templateUrl: './add-social-media-message.component.html',
        styleUrls: ['./add-social-media-message.component.scss'],
        host: { '(window:resize)': 'resize()' }
    })
], AddSocialMediaMessageComponent);
export { AddSocialMediaMessageComponent };
//# sourceMappingURL=add-social-media-message.component.js.map