var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { ContextMenuView } from 'src/app/core/enums/common-enums';
import { ContextMenu } from 'src/app/core/models/common/context-menu';
import { Menu, SubMenuItem } from 'src/app/core/models/common/menu';
import { GlobalFunctions } from 'src/app/shared/global-functions';
import { BroadCastEventKeys, RoutePath } from '../../../../shared/constants';
import { ExceptionHelper } from '../../../../shared/helper/exception-helper';
import { BaseDetailComponent } from '../../../common/base-detail.component';
let QuestionAnswerDetailComponent = class QuestionAnswerDetailComponent extends BaseDetailComponent {
    constructor(cacheManager, sessionManager, dialog, contextMenuService, questionanswerService, searchService, eventProvider, integrationSettingManager, phoneManager, dialogManager, translateService, router) {
        super(phoneManager, dialogManager, translateService);
        this.cacheManager = cacheManager;
        this.sessionManager = sessionManager;
        this.dialog = dialog;
        this.contextMenuService = contextMenuService;
        this.questionanswerService = questionanswerService;
        this.searchService = searchService;
        this.eventProvider = eventProvider;
        this.integrationSettingManager = integrationSettingManager;
        this.phoneManager = phoneManager;
        this.dialogManager = dialogManager;
        this.translateService = translateService;
        this.router = router;
        this.subMenuItem = new SubMenuItem();
        this.fetchQuestionAnswerDetailResponse = this.fetchQuestionAnswerDetailResponse.bind(this);
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.RELOAD_ENTITY_DETAIL).subscribe(() => {
            this.menu = new Menu();
            this.subMenuItem = new SubMenuItem();
            this.ngOnInit();
        });
    }
    ngOnInit() {
        const detailEntityType = GlobalFunctions.getObjectTypeName(this.sessionManager.selectedEntity?.RelatedEntityFqdn);
        const oldContentType = GlobalFunctions.toContentType(detailEntityType);
        this.sessionManager.contextMenu = new ContextMenu(oldContentType, detailEntityType, this.translateService, this.sessionManager.selectedEntity, GlobalFunctions.getLoggedInUserId(), ContextMenuView.Detail, this.sessionManager.customContextMenuItems, this.sessionManager, this.integrationSettingManager);
        this.contextMenuService.loadActionButton(detailEntityType);
        this.loadQuestionAnswerDetail();
    }
    ngOnDestroy() {
        this.sessionManager.showDetailSearch = false;
        this.subs.unsubscribe();
    }
    loadQuestionAnswerDetail() {
        try {
            this.sessionManager.showDetailSearch = true;
            this.sessionManager.detailSearchQuery = "";
            this.menu.addOrUpdateMenuItem(0, "QuestionAnswerDetail", this.translateService.instant("LBL_QUESTIONANSWER"), false, true, true, true, false, this.subMenuItem);
            this.addMenuItem.emit(this.menu);
            if (!GlobalFunctions.isEmpty(this.sessionManager.selectedEntity) && this.sessionManager.selectedEntity.Partial == true) {
                let partialDto = new Object();
                partialDto.Id = this.sessionManager.selectedEntity.Id;
                partialDto.ObjectSource = this.sessionManager.selectedEntity.ObjectSource;
                partialDto.Query = this.searchService.selectedSearchOption ? this.searchService.selectedSearchOption.searchQuery : "";
                this.questionanswerService.fetchDetail(partialDto, this.fetchQuestionAnswerDetailResponse);
                this.startSpinner();
            }
            else {
                this.processFirstDescriptionElement();
                this.sendRelatedRequest.emit();
            }
        }
        catch (e) {
            ExceptionHelper.showException(null, null, false, e.message, "");
        }
    }
    fetchQuestionAnswerDetailResponse(result) {
        this.stopSpinner();
        this.sessionManager.loadedFromRelatedView = false;
        if (result != null) {
            this.sessionManager.setBreadcrumbGrammer(result);
            this.sessionManager.selectedEntity = result;
            this.processFirstDescriptionElement();
            this.sendRelatedRequest.emit();
            this.eventProvider.BroadcastEvent(BroadCastEventKeys.LOAD_SELECTED_ENTITY_IN_DETAIL, this.sessionManager.selectedEntity);
        }
        else {
            let exception = ExceptionHelper.create(this.translateService.instant("LBL_FAQ_NOT_FOUND"), this.translateService.instant("LBL_FAQ_NOT_FOUND_MESSAGE"), this.translateService.instant("LBL_FAQ"));
            ExceptionHelper.showException(this.dialog, exception, true).afterClosed().subscribe(() => this.router.navigate([RoutePath.DASHBOARD]));
        }
    }
    processFirstDescriptionElement() {
        this.addSubMenuItems(this.sessionManager.selectedEntity);
        if (this.sessionManager.selectedEntity != null && this.sessionManager.selectedEntity.ChannelQuestionAnswers[0] != null && this.sessionManager.selectedEntity.ChannelQuestionAnswers[0].Answers != null && this.sessionManager.selectedEntity.ChannelQuestionAnswers[0].Answers.length > 0)
            this.sessionManager.selectedEntity.ChannelQuestionAnswers[0].Answers[0].Title = "";
        this.eventProvider.BroadcastEvent(BroadCastEventKeys.LOAD_SELECTED_ENTITY_IN_DETAIL, this.sessionManager.selectedEntity);
    }
    addSubMenuItems(questionAnswerDto) {
        if (questionAnswerDto != null) {
            if (questionAnswerDto.ChannelQuestionAnswers[0] != null && questionAnswerDto.ChannelQuestionAnswers[0].Answers != null && questionAnswerDto.ChannelQuestionAnswers[0].Answers.length > 0) {
                for (let index = 0; index < questionAnswerDto.ChannelQuestionAnswers[0].Answers.length; index++) {
                    if (questionAnswerDto.ChannelQuestionAnswers[0].Answers[index].Title != "" && questionAnswerDto.ChannelQuestionAnswers[0].Answers[index].Title != undefined)
                        this.subMenuItem.addMenuItem(questionAnswerDto.ChannelQuestionAnswers[0].Answers[index].Title, index.toString());
                }
            }
        }
    }
};
QuestionAnswerDetailComponent = __decorate([
    Component({
        selector: 'question-answer-detail',
        templateUrl: './question-answer-detail.component.html',
        styleUrls: ['./question-answer-detail.component.scss']
    })
], QuestionAnswerDetailComponent);
export { QuestionAnswerDetailComponent };
;
//# sourceMappingURL=question-answer-detail.component.js.map