var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { AlternateSearchType } from 'src/app/core/enums/common-enums';
import { BroadCastEventKeys, EntityName } from '../../../../shared/constants';
import { BaseSearchResultComponent } from '../../../common/base-search-result.component';
let ProductSearchResultComponent = class ProductSearchResultComponent extends BaseSearchResultComponent {
    constructor(activatedRoute, router, translateService, productService, sessionManager, searchService, sortManager, changeDetectorRef, eventProvider, applicationSettingManager, employeeService, formatManager, cacheManager, integrationSettingManager, datePipe, localSearchResultDataService) {
        super(translateService, changeDetectorRef, sessionManager, router, activatedRoute, eventProvider, sortManager, applicationSettingManager, employeeService, formatManager, cacheManager, integrationSettingManager, datePipe, searchService);
        this.activatedRoute = activatedRoute;
        this.router = router;
        this.translateService = translateService;
        this.productService = productService;
        this.sessionManager = sessionManager;
        this.searchService = searchService;
        this.sortManager = sortManager;
        this.changeDetectorRef = changeDetectorRef;
        this.eventProvider = eventProvider;
        this.applicationSettingManager = applicationSettingManager;
        this.employeeService = employeeService;
        this.formatManager = formatManager;
        this.cacheManager = cacheManager;
        this.integrationSettingManager = integrationSettingManager;
        this.datePipe = datePipe;
        this.localSearchResultDataService = localSearchResultDataService;
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.UPDATE_SEARCH_RESULTS).subscribe(searchStatusQuery => {
            this.searchStatusQuery = searchStatusQuery;
            this.ngOnInit();
        });
    }
    ;
    ngOnInit() {
        this.type = EntityName.PRODUCT;
        if (this.localSearchResultDataService.localSearchResultData.localResult?.length > 0 && (this.localSearchResultDataService.localSearchResultData.contentType.toLowerCase() == this.type.toLowerCase() || this.localSearchResultDataService.localSearchResultData.contentType.toLowerCase() == "advanced")) {
            this.sourceCount = 0;
            this.searchStatusQuery = this.localSearchResultDataService.localSearchResultData.localResult[0].searchStatusQuery;
            this.searchResultFound(this.localSearchResultDataService.localSearchResultData.localResult);
            this.localSearchResultDataService.localSearchResultData.localResult = [];
            this.localSearchResultDataService.localSearchResultData.contentType = "";
        }
        else {
            this.resultCount = 0;
            this.alternateSearchSources = [];
            this.resultList = [];
            this.filteredSearchResult = [];
            this.searchStatusMessage = '';
            this.searchProduct();
        }
    }
    ngOnDestroy() {
        super.ngOnDestroy();
    }
    searchProduct() {
        this.updateSearchStatus(this.activeHandlersObj);
        this.productService.search(this.searchStatusQuery, false, AlternateSearchType.None, this.searchService.selectedSearchOption?.sourceLocation, "", this.searchResultFound, this.updateSearchStatus, this.alternateSearchResponseReceived, this.alternateSearchSuggestionsResponseReceived);
    }
    alternateSearch(item) {
        this.resultList = [];
        this.filteredSearchResult = [];
        this.alternateSearchSources = [];
        this.alternateSearchSuggestions = [];
        this.productService.search(this.searchStatusQuery, false, AlternateSearchType.AlternateHandlerSearch, "", item.Handler, this.searchResultFound, this.updateSearchStatus, this.alternateSearchResponseReceived, this.alternateSearchSuggestionsResponseReceived);
    }
    alternateSearchSuggestion(item) {
        this.resultList = [];
        this.filteredSearchResult = [];
        this.alternateSearchSources = [];
        this.alternateSearchSuggestions = [];
        this.searchStatusQuery = item;
        this.productService.search(item, false, AlternateSearchType.None, "", "", this.searchResultFound, this.updateSearchStatus, this.alternateSearchResponseReceived, this.alternateSearchSuggestionsResponseReceived);
        this.sendResultCount.emit(this.resultCount);
    }
    fetchSourceCaption(person) {
        this.sessionManager.fetchSourceCaption(person.additionalObjectSource, null);
    }
};
ProductSearchResultComponent = __decorate([
    Component({
        selector: 'product-search-result',
        templateUrl: './product-search-result.component.html',
        styleUrls: ['./product-search-result.component.scss']
    })
], ProductSearchResultComponent);
export { ProductSearchResultComponent };
//# sourceMappingURL=product-search-result.component.js.map