var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { ContextMenuView } from 'src/app/core/enums/common-enums';
import { ContextMenu } from 'src/app/core/models/common/context-menu';
import { Menu, SubMenuItem } from 'src/app/core/models/common/menu';
import { GlobalFunctions } from 'src/app/shared/global-functions';
import { BroadCastEventKeys, RoutePath } from '../../../../shared/constants';
import { ExceptionHelper } from '../../../../shared/helper/exception-helper';
import { BaseDetailComponent } from '../../../common/base-detail.component';
let ProductDetailComponent = class ProductDetailComponent extends BaseDetailComponent {
    constructor(router, zone, cacheManager, sessionManager, dialog, contextMenuService, productService, searchService, eventProvider, integrationSettingManager, phoneManager, dialogManager, translateService) {
        super(phoneManager, dialogManager, translateService);
        this.router = router;
        this.zone = zone;
        this.cacheManager = cacheManager;
        this.sessionManager = sessionManager;
        this.dialog = dialog;
        this.contextMenuService = contextMenuService;
        this.productService = productService;
        this.searchService = searchService;
        this.eventProvider = eventProvider;
        this.integrationSettingManager = integrationSettingManager;
        this.phoneManager = phoneManager;
        this.dialogManager = dialogManager;
        this.translateService = translateService;
        this.subMenuItem = new SubMenuItem();
        this.fetchProductDetailResponse = this.fetchProductDetailResponse.bind(this);
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.RELOAD_ENTITY_DETAIL).subscribe(() => {
            this.menu = new Menu();
            this.subMenuItem = new SubMenuItem();
            this.ngOnInit();
        });
    }
    ngOnInit() {
        const detailEntityType = GlobalFunctions.getObjectTypeName(this.sessionManager.selectedEntity?.RelatedEntityFqdn);
        const oldContentType = GlobalFunctions.toContentType(detailEntityType);
        this.sessionManager.contextMenu = new ContextMenu(oldContentType, detailEntityType, this.translateService, this.sessionManager.selectedEntity, GlobalFunctions.getLoggedInUserId(), ContextMenuView.Detail, this.sessionManager.customContextMenuItems, this.sessionManager, this.integrationSettingManager);
        this.contextMenuService.loadActionButton(detailEntityType);
        this.loadProductDetail();
    }
    ;
    ngOnDestroy() {
        this.sessionManager.showDetailSearch = false;
        this.subs.unsubscribe();
    }
    loadProductDetail() {
        try {
            this.sessionManager.showDetailSearch = true;
            this.sessionManager.detailSearchQuery = "";
            this.menu.addOrUpdateMenuItem(0, "ProductDetail", this.translateService.instant("LBL_PRODUCT"), false, true, true, true, false, this.subMenuItem);
            this.addMenuItem.emit(this.menu);
            if (!GlobalFunctions.isEmpty(this.sessionManager.selectedEntity) && this.sessionManager.selectedEntity.Partial == true) {
                let partialDto = new Object();
                partialDto.Id = this.sessionManager.selectedEntity.Id;
                partialDto.ObjectSource = this.sessionManager.selectedEntity.ObjectSource;
                partialDto.Query = this.searchService.selectedSearchOption ? this.searchService.selectedSearchOption.searchQuery : "";
                partialDto.Name = !GlobalFunctions.isEmpty(this.sessionManager.selectedEntity.Name) ? this.sessionManager.selectedEntity.Name : this.sessionManager.selectedEntity.StringRepresentation;
                partialDto.SourceApplicationDeeplink = this.sessionManager.selectedEntity.SourceApplicationDeeplink;
                this.productService.fetchDetail(partialDto, this.fetchProductDetailResponse);
                this.startSpinner();
            }
            else {
                this.processFirstDescriptionElement();
                this.sendRelatedRequest.emit();
            }
        }
        catch (e) {
            ExceptionHelper.showException(null, null, false, e.message, "");
        }
    }
    ;
    fetchProductDetailResponse(result) {
        this.stopSpinner();
        this.sessionManager.loadedFromRelatedView = false;
        if (result != null) {
            this.sessionManager.setBreadcrumbGrammer(result);
            this.sessionManager.selectedEntity = result;
            this.processFirstDescriptionElement();
            this.sendRelatedRequest.emit();
            this.eventProvider.BroadcastEvent(BroadCastEventKeys.LOAD_SELECTED_ENTITY_IN_DETAIL, this.sessionManager.selectedEntity);
        }
        else {
            let exception = ExceptionHelper.create(this.translateService.instant("LBL_PRODUCT_NOT_FOUND"), this.translateService.instant("LBL_PRODUCT_NOT_FOUND_MESSAGE"), this.translateService.instant("LBL_PRODUCT"));
            ExceptionHelper.showException(this.dialog, exception, true).afterClosed().subscribe(() => this.router.navigate([RoutePath.DASHBOARD]));
        }
    }
    ;
    processFirstDescriptionElement() {
        this.addSubMenuItems(this.sessionManager.selectedEntity);
        if (this.sessionManager.selectedEntity != null && this.sessionManager.selectedEntity.Descriptions != null && this.sessionManager.selectedEntity.Descriptions.length > 0)
            this.sessionManager.selectedEntity.Descriptions[0].Title = "";
        this.eventProvider.BroadcastEvent(BroadCastEventKeys.LOAD_SELECTED_ENTITY_IN_DETAIL, this.sessionManager.selectedEntity);
    }
    ;
    addSubMenuItems(productDto) {
        if (productDto != null) {
            if (productDto.Descriptions != null && productDto.Descriptions.length > 0) {
                for (let index = 0; index < productDto.Descriptions.length; index++) {
                    if (productDto.Descriptions[index].Title != "" && productDto.Descriptions[index].Title != undefined)
                        this.subMenuItem.addMenuItem(productDto.Descriptions[index].Title, index.toString());
                }
            }
        }
    }
    ;
    loadRoute(relatedObject) {
        relatedObject.Name = relatedObject.StringRepresentation;
        relatedObject.RelatedEntityFqdn = "Decos_Kcs_Products_Entities_Product";
        this.sessionManager.setBreadcrumbGrammer(relatedObject);
        this.sessionManager.addBreadcrumbItems([relatedObject], null, RoutePath.DETAIL_PATH);
        this.sessionManager.selectedEntity = relatedObject;
        this.zone.run(() => this.router.navigate([RoutePath.DETAIL_PATH, "product"]));
    }
    ;
};
ProductDetailComponent = __decorate([
    Component({
        selector: 'product-detail',
        templateUrl: './product-detail.component.html',
        styleUrls: ['./product-detail.component.scss']
    })
], ProductDetailComponent);
export { ProductDetailComponent };
;
//# sourceMappingURL=product-detail.component.js.map