var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { BaseDialogComponent } from 'src/app/components/common/base-dialog.component';
import { CallStatus, PhoneStatus } from 'src/app/core/enums/phone-enum';
import { PhoneExtensionDto } from 'src/app/core/models/phone/phone-extensionDto';
import { GlobalFunctions } from 'src/app/shared/global-functions';
import { EntityFqdn } from '../../../../core/enums/core-enums';
import { LocalStorageKey } from '../../../../shared/constants';
let RegisterPhoneComponent = class RegisterPhoneComponent extends BaseDialogComponent {
    constructor(translateService, phoneManager, phoneService, integrationSettingManager) {
        super();
        this.translateService = translateService;
        this.phoneManager = phoneManager;
        this.phoneService = phoneService;
        this.integrationSettingManager = integrationSettingManager;
        this.registeredExtension = this.translateService.instant("LBL_OFFLINE") != null ? this.translateService.instant("LBL_OFFLINE").toUpperCase() : "Offline";
        this.extensionNumber = "";
        this.placeholder = "";
        this.IsWrongInfo = false;
        this.phoneUsername = "";
        this.phoneUserPassword = "";
        this.loginType = "extension";
        this.deviceType = 0; //get default setting from handler integration
        this.deviceValue = "";
        this.registerResponse = this.registerResponse.bind(this);
    }
    ngOnInit() {
        this.extensionNumber = this.phoneManager.getPhoneRegisterValue();
        this.placeholder = this.phoneManager.getPhoneRegisterPlaceholder();
        if (this.phoneManager.phoneState.IsPhoneBasicFeatureEnabled)
            this.loginType = "custom";
        else if (this.phoneManager.phoneState.IsCiscoPhoneEnabled)
            this.loginType = "credential";
        else if (this.phoneManager.phoneState.IsUnexusPhoneEnabled) {
            this.loginType = "device";
            let deviceType = this.integrationSettingManager.getIntegrationSetting(EntityFqdn.Decos_Kcs_Phone_Entities_Phone, "DEFAULTLOGINTYPE");
            if (!GlobalFunctions.isEmpty(deviceType))
                this.deviceType = parseInt(deviceType);
        }
    }
    register() {
        this.IsWrongInfo = false;
        this.phoneLoginInfo = "";
        if (this.extensionNumber != null && this.extensionNumber.length > 0) {
            if (this.phoneManager.phoneState.IsCiscoPhoneEnabled && (GlobalFunctions.isEmpty(this.phoneUsername) || GlobalFunctions.isEmpty(this.phoneUserPassword)))
                return;
            if (this.phoneManager.phoneState.IsUnexusPhoneEnabled && (this.deviceType == 2 && GlobalFunctions.isEmpty(this.deviceValue)))
                return;
            this.phoneService.setRegisterPeerResponseCallback(this.registerResponse);
            this.startSpinner();
            let extension = new PhoneExtensionDto();
            extension.Id = this.extensionNumber;
            extension.LoginName = this.phoneUsername;
            extension.LoginPassword = this.phoneUserPassword;
            extension.DeviceType = this.deviceType;
            extension.DeviceValue = this.deviceValue;
            this.phoneService.registerPeerRequest(extension);
        }
    }
    registerResponse(message) {
        this.phoneService.setRegisterPeerResponseCallback(null);
        this.stopSpinner();
        console.log("Received register extension response: {0}", message);
        if (message?.Success == true) {
            $("#mainPhoneContainer").hide();
            this.registeredExtension = this.extensionNumber;
            this.phoneManager.phoneState.RegisteredExtension = this.extensionNumber;
            this.extensionNumber = "";
            this.phoneManager.phoneState.CurrentState = CallStatus.Inactive;
            this.phoneManager.phoneState.PhoneAvailableStatus = PhoneStatus.Available;
            this.phoneManager.phoneState.SelectedPhoneStatus = this.phoneManager.phoneState.GetPhoneStatus(PhoneStatus.Available, null);
            this.phoneManager.phoneState.CurrentState;
            this.registeredExtension = this.translateService.instant("LBL_OFFLINE").toUpperCase();
            GlobalFunctions.setCookie(LocalStorageKey.REGISTERED_EXTENSION, this.phoneManager.phoneState.RegisteredExtension);
            this.phoneManager.changeAvailabilityStatus();
            this.phoneManager.phoneState.EnabledPhoneFeatures.init(message.NotSupportedFeatures);
        }
        else {
            this.IsWrongInfo = true;
            this.phoneUsername = "";
            this.phoneUserPassword = "";
            this.phoneLoginInfo = this.phoneManager.phoneState.IsCiscoPhoneEnabled ? this.translateService.instant("LBL_INVALID_LOGIN_CREDENTIALS_ERROR") : this.translateService.instant("LBL_INVALID_EXTENSION");
        }
    }
};
RegisterPhoneComponent = __decorate([
    Component({
        selector: 'register-phone',
        templateUrl: './register-phone.component.html',
        styleUrls: ['./register-phone.component.scss']
    })
], RegisterPhoneComponent);
export { RegisterPhoneComponent };
//# sourceMappingURL=register-phone.component.js.map