var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, HostListener } from '@angular/core';
import { BaseDialogComponent } from 'src/app/components/common/base-dialog.component';
import { CallStatus, PhoneStatus } from 'src/app/core/enums/phone-enum';
import { PhoneStatusInfo } from 'src/app/core/models/phone/phone-status-info';
import { PhoneStatusDto } from 'src/app/core/models/phone/phone-statusDto';
import { GlobalFunctions } from 'src/app/shared/global-functions';
import { ExceptionHelper } from 'src/app/shared/helper/exception-helper';
import { LocalStorageKey } from '../../../../shared/constants';
let DialPhoneComponent = class DialPhoneComponent extends BaseDialogComponent {
    constructor(phoneManager, applicationFeatureManager, cacheManager, phoneService, employeeService, translateService, dialog, employeeFilterPipe) {
        super();
        this.phoneManager = phoneManager;
        this.applicationFeatureManager = applicationFeatureManager;
        this.cacheManager = cacheManager;
        this.phoneService = phoneService;
        this.employeeService = employeeService;
        this.translateService = translateService;
        this.dialog = dialog;
        this.employeeFilterPipe = employeeFilterPipe;
        this.phoneState = this.phoneManager.phoneState;
        this.filteredEmployees = [];
        this.filteredIndex = 0;
        this.isPhoneStatusEnabled = this.applicationFeatureManager.isPhoneStatusEnabled;
        this.popularEmployeeList = this.cacheManager.getPopularEmployeeList();
        this.lazyLoadingChunk = 5;
        this.lazyLoadingLimitTo = this.lazyLoadingChunk;
        this.employeeSearchVisible = false;
        this.updateStatus = this.updateStatus.bind(this);
        this.unregisterPeerResponse = this.unregisterPeerResponse.bind(this);
        this.setEmployeeAvailabilityCompleted = this.setEmployeeAvailabilityCompleted.bind(this);
    }
    ngOnInit() {
        $("#employeeSearchDiv").hide();
        this.phoneService.setUnregisterPeerResponseCallback(this.unregisterPeerResponse);
    }
    unregister() {
        $("#mainPhoneContainer").hide();
        this.phoneManager.unregisterExtension();
    }
    unregisterPeerResponse(message) {
        console.log("Received unregister extension response: {0}", message);
        if (message != null && message.Success == true) {
            this.phoneManager.showHidePhoneStatus(false);
            this.phoneManager.phoneState.CurrentState = CallStatus.Unregistered;
            this.phoneManager.phoneState.PhoneAvailableStatus = PhoneStatus.Available;
            this.phoneManager.phoneState.RegisteredExtension = "";
            GlobalFunctions.removeCookie(LocalStorageKey.REGISTERED_EXTENSION);
            this.phoneManager.phoneState.SelectedPhoneStatus = null;
            this.phoneManager.changeAvailabilityStatus();
            if (message.LogoutBySystem == true) {
                let exception = ExceptionHelper.create(this.translateService.instant("LBL_CONNECTION_BROKEN"), this.translateService.instant("LBL_PHONE_SHUTDOWN_MESSAGE"), this.translateService.instant("LBL_PHONE"));
                ExceptionHelper.showException(this.dialog, exception, true);
            }
        }
    }
    popularNumber() {
        this.employeeSearchVisible = true;
        $('#dialExtensionTextField').val('');
        $("#employeeSearchDiv").show();
        $("#dialPadDiv").hide();
        $("#btnPhoneCall").hide();
        $("#popular").hide();
        $("#dialerPad").show();
        this.filteredEmployees = this.cacheManager.getPopularEmployeeList();
    }
    dialerPad() {
        this.employeeSearchVisible = false;
        $("#popular").show();
        $("#dialerPad").hide();
        $("#dialPadDiv").show();
        $("#btnPhoneCall").show();
        $("#employeeSearchDiv").hide();
    }
    dialpadButtonClick(key) {
        if (this.targetNumber == undefined)
            this.targetNumber = "";
        this.targetNumber += key;
    }
    ;
    handleKeyPressEvent(keyCode) {
        switch (keyCode) {
            case 13:
                {
                    this.callButtonClick();
                    break;
                }
        }
    }
    callButtonClick(targetEmployee = null) {
        let regexp = /^[\+\*\d]([-#\d]*)$/;
        if (targetEmployee == null)
            this.targetNumber = $('#dialExtensionTextField').val();
        if (regexp.test(this.targetNumber) && this.targetNumber != '+' && this.targetNumber != '*') {
            $('#phoneMenu').removeClass('open');
            if (targetEmployee != null)
                this.phoneManager.placeCall(this.targetNumber, targetEmployee.StringRepresentation, targetEmployee.PictureData, targetEmployee.Id);
            else
                this.phoneManager.placeCall(this.targetNumber, this.translateService.instant("LBL_NO_PERSON_FOUND"), null);
            this.targetNumber = "";
            $("#dialPadDiv").show();
            $("#btnPhoneCall").show();
            $("#employeeSearchDiv").hide();
        }
    }
    setEmployeeAvailabilityCompleted() {
        this.filteredEmployees;
    }
    searchEmployee(query) {
        if (query == undefined || query == '') {
            $("#dialPadDiv").show();
            $("#btnPhoneCall").show();
            $("#employeeSearchDiv").hide();
            $("#popular").show();
            $("#dialerPad").hide();
        }
        if (query != undefined && query != null && query.length > 1) {
            let employees = this.cacheManager.getEmployeeList(true);
            if (!GlobalFunctions.isEmpty(this.popularEmployeeList) && this.popularEmployeeList.length > 0)
                employees = employees.concat(this.popularEmployeeList);
            if (employees != null && employees.length > 0) {
                if (query.indexOf('+') == 0) // '+' only allowed at start 
                    query = query.substr(1);
                $("#dialPadDiv").hide();
                $("#btnPhoneCall").hide();
                $("#employeeSearchDiv").show();
                this.filteredEmployees = new Array();
                let searchEmployees = this.employeeFilterPipe.transform(employees, query);
                if (searchEmployees.length > 0) {
                    let sortedList = searchEmployees.filter(emp => emp['Surname']);
                    sortedList.sort((a, b) => (b.IsPopular ? 1 : 0) - (a.IsPopular ? 1 : 0));
                    for (let i = 0; i < sortedList.length; i++) {
                        if (sortedList[i] != null && (!GlobalFunctions.isEmpty(sortedList[i].ExtensionNumber) || !GlobalFunctions.isEmpty(sortedList[i].PhoneNumber) || !GlobalFunctions.isEmpty(sortedList[i].MobileNumber))) {
                            this.filteredEmployees.push(sortedList[i]);
                        }
                    }
                    this.filteredIndex = 0;
                    this.fetchAvailabilitySlot();
                    this.GetSelectedEmployeesPhoneStatus();
                }
                if (GlobalFunctions.isNumber(query) && searchEmployees.length == 0) {
                    $("#dialPadDiv").show();
                    $("#btnPhoneCall").show();
                    $("#employeeSearchDiv").hide();
                }
            }
        }
    }
    GetSelectedEmployeesPhoneStatus() {
        if (!this.isPhoneStatusEnabled)
            return;
        let phoneStatusArray = [];
        if (this.filteredEmployees != null && this.filteredEmployees.length > 0) {
            for (let i = 0; i < this.filteredEmployees.length; i++) {
                let phonestatusDto = new PhoneStatusDto();
                phonestatusDto.EmployeeId = this.filteredEmployees[i].Id;
                phonestatusDto.Extension = this.filteredEmployees[i].ExtensionNumber;
                phoneStatusArray.push(phonestatusDto);
                this.filteredEmployees[i].phoneStatusInfo = new PhoneStatusInfo();
                this.filteredEmployees[i].phoneStatusInfo.Tooltip = "";
            }
        }
        this.phoneService.clearPhoneStatusCallbacks();
        this.phoneService.fetchPhoneStatusRequest(phoneStatusArray);
        this.phoneService.setFetchPhoneStatusCallback(this.updateStatus);
    }
    updateStatus(result) {
        if (result != null && result.StatusList != null && result.StatusList.length > 0 && this.filteredEmployees.length == result.StatusList.length) {
            for (let i = 0; i < result.StatusList.length; i++) {
                if (this.filteredEmployees[i].Id == result.StatusList[i].EmployeeId) {
                    this.filteredEmployees[i].phoneStatusInfo = this.phoneService.getPhoneStatusBasedOnResult(result.StatusList[i]);
                }
            }
        }
    }
    fetchAvailabilitySlot() {
        if (this.filteredIndex < this.filteredEmployees.length) {
            let nextSlotSize = this.filteredIndex + 5;
            if (nextSlotSize > this.filteredEmployees.length)
                nextSlotSize = this.filteredEmployees.length;
            let nextSlot = this.filteredEmployees.slice(this.filteredIndex, nextSlotSize);
            this.employeeService.setEmployeeAvailability(nextSlot, this.setEmployeeAvailabilityCompleted);
            this.filteredIndex += 5;
        }
    }
    selectNumber(targetEmployee, val) {
        this.targetNumber = !GlobalFunctions.isEmpty(val) ? val.replace(/ /g, "") : val;
        this.callButtonClick(targetEmployee);
    }
    loadMore() {
        if (this.lazyLoadingLimitTo < this.filteredEmployees.length) {
            let nextList = this.lazyLoadingLimitTo + this.lazyLoadingChunk;
            console.log("nextList " + nextList);
            if (nextList > this.filteredEmployees.length)
                this.lazyLoadingLimitTo = this.filteredEmployees.length;
            else
                this.lazyLoadingLimitTo = nextList;
        }
        else
            this.lazyLoadingLimitTo = this.filteredEmployees.length;
    }
};
__decorate([
    HostListener('window:scroll', ['$event'])
], DialPhoneComponent.prototype, "loadMore", null);
DialPhoneComponent = __decorate([
    Component({
        selector: 'dial-phone',
        templateUrl: './dial-phone.component.html',
        styleUrls: ['./dial-phone.component.scss']
    })
], DialPhoneComponent);
export { DialPhoneComponent };
//# sourceMappingURL=dial-phone.component.js.map