var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, EventEmitter, Output } from '@angular/core';
import { BaseViewerComponent } from 'src/app/components/common/base-viewer.component';
import { OperationType } from 'src/app/core/enums/common-enums';
import { PhoneState } from 'src/app/core/models/common/phone-state';
import { ContentType } from 'src/app/core/models/jkc-object/jkc-object';
import { CallerIdInfoDto } from 'src/app/core/models/phone/phone-caller-id-infoDto';
import { BroadCastEventKeys } from 'src/app/shared/constants';
import { GlobalFunctions } from 'src/app/shared/global-functions';
import { EntityFqdn } from '../../../../core/enums/core-enums';
let PersonViewerComponent = class PersonViewerComponent extends BaseViewerComponent {
    constructor(sessionManager, eventProvider, phoneManager, dialogManager, translateService, applicationSettingManager) {
        super(phoneManager, dialogManager, translateService);
        this.sessionManager = sessionManager;
        this.eventProvider = eventProvider;
        this.phoneManager = phoneManager;
        this.dialogManager = dialogManager;
        this.translateService = translateService;
        this.applicationSettingManager = applicationSettingManager;
        this.isPersonExpired = false;
        this.additionalInformationTab = 'Partner';
        this.showRelatedPartner = false;
        this.showRelatedParents = false;
        this.showRelatedChildren = false;
        this.showHistoricAddress = false;
        this.showTravelDocuments = false;
        this.callerIdInfo = new CallerIdInfoDto();
        this.phoneState = new PhoneState();
        this.onItemSelect = new EventEmitter();
        this.hasRightLocation = false;
    }
    ngOnInit() {
        this.phoneState = this.phoneManager.phoneState;
        this.personPrivateFields = GlobalFunctions.getAllowedDataRights(ContentType.Person, OperationType.PrivateField);
        this.hasRightLocation = GlobalFunctions.hasRight(GlobalFunctions.toContentType("Location"), OperationType.View) && GlobalFunctions.isValidToShowMap(this.personPrivateFields);
        if (this.applicationSettingManager.isPersonStufEnabled())
            this.setParamaters();
    }
    getYesNoText() {
        return (this.selectedViewerEntity?.AdministeredPersonDto?.Secret ? this.translateService.instant('LBL_YES') : this.translateService.instant('LBL_NO'));
    }
    getChildrenAuthorityText() {
        const childrenAuthority = this.selectedViewerEntity.ChildrenAuthority;
        return this.translateService.instant('LBL_CHILDREN_AUTHORITY_' + childrenAuthority.toUpperCase());
    }
    getPersonChildrenAuthorityText(person) {
        return this.translateService.instant('LBL_CHILDREN_AUTHORITY_' + person.ChildrenAuthority.toUpperCase());
    }
    isNullOrEmpty(exp) {
        return GlobalFunctions.isEmpty(exp);
    }
    checkPersonDeceased(dateOfExpiration) {
        return GlobalFunctions.isPersonDeceased(dateOfExpiration);
    }
    select(type, item) {
        this.eventProvider.BroadcastEvent(BroadCastEventKeys.UPDATE_VIEWER_VIEW, { type: type, item: item });
    }
    viewerEntityResponse(viewerDto) {
        this.selectedViewerEntity = viewerDto;
    }
    setParamaters() {
        let personEntityFqdn = GlobalFunctions.toString(EntityFqdn[EntityFqdn.Decos_Kcs_Persons_Entities_Person]);
        this.showRelatedPartner = GlobalFunctions.hasRight(personEntityFqdn, OperationType.ShowPartner);
        this.showRelatedParents = GlobalFunctions.hasRight(personEntityFqdn, OperationType.ShowParent);
        this.showRelatedChildren = GlobalFunctions.hasRight(personEntityFqdn, OperationType.ShowChildren);
        this.showHistoricAddress = GlobalFunctions.hasRight(personEntityFqdn, OperationType.ShowHistoricAddress);
        this.showTravelDocuments = GlobalFunctions.hasRight(personEntityFqdn, OperationType.ShowTravelDocument);
        if (this.showRelatedPartner == true)
            this.additionalInformationTab = 'Partner';
        else if (this.showRelatedParents == true)
            this.additionalInformationTab = 'Parent';
        else if (this.showRelatedChildren == true)
            this.additionalInformationTab = 'Children';
        else if (this.showHistoricAddress == true)
            this.additionalInformationTab = 'HistoricalAddress';
    }
};
__decorate([
    Output()
], PersonViewerComponent.prototype, "onItemSelect", void 0);
PersonViewerComponent = __decorate([
    Component({
        selector: 'person-viewer',
        templateUrl: './person-viewer.component.html',
        styleUrls: ['./person-viewer.component.scss']
    })
], PersonViewerComponent);
export { PersonViewerComponent };
//# sourceMappingURL=person-viewer.component.js.map