var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { BaseSearchResultComponent } from 'src/app/components/common/base-search-result.component';
import { AlternateSearchType, OperationType } from 'src/app/core/enums/common-enums';
import { GlobalFunctions } from 'src/app/shared/global-functions';
import { PersonSearchResultColumnWidth } from '../../../../core/models/common/column-width';
import { ContentType } from '../../../../core/models/jkc-object/jkc-object';
import { BroadCastEventKeys, EntityName } from '../../../../shared/constants';
let PersonSearchResultComponent = class PersonSearchResultComponent extends BaseSearchResultComponent {
    constructor(router, translateService, personService, sessionManager, searchService, applicationSettingManager, sortManager, changeDetectorRef, personPipe, activatedRoute, eventProvider, employeeService, formatManager, cacheManager, integrationSettingManager, datePipe, localSearchResultDataService) {
        super(translateService, changeDetectorRef, sessionManager, router, activatedRoute, eventProvider, sortManager, applicationSettingManager, employeeService, formatManager, cacheManager, integrationSettingManager, datePipe, searchService);
        this.router = router;
        this.translateService = translateService;
        this.personService = personService;
        this.sessionManager = sessionManager;
        this.searchService = searchService;
        this.applicationSettingManager = applicationSettingManager;
        this.sortManager = sortManager;
        this.changeDetectorRef = changeDetectorRef;
        this.personPipe = personPipe;
        this.activatedRoute = activatedRoute;
        this.eventProvider = eventProvider;
        this.employeeService = employeeService;
        this.formatManager = formatManager;
        this.cacheManager = cacheManager;
        this.integrationSettingManager = integrationSettingManager;
        this.datePipe = datePipe;
        this.localSearchResultDataService = localSearchResultDataService;
        this.privateFields = GlobalFunctions.getAllowedDataRights(GlobalFunctions.toContentType(ContentType.Person), OperationType.PrivateField);
        this.personColumnWidth = new PersonSearchResultColumnWidth(this.privateFields);
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.UPDATE_SEARCH_RESULTS).subscribe(searchStatusQuery => {
            this.searchStatusQuery = searchStatusQuery;
            this.ngOnInit();
        });
    }
    ngOnInit() {
        this.type = EntityName.PERSON;
        this.resultList = [];
        this.filteredSearchResult = [];
        this.sessionManager.localSearchFieldList = this.applicationSettingManager.getSearchFieldListByEntity(ContentType.Person);
        if (this.localSearchResultDataService.localSearchResultData.localResult?.length > 0 && (this.localSearchResultDataService.localSearchResultData.contentType.toLowerCase() == this.type.toLowerCase() || this.localSearchResultDataService.localSearchResultData.contentType.toLowerCase() == "advanced")) {
            this.sourceCount = 0;
            this.searchStatusQuery = this.localSearchResultDataService.localSearchResultData.localResult[0].searchStatusQuery;
            this.searchResultFound(this.localSearchResultDataService.localSearchResultData.localResult);
            this.localSearchResultDataService.localSearchResultData.localResult = [];
            this.localSearchResultDataService.localSearchResultData.contentType = "";
        }
        else {
            this.resultCount = 0;
            this.alternateSearchSources = [];
            this.searchStatusMessage = '';
            if (this.searchService.isAdvancedSearch)
                this.advanceSearchPerson();
            else
                this.searchPerson();
        }
    }
    ngOnDestroy() {
        super.ngOnDestroy();
    }
    searchPerson() {
        if (this.searchStatusQuery !== undefined) {
            this.updateSearchStatus(this.activeHandlersObj);
            this.personService.search(this.searchStatusQuery, false, AlternateSearchType.None, this.searchService.selectedSearchOption?.sourceLocation, this.searchService.selectedSearchOption?.handler, this.searchResultFound, this.updateSearchStatus, this.alternateSearchResponseReceived, this.alternateSearchSuggestionsResponseReceived, this.searchPrivateFieldValidationResponseFound);
        }
    }
    advanceSearchPerson() {
        this.updateSearchStatus(this.activeHandlersObj);
        this.personService.advancedSearch(this.searchService.advancedSearchOption.searchDto, AlternateSearchType.None, this.searchService.advancedSearchOption.sourceLocation, "", this.searchResultFound, this.updateSearchStatus, this.alternateSearchResponseReceived, null, null);
        this.searchStatusQuery = this.searchService.advancedSearchQuery;
    }
    checkPersonDeceased(dateOfExpiration) {
        return GlobalFunctions.isPersonDeceased(dateOfExpiration);
    }
    isNoAdressFound(personDto) {
        return (!GlobalFunctions.isEmpty(personDto) && this.personPipe.transform(personDto) === this.translateService.instant("LBL_NO_ADDRESS_FOUND"));
    }
    ;
    fetchSourceCaption(person) {
        this.sessionManager.fetchSourceCaption(person.additionalObjectSource, null);
    }
    alternateSearch(item) {
        this.resultList = [];
        this.filteredSearchResult = [];
        this.alternateSearchSources = [];
        this.alternateSearchSuggestions = [];
        if (this.searchService.isAdvancedSearch)
            this.personService.advancedSearch(this.searchService.advancedSearchOption.searchDto, AlternateSearchType.AlternateHandlerSearch, "", item.Handler, this.searchResultFound, this.updateSearchStatus, this.alternateSearchResponseReceived, null, null);
        else
            this.personService.search(this.searchStatusQuery, false, AlternateSearchType.AlternateHandlerSearch, "", item.Handler, this.searchResultFound, this.updateSearchStatus, this.alternateSearchResponseReceived, null, null);
    }
    alternateSearchSuggestion(item) {
        this.resultList = [];
        this.filteredSearchResult = [];
        this.alternateSearchSources = [];
        this.alternateSearchSuggestions = [];
        this.searchStatusQuery = item;
        this.personService.search(item, false, AlternateSearchType.None, "", "", this.searchResultFound, this.updateSearchStatus, this.alternateSearchResponseReceived, this.alternateSearchSuggestionsResponseReceived, null);
        this.sendResultCount.emit(this.resultCount);
    }
    ;
};
PersonSearchResultComponent = __decorate([
    Component({
        selector: 'person-search-result',
        templateUrl: './person-search-result.component.html',
        styleUrls: ['./person-search-result.component.scss']
    })
], PersonSearchResultComponent);
export { PersonSearchResultComponent };
//# sourceMappingURL=person-search-result.component.js.map