var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { BaseRelatedListComponent } from '../../../../components/common/base-related-list.component';
import { OperationType } from '../../../../core/enums/common-enums';
import { PersonRelatedResultColumnWidth } from '../../../../core/models/common/column-width';
import { ContentType } from '../../../../core/models/jkc-object/jkc-object';
import { GlobalFunctions } from '../../../../shared/global-functions';
let PersonRelatedListComponent = class PersonRelatedListComponent extends BaseRelatedListComponent {
    constructor(personFormatedAddressPipe, activatedRoute, translateService, sessionManager, eventProvider, applicationSettingManager, dialogManager, router, phoneManager) {
        super(translateService, activatedRoute, sessionManager, eventProvider, dialogManager, applicationSettingManager, router, phoneManager);
        this.personFormatedAddressPipe = personFormatedAddressPipe;
        this.activatedRoute = activatedRoute;
        this.translateService = translateService;
        this.sessionManager = sessionManager;
        this.eventProvider = eventProvider;
        this.applicationSettingManager = applicationSettingManager;
        this.dialogManager = dialogManager;
        this.router = router;
        this.phoneManager = phoneManager;
        this.privateFields = GlobalFunctions.getAllowedDataRights(ContentType.Person, OperationType.PrivateField);
        this.personColumnsWidth = new PersonRelatedResultColumnWidth(this.privateFields);
    }
    checkPersonDeceased(dateOfExpiration) {
        return GlobalFunctions.isPersonDeceased(dateOfExpiration);
    }
    isNoAdressFound(personDto) {
        return (!GlobalFunctions.isEmpty(personDto) && this.personFormatedAddressPipe.transform(personDto) === ("LBL_NO_ADDRESS_FOUND"));
    }
    ;
};
PersonRelatedListComponent = __decorate([
    Component({
        selector: 'person-related-list',
        templateUrl: './person-related-list.component.html',
        styleUrls: ['./person-related-list.component.scss']
    })
], PersonRelatedListComponent);
export { PersonRelatedListComponent };
//# sourceMappingURL=person-related-list.component.js.map