var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { BaseDetailComponent } from '../../../../components/common/base-detail.component';
import { ContextMenuView, OperationType, RecordOperationMode } from '../../../../core/enums/common-enums';
import { EntityFqdn } from '../../../../core/enums/core-enums';
import { ContextMenu } from '../../../../core/models/common/context-menu';
import { Menu } from '../../../../core/models/common/menu';
import { ContentType, PersonSearchField } from '../../../../core/models/jkc-object/jkc-object';
import { CreateOrUpdatePersonRequest } from '../../../../core/models/person/create-update-person-request';
import { CallerIdInfoDto } from '../../../../core/models/phone/phone-caller-id-infoDto';
import { PhoneCallerInfoDto } from '../../../../core/models/phone/phone-caller-infoDto';
import { BroadCastEventKeys, RoutePath } from '../../../../shared/constants';
import { GlobalFunctions } from '../../../../shared/global-functions';
import { DateHelper } from '../../../../shared/helper/date-helper';
import { DialogHelper } from '../../../../shared/helper/dialog-helper';
import { MessageboxComponent } from '../../../common/messagebox/messagebox.component';
let PersonDetailComponent = class PersonDetailComponent extends BaseDetailComponent {
    constructor(router, dialog, activatedRoute, sessionManager, contextMenuService, personService, phoneService, applicationSettingManager, eventProvider, integrationSettingManager, phoneManager, dialogManager, translateService) {
        super(phoneManager, dialogManager, translateService);
        this.router = router;
        this.dialog = dialog;
        this.activatedRoute = activatedRoute;
        this.sessionManager = sessionManager;
        this.contextMenuService = contextMenuService;
        this.personService = personService;
        this.phoneService = phoneService;
        this.applicationSettingManager = applicationSettingManager;
        this.eventProvider = eventProvider;
        this.integrationSettingManager = integrationSettingManager;
        this.phoneManager = phoneManager;
        this.dialogManager = dialogManager;
        this.translateService = translateService;
        this.isPersonExpired = false;
        this.additionalInformationTab = 'Partner';
        this.showRelatedPartner = false;
        this.showRelatedParents = false;
        this.showRelatedChildren = false;
        this.showHistoricAddress = false;
        this.showTravelDocuments = false;
        this.callerIdInfo = new CallerIdInfoDto();
        this.personPrivateFields = GlobalFunctions.getAllowedDataRights(ContentType.Person, OperationType.PrivateField);
        this.isPrefetchRequest = false;
        this.changeCallerId = (isMobileNumber) => {
            let callerInfoDto = new PhoneCallerInfoDto();
            if (this.sessionManager.isPersonDeeplinkEnabled && !GlobalFunctions.isEmpty(this.sessionManager.deeplinkPhoneNumber))
                callerInfoDto.PhoneNumber = this.sessionManager.deeplinkPhoneNumber;
            else
                callerInfoDto.PhoneNumber = this.phoneManager.phoneState.CurrentCaller.PhoneNumber;
            callerInfoDto.ObjectId = this.sessionManager.selectedEntity.Id;
            callerInfoDto.ObjectType = GlobalFunctions.toContentType(GlobalFunctions.getObjectTypeName(this.sessionManager.selectedEntity.RelatedEntityFqdn));
            callerInfoDto.ObjectSource = this.sessionManager.selectedEntity.ObjectSource;
            if (this.callerIdInfo.Resolved) {
                this.phoneService.updateCallerIdRequest(callerInfoDto);
                if (isMobileNumber)
                    this.sessionManager.selectedEntity.MobileNumber = callerInfoDto.PhoneNumber;
                else
                    this.sessionManager.selectedEntity.PhoneNumber = callerInfoDto.PhoneNumber;
                this.phoneManager.phoneState.CurrentCaller.Item = this.sessionManager.selectedEntity;
                this.callerIdInfo.ToolTipText = this.translateService.instant("LBL_REMOVE_PHONE_NUMBER") + " {" + callerInfoDto.PhoneNumber + "}";
                this.createPersonRequest(this.sessionManager.selectedEntity);
            }
            else {
                this.phoneService.deleteCallerIdRequest(callerInfoDto);
                if (this.callerIdInfo.OldPhoneNumber == callerInfoDto.PhoneNumber)
                    this.callerIdInfo.OldPhoneNumber = "";
                if (GlobalFunctions.isMobileNumber(callerInfoDto.PhoneNumber))
                    this.sessionManager.selectedEntity.MobileNumber = this.callerIdInfo.OldPhoneNumber;
                else
                    this.sessionManager.selectedEntity.PhoneNumber = this.callerIdInfo.OldPhoneNumber;
                this.callerIdInfo.ToolTipText = this.translateService.instant("LBL_ADD_PHONE_NUMBER") + '{' + callerInfoDto.PhoneNumber + '}';
                this.createPersonRequest(this.sessionManager.selectedEntity);
            }
        };
        this.fetchPersonDetailResponse = this.fetchPersonDetailResponse.bind(this);
        this.prefetchPersonDetailResponse = this.prefetchPersonDetailResponse.bind(this);
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.RELOAD_ENTITY_DETAIL).subscribe(() => {
            this.menu = new Menu();
            this.ngOnInit();
        });
    }
    ngOnInit() {
        const detailEntityType = this.activatedRoute.snapshot.queryParams && !this.sessionManager.selectedEntity ? "Person" : GlobalFunctions.getObjectTypeName(this.sessionManager.selectedEntity?.RelatedEntityFqdn);
        const oldContentType = this.activatedRoute.snapshot.queryParams && !this.sessionManager.selectedEntity ? "Decos.Kcs.Persons.Entities.Person" : GlobalFunctions.toContentType(detailEntityType);
        this.sessionManager.contextMenu = new ContextMenu(oldContentType, detailEntityType, this.translateService, this.sessionManager.selectedEntity, GlobalFunctions.getLoggedInUserId(), ContextMenuView.Detail, this.sessionManager.customContextMenuItems, this.sessionManager, this.integrationSettingManager);
        this.contextMenuService.loadActionButton(detailEntityType);
        this.menu.addOrUpdateMenuItem(0, "PersonDetail", this.translateService.instant("LBL_PERSON"), false, true, true);
        this.addMenuItem.emit(this.menu);
        if (this.activatedRoute.snapshot.queryParams && !this.sessionManager.selectedEntity)
            this.prefetchPersonDetail();
        else if (!GlobalFunctions.isEmpty(this.sessionManager.selectedEntity)) {
            if (this.sessionManager.selectedEntity.Partial)
                this.fetchPersonDetail();
            else
                this.loadPersonDetail();
        }
        else
            this.router.navigate([RoutePath.DASHBOARD]);
    }
    ngOnDestroy() {
        this.subs.unsubscribe();
    }
    prefetchPersonDetail() {
        this.isPrefetchRequest = true;
        GlobalFunctions.removeDeeplinkLocalStorage();
        this.startSpinner();
        if (this.activatedRoute.snapshot.queryParams["email"] != null)
            this.personService.connect().then(() => this.personService.prefetchDetail(PersonSearchField.Email, decodeURIComponent(this.activatedRoute.snapshot.queryParams["email"]), this.prefetchPersonDetailResponse));
        else if (this.activatedRoute.snapshot.queryParams["mobile"] != null) {
            this.sessionManager.deeplinkPhoneNumber = this.toParsePhoneNumber(this.activatedRoute.snapshot.queryParams["mobile"].trim());
            this.personService.connect().then(() => this.personService.prefetchDetail(PersonSearchField.MobileNumber, this.sessionManager.deeplinkPhoneNumber, this.prefetchPersonDetailResponse));
        }
        else
            this.router.navigate([RoutePath.DASHBOARD]);
    }
    prefetchPersonDetailResponse(partialDto) {
        if (partialDto == null) {
            this.setPrefetchInfoToContactSessionNote();
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_PERSON'), textMsg: this.translateService.instant('LBL_NO_PERSON_FOUND') }).afterClosed().subscribe(() => this.router.navigate([RoutePath.DASHBOARD]));
        }
        else
            this.personService.fetchDetail(partialDto, this.fetchPersonDetailResponse);
    }
    fetchPersonDetail() {
        this.startSpinner();
        if (!GlobalFunctions.isEmpty(this.sessionManager.selectedEntity)) {
            let partialDto = new Object();
            partialDto.Id = this.sessionManager.selectedEntity.Id;
            partialDto.ObjectSource = this.sessionManager.selectedEntity.ObjectSource;
            this.personService.fetchDetail(partialDto, this.fetchPersonDetailResponse);
        }
    }
    fetchPersonDetailResponse(result) {
        this.stopSpinner();
        this.sessionManager.loadedFromRelatedView = false;
        if (result == null) {
            this.setPrefetchInfoToContactSessionNote();
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant('LBL_PERSON'), textMsg: this.translateService.instant('LBL_NO_PERSON_FOUND') }).afterClosed().subscribe(() => this.router.navigate([RoutePath.DASHBOARD]));
        }
        else {
            this.sessionManager.setBreadcrumbGrammer(result);
            this.sessionManager.selectedEntity = result;
            this.loadPersonDetail();
        }
    }
    loadPersonDetail() {
        try {
            this.hasRightLocation = GlobalFunctions.hasRight(GlobalFunctions.toContentType("Location"), OperationType.View) && GlobalFunctions.isValidToShowMap(this.personPrivateFields);
            if (this.sessionManager.selectedEntity != null && this.sessionManager.selectedEntity.Details != null && GlobalFunctions.isPersonDeceased(this.sessionManager.selectedEntity.Details.DateOfExpiration))
                this.isPersonExpired = true;
            this.sendRelatedRequest.emit();
            if (this.applicationSettingManager.isPersonStufEnabled())
                this.setParamaters();
            this.eventProvider.BroadcastEvent(BroadCastEventKeys.LOAD_SELECTED_ENTITY_IN_DETAIL, this.sessionManager.selectedEntity);
            this.sessionManager.addItemToSession(this.sessionManager.selectedEntity);
            this.personService.setMaritalStatusText(this.sessionManager.selectedEntity);
            this.updateCallerIdInfo();
            this.sessionManager.selectedEntity.locationUrl = `${RoutePath.DETAIL_PATH}/person`;
            this.sessionManager.addBreadcrumbItems([this.sessionManager.selectedEntity], null, this.router.url);
        }
        catch (e) {
            console.error(e.message);
        }
    }
    setPrefetchInfoToContactSessionNote() {
        if (this.isPrefetchRequest) {
            if (this.activatedRoute.snapshot.queryParams["email"] != null)
                this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactEmail = this.activatedRoute.snapshot.queryParams["email"].trim();
            else if (this.activatedRoute.snapshot.queryParams["mobile"] != null) {
                this.sessionManager.contactSessionNotesState.ContactHistoryDto.ContactPhoneNumber = this.sessionManager.deeplinkPhoneNumber;
            }
        }
    }
    checkPersonDeceased(dateOfExpiration) {
        return GlobalFunctions.isPersonDeceased(dateOfExpiration);
    }
    compareDateWithCurrent(dateOfExpiration) {
        if (!GlobalFunctions.isEmpty(dateOfExpiration))
            return DateHelper.compareDateWithCurrent(dateOfExpiration);
        return false;
    }
    isNullOrEmpty(exp) {
        return GlobalFunctions.isEmpty(exp);
    }
    setParamaters() {
        let personEntityFqdn = GlobalFunctions.toString(EntityFqdn[EntityFqdn.Decos_Kcs_Persons_Entities_Person]);
        this.showRelatedPartner = GlobalFunctions.hasRight(personEntityFqdn, OperationType.ShowPartner);
        this.showRelatedParents = GlobalFunctions.hasRight(personEntityFqdn, OperationType.ShowParent);
        this.showRelatedChildren = GlobalFunctions.hasRight(personEntityFqdn, OperationType.ShowChildren);
        this.showHistoricAddress = GlobalFunctions.hasRight(personEntityFqdn, OperationType.ShowHistoricAddress);
        this.showTravelDocuments = GlobalFunctions.hasRight(personEntityFqdn, OperationType.ShowTravelDocument);
        if (this.showRelatedPartner == true)
            this.additionalInformationTab = 'Partner';
        else if (this.showRelatedParents == true)
            this.additionalInformationTab = 'Parent';
        else if (this.showRelatedChildren == true)
            this.additionalInformationTab = 'Children';
        else if (this.showHistoricAddress == true)
            this.additionalInformationTab = 'HistoricalAddress';
    }
    updateCallerIdInfo() {
        let phoneNumber = "";
        if (this.phoneManager.phoneState.IsPhoneBasicFeatureEnabled && !GlobalFunctions.isEmpty(this.phoneManager.phoneState.CurrentCaller.PhoneNumber))
            phoneNumber = this.phoneManager.phoneState.CurrentCaller.PhoneNumber;
        else if (this.sessionManager.isPersonDeeplinkEnabled && !GlobalFunctions.isEmpty(this.sessionManager.deeplinkPhoneNumber))
            phoneNumber = this.sessionManager.deeplinkPhoneNumber;
        if (!GlobalFunctions.isEmpty(phoneNumber)) {
            if (GlobalFunctions.isMobileNumber(phoneNumber)) {
                this.callerIdInfo.IsMobile = true;
                this.callerIdInfo.OldPhoneNumber = this.toParsePhoneNumber(this.sessionManager.selectedEntity.MobileNumber);
            }
            else {
                this.callerIdInfo.IsPhone = true;
                this.callerIdInfo.OldPhoneNumber = this.toParsePhoneNumber(this.sessionManager.selectedEntity.PhoneNumber);
            }
            if (this.callerIdInfo.OldPhoneNumber == phoneNumber) {
                this.callerIdInfo.Resolved = true;
                this.callerIdInfo.ToolTipText = this.translateService.instant("LBL_REMOVE_PHONE_NUMBER") + " {" + phoneNumber + "}";
            }
            else {
                this.callerIdInfo.Resolved = false;
                this.callerIdInfo.ToolTipText = this.translateService.instant("LBL_ADD_PHONE_NUMBER") + " {" + phoneNumber + "}";
            }
        }
    }
    createPersonRequest(personDto) {
        let personRequest = new CreateOrUpdatePersonRequest();
        personRequest.Mode = RecordOperationMode.Edit;
        personRequest.PersonDto = personDto;
        this.personService.createPersonEntity(personRequest, null, null);
    }
    ;
    getChildrenAuthorityText() {
        const childrenAuthority = this.sessionManager.selectedEntity.ChildrenAuthority;
        return this.translateService.instant('LBL_CHILDREN_AUTHORITY_' + childrenAuthority.toUpperCase());
    }
    getPersonChildrenAuthorityText(person) {
        return this.translateService.instant('LBL_CHILDREN_AUTHORITY_' + person.ChildrenAuthority.toUpperCase());
    }
    select(type, selectedEntity) {
        if (selectedEntity) {
            if (this.sessionManager.isViewerFeatureEnabled && this.sessionManager.hasViewerAccess && this.applicationSettingManager.viewerSetting.loadFromRelatedItem(type))
                this.eventProvider.BroadcastEvent(BroadCastEventKeys.OPEN_VIEWER_PANEL, selectedEntity);
            else
                this.openItemInDetailView(type, selectedEntity);
        }
    }
    ;
    openItemInDetailView(type, item) {
        if (type.toUpperCase() == 'PERSON' && GlobalFunctions.isEmpty(item.Id) && !GlobalFunctions.isEmpty(item.AdministeredPersonDto) && !GlobalFunctions.isEmpty(item.AdministeredPersonDto.ServiceNumber))
            item.Id = item.AdministeredPersonDto.ServiceNumber;
        this.sessionManager.loadedFromRelatedView = true;
        this.sessionManager.selectedEntity = item;
        type = type.toLowerCase();
        item.locationUrl = `/${RoutePath.DETAIL_PATH}/${type}`;
        this.sessionManager.setBreadcrumbGrammer(item);
        this.sessionManager.addBreadcrumbItems([item], null, RoutePath.DETAIL_PATH);
        if (this.router.url === item.locationUrl)
            this.eventProvider.BroadcastEvent(BroadCastEventKeys.RELOAD_ENTITY_DETAIL);
        else
            this.router.navigate([item.locationUrl]);
    }
    ;
    toParsePhoneNumber(phoneNumber) {
        if (!GlobalFunctions.isEmpty(phoneNumber)) {
            phoneNumber = decodeURIComponent(phoneNumber);
            phoneNumber = phoneNumber.replace(/%20/g, '').replace(/%2B/g, '').replace(/ /g, '');
            if (!phoneNumber.startsWith("+31")) // check if phoneNumber is already starts with +31 or not
                phoneNumber = phoneNumber.startsWith("31") ? "+" + phoneNumber : "+31" + phoneNumber;
            return phoneNumber;
        }
    }
};
PersonDetailComponent = __decorate([
    Component({
        selector: 'person-detail',
        templateUrl: './person-detail.component.html',
        styleUrls: ['./person-detail.component.scss']
    })
], PersonDetailComponent);
export { PersonDetailComponent };
//# sourceMappingURL=person-detail.component.js.map