var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { GlobalFunctions } from 'src/app/shared/global-functions';
import { OperationType } from '../../../../core/enums/common-enums';
import { ContentType } from '../../../../core/models/jkc-object/jkc-object';
import { BaseAssociatedListComponent } from '../../../common/base-associated-list.component';
let PersonAssociatedListComponent = class PersonAssociatedListComponent extends BaseAssociatedListComponent {
    constructor(router, sessionManager, eventProvider, translateService, applicationSettingManager, personFormattedAddressPipe) {
        super(router, eventProvider, sessionManager, translateService, applicationSettingManager);
        this.router = router;
        this.sessionManager = sessionManager;
        this.eventProvider = eventProvider;
        this.translateService = translateService;
        this.applicationSettingManager = applicationSettingManager;
        this.personFormattedAddressPipe = personFormattedAddressPipe;
        this.privateFields = GlobalFunctions.getAllowedDataRights(ContentType.Person, OperationType.PrivateField);
    }
    isNoAdressFound(personDto) {
        return (!GlobalFunctions.isEmpty(personDto) && this.personFormattedAddressPipe.transform(personDto) === ("LBL_NO_ADDRESS_FOUND"));
    }
    ;
    checkPersonDeceased(dateOfExpiration) {
        return GlobalFunctions.isPersonDeceased(dateOfExpiration);
    }
};
PersonAssociatedListComponent = __decorate([
    Component({
        selector: 'person-associated-list',
        templateUrl: './person-associated-list.component.html',
        styleUrls: ['./person-associated-list.component.scss']
    })
], PersonAssociatedListComponent);
export { PersonAssociatedListComponent };
//# sourceMappingURL=person-associated-list.component.js.map