var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { BaseSearchResultComponent } from 'src/app/components/common/base-search-result.component';
import { AlternateSearchType, OperationType } from 'src/app/core/enums/common-enums';
import { ContentType } from '../../../../core/models/jkc-object/jkc-object';
import { BroadCastEventKeys, EntityName } from '../../../../shared/constants';
import { GlobalFunctions } from '../../../../shared/global-functions';
let OrganizationSearchResultComponent = class OrganizationSearchResultComponent extends BaseSearchResultComponent {
    constructor(router, translateService, organizationService, sessionManager, searchService, sortManager, changeDetectorRef, activatedRoute, eventProvider, applicationSettingManager, employeeService, formatManager, cacheManager, integrationSettingManager, datePipe, localSearchResultDataService) {
        super(translateService, changeDetectorRef, sessionManager, router, activatedRoute, eventProvider, sortManager, applicationSettingManager, employeeService, formatManager, cacheManager, integrationSettingManager, datePipe, searchService);
        this.router = router;
        this.translateService = translateService;
        this.organizationService = organizationService;
        this.sessionManager = sessionManager;
        this.searchService = searchService;
        this.sortManager = sortManager;
        this.changeDetectorRef = changeDetectorRef;
        this.activatedRoute = activatedRoute;
        this.eventProvider = eventProvider;
        this.applicationSettingManager = applicationSettingManager;
        this.employeeService = employeeService;
        this.formatManager = formatManager;
        this.cacheManager = cacheManager;
        this.integrationSettingManager = integrationSettingManager;
        this.datePipe = datePipe;
        this.localSearchResultDataService = localSearchResultDataService;
        this.privateFields = GlobalFunctions.getAllowedDataRights(ContentType.Organization, OperationType.PrivateField);
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.UPDATE_SEARCH_RESULTS).subscribe(searchStatusQuery => {
            this.searchStatusQuery = searchStatusQuery;
            this.ngOnInit();
        });
    }
    ngOnInit() {
        this.type = EntityName.ORGANIZATION;
        if (this.localSearchResultDataService.localSearchResultData.localResult?.length > 0 && (this.localSearchResultDataService.localSearchResultData.contentType.toLowerCase() == this.type.toLowerCase() || this.localSearchResultDataService.localSearchResultData.contentType.toLowerCase() == "advanced")) {
            this.sourceCount = 0;
            this.searchStatusQuery = this.localSearchResultDataService.localSearchResultData.localResult[0].searchStatusQuery;
            this.searchResultFound(this.localSearchResultDataService.localSearchResultData.localResult);
            this.localSearchResultDataService.localSearchResultData.localResult = [];
            this.localSearchResultDataService.localSearchResultData.contentType = "";
        }
        else {
            this.resultCount = 0;
            this.alternateSearchSources = [];
            this.resultList = [];
            this.filteredSearchResult = [];
            this.searchStatusMessage = '';
            if (this.searchService.isAdvancedSearch)
                this.advanceSearchOrganization();
            else
                this.searchOrganization();
        }
    }
    ngOnDestroy() {
        super.ngOnDestroy();
    }
    searchOrganization() {
        if (this.searchStatusQuery !== undefined) {
            this.updateSearchStatus(this.activeHandlersObj);
            this.organizationService.search(this.searchStatusQuery, false, AlternateSearchType.None, this.searchService.selectedSearchOption?.sourceLocation, this.searchService.selectedSearchOption?.handler, this.searchResultFound, this.updateSearchStatus, this.alternateSearchResponseReceived, this.alternateSearchSuggestionsResponseReceived, this.searchPrivateFieldValidationResponseFound);
        }
    }
    advanceSearchOrganization() {
        this.updateSearchStatus(this.activeHandlersObj);
        this.searchStatusQuery = this.searchService.advancedSearchQuery;
        this.organizationService.advancedSearch(this.searchService.advancedSearchOption.searchDto, AlternateSearchType.None, this.searchService.advancedSearchOption?.sourceLocation, "", this.searchResultFound, this.updateSearchStatus, this.alternateSearchResponseReceived, null, null);
    }
    alternateSearch(item) {
        this.resultList = [];
        this.filteredSearchResult = [];
        this.alternateSearchSources = [];
        this.alternateSearchSuggestions = [];
        if (this.searchService.isAdvancedSearch)
            this.organizationService.advancedSearch(this.searchService.advancedSearchOption.searchDto, AlternateSearchType.AlternateHandlerSearch, "", item.Handler, this.searchResultFound, this.updateSearchStatus, this.alternateSearchResponseReceived, null, null);
        else
            this.organizationService.search(this.searchStatusQuery, false, AlternateSearchType.AlternateHandlerSearch, "", item.Handler, this.searchResultFound, this.updateSearchStatus, this.alternateSearchResponseReceived, null, null);
    }
};
OrganizationSearchResultComponent = __decorate([
    Component({
        selector: 'organization-search-result',
        templateUrl: './organization-search-result.component.html',
        styleUrls: ['./organization-search-result.component.scss']
    })
], OrganizationSearchResultComponent);
export { OrganizationSearchResultComponent };
//# sourceMappingURL=organization-search-result.component.js.map